/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.olingo.service.DocumentNode;
import org.teiid.query.sql.symbol.Expression;

public class ProjectedColumn
implements DocumentNode.ContextColumn {
    private Expression expr;
    private SingletonPrimitiveType edmType;
    private boolean collection;
    private int ordinal;
    private EdmProperty property;

    public ProjectedColumn(Expression expr, SingletonPrimitiveType edmType, EdmProperty property, boolean collection) {
        this.expr = expr;
        this.edmType = edmType;
        this.collection = collection;
        this.property = property;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public SingletonPrimitiveType getEdmType() {
        return this.edmType;
    }

    public boolean isCollection() {
        return this.collection;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public EdmProperty getProperty() {
        return this.property;
    }

    public Integer getPrecision() {
        if (this.property == null) {
            return null;
        }
        return this.property.getPrecision();
    }

    public Integer getScale() {
        if (this.property == null) {
            return null;
        }
        return this.property.getScale();
    }

    @Override
    public String getName() {
        if (this.property == null) {
            return null;
        }
        return this.property.getName();
    }

    @Override
    public String getRuntimeType() {
        return DataTypeManager.getDataTypeName((Class)this.expr.getType());
    }

    @Override
    public EdmPrimitiveTypeKind getEdmPrimitiveTypeKind() {
        return EdmPrimitiveTypeKind.getByName((String)this.edmType.getName());
    }
}

