/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.EdmPropertyImpl;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.core.uri.queryoption.expression.LiteralImpl;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ProjectedColumn;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.olingo.service.ExpandDocumentNode;
import org.teiid.olingo.service.ODataExpressionToSQLVisitor;
import org.teiid.olingo.service.ODataSQLBuilder;
import org.teiid.olingo.service.ODataSchemaBuilder;
import org.teiid.olingo.service.TeiidServiceHandler;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class DocumentNode {
    private Table table;
    private GroupSymbol groupSymbol;
    private EdmStructuredType edmStructuredType;
    private List<UriParameter> keyPredicates;
    private FromClause fromClause;
    private Criteria criteria;
    protected LinkedHashMap<Expression, ProjectedColumn> projectedColumns = new LinkedHashMap();
    protected LinkedHashMap<String, ProjectedColumn> projectedColumnsByName = new LinkedHashMap();
    private List<DocumentNode> siblings = new ArrayList<DocumentNode>();
    private List<ExpandDocumentNode> expands = new ArrayList<ExpandDocumentNode>();
    private DocumentNode iterator;

    public static DocumentNode build(EdmEntityType type, List<UriParameter> keyPredicates, MetadataStore metadata, OData odata, TeiidServiceHandler.UniqueNameGenerator nameGenerator, boolean useAlias, UriInfo uriInfo, ODataSQLBuilder.URLParseService parseService) throws TeiidException {
        DocumentNode resource = new DocumentNode();
        return DocumentNode.build(resource, type, keyPredicates, metadata, odata, nameGenerator, useAlias, uriInfo, parseService);
    }

    public static DocumentNode build(DocumentNode resource, EdmEntityType type, List<UriParameter> keyPredicates, MetadataStore metadata, OData odata, TeiidServiceHandler.UniqueNameGenerator nameGenerator, boolean useAlias, UriInfo uriInfo, ODataSQLBuilder.URLParseService parseService) throws TeiidException {
        Table table = DocumentNode.findTable(type, metadata);
        GroupSymbol gs = null;
        gs = useAlias ? new GroupSymbol(nameGenerator.getNextGroup(), table.getFullName()) : new GroupSymbol(table.getFullName());
        resource.setTable(table);
        resource.setGroupSymbol(gs);
        resource.setEdmStructuredType((EdmStructuredType)type);
        resource.setKeyPredicates(keyPredicates);
        resource.setFromClause((FromClause)new UnaryFromClause(gs));
        if (keyPredicates != null && !keyPredicates.isEmpty()) {
            Criteria criteria = DocumentNode.buildEntityKeyCriteria(resource, uriInfo, metadata, odata, nameGenerator, parseService);
            resource.setCriteria(criteria);
        }
        return resource;
    }

    static Table findTable(EdmEntityType entityType, MetadataStore store) {
        FullQualifiedName fqn = entityType.getFullQualifiedName();
        String withoutVDB = fqn.getNamespace().substring(fqn.getNamespace().lastIndexOf(46) + 1);
        Schema schema = store.getSchema(withoutVDB);
        return schema.getTable(entityType.getName());
    }

    static Table findTable(EdmEntitySet entitySet, MetadataStore store) {
        return DocumentNode.findTable(entitySet.getEntityType(), store);
    }

    static Criteria buildEntityKeyCriteria(DocumentNode resource, UriInfo uriInfo, MetadataStore store, OData odata, TeiidServiceHandler.UniqueNameGenerator nameGenerator, ODataSQLBuilder.URLParseService parseService) throws TeiidException {
        List<Column> pk = DocumentNode.getPKColumns(resource.getTable());
        if (resource.getKeyPredicates().size() == 1) {
            if (pk.size() != 1) {
                throw new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16015, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16015, new Object[]{resource.getTable().getFullName()}));
            }
            Column column = pk.get(0);
            ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(resource, false, uriInfo, store, odata, nameGenerator, null, parseService);
            UriParameter key = resource.getKeyPredicates().get(0);
            org.apache.olingo.server.api.uri.queryoption.expression.Expression expr = DocumentNode.getKeyPredicateExpression(key, odata, column);
            return new CompareCriteria((Expression)new ElementSymbol(column.getName(), resource.getGroupSymbol()), 1, visitor.getExpression(expr));
        }
        ArrayList<CompareCriteria> critList = new ArrayList<CompareCriteria>();
        if (pk.size() != resource.getKeyPredicates().size()) {
            throw new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16015, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16015, new Object[]{resource.getTable().getFullName()}));
        }
        for (UriParameter key : resource.getKeyPredicates()) {
            Column column = DocumentNode.findColumn(resource.getTable(), key.getName());
            ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(resource, false, uriInfo, store, odata, nameGenerator, null, parseService);
            org.apache.olingo.server.api.uri.queryoption.expression.Expression expr = DocumentNode.getKeyPredicateExpression(key, odata, column);
            critList.add(new CompareCriteria((Expression)new ElementSymbol(column.getName(), resource.getGroupSymbol()), 1, visitor.getExpression(expr)));
        }
        return new CompoundCriteria(0, critList);
    }

    private static org.apache.olingo.server.api.uri.queryoption.expression.Expression getKeyPredicateExpression(UriParameter key, OData odata, Column column) {
        org.apache.olingo.server.api.uri.queryoption.expression.Expression expr = key.getExpression();
        if (expr == null) {
            EdmPrimitiveTypeKind primitiveTypeKind = ODataTypeManager.odataType((BaseColumn)column);
            expr = new LiteralImpl(key.getText(), (EdmType)odata.createPrimitiveTypeInstance(primitiveTypeKind));
        }
        return expr;
    }

    static Column findColumn(Table table, String propertyName) {
        return table.getColumnByName(propertyName);
    }

    public DocumentNode() {
    }

    public DocumentNode(Table table, GroupSymbol gs, EdmEntityType type) {
        this.table = table;
        this.groupSymbol = gs;
        this.edmStructuredType = type;
    }

    private Table getTable() {
        return this.table;
    }

    public String getName() {
        return this.table.getName();
    }

    public ContextColumn getColumnByName(String name) {
        Column c = this.table.getColumnByName(name);
        if (c != null) {
            return new TableContextColumn(c);
        }
        return null;
    }

    public String getFullName() {
        return this.table.getFullName();
    }

    public GroupSymbol getGroupSymbol() {
        return this.groupSymbol;
    }

    public EdmStructuredType getEdmStructuredType() {
        return this.edmStructuredType;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(FromClause fromClause) {
        this.fromClause = fromClause;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setGroupSymbol(GroupSymbol groupSymbol) {
        this.groupSymbol = groupSymbol;
    }

    public void setEdmStructuredType(EdmStructuredType edmStructuredType) {
        this.edmStructuredType = edmStructuredType;
    }

    protected void addAllColumns(boolean onlyPK) {
        if (onlyPK) {
            List<Column> columns = DocumentNode.getPKColumns(this.getTable());
            for (Column column : columns) {
                if (!column.isSelectable()) continue;
                this.addProjectedColumn(column.getName(), (Expression)new ElementSymbol(column.getName(), this.getGroupSymbol()));
            }
        } else {
            for (Column column : this.getTable().getColumns()) {
                if (!column.isSelectable()) continue;
                this.addProjectedColumn(column.getName(), (Expression)new ElementSymbol(column.getName(), this.getGroupSymbol()));
            }
        }
    }

    protected void addProjectedColumn(String columnName, Expression expr) {
        EdmPropertyImpl edmProperty = (EdmPropertyImpl)this.edmStructuredType.getProperty(columnName);
        ContextColumn c = this.getColumnByName(columnName);
        ProjectedColumn pc = this.addProjectedColumn(expr, edmProperty.getType(), (EdmProperty)edmProperty, edmProperty.isCollection());
        pc.setOrdinal(c.getOrdinal());
    }

    protected ProjectedColumn addProjectedColumn(Expression expr, EdmType type, EdmProperty property, boolean collection) {
        ProjectedColumn pc = this.projectedColumns.get(expr);
        if (pc != null) {
            return pc;
        }
        pc = new ProjectedColumn(expr, (SingletonPrimitiveType)type, property, collection);
        pc.setOrdinal(Integer.MAX_VALUE);
        this.projectedColumns.put(expr, pc);
        if (property != null) {
            this.projectedColumnsByName.put(property.getName(), pc);
        }
        return pc;
    }

    OrderBy addDefaultOrderBy() {
        if (this.table == null) {
            return null;
        }
        OrderBy orderBy = new OrderBy();
        KeyRecord record = ODataSchemaBuilder.getIdentifier(this.table);
        for (Column column : record.getColumns()) {
            ElementSymbol expr = new ElementSymbol(column.getName(), this.groupSymbol);
            orderBy.addVariable((Expression)expr);
            this.addProjectedColumn(column.getName(), (Expression)expr);
        }
        return orderBy;
    }

    public LinkedHashMap<Expression, ProjectedColumn> getProjectedColumns() {
        return this.projectedColumns;
    }

    public List<ProjectedColumn> getAllProjectedColumns() {
        ArrayList<ProjectedColumn> columns = new ArrayList<ProjectedColumn>();
        columns.addAll(this.projectedColumns.values());
        for (DocumentNode er : this.siblings) {
            columns.addAll(er.getAllProjectedColumns());
        }
        if (this.iterator != null) {
            columns.addAll(this.iterator.getAllProjectedColumns());
        }
        return columns;
    }

    public List<UriParameter> getKeyPredicates() {
        return this.keyPredicates;
    }

    public List<String> getKeyColumnNames() {
        if (this.edmStructuredType instanceof EdmEntityType) {
            return ((EdmEntityType)this.edmStructuredType).getKeyPredicateNames();
        }
        return Collections.emptyList();
    }

    public void setKeyPredicates(List<UriParameter> keyPredicates) {
        this.keyPredicates = keyPredicates;
    }

    public void addSibling(DocumentNode resource) {
        this.siblings.add(resource);
    }

    public List<DocumentNode> getSiblings() {
        return this.siblings;
    }

    public void addExpand(ExpandDocumentNode resource) {
        this.expands.add(resource);
    }

    public List<ExpandDocumentNode> getExpands() {
        return this.expands;
    }

    public Query buildQuery() {
        Select select = new Select();
        AtomicInteger ordinal = new AtomicInteger(1);
        this.addColumns(select, ordinal, this.sortColumns(this.getProjectedColumns().values()));
        for (DocumentNode sibiling : this.siblings) {
            this.addColumns(select, ordinal, this.sortColumns(sibiling.getProjectedColumns().values()));
        }
        Query query = new Query();
        From from = new From();
        from.addClause(this.fromClause);
        for (DocumentNode sibiling : this.siblings) {
            from.addClause(sibiling.getFromClause());
        }
        if (this.iterator != null) {
            this.addColumns(select, ordinal, this.sortColumns(this.iterator.getProjectedColumns().values()));
            from.addClause(this.iterator.getFromClause());
            GroupBy groupBy = new GroupBy();
            for (String keyCol : this.getKeyColumnNames()) {
                groupBy.addSymbol((Expression)new ElementSymbol(keyCol, this.groupSymbol));
            }
            query.setGroupBy(groupBy);
        }
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria(this.criteria);
        return query;
    }

    protected List<ProjectedColumn> sortColumns(Collection<ProjectedColumn> toSort) {
        ArrayList<ProjectedColumn> list = new ArrayList<ProjectedColumn>(toSort);
        Collections.sort(list, new Comparator<ProjectedColumn>(){

            @Override
            public int compare(ProjectedColumn o1, ProjectedColumn o2) {
                return Integer.compare(o1.getOrdinal(), o2.getOrdinal());
            }
        });
        return list;
    }

    protected void addColumns(Select select, AtomicInteger ordinal, List<ProjectedColumn> projected) {
        for (ProjectedColumn column : projected) {
            select.addSymbol(column.getExpression());
            column.setOrdinal(ordinal.getAndIncrement());
        }
    }

    Criteria buildJoinCriteria(DocumentNode joinResource, EdmNavigationProperty property) throws TeiidException {
        KeyInfo keyInfo = DocumentNode.joinFK(joinResource.getTable(), this.getTable(), property);
        if (keyInfo == null && (keyInfo = DocumentNode.joinFK(this.getTable(), joinResource.getTable(), property)) == null) {
            throw new TeiidException("Fk not found");
        }
        return DocumentNode.buildCriteria(keyInfo.reverse ? joinResource : this, keyInfo.reverse ? this : joinResource, keyInfo.fk);
    }

    DocumentNode joinTable(DocumentNode joinResource, EdmNavigationProperty property, JoinType joinType) throws TeiidException {
        Criteria crit = null;
        if (!joinType.equals((Object)JoinType.JOIN_CROSS)) {
            crit = this.buildJoinCriteria(joinResource, property);
        }
        Object fromClause = joinResource.getKeyPredicates() != null && joinResource.getKeyPredicates().size() > 0 ? new UnaryFromClause(joinResource.getGroupSymbol()) : new JoinPredicate(this.getFromClause(), (FromClause)new UnaryFromClause(joinResource.getGroupSymbol()), joinType, crit);
        joinResource.setFromClause((FromClause)fromClause);
        return joinResource;
    }

    static ForeignKey joinFK(DocumentNode current, DocumentNode reference, EdmNavigationProperty property) {
        Table currentTable = current.getTable();
        Table referenceTable = reference.getTable();
        if (currentTable == null || referenceTable == null) {
            return null;
        }
        KeyInfo keyInfo = DocumentNode.joinFK(currentTable, referenceTable, property);
        if (keyInfo != null) {
            return keyInfo.fk;
        }
        return null;
    }

    private static KeyInfo joinFK(Table currentTable, Table referenceTable, EdmNavigationProperty property) {
        for (ForeignKey fk : currentTable.getForeignKeys()) {
            if (!((Schema)referenceTable.getParent()).equals((Object)((Table)fk.getReferenceKey().getParent()).getParent()) || !referenceTable.getName().equals(fk.getReferenceTableName())) continue;
            if (!property.isCollection() && property.getName().equals(fk.getName())) {
                return new KeyInfo(false, fk);
            }
            if (!property.getName().equals(currentTable.getName() + "_" + fk.getName())) continue;
            return new KeyInfo(true, fk);
        }
        return null;
    }

    static Criteria buildJoinCriteria(DocumentNode from, DocumentNode to) {
        for (ForeignKey fk : from.getTable().getForeignKeys()) {
            if (!((Table)fk.getReferenceKey().getParent()).equals((Object)to.getTable())) continue;
            return DocumentNode.buildCriteria(from, to, fk);
        }
        return null;
    }

    private static Criteria buildCriteria(DocumentNode from, DocumentNode to, ForeignKey fk) {
        List<String> fkColumns = DocumentNode.getColumnNames(fk.getColumns());
        if (fkColumns == null) {
            fkColumns = DocumentNode.getColumnNames(DocumentNode.getPKColumns(from.getTable()));
        }
        List<String> pkColumns = DocumentNode.getColumnNames(fk.getReferenceKey().getColumns());
        Criteria criteria = DocumentNode.buildJoinCriteria(from.getGroupSymbol(), to.getGroupSymbol(), pkColumns, fkColumns);
        return criteria;
    }

    static List<Column> getPKColumns(Table table) {
        return ODataSchemaBuilder.getIdentifier(table).getColumns();
    }

    static Criteria buildJoinCriteria(GroupSymbol joinGroup, GroupSymbol entityGroup, List<String> pkColumns, List<String> refColumns) {
        ArrayList<CompareCriteria> critList = new ArrayList<CompareCriteria>();
        for (int i = 0; i < refColumns.size(); ++i) {
            critList.add(new CompareCriteria((Expression)new ElementSymbol(pkColumns.get(i), entityGroup), 1, (Expression)new ElementSymbol(refColumns.get(i), joinGroup)));
        }
        Criteria crit = (Criteria)critList.get(0);
        for (int i = 1; i < critList.size(); ++i) {
            crit = new CompoundCriteria(0, crit, (Criteria)critList.get(i));
        }
        return crit;
    }

    static List<String> getColumnNames(List<Column> columns) {
        if (columns == null || columns.isEmpty()) {
            return null;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column column : columns) {
            columnNames.add(column.getName());
        }
        return columnNames;
    }

    public void addCriteria(Expression filter) {
        if (filter != null) {
            Object crit = null;
            crit = filter instanceof Criteria ? (Criteria)filter : new ExpressionCriteria(filter);
            this.criteria = Criteria.combineCriteria((Criteria)this.criteria, (Criteria)crit);
        }
    }

    public String toString() {
        return this.table.getFullName();
    }

    public void setIterator(DocumentNode itResource) {
        this.iterator = itResource;
    }

    public DocumentNode getIterator() {
        return this.iterator;
    }

    private static class KeyInfo {
        boolean reverse;
        ForeignKey fk;

        public KeyInfo(boolean reverse, ForeignKey fk) {
            this.reverse = reverse;
            this.fk = fk;
        }
    }

    public static class TableContextColumn
    implements ContextColumn {
        private Column column;

        public TableContextColumn(Column c) {
            this.column = c;
        }

        @Override
        public int getOrdinal() {
            return this.column.getPosition();
        }

        @Override
        public String getName() {
            return this.column.getName();
        }

        @Override
        public String getRuntimeType() {
            return this.column.getRuntimeType();
        }

        @Override
        public EdmPrimitiveTypeKind getEdmPrimitiveTypeKind() {
            return ODataTypeManager.odataType((BaseColumn)this.column);
        }
    }

    public static interface ContextColumn {
        public int getOrdinal();

        public String getName();

        public String getRuntimeType();

        public EdmPrimitiveTypeKind getEdmPrimitiveTypeKind();
    }
}

