/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.CallableStatementImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataStore;
import org.teiid.odata.api.Client;
import org.teiid.odata.api.CountResponse;
import org.teiid.odata.api.OperationResponse;
import org.teiid.odata.api.ProcedureReturnType;
import org.teiid.odata.api.QueryResponse;
import org.teiid.odata.api.SQLParameter;
import org.teiid.odata.api.UpdateResponse;
import org.teiid.odbc.ODBCServerRemoteImpl;
import org.teiid.olingo.ODataPlugin;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.translator.CacheDirective;
import org.teiid.transport.LocalServerConnection;

public class LocalClient
implements Client {
    static final String DELIMITER = ",";
    private volatile VDBMetaData vdb;
    private final String vdbName;
    private final String vdbVersion;
    protected ConnectionImpl connection;
    private Properties properties;
    private Map<Object, Future<Boolean>> loading;
    private Object loadingKey;
    private ResultSet toCache;
    private CompletableFuture<Boolean> loadingFinished;

    public LocalClient(String vdbName, String vdbVersion, Properties properties, Map<Object, Future<Boolean>> loading) {
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.properties = properties;
        this.loading = loading;
    }

    private long getCacheTime() {
        return PropertiesUtils.getLongProperty((Properties)this.properties, (String)"skiptoken-cache-time", (long)300000L);
    }

    @Override
    public Connection open() throws SQLException, TeiidProcessingException {
        this.connection = LocalClient.buildConnection(TeiidDriver.getInstance(), this.vdbName, this.vdbVersion, this.properties);
        ODBCServerRemoteImpl.setConnectionProperties((ConnectionImpl)this.connection);
        ODBCServerRemoteImpl.setConnectionProperties((ConnectionImpl)this.connection, (Properties)this.properties);
        this.getVDBInternal();
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.toCache != null) {
                this.toCache.last();
            }
        }
        finally {
            if (this.loadingFinished != null) {
                this.loadingFinished.complete(true);
                this.loading.remove(this.loadingKey);
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public static ConnectionImpl buildConnection(TeiidDriver driver, String vdbName, String version, Properties props) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:teiid:").append(vdbName);
        if (version != null) {
            sb.append(".").append(version);
        }
        sb.append(";");
        if (props.getProperty("PassthroughAuthentication") == null) {
            props.setProperty("PassthroughAuthentication", "true");
        }
        if (props.getProperty("transportName") == null) {
            props.setProperty("transportName", "odata");
        }
        if (props.getProperty("waitForLoad") == null) {
            props.setProperty("waitForLoad", "0");
        }
        if (props.getProperty("ApplicationName") == null) {
            props.setProperty("ApplicationName", "OData");
        }
        ConnectionImpl connection = driver.connect(sb.toString(), props);
        return connection;
    }

    @Override
    public VDBMetaData getVDB() {
        try {
            return this.getVDBInternal();
        }
        catch (TeiidProcessingException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (SQLException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private VDBMetaData getVDBInternal() throws SQLException, TeiidProcessingException {
        if (this.vdb == null) {
            LocalServerConnection lsc = (LocalServerConnection)this.getConnection().getServerConnection();
            this.vdb = lsc.getWorkContext().getVDB();
            if (this.vdb == null) {
                throw new TeiidRuntimeException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16001, new Object[]{this.vdbName, this.vdbVersion}));
            }
            this.vdb = this.vdb;
        }
        if (this.vdb.getStatus() != VDB.Status.ACTIVE) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31099, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31099, new Object[]{this.vdb, this.vdb.getStatus()}));
        }
        return this.vdb;
    }

    @Override
    public void executeCall(String sql, List<SQLParameter> parameters, ProcedureReturnType returnType, OperationResponse response) throws SQLException {
        boolean results;
        LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
        CallableStatementImpl stmt = this.getConnection().prepareCall(sql);
        int i = 1;
        if (returnType.getSqlType() != null) {
            stmt.registerOutParameter(i++, (int)returnType.getSqlType());
        }
        if (!parameters.isEmpty()) {
            for (SQLParameter param : parameters) {
                stmt.setObject(i++, param.getValue(), param.getSqlType());
            }
        }
        if (results = stmt.execute()) {
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                response.addRow(rs);
            }
        }
        if (returnType.getSqlType() != null) {
            Object result = stmt.getObject(1);
            response.setReturnValue(result);
        }
    }

    @Override
    public MetadataStore getMetadataStore() {
        return ((TransformationMetadata)this.getVDB().getAttachment(TransformationMetadata.class)).getMetadataStore();
    }

    @Override
    public void executeSQL(Query query, List<SQLParameter> parameters, boolean calculateTotalSize, Integer skipOption, Integer topOption, String nextOption, int pageSize, QueryResponse response) throws SQLException {
        boolean cache = pageSize > 0;
        boolean getCount = false;
        getCount = calculateTotalSize;
        boolean skipAndTopApplied = false;
        if (!(getCount || topOption == null && skipOption == null)) {
            query.setLimit(new Limit((Expression)(skipOption != null ? new Constant((Object)skipOption) : null), (Expression)(topOption != null ? new Constant((Object)topOption) : null)));
            skipAndTopApplied = true;
        }
        ConnectionImpl conn = this.getConnection();
        String sessionId = conn.getServerConnection().getLogonResult().getSessionID();
        Integer toSkip = null;
        Integer savedEntityCount = null;
        if (nextOption != null) {
            if (cache) {
                StringTokenizer st = new StringTokenizer(nextOption, DELIMITER);
                sessionId = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new TeiidRuntimeException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16062, new Object[0]));
                }
                try {
                    toSkip = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        savedEntityCount = Integer.parseInt(st.nextToken());
                    }
                }
                catch (NumberFormatException e) {
                    throw new TeiidRuntimeException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16062, new Object[0]));
                }
            }
            getCount = false;
        }
        int count = 0;
        int expectedEnd = 0;
        if (!getCount && cache) {
            int offsetParam = 0;
            int limitParam = 0;
            pageSize = Math.min(pageSize, 0x2000000);
            int resultWindow = pageSize << 6;
            int windows = 0;
            if (toSkip != null) {
                windows = toSkip / resultWindow;
                toSkip = toSkip % resultWindow;
                count = windows * resultWindow;
            }
            expectedEnd = count + resultWindow;
            if (query.getLimit() != null) {
                offsetParam = count + (skipOption != null ? skipOption : 0);
                limitParam = Math.min(resultWindow, topOption != null ? topOption : Integer.MAX_VALUE);
            } else {
                offsetParam = count;
                limitParam = resultWindow;
            }
            parameters = parameters == null ? new ArrayList<SQLParameter>() : new ArrayList<SQLParameter>(parameters);
            query.setLimit(new Limit((Expression)new Reference(parameters.size()), (Expression)new Reference(parameters.size() + 1)));
            parameters.add(new SQLParameter(offsetParam, 4));
            parameters.add(new SQLParameter(limitParam, 4));
        }
        if (cache) {
            CacheHint hint = new CacheHint();
            hint.setTtl(Long.valueOf(this.getCacheTime()));
            hint.setScope(CacheDirective.Scope.USER);
            query.setCacheHint(hint);
        }
        String sql = query.toString();
        if (cache && !Boolean.valueOf(conn.getExecutionProperty("resultSetCacheMode")).booleanValue()) {
            sql = sql + " /* " + sessionId + " */";
        }
        LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
        if (cache) {
            this.loadingKey = Arrays.asList(sql, parameters);
            Future<Boolean> future = this.loading.get(this.loadingKey);
            if (future != null) {
                try {
                    future.get(5L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    throw new TeiidRuntimeException((Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
                catch (TimeoutException e) {
                    LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Waited 5 minutes for the initial load of", (Object)sql, (Object)".  You should consider higher level caching such as materialization");
                }
            }
        }
        PreparedStatementImpl stmt = conn.prepareStatement(sql, cache ? 1004 : 1003, 1007);
        if (parameters != null && !parameters.isEmpty()) {
            List references = ReferenceCollectorVisitor.getReferences((LanguageObject)query);
            for (int i = 0; i < references.size(); ++i) {
                int index = ((Reference)references.get(i)).getIndex();
                stmt.setObject(i + 1, parameters.get(index).getValue(), parameters.get(index).getSqlType());
            }
        }
        ResultSet rs = stmt.executeQuery();
        int entityCount = 0;
        int skipSize = 0;
        if (toSkip == null) {
            if (skipOption != null && skipOption > 0 && !skipAndTopApplied) {
                int s = this.skipEntities(rs, skipOption);
                entityCount = s;
                skipSize = count += s;
            }
        } else if ((skipSize += toSkip.intValue()) > 0) {
            count += this.skip(cache, rs, skipSize);
        }
        int size = pageSize;
        int top = Integer.MAX_VALUE;
        if (getCount && topOption != null) {
            size = top = topOption.intValue();
            if (pageSize > 0) {
                size = Math.min(pageSize, size);
            }
        } else if (size < 1) {
            size = Integer.MAX_VALUE;
        }
        int i = 0;
        int nextCount = count;
        while (rs.next()) {
            ++count;
            ++entityCount;
            if (++i > size) break;
            ++nextCount;
            response.addRow(rs);
        }
        if (getCount) {
            while (rs.next()) {
                ++count;
                ++entityCount;
            }
        }
        if (savedEntityCount != null) {
            response.setCount(savedEntityCount.intValue());
        } else {
            response.setCount(entityCount);
        }
        if (cache && response.size() == (long)pageSize) {
            long end = nextCount;
            if (getCount) {
                if (end < (long)Math.min(top, count)) {
                    response.setNextToken(this.nextToken(cache, sessionId, end, entityCount));
                }
            } else if (i > size || count == expectedEnd) {
                response.setNextToken(this.nextToken(cache, sessionId, end, null));
                this.loadingFinished = new CompletableFuture();
                this.loading.put(this.loadingKey, this.loadingFinished);
                this.toCache = rs;
            }
        }
    }

    private String nextToken(boolean cache, String sessionid, long skip, Integer entityCount) {
        if (cache) {
            String token = sessionid + DELIMITER + String.valueOf(skip);
            if (entityCount != null) {
                token = token + DELIMITER + String.valueOf(entityCount);
            }
            return token;
        }
        return String.valueOf(skip);
    }

    private int skip(boolean cache, ResultSet rs, int skipSize) throws SQLException {
        int skipped = 0;
        if (!cache) {
            for (int i = 0; i < skipSize; ++i) {
                ++skipped;
                if (rs.next()) {
                    continue;
                }
                break;
            }
        } else {
            skipped = skipSize;
            rs.absolute(skipSize);
        }
        return skipped;
    }

    private int skipEntities(ResultSet rs, int skipEntities) throws SQLException {
        int skipped = 0;
        while (rs.next() && ++skipped != skipEntities) {
        }
        return skipped;
    }

    @Override
    public CountResponse executeCount(Query query, List<SQLParameter> parameters) throws SQLException {
        String sql = query.toString();
        LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
        PreparedStatementImpl stmt = this.getConnection().prepareStatement(sql);
        if (!parameters.isEmpty()) {
            for (int i = 0; i < parameters.size(); ++i) {
                stmt.setObject(i + 1, parameters.get(i).getValue(), parameters.get(i).getSqlType());
            }
        }
        ResultSet rs = stmt.executeQuery();
        rs.next();
        final int count = rs.getInt(1);
        rs.close();
        stmt.close();
        return new CountResponse(){

            @Override
            public int getCount() {
                return count;
            }
        };
    }

    @Override
    public UpdateResponse executeUpdate(Command query, List<SQLParameter> parameters) throws SQLException {
        String sql = query.toString();
        LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
        PreparedStatementImpl stmt = this.getConnection().prepareStatement(sql, 1003, 1007, 1, 1);
        if (!parameters.isEmpty()) {
            for (int i = 0; i < parameters.size(); ++i) {
                stmt.setObject(i + 1, parameters.get(i).getValue(), parameters.get(i).getSqlType().intValue());
            }
        }
        final int count = stmt.executeUpdate();
        final Map<String, Object> keys = this.getGeneratedKeys(stmt.getGeneratedKeys());
        stmt.close();
        return new UpdateResponse(){

            @Override
            public Map<String, Object> getGeneratedKeys() {
                return keys;
            }

            @Override
            public int getUpdateCount() {
                return count;
            }
        };
    }

    private Map<String, Object> getGeneratedKeys(ResultSet result) throws SQLException {
        if (result == null) {
            return null;
        }
        HashMap<String, Object> keys = new HashMap<String, Object>();
        ResultSetMetaData metadata = result.getMetaData();
        while (result.next()) {
            for (int i = 0; i < metadata.getColumnCount(); ++i) {
                String label = metadata.getColumnLabel(i + 1);
                keys.put(label, result.getObject(i + 1));
            }
        }
        return keys;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String startTransaction() throws SQLException {
        this.getConnection().setAutoCommit(false);
        return "anyid";
    }

    @Override
    public void commit(String txnId) throws SQLException {
        this.getConnection().commit();
        this.getConnection().setAutoCommit(true);
    }

    @Override
    public void rollback(String txnId) throws SQLException {
        this.getConnection().rollback();
        this.getConnection().setAutoCommit(true);
    }
}

