/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoAll;
import org.apache.olingo.server.api.uri.UriInfoBatch;
import org.apache.olingo.server.api.uri.UriInfoCrossjoin;
import org.apache.olingo.server.api.uri.UriInfoEntityId;
import org.apache.olingo.server.api.uri.UriInfoMetadata;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriInfoService;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceIt;
import org.apache.olingo.server.api.uri.UriResourceLambdaAll;
import org.apache.olingo.server.api.uri.UriResourceLambdaAny;
import org.apache.olingo.server.api.uri.UriResourceLambdaVariable;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceRef;
import org.apache.olingo.server.api.uri.UriResourceRoot;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.api.uri.UriResourceValue;
import org.apache.olingo.server.api.uri.queryoption.ApplyItem;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SkipTokenOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.api.uri.queryoption.apply.Aggregate;
import org.apache.olingo.server.api.uri.queryoption.apply.AggregateExpression;
import org.apache.olingo.server.api.uri.queryoption.apply.Filter;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupBy;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupByItem;
import org.apache.olingo.server.core.RequestURLHierarchyVisitor;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriResourceEntitySetImpl;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.queryoption.ExpandOptionImpl;
import org.apache.olingo.server.core.uri.validator.UriValidationException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.language.SortSpecification;
import org.teiid.metadata.Column;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.odata.api.SQLParameter;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.olingo.service.ApplyDocumentNode;
import org.teiid.olingo.service.ComplexDocumentNode;
import org.teiid.olingo.service.CrossJoinNode;
import org.teiid.olingo.service.DocumentNode;
import org.teiid.olingo.service.ExpandDocumentNode;
import org.teiid.olingo.service.ExpandSQLBuilder;
import org.teiid.olingo.service.NoDocumentNode;
import org.teiid.olingo.service.ODataExpressionToSQLVisitor;
import org.teiid.olingo.service.ODataSchemaBuilder;
import org.teiid.olingo.service.ProcedureSQLBuilder;
import org.teiid.olingo.service.TeiidNotImplementedException;
import org.teiid.olingo.service.TeiidServiceHandler;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class ODataSQLBuilder
extends RequestURLHierarchyVisitor {
    static final int MAX_EXPAND_LEVEL = 3;
    private final MetadataStore metadata;
    private boolean prepared = true;
    private final ArrayList<SQLParameter> params = new ArrayList();
    private final ArrayList<Exception> exceptions = new ArrayList();
    private DocumentNode context;
    private SkipOption skipOption;
    private TopOption topOption;
    private boolean countOption;
    private OrderBy orderBy;
    private boolean selectionComplete;
    private String nextToken;
    private boolean aliasedGroups;
    private boolean countQuery = false;
    private boolean reference = false;
    private String baseURI;
    private ServiceMetadata serviceMetadata;
    private TeiidServiceHandler.UniqueNameGenerator nameGenerator = new TeiidServiceHandler.UniqueNameGenerator();
    private ExpandOption expandOption;
    private URLParseService parseService;
    private OData odata;
    private boolean navigation = false;
    private TeiidServiceHandler.OperationParameterValueProvider parameters;

    public ODataSQLBuilder(OData odata, MetadataStore metadata, boolean prepared, boolean aliasedGroups, String baseURI, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.metadata = metadata;
        this.prepared = prepared;
        this.aliasedGroups = aliasedGroups;
        this.baseURI = baseURI;
        this.serviceMetadata = serviceMetadata;
        this.parseService = new URLParseService();
    }

    public DocumentNode getContext() {
        return this.context;
    }

    public boolean includeTotalSize() {
        return this.countOption;
    }

    public Integer getSkip() {
        if (this.skipOption == null) {
            return null;
        }
        return this.skipOption.getValue();
    }

    public Integer getTop() {
        if (this.topOption == null) {
            return null;
        }
        return this.topOption.getValue();
    }

    public boolean hasNavigation() {
        return this.navigation;
    }

    public Query selectQuery() throws TeiidException, ODataLibraryException, ODataApplicationException {
        if (!this.exceptions.isEmpty()) {
            Exception e = this.exceptions.get(0);
            if (e instanceof ODataLibraryException) {
                throw (ODataLibraryException)((Object)e);
            }
            if (e instanceof ODataApplicationException) {
                throw (ODataApplicationException)((Object)e);
            }
            if (e instanceof TeiidException) {
                throw (TeiidException)e;
            }
            throw new TeiidException((Throwable)e);
        }
        Query query = this.context.buildQuery();
        if (this.countQuery) {
            AggregateSymbol aggregateSymbol = new AggregateSymbol(AggregateSymbol.Type.COUNT.name(), false, null);
            Select select = new Select(Arrays.asList(aggregateSymbol));
            query.setSelect(select);
        } else if (this.orderBy != null) {
            if (this.context.getIterator() != null) {
                ((AggregateSymbol)((AliasSymbol)query.getSelect().getSymbol(query.getSelect().getProjectedSymbols().size() - 1)).getSymbol()).setOrderBy(this.orderBy);
            } else {
                query.setOrderBy(this.orderBy);
            }
        }
        if (this.expandOption != null) {
            this.processExpandOption(this.expandOption, this.context, query, 1, null);
        }
        return query;
    }

    private void processExpandOption(ExpandOption option, DocumentNode node, Query outerQuery, int expandLevel, Integer cyclicLevel) throws TeiidException {
        ODataSQLBuilder.checkExpandLevel(expandLevel);
        int starLevels = 0;
        HashSet<String> seen = new HashSet<String>();
        for (ExpandItem ei : option.getExpandItems()) {
            if (ei.getSearchOption() != null) {
                throw new TeiidNotImplementedException((BundleUtil.Event)ODataPlugin.Event.TEIID16035, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16035, new Object[0]));
            }
            Integer levels = null;
            if (cyclicLevel != null) {
                levels = cyclicLevel - 1;
            } else if (ei.getLevelsOption() != null) {
                if (ei.getLevelsOption().isMax()) {
                    levels = 3 - expandLevel + 1;
                } else {
                    levels = ei.getLevelsOption().getValue();
                    ODataSQLBuilder.checkExpandLevel(expandLevel + levels - 1);
                }
            }
            ExpandSQLBuilder esb = new ExpandSQLBuilder(ei);
            EdmNavigationProperty property = esb.getNavigationProperty();
            if (property == null) {
                if (ei.isStar()) {
                    if (starLevels > 0) {
                        throw new TeiidProcessingException((BundleUtil.Event)ODataPlugin.Event.TEIID16058, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16058, new Object[]{"*"}));
                    }
                    if (levels != null) {
                        starLevels = levels;
                        continue;
                    }
                    starLevels = 1;
                    continue;
                }
                throw new TeiidNotImplementedException((BundleUtil.Event)ODataPlugin.Event.TEIID16057, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16057, new Object[0]));
            }
            if (!seen.add(property.getName())) {
                throw new TeiidProcessingException((BundleUtil.Event)ODataPlugin.Event.TEIID16058, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16058, new Object[]{property.getName()}));
            }
            ExpandDocumentNode expandResource = ExpandDocumentNode.buildExpand(property, this.metadata, this.odata, this.nameGenerator, true, this.getUriInfo(), this.parseService, this.context);
            node.addExpand(expandResource);
            if (ei.getFilterOption() != null) {
                Expression expandCriteria = this.processFilterOption(ei.getFilterOption(), expandResource);
                expandResource.addCriteria(expandCriteria);
            }
            if (ei.getApplyOption() != null) {
                throw new TeiidNotImplementedException("Apply Not Implemented");
            }
            OrderBy expandOrder = null;
            if (ei.getOrderByOption() != null) {
                expandOrder = new OrderBy();
                this.processOrderBy(expandOrder, ei.getOrderByOption().getOrders(), expandResource);
            } else {
                expandOrder = expandResource.addDefaultOrderBy();
            }
            this.processSelectOption(ei.getSelectOption(), expandResource, this.reference);
            if (ei.getSkipOption() != null) {
                expandResource.setSkip(ei.getSkipOption().getValue());
            }
            if (ei.getTopOption() != null) {
                expandResource.setTop(ei.getTopOption().getValue());
            }
            Query query = expandResource.buildQuery();
            if (ei.getExpandOption() != null) {
                this.processExpandOption(ei.getExpandOption(), expandResource, query, expandLevel + 1, null);
            } else if (levels != null) {
                if (!property.getType().getFullQualifiedName().equals((Object)node.getEdmStructuredType().getFullQualifiedName())) {
                    throw new TeiidProcessingException((BundleUtil.Event)ODataPlugin.Event.TEIID16060, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16060, new Object[]{node.getEdmStructuredType().getFullQualifiedName(), property.getType().getFullQualifiedName()}));
                }
                if (levels > 1) {
                    ExpandOptionImpl eoi = new ExpandOptionImpl();
                    eoi.addExpandItem(ei);
                    this.processExpandOption((ExpandOption)eoi, expandResource, query, expandLevel + 1, levels);
                }
            }
            this.buildAggregateQuery(node, outerQuery, expandResource, expandOrder, query, property);
        }
        if (starLevels > 0) {
            ArrayList<TeiidServiceHandler.ExpandNode> starExpand = new ArrayList<TeiidServiceHandler.ExpandNode>();
            EdmEntityType edmEntityType = (EdmEntityType)node.getEdmStructuredType();
            this.buildExpandGraph(seen, starExpand, edmEntityType, starLevels - 1);
            if (!starExpand.isEmpty()) {
                this.processExpand(starExpand, node, outerQuery, expandLevel);
            }
        }
    }

    private void buildExpandGraph(HashSet<String> seen, List<TeiidServiceHandler.ExpandNode> starExpand, EdmEntityType edmEntityType, int remainingLevels) {
        for (String name : edmEntityType.getNavigationPropertyNames()) {
            if (seen != null && seen.contains(name)) continue;
            EdmNavigationProperty property = edmEntityType.getNavigationProperty(name);
            TeiidServiceHandler.ExpandNode en = new TeiidServiceHandler.ExpandNode();
            en.navigationProperty = property;
            starExpand.add(en);
            if (remainingLevels <= 0) continue;
            this.buildExpandGraph(null, en.children, property.getType(), remainingLevels - 1);
        }
    }

    public static void checkExpandLevel(int expandLevel) throws TeiidProcessingException {
        if (expandLevel > 3) {
            throw new TeiidProcessingException((BundleUtil.Event)ODataPlugin.Event.TEIID16059, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16059, new Object[]{3}));
        }
    }

    private void buildAggregateQuery(DocumentNode node, Query outerQuery, ExpandDocumentNode expandResource, OrderBy expandOrder, Query query, EdmNavigationProperty navigationProperty) throws TeiidException {
        Select select = query.getSelect();
        Array array = new Array(Object.class, new ArrayList(select.getSymbols()));
        select.getSymbols().clear();
        AggregateSymbol symbol = new AggregateSymbol(AggregateSymbol.Type.ARRAY_AGG.name(), false, (Expression)array);
        select.addSymbol((Expression)symbol);
        symbol.setOrderBy(expandOrder);
        Criteria crit = node.buildJoinCriteria(expandResource, navigationProperty);
        if (crit != null) {
            query.setCriteria(Criteria.combineCriteria((Criteria)crit, (Criteria)query.getCriteria()));
        }
        expandResource.setColumnIndex(outerQuery.getSelect().getCount() + 1);
        ScalarSubquery agg = new ScalarSubquery((QueryCommand)query);
        ExistsCriteria.SubqueryHint subqueryHint = new ExistsCriteria.SubqueryHint();
        subqueryHint.setMergeJoin(true);
        agg.setSubqueryHint(subqueryHint);
        outerQuery.getSelect().addSymbol((Expression)agg);
        ((FromClause)outerQuery.getFrom().getClauses().get(0)).setMakeInd(new Option.MakeDep());
    }

    private Expression processFilterOption(FilterOption option, DocumentNode resource) throws TeiidException {
        ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(resource, this.prepared, this.getUriInfo(), this.metadata, this.odata, this.nameGenerator, this.params, this.parseService);
        return visitor.getExpression(option.getExpression());
    }

    public List<SQLParameter> getParameters() {
        return this.params;
    }

    public void visit(UriResourceEntitySet info) {
        try {
            this.context = DocumentNode.build(info.getEntitySet().getEntityType(), info.getKeyPredicates(), this.metadata, this.odata, this.nameGenerator, this.aliasedGroups, this.getUriInfo(), this.parseService);
        }
        catch (TeiidException e) {
            this.exceptions.add((Exception)((Object)e));
        }
    }

    public void visit(SkipOption option) {
        this.skipOption = option;
    }

    public void visit(TopOption option) {
        this.topOption = option;
    }

    public void visit(CountOption info) {
        this.countOption = info.getValue();
    }

    public void visit(SelectOption option) {
        if (this.selectionComplete) {
            return;
        }
        try {
            this.processSelectOption(option, this.context, this.reference);
        }
        catch (TeiidException e) {
            this.exceptions.add((Exception)((Object)e));
        }
    }

    private void processSelectOption(SelectOption option, DocumentNode resource, boolean onlyReference) throws TeiidException {
        if (option == null) {
            resource.addAllColumns(onlyReference);
        } else {
            boolean addkeys = true;
            ArrayList<String> keys = new ArrayList<String>(resource.getKeyColumnNames());
            for (SelectItem si : option.getSelectItems()) {
                if (si.isStar()) {
                    resource.addAllColumns(onlyReference);
                    addkeys = false;
                    continue;
                }
                ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(resource, false, this.getUriInfo(), this.metadata, this.odata, this.nameGenerator, this.params, this.parseService);
                ElementSymbol expr = (ElementSymbol)visitor.getExpression(si.getResourcePath());
                resource.addProjectedColumn(expr.getShortName(), (Expression)expr);
                keys.remove(expr.getShortName());
            }
            if (!keys.isEmpty() && addkeys) {
                for (String key : keys) {
                    ElementSymbol es = new ElementSymbol(key, resource.getGroupSymbol());
                    resource.addProjectedColumn(key, (Expression)es);
                }
            }
        }
    }

    public void visit(OrderByOption option) {
        if (option == null || option.getOrders().isEmpty()) {
            this.orderBy = this.context.addDefaultOrderBy();
        } else {
            List orderBys = option.getOrders();
            try {
                this.orderBy = this.processOrderBy(new OrderBy(), orderBys, this.context);
            }
            catch (TeiidException e) {
                this.exceptions.add((Exception)((Object)e));
            }
        }
    }

    private OrderBy processOrderBy(OrderBy orderBy, List<org.apache.olingo.server.api.uri.queryoption.OrderByItem> orderByItems, DocumentNode resource) throws TeiidException {
        int i = 1;
        for (org.apache.olingo.server.api.uri.queryoption.OrderByItem obitem : orderByItems) {
            ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(resource, false, this.getUriInfo(), this.metadata, this.odata, this.nameGenerator, this.params, this.parseService);
            Expression expr = visitor.getExpression(obitem.getExpression());
            OrderByItem item = null;
            if (expr instanceof ElementSymbol || ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)expr).isEmpty()) {
                item = orderBy.addVariable(expr, !obitem.isDescending());
            } else {
                String baseName = "_orderByAlias_";
                String name = baseName + i++;
                while (resource.getColumnByName(name) != null) {
                    name = baseName + i++;
                }
                AliasSymbol alias = new AliasSymbol(name, expr);
                item = orderBy.addVariable((Expression)alias, !obitem.isDescending());
                visitor.getEntityResource().addProjectedColumn((Expression)alias, (EdmType)EdmInt32.getInstance(), null, false);
            }
            if (obitem.isDescending()) {
                item.setNullOrdering(SortSpecification.NullOrdering.LAST);
                continue;
            }
            item.setNullOrdering(SortSpecification.NullOrdering.FIRST);
        }
        return orderBy;
    }

    public void visit(FilterOption info) {
        ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(this.context, this.prepared, this.getUriInfo(), this.metadata, this.odata, this.nameGenerator, this.params, this.parseService);
        Expression filter = null;
        try {
            filter = visitor.getExpression(info.getExpression());
        }
        catch (TeiidException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        this.context = visitor.getEntityResource();
        this.context.addCriteria(filter);
    }

    public void visit(UriResourceNavigation info) {
        EdmNavigationProperty property = info.getProperty();
        try {
            DocumentNode joinResource = DocumentNode.build(property.getType(), info.getKeyPredicates(), this.metadata, this.odata, this.nameGenerator, true, this.getUriInfo(), this.parseService);
            this.context.joinTable(joinResource, property, JoinType.JOIN_INNER);
            if (joinResource.getCriteria() == null) {
                joinResource.addCriteria((Expression)this.context.getCriteria());
            }
            this.context = joinResource;
            this.navigation = true;
        }
        catch (TeiidException e) {
            this.exceptions.add((Exception)((Object)e));
        }
    }

    public void visit(UriResourcePrimitiveProperty info) {
        String propertyName = info.getProperty().getName();
        ElementSymbol es = new ElementSymbol(propertyName, this.context.getGroupSymbol());
        this.context.addProjectedColumn(propertyName, (Expression)es);
        this.selectionComplete = true;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void visit(SkipTokenOption option) {
        if (option != null) {
            this.nextToken = option.getValue();
        }
    }

    public void visit(SearchOption option) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException((BundleUtil.Event)ODataPlugin.Event.TEIID16035, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16035, new Object[0]))));
    }

    public Insert insert(EdmEntityType entityType, Entity entity, List<UriParameter> keys, boolean prepared) throws TeiidException {
        Table entityTable = this.findTable(entityType.getName(), this.metadata);
        DocumentNode resource = new DocumentNode(entityTable, new GroupSymbol(entityTable.getFullName()), entityType);
        ArrayList<Reference> referenceValues = new ArrayList<Reference>();
        ArrayList<Constant> constantValues = new ArrayList<Constant>();
        Insert insert = new Insert();
        insert.setGroup(resource.getGroupSymbol());
        if (keys != null) {
            for (UriParameter key : keys) {
                EdmProperty edmProperty = (EdmProperty)entityType.getProperty(key.getName());
                Column column = entityTable.getColumnByName(edmProperty.getName());
                Object propertyValue = ODataTypeManager.parseLiteral((EdmProperty)edmProperty, (Class)column.getJavaType(), (String)key.getText());
                Property existing = entity.getProperty(edmProperty.getName());
                if (!(existing == null || existing.getValue() == null && propertyValue != null || existing.getValue() != null && propertyValue == null) && (existing.getValue() == null || existing.getValue().equals(propertyValue))) continue;
                throw new TeiidProcessingException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16048, new Object[]{edmProperty.getName()}));
            }
        }
        int i = 0;
        for (Property prop : entity.getProperties()) {
            EdmProperty edmProp = (EdmProperty)entityType.getProperty(prop.getName());
            Column column = entityTable.getColumnByName(edmProp.getName());
            insert.addVariable(new ElementSymbol(column.getName(), resource.getGroupSymbol()));
            if (prepared) {
                referenceValues.add(new Reference(i++));
                this.params.add(ODataSQLBuilder.asParam(edmProp, prop.getValue()));
                continue;
            }
            constantValues.add(new Constant(ODataSQLBuilder.asParam(edmProp, prop.getValue()).getValue()));
        }
        if (prepared) {
            insert.setValues(referenceValues);
        } else {
            insert.setValues(constantValues);
        }
        return insert;
    }

    static SQLParameter asParam(EdmProperty edmProp, Object value) throws TeiidException {
        return ODataSQLBuilder.asParam(edmProp, value, false);
    }

    static SQLParameter asParam(EdmProperty edmProp, Object value, boolean rawValue) throws TeiidException {
        String teiidType = ODataTypeManager.teiidType((SingletonPrimitiveType)((SingletonPrimitiveType)edmProp.getType()), (boolean)edmProp.isCollection());
        int sqlType = JDBCSQLTypeInfo.getSQLType((String)teiidType);
        if (value == null) {
            return new SQLParameter(null, sqlType);
        }
        if (rawValue) {
            return new SQLParameter(ODataTypeManager.convertByteArrayToTeiidRuntimeType((Class)DataTypeManager.getDataTypeClass((String)teiidType), (byte[])((byte[])value), (String)((SingletonPrimitiveType)edmProp.getType()).getFullQualifiedName().getFullQualifiedNameAsString(), edmProp.getSrid() != null ? edmProp.getSrid().toString() : null), sqlType);
        }
        return new SQLParameter(ODataTypeManager.convertToTeiidRuntimeType((Class)DataTypeManager.getDataTypeClass((String)teiidType), (Object)value, (String)((SingletonPrimitiveType)edmProp.getType()).getFullQualifiedName().getFullQualifiedNameAsString(), edmProp.getSrid() != null ? edmProp.getSrid().toString() : null), sqlType);
    }

    private Table findTable(String tableName, MetadataStore store) {
        Table t;
        Schema s;
        int idx = tableName.indexOf(46);
        if (idx > 0 && (s = store.getSchema(tableName.substring(0, idx))) != null && (t = s.getTable(tableName.substring(idx + 1))) != null) {
            return t;
        }
        for (Schema s2 : store.getSchemaList()) {
            Table t2 = (Table)s2.getTables().get(tableName);
            if (t2 == null) continue;
            return t2;
        }
        return null;
    }

    public Query selectWithEntityKey(EdmEntityType entityType, Entity entity, Map<String, Object> generatedKeys, List<TeiidServiceHandler.ExpandNode> expand) throws TeiidException {
        Table table = this.findTable(entityType.getName(), this.metadata);
        DocumentNode resource = new DocumentNode(table, new GroupSymbol(table.getFullName()), entityType);
        resource.setFromClause((FromClause)new UnaryFromClause(new GroupSymbol(table.getFullName())));
        resource.addAllColumns(false);
        this.context = resource;
        Query query = this.context.buildQuery();
        this.processExpand(expand, resource, query, 1);
        CompareCriteria criteria = null;
        KeyRecord pk = ODataSchemaBuilder.getIdentifier(table);
        for (Column c : pk.getColumns()) {
            Property prop = entity.getProperty(c.getName());
            Constant right = null;
            if (prop != null) {
                right = new Constant(ODataTypeManager.convertToTeiidRuntimeType((Class)c.getJavaType(), (Object)prop.getValue(), null, (String)c.getProperty("teiid_spatial:srid", false)));
            } else {
                Object value = generatedKeys.get(c.getName());
                if (value == null) {
                    throw new TeiidProcessingException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16016, new Object[]{entityType.getName()}));
                }
                right = new Constant(value);
            }
            ElementSymbol left = new ElementSymbol(c.getName(), this.context.getGroupSymbol());
            if (criteria == null) {
                criteria = new CompareCriteria((Expression)left, 1, (Expression)right);
                continue;
            }
            CompareCriteria rightCC = new CompareCriteria((Expression)left, 1, (Expression)right);
            criteria = new CompoundCriteria(0, (Criteria)criteria, (Criteria)rightCC);
        }
        query.setCriteria(criteria);
        return query;
    }

    private void processExpand(List<TeiidServiceHandler.ExpandNode> expand, DocumentNode resource, Query outerQuery, int expandLevel) throws TeiidException {
        if (expand.isEmpty()) {
            return;
        }
        ODataSQLBuilder.checkExpandLevel(expandLevel);
        for (TeiidServiceHandler.ExpandNode expandNode : expand) {
            ExpandDocumentNode expandResource = ExpandDocumentNode.buildExpand(expandNode.navigationProperty, this.metadata, this.odata, this.nameGenerator, this.aliasedGroups, this.getUriInfo(), this.parseService, this.context);
            OrderBy expandOrder = expandResource.addDefaultOrderBy();
            expandResource.addAllColumns(false);
            resource.addExpand(expandResource);
            Query query = expandResource.buildQuery();
            this.processExpand(expandNode.children, expandResource, query, expandLevel + 1);
            this.buildAggregateQuery(resource, outerQuery, expandResource, expandOrder, query, expandNode.navigationProperty);
        }
    }

    public Update update(EdmEntityType entityType, Entity entity, boolean prepared) throws TeiidException {
        Update update = new Update();
        update.setGroup(this.context.getGroupSymbol());
        int i = 0;
        for (Property property : entity.getProperties()) {
            EdmProperty edmProperty = (EdmProperty)entityType.getProperty(property.getName());
            DocumentNode.ContextColumn column = this.context.getColumnByName(edmProperty.getName());
            ElementSymbol symbol = new ElementSymbol(column.getName(), this.context.getGroupSymbol());
            boolean add = true;
            for (String c : this.context.getKeyColumnNames()) {
                if (!c.equals(column.getName())) continue;
                add = false;
                break;
            }
            if (!add) continue;
            if (prepared) {
                update.addChange(symbol, (Expression)new Reference(i++));
                this.params.add(ODataSQLBuilder.asParam(edmProperty, property.getValue()));
                continue;
            }
            update.addChange(symbol, (Expression)new Constant(ODataSQLBuilder.asParam(edmProperty, property.getValue()).getValue()));
        }
        update.setCriteria(this.context.getCriteria());
        return update;
    }

    public Update updateProperty(EdmProperty edmProperty, Property property, boolean prepared, boolean rawValue) throws TeiidException {
        Update update = new Update();
        update.setGroup(this.context.getGroupSymbol());
        DocumentNode.ContextColumn column = this.context.getColumnByName(edmProperty.getName());
        ElementSymbol symbol = new ElementSymbol(column.getName(), this.context.getGroupSymbol());
        if (prepared) {
            update.addChange(symbol, (Expression)new Reference(0));
            this.params.add(ODataSQLBuilder.asParam(edmProperty, property.getValue(), rawValue));
        } else {
            update.addChange(symbol, (Expression)new Constant(ODataSQLBuilder.asParam(edmProperty, property.getValue()).getValue()));
        }
        update.setCriteria(this.context.getCriteria());
        return update;
    }

    public Update updateStreamProperty(EdmProperty edmProperty, final InputStream content) throws TeiidException {
        Update update = new Update();
        update.setGroup(this.context.getGroupSymbol());
        DocumentNode.ContextColumn column = this.context.getColumnByName(edmProperty.getName());
        ElementSymbol symbol = new ElementSymbol(column.getName(), this.context.getGroupSymbol());
        update.addChange(symbol, (Expression)new Reference(0));
        Class lobType = DataTypeManager.getDataTypeClass((String)column.getRuntimeType());
        int sqlType = JDBCSQLTypeInfo.getSQLType((String)column.getRuntimeType());
        if (content == null) {
            this.params.add(new SQLParameter(null, sqlType));
        } else {
            SQLXMLImpl value = null;
            InputStreamFactory isf = new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return content;
                }
            };
            if (lobType.isAssignableFrom(SQLXML.class)) {
                value = new SQLXMLImpl(isf);
            } else if (lobType.isAssignableFrom(ClobType.class)) {
                value = new ClobImpl(isf, -1L);
            } else if (lobType.isAssignableFrom(BlobType.class)) {
                value = new BlobImpl(isf);
            } else {
                throw new TeiidException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16031, new Object[]{column.getName()}));
            }
            this.params.add(new SQLParameter(value, sqlType));
        }
        update.setCriteria(this.context.getCriteria());
        return update;
    }

    public Delete delete() {
        Delete delete = new Delete();
        delete.setGroup(this.context.getGroupSymbol());
        delete.setCriteria(this.context.getCriteria());
        return delete;
    }

    public void visit(UriInfoService info) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("UriInfoService Not Implemented")));
    }

    public void visit(UriInfoAll info) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("UriInfoAll Not Implemented")));
    }

    public void visit(UriInfoBatch info) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("UriInfoBatch Not Implemented")));
    }

    public void visit(UriInfoCrossjoin info) {
        for (String name : info.getEntitySetNames()) {
            EdmEntitySet entitySet = this.serviceMetadata.getEdm().getEntityContainer().getEntitySet(name);
            EdmEntityType entityType = entitySet.getEntityType();
            CrossJoinNode resource = null;
            try {
                boolean hasExpand = this.hasExpand(entitySet.getName(), info.getExpandOption());
                resource = CrossJoinNode.buildCrossJoin(entityType, this.metadata, this.odata, this.nameGenerator, this.aliasedGroups, this.getUriInfo(), this.parseService, hasExpand);
                resource.addAllColumns(!hasExpand);
                if (this.context == null) {
                    this.context = resource;
                    this.orderBy = this.context.addDefaultOrderBy();
                    continue;
                }
                this.context.addSibling(resource);
                OrderBy orderby = resource.addDefaultOrderBy();
                int index = orderby.getVariableCount();
                for (int i = 0; i < index; ++i) {
                    this.orderBy.addVariable(orderby.getVariable(i));
                }
            }
            catch (TeiidException e) {
                this.exceptions.add((Exception)((Object)e));
            }
        }
        super.visit(info);
        this.expandOption = null;
    }

    private boolean hasExpand(String name, ExpandOption expandOption) {
        if (expandOption == null) {
            return false;
        }
        for (ExpandItem ei : expandOption.getExpandItems()) {
            String expand = ((UriResourceEntitySetImpl)ei.getResourcePath().getUriResourceParts().get(0)).getEntitySet().getName();
            if (!expand.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void visit(UriInfoMetadata info) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("UriInfoMetadata Not Implemented")));
    }

    public void visit(ExpandOption option) {
        this.expandOption = option;
    }

    public void visit(FormatOption info) {
    }

    public void visit(ApplyOption apply) {
        this.visit(apply, null);
    }

    public void visit(ApplyOption apply, ApplyDocumentNode currentContext) {
        block5: for (ApplyItem item : apply.getApplyItems()) {
            switch (item.getKind()) {
                case AGGREGATE: {
                    this.applyAggregate(apply, (Aggregate)item, currentContext);
                    currentContext = null;
                    continue block5;
                }
                case FILTER: {
                    if (currentContext != null) {
                        this.context = currentContext;
                        currentContext = null;
                    }
                    Filter filter = (Filter)item;
                    FilterOption filterOption = filter.getFilterOption();
                    this.visit(filterOption);
                    continue block5;
                }
                case GROUP_BY: {
                    if (currentContext != null) {
                        this.context = currentContext;
                        currentContext = null;
                    }
                    this.applyGroupBy(apply, (GroupBy)item);
                    continue block5;
                }
            }
            this.exceptions.add((Exception)((Object)new TeiidNotImplementedException(item.getKind().toString())));
            return;
        }
        if (!this.exceptions.isEmpty()) {
            return;
        }
    }

    private void applyGroupBy(ApplyOption apply, GroupBy groupBy) throws AssertionError {
        List groupByItems = groupBy.getGroupByItems();
        org.teiid.query.sql.lang.GroupBy grouping = new org.teiid.query.sql.lang.GroupBy();
        for (int i = 0; i < groupByItems.size(); ++i) {
            Expression ex;
            GroupByItem gbi = (GroupByItem)groupByItems.get(i);
            if (!gbi.getRollup().isEmpty() || gbi.isRollupAll()) {
                this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("rollup")));
                return;
            }
            List path = gbi.getPath();
            if (path.isEmpty()) {
                this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("empty path")));
                return;
            }
            UriInfoImpl impl = new UriInfoImpl();
            for (UriResource resource : path) {
                impl.addResourcePart(resource);
            }
            ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(this.context, false, this.getUriInfo(), this.metadata, this.odata, this.nameGenerator, this.params, this.parseService);
            try {
                ex = visitor.getExpression((UriInfoResource)impl);
            }
            catch (TeiidException e) {
                this.exceptions.add((Exception)((Object)e));
                return;
            }
            String alias = Symbol.getShortName((Expression)ex);
            AliasSymbol as = new AliasSymbol(alias, ex);
            EdmProperty property = apply.getEdmStructuredType().getStructuralProperty(alias);
            this.context.addProjectedColumn((Expression)as, property.getType(), property, property.isCollection());
            grouping.addSymbol(ex);
        }
        ApplyDocumentNode adn = ApplyDocumentNode.buildApplyDocumentNode(this.context, this.nameGenerator, apply.getEdmStructuredType());
        adn.setGroupBy(grouping);
        if (groupBy.getApplyOption() != null) {
            ApplyOption applyOption = groupBy.getApplyOption();
            this.visit(applyOption, adn);
        } else {
            this.context = adn;
        }
    }

    private void applyAggregate(ApplyOption apply, Aggregate aggregate, ApplyDocumentNode currentContext) {
        List expressions = aggregate.getExpressions();
        for (int i = 0; i < expressions.size(); ++i) {
            Expression ex;
            AggregateExpression ae = (AggregateExpression)expressions.get(i);
            if (ae.getCustomMethod() != null || !ae.getPath().isEmpty()) {
                this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("custom aggregate method")));
                return;
            }
            if (!ae.getFrom().isEmpty()) {
                this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("aggregate from")));
                return;
            }
            if (ae.getInlineAggregateExpression() != null) {
                this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("inline aggregate")));
                return;
            }
            AggregateExpression.StandardMethod sm = ae.getStandardMethod();
            String alias = ae.getAlias();
            boolean distinct = false;
            String agg = null;
            switch (sm) {
                case COUNT_DISTINCT: {
                    distinct = true;
                    agg = "COUNT";
                    break;
                }
                case AVERAGE: 
                case MAX: 
                case MIN: 
                case SUM: {
                    agg = sm.name();
                    break;
                }
                default: {
                    this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("unknown aggregate")));
                    return;
                }
            }
            ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(currentContext != null ? currentContext.getNestedContext() : this.context, false, this.getUriInfo(), this.metadata, this.odata, this.nameGenerator, this.params, this.parseService);
            try {
                ex = visitor.getExpression(ae.getExpression());
            }
            catch (TeiidException e) {
                this.exceptions.add((Exception)((Object)e));
                return;
            }
            AliasSymbol as = new AliasSymbol(alias, (Expression)new AggregateSymbol(agg, distinct, ex));
            EdmProperty property = apply.getEdmStructuredType().getStructuralProperty(alias);
            this.context.addProjectedColumn((Expression)as, property.getType(), property, property.isCollection());
        }
        this.context = currentContext == null ? ApplyDocumentNode.buildApplyDocumentNode(this.context, this.nameGenerator, apply.getEdmStructuredType()) : currentContext;
    }

    public void visit(UriInfoEntityId info) {
        try {
            this.visit(ODataSQLBuilder.buildUriInfo(new URI(info.getIdOption().getValue()), this.baseURI, this.serviceMetadata, this.odata));
        }
        catch (URISyntaxException | ODataLibraryException e) {
            this.exceptions.add((Exception)e);
        }
        this.visit(info.getSelectOption());
        if (info.getExpandOption() != null) {
            this.visit(info.getExpandOption());
        }
        if (info.getFormatOption() != null) {
            this.visit(info.getFormatOption());
        }
    }

    static UriInfo buildUriInfo(URI uri, String baseUri, ServiceMetadata serviceMetadata, OData odata) throws URISyntaxException, UriParserException, UriValidationException {
        URI servicePath = new URI(baseUri);
        String path = servicePath.getPath();
        String rawPath = uri.getPath();
        int e = rawPath.indexOf(path);
        rawPath = -1 == e ? uri.getPath() : rawPath.substring(e + path.length());
        return new Parser(serviceMetadata.getEdm(), odata).parseUri(rawPath, uri.getQuery(), null, baseUri);
    }

    public void visit(UriResourceCount option) {
        if (option != null) {
            this.countQuery = true;
        }
    }

    public void visit(UriResourceRef info) {
        this.reference = true;
    }

    public void visit(UriResourceRoot info) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("UriResourceRoot Not Implemented")));
    }

    public void visit(UriResourceValue info) {
    }

    public void visit(UriResourceAction info) {
        this.visitOperation((EdmOperation)info.getAction());
    }

    public void visit(UriResourceFunction info) {
        this.visitOperation((EdmOperation)info.getFunction());
    }

    private void visitOperation(EdmOperation operation) {
        try {
            ProcedureSQLBuilder builder = new ProcedureSQLBuilder(this.metadata, operation, this.parameters, this.params);
            ProcedureSQLBuilder.ProcedureReturn pp = builder.getReturn();
            if (pp == null) {
                pp = new ProcedureSQLBuilder.ProcedureReturn(null, null, false);
            }
            if (pp.hasResultSet()) {
                ComplexDocumentNode cdn = ComplexDocumentNode.buildComplexDocumentNode(operation, this.metadata, this.nameGenerator);
                cdn.setProcedureReturn(pp);
                this.context = cdn;
            } else {
                NoDocumentNode ndn = new NoDocumentNode();
                ndn.setProcedureReturn(pp);
                ndn.setQuery(builder.buildProcedureSQL());
                this.context = ndn;
            }
        }
        catch (TeiidProcessingException e) {
            throw new ODataRuntimeException((Exception)((Object)e));
        }
    }

    public void visit(UriResourceIt info) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("UriResourceIt Not Implemented")));
    }

    public void visit(UriResourceLambdaAll info) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("UriResourceLambdaAll Not Implemented")));
    }

    public void visit(UriResourceLambdaAny info) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("UriResourceLambdaAll Not Implemented")));
    }

    public void visit(UriResourceLambdaVariable info) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("UriResourceLambdaVariable Not Implemented")));
    }

    public void visit(UriResourceSingleton info) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("UriResourceSingleton Not Implemented")));
    }

    public void visit(UriResourceComplexProperty info) {
        this.exceptions.add((Exception)((Object)new TeiidNotImplementedException("UriResourceComplexProperty Not Implemented")));
    }

    public void setOperationParameterValueProvider(TeiidServiceHandler.OperationParameterValueProvider parameters) {
        this.parameters = parameters;
    }

    class URLParseService {
        URLParseService() {
        }

        public Query parse(String rawPath, String baseUri) throws TeiidException {
            try {
                rawPath = rawPath.replace("$root", "");
                UriInfo uriInfo = new Parser(ODataSQLBuilder.this.serviceMetadata.getEdm(), ODataSQLBuilder.this.odata).parseUri(rawPath, null, null, baseUri);
                ODataSQLBuilder visitor = new ODataSQLBuilder(ODataSQLBuilder.this.odata, ODataSQLBuilder.this.metadata, ODataSQLBuilder.this.prepared, ODataSQLBuilder.this.aliasedGroups, ODataSQLBuilder.this.baseURI, ODataSQLBuilder.this.serviceMetadata){

                    @Override
                    public void visit(OrderByOption option) {
                    }
                };
                visitor.nameGenerator = ODataSQLBuilder.this.nameGenerator;
                visitor.visit(uriInfo);
                return visitor.selectQuery();
            }
            catch (ODataApplicationException | ODataLibraryException e) {
                throw new TeiidException(e);
            }
        }
    }
}

