/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.core.serializer.SerializerResultImpl;
import org.apache.olingo.server.core.serializer.json.ODataJsonSerializer;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.utils.ContentTypeHelper;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;
import org.teiid.olingo.ComplexReturnType;

public class TeiidODataJsonSerializer
extends ODataJsonSerializer {
    private boolean isODataMetadataFull;
    private boolean isODataMetadataNone;

    public TeiidODataJsonSerializer(ContentType contentType) {
        super(contentType);
        this.isODataMetadataNone = ContentTypeHelper.isODataMetadataNone((ContentType)contentType);
        this.isODataMetadataFull = ContentTypeHelper.isODataMetadataFull((ContentType)contentType);
    }

    public SerializerResult complexCollection(ServiceMetadata metadata, List<List<ComplexReturnType>> result, ContextURL contextURL, URI nextLink) throws SerializerException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            json.writeStartObject();
            if (contextURL != null && (this.isODataMetadataFull || !this.isODataMetadataNone)) {
                json.writeStringField("@odata.context", ContextURLBuilder.create((ContextURL)contextURL).toASCIIString());
            }
            json.writeFieldName("value");
            json.writeStartArray();
            for (List<ComplexReturnType> ct : result) {
                boolean isCross = ct.size() > 1;
                json.writeStartObject();
                for (ComplexReturnType type : ct) {
                    if (!type.isExpand() && type.getEntity().getId() != null) {
                        json.writeStringField(type.getName() + "@odata.navigationLink", type.getEntity().getId().toASCIIString());
                        continue;
                    }
                    if (isCross) {
                        json.writeFieldName(type.getName());
                    }
                    if (type.getEdmStructuredType() instanceof EdmEntityType) {
                        this.writeEntity(metadata, (EdmEntityType)type.getEdmStructuredType(), type.getEntity(), null, null, null, null, false, null, type.getName(), json);
                        continue;
                    }
                    if (isCross) {
                        json.writeStartObject();
                    }
                    json.writeStringField("@odata.id", "null");
                    for (Property property : type.getEntity().getProperties()) {
                        EdmProperty edmProperty = type.getEdmStructuredType().getStructuralProperty(property.getName());
                        this.writeProperty(metadata, edmProperty, property, null, json, null, (Linked)type.getEntity(), null);
                    }
                    if (!isCross) continue;
                    json.writeEndObject();
                }
                json.writeEndObject();
            }
            json.writeEndArray();
            if (nextLink != null) {
                json.writeStringField("@odata.nextLink", nextLink.toASCIIString());
            }
            json.close();
        }
        catch (IOException | DecoderException e) {
            throw new SerializerException("An I/O exception occurred.", e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return SerializerResultImpl.with().content(buffer.getInputStream()).build();
    }

    public SerializerResult complexCollection(ServiceMetadata metadata, EdmComplexType type, Property result, ContextURL contextURL, URI nextLink) throws SerializerException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            json.writeStartObject();
            if (contextURL != null && (this.isODataMetadataFull || !this.isODataMetadataNone)) {
                json.writeStringField("@odata.context", ContextURLBuilder.create((ContextURL)contextURL).toASCIIString());
            }
            json.writeFieldName("value");
            json.writeStartArray();
            for (Object value : result.asCollection()) {
                json.writeStartObject();
                this.writeComplexValue(metadata, type, ((ComplexValue)value).getValue(), null, json, null, (Linked)((ComplexValue)value), null, result.getName());
                json.writeEndObject();
            }
            json.writeEndArray();
            if (nextLink != null) {
                json.writeStringField("@odata.nextLink", nextLink.toASCIIString());
            }
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return SerializerResultImpl.with().content(buffer.getInputStream()).build();
    }
}

