/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.olingo.ProjectedColumn;
import org.teiid.olingo.service.DocumentNode;
import org.teiid.olingo.service.TeiidServiceHandler;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;

public class ApplyDocumentNode
extends DocumentNode {
    private DocumentNode context;
    private GroupBy groupBy;

    public static ApplyDocumentNode buildApplyDocumentNode(DocumentNode previousContext, TeiidServiceHandler.UniqueNameGenerator nameGenerator, EdmStructuredType edmStructuredType) {
        ApplyDocumentNode resource = new ApplyDocumentNode(previousContext);
        String group = nameGenerator.getNextGroup();
        resource.setGroupSymbol(new GroupSymbol(group));
        resource.setEdmStructuredType(edmStructuredType);
        return resource;
    }

    public ApplyDocumentNode(DocumentNode context) {
        this.context = context;
    }

    DocumentNode getNestedContext() {
        return this.context;
    }

    @Override
    protected void addAllColumns(boolean onlyPK) {
    }

    @Override
    OrderBy addDefaultOrderBy() {
        return null;
    }

    @Override
    public Query buildQuery() {
        Query inner = this.context.buildQuery();
        inner.setGroupBy(this.groupBy);
        Query query = new Query();
        query.setSelect(new Select());
        if (this.projectedColumns.size() > 0) {
            AtomicInteger ordinal = new AtomicInteger(1);
            this.addColumns(query.getSelect(), ordinal, this.sortColumns(this.getProjectedColumns().values()));
        } else {
            query.getSelect().addSymbol((Expression)new MultipleElementSymbol());
        }
        query.setFrom(new From(Arrays.asList(new SubqueryFromClause(this.getGroupSymbol(), (Command)inner))));
        query.setCriteria(this.getCriteria());
        return query;
    }

    public DocumentNode getBaseContext() {
        if (this.context instanceof ApplyDocumentNode) {
            return ((ApplyDocumentNode)this.context).getBaseContext();
        }
        return this.context;
    }

    @Override
    public DocumentNode.ContextColumn getColumnByName(String name) {
        if (this.projectedColumnsByName.size() > 0) {
            return (DocumentNode.ContextColumn)this.projectedColumnsByName.get(name);
        }
        if (this.context.projectedColumnsByName.size() > 0) {
            return this.context.projectedColumnsByName.get(name);
        }
        return this.context.getColumnByName(name);
    }

    @Override
    public String getName() {
        return this.context.getName();
    }

    @Override
    public String toString() {
        return "Apply " + this.getGroupSymbol() + " " + this.context;
    }

    @Override
    public List<DocumentNode> getSiblings() {
        return this.context.getSiblings();
    }

    public void setGroupBy(GroupBy grouping) {
        this.groupBy = grouping;
    }

    @Override
    public List<ProjectedColumn> getAllProjectedColumns() {
        List<ProjectedColumn> all = super.getAllProjectedColumns();
        if (this.projectedColumns.size() == 0) {
            all.addAll(this.context.getAllProjectedColumns());
        }
        return all;
    }

    @Override
    Criteria buildJoinCriteria(DocumentNode joinResource, EdmNavigationProperty property) throws TeiidException {
        throw new TeiidRuntimeException("not implemented");
    }

    @Override
    public String getFullName() {
        throw new TeiidRuntimeException("not implemented");
    }

    @Override
    public void addSibling(DocumentNode resource) {
        throw new TeiidRuntimeException("not implemented");
    }

    @Override
    public FromClause getFromClause() {
        throw new TeiidRuntimeException("not implemented");
    }
}

