/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.teiid.odata.api.ComplexResponse;
import org.teiid.olingo.ComplexReturnType;
import org.teiid.olingo.TeiidODataJsonSerializer;
import org.teiid.olingo.service.ApplyDocumentNode;
import org.teiid.olingo.service.CrossJoinNode;
import org.teiid.olingo.service.DocumentNode;
import org.teiid.olingo.service.EntityCollectionResponse;

public class ApplyResult
implements ComplexResponse {
    private String nextToken;
    private ApplyDocumentNode documentNode;
    private List<List<ComplexReturnType>> out = new ArrayList<List<ComplexReturnType>>();
    private String baseURL;

    public ApplyResult(String baseURL, ApplyDocumentNode context) {
        this.baseURL = baseURL;
        this.documentNode = context;
    }

    @Override
    public void addRow(ResultSet rs) throws SQLException {
        ArrayList<ComplexReturnType> row = new ArrayList<ComplexReturnType>();
        Entity entity = EntityCollectionResponse.createEntity(rs, (DocumentNode)this.documentNode, this.baseURL, null);
        DocumentNode base = this.documentNode.getBaseContext();
        if (base instanceof CrossJoinNode) {
            row.add(new ComplexReturnType(base.getName(), this.documentNode.getEdmStructuredType(), entity, ((CrossJoinNode)base).hasExpand()));
            for (DocumentNode node : base.getSiblings()) {
                Entity sibiling = EntityCollectionResponse.createEntity(rs, node, this.baseURL, null);
                row.add(new ComplexReturnType(node.getName(), node.getEdmStructuredType(), sibiling, ((CrossJoinNode)node).hasExpand()));
            }
        } else {
            row.add(new ComplexReturnType(base.getName(), this.documentNode.getEdmStructuredType(), entity, false));
        }
        this.out.add(row);
    }

    public List<List<ComplexReturnType>> getResults() {
        return this.out;
    }

    @Override
    public long size() {
        return this.out.size();
    }

    @Override
    public void setCount(long count) {
    }

    @Override
    public void setNextToken(String token) {
        this.nextToken = token;
    }

    @Override
    public String getNextToken() {
        return this.nextToken;
    }

    @Override
    public void serialize(ODataResponse response, TeiidODataJsonSerializer serializer, ServiceMetadata metadata, ContextURL contextURL, URI next) throws SerializerException {
        response.setContent(serializer.complexCollection(metadata, this.getResults(), contextURL, next).getContent());
    }

    public ApplyDocumentNode getDocumentNode() {
        return this.documentNode;
    }
}

