/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlOperation;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlReferentialConstraint;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlCollection;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlConstantExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.olingo.service.TeiidEdmProvider;

public class ODataSchemaBuilder {
    public static final String VISIBLE = "teiid_odata:visible";
    static Pattern NAME_PATTERN = Pattern.compile("[\\p{L}\\p{Nl}][\\p{L}\\p{Nl}\\p{Nd}\\p{Mn}\\p{Mc}\\p{Pc}\\p{Cf}]{0,}");

    public static CsdlSchema buildMetadata(String namespace, Schema teiidSchema) {
        final ODataSchemaInfo info = ODataSchemaBuilder.buildStructuralMetadata(namespace, teiidSchema, teiidSchema.getName());
        ODataSchemaBuilder.buildNavigationProperties(teiidSchema, info, new SchemaResolver(){

            @Override
            public ODataSchemaInfo getSchemaInfo(String schemaName) {
                return info;
            }
        });
        return info.schema;
    }

    public static ODataSchemaInfo buildStructuralMetadata(String namespace, Schema teiidSchema, String alias) {
        try {
            ODataSchemaInfo info = new ODataSchemaInfo();
            String fullSchemaName = namespace + "." + teiidSchema.getName();
            info.schema.setNamespace(fullSchemaName).setAlias(alias);
            ODataSchemaBuilder.buildEntityTypes(teiidSchema, info.schema, info.entitySets, info.entityTypes);
            ODataSchemaBuilder.buildProcedures(teiidSchema, info.schema);
            return info;
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    static void buildEntityTypes(Schema schema, CsdlSchema csdlSchema, Map<String, CsdlEntitySet> entitySets, Map<String, CsdlEntityType> entityTypes) {
        String fullSchemaName = csdlSchema.getNamespace();
        for (Table table : schema.getTables().values()) {
            Object c2;
            KeyRecord primaryKey = ODataSchemaBuilder.getIdentifier(table);
            if (primaryKey == null) {
                LogManager.logDetail((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16017, new Object[]{table.getFullName()}));
                continue;
            }
            if (!ODataSchemaBuilder.isObjectVisible((AbstractMetadataRecord)table)) continue;
            String entityTypeName = table.getName();
            CsdlEntityType entityType = new CsdlEntityType().setName(entityTypeName);
            ArrayList<CsdlProperty> properties = new ArrayList<CsdlProperty>();
            for (Object c2 : table.getColumns()) {
                boolean nullable = c2.getNullType() == BaseColumn.NullType.Nullable;
                CsdlProperty property = ODataSchemaBuilder.buildProperty((Column)c2, ODataSchemaBuilder.hasColumn(primaryKey, c2.getName()) ? false : nullable);
                ODataSchemaBuilder.addColumnAnnotations((Column)c2, property, csdlSchema);
                properties.add(property);
            }
            entityType.setProperties(properties);
            if (ODataSchemaBuilder.hasStream(properties)) {
                entityType.setHasStream(true);
            }
            ArrayList<CsdlPropertyRef> keyProps = new ArrayList<CsdlPropertyRef>();
            c2 = primaryKey.getColumns().iterator();
            while (c2.hasNext()) {
                Column c3 = (Column)c2.next();
                keyProps.add(new CsdlPropertyRef().setName(c3.getName()));
            }
            entityType.setKey(keyProps);
            ODataSchemaBuilder.addTableAnnotations(table, entityType, csdlSchema);
            CsdlEntitySet entitySet = new CsdlEntitySet().setName(entityTypeName).setType(new FullQualifiedName(fullSchemaName, entityTypeName)).setIncludeInServiceDocument(true);
            entityTypes.put(entityTypeName, entityType);
            entitySets.put(entityTypeName, entitySet);
        }
        CsdlEntityContainer entityContainer = new CsdlEntityContainer().setName(csdlSchema.getAlias()).setEntitySets(new ArrayList<CsdlEntitySet>(entitySets.values()));
        csdlSchema.setEntityTypes(new ArrayList<CsdlEntityType>(entityTypes.values())).setEntityContainer(entityContainer);
    }

    private static boolean isObjectVisible(AbstractMetadataRecord record) {
        String visible = record.getProperty(VISIBLE, false);
        return visible == null || Boolean.valueOf(visible) != false;
    }

    private static boolean hasStream(List<CsdlProperty> properties) {
        for (CsdlProperty p : properties) {
            if (!p.getType().equals(EdmPrimitiveTypeKind.Stream.getFullQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }

    private static CsdlProperty buildProperty(Column c, boolean nullable) {
        String srid;
        int precision;
        String runtimeType = c.getRuntimeType();
        CsdlProperty property = new CsdlProperty().setName(c.getName()).setType(ODataTypeManager.odataType((BaseColumn)c).getFullQualifiedName()).setNullable(nullable);
        if (DataTypeManager.isArrayType((String)runtimeType)) {
            property.setCollection(true);
        }
        if ((runtimeType = ODataTypeManager.teiidType((String)property.getType(), (boolean)false)).equals("string") || runtimeType.equals("varbinary")) {
            property.setMaxLength(Integer.valueOf(c.getLength()));
            if (runtimeType.equals("string")) {
                property.setUnicode(true);
            }
        } else if (runtimeType.equals("bigdecimal") || runtimeType.equals("biginteger")) {
            if (c.getScale() < 0) {
                property.setPrecision(Integer.valueOf((int)Math.min(Integer.MAX_VALUE, (long)c.getPrecision() - (long)c.getScale())));
            } else {
                property.setPrecision(Integer.valueOf(c.getPrecision()));
            }
            property.setScale(Integer.valueOf(Math.max(0, c.getScale())));
        } else if (runtimeType.equals("timestamp") && ((precision = c.getScale()) != 0 || c.getPrecision() != 0)) {
            property.setPrecision(Integer.valueOf(precision));
        }
        if (c.getDefaultValue() != null) {
            property.setDefaultValue(c.getDefaultValue());
        }
        if ((srid = c.getProperty("teiid_spatial:srid", false)) != null) {
            property.setSrid(SRID.valueOf((String)srid));
        }
        return property;
    }

    static boolean hasColumn(KeyRecord pk, String columnName) {
        if (pk != null) {
            for (Column column : pk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    static KeyRecord getIdentifier(Table table) {
        if (table.getPrimaryKey() != null) {
            return table.getPrimaryKey();
        }
        Iterator iterator = table.getUniqueKeys().iterator();
        if (iterator.hasNext()) {
            KeyRecord key = (KeyRecord)iterator.next();
            return key;
        }
        return null;
    }

    static void buildNavigationProperties(Schema schema, ODataSchemaInfo info, SchemaResolver resolver) {
        for (Table table : schema.getTables().values()) {
            if (info.entitySets.get(table.getName()) == null) continue;
            for (ForeignKey fk : table.getForeignKeys()) {
                List setOne = ODataSchemaBuilder.getIdentifier(table).getColumns();
                List setTwo = fk.getColumns();
                boolean fkPKSame = setOne.equals(setTwo);
                ODataSchemaBuilder.addForwardNavigation(info.entityTypes, info.entitySets, table, fk, fkPKSame, resolver);
                ODataSchemaBuilder.addReverseNavigation(info, table, fk, fkPKSame, resolver);
            }
        }
    }

    private static void addForwardNavigation(Map<String, CsdlEntityType> entityTypes, Map<String, CsdlEntitySet> entitySets, Table table, ForeignKey fk, boolean onetoone, SchemaResolver resolver) {
        Table pkTable = (Table)fk.getReferenceKey().getParent();
        ODataSchemaInfo pkSchema = resolver.getSchemaInfo(((Schema)pkTable.getParent()).getName());
        if (pkSchema == null || pkSchema.entityTypes.get(pkTable.getName()) == null) {
            return;
        }
        String fqn = pkSchema.schema.getAlias() + '.' + pkTable.getName();
        CsdlNavigationPropertyBinding navigationBinding = ODataSchemaBuilder.buildNavigationBinding(fk, pkTable, fqn);
        CsdlNavigationProperty navigaton = ODataSchemaBuilder.buildNavigation(fk, fqn);
        String entityTypeName = table.getName();
        if (onetoone) {
            navigaton.setNullable(Boolean.valueOf(false));
        } else {
            for (Column c : fk.getColumns()) {
                if (c.getNullType() != BaseColumn.NullType.No_Nulls) continue;
                navigaton.setNullable(Boolean.valueOf(false));
                break;
            }
        }
        ArrayList<CsdlReferentialConstraint> constraints = new ArrayList<CsdlReferentialConstraint>();
        KeyRecord key = fk.getReferenceKey();
        for (int i = 0; i < key.getColumns().size(); ++i) {
            constraints.add(new CsdlReferentialConstraint().setReferencedProperty(((Column)key.getColumns().get(i)).getName()).setProperty(((Column)fk.getColumns().get(i)).getName()));
        }
        navigaton.setReferentialConstraints(constraints);
        CsdlEntityType entityType = entityTypes.get(entityTypeName);
        entityType.getNavigationProperties().add(navigaton);
        CsdlEntitySet entitySet = entitySets.get(entityTypeName);
        entitySet.getNavigationPropertyBindings().add(navigationBinding);
    }

    private static void addReverseNavigation(ODataSchemaInfo schema, Table table, ForeignKey fk, boolean onetoone, SchemaResolver resolver) {
        Table pkTable = (Table)fk.getReferenceKey().getParent();
        String entitySchema = ((Schema)pkTable.getParent()).getName();
        ODataSchemaInfo pkSchema = resolver.getSchemaInfo(entitySchema);
        if (pkSchema == null || pkSchema.entityTypes.get(pkTable.getName()) == null) {
            return;
        }
        String fqn = schema.schema.getAlias() + '.' + table.getName();
        CsdlNavigationPropertyBinding navigationBinding = ODataSchemaBuilder.buildReverseNavigationBinding(table, pkTable, fk, fqn);
        CsdlNavigationProperty navigaton = ODataSchemaBuilder.buildReverseNavigation(table, fk, fqn);
        String entityTypeName = fk.getReferenceTableName();
        if (onetoone) {
            navigaton.setNullable(Boolean.valueOf(false));
        } else {
            navigaton.setCollection(true);
        }
        CsdlEntityType entityType = pkSchema.entityTypes.get(entityTypeName);
        CsdlEntitySet entitySet = pkSchema.entitySets.get(entityTypeName);
        entityType.getNavigationProperties().add(navigaton);
        entitySet.getNavigationPropertyBindings().add(navigationBinding);
    }

    private static CsdlNavigationPropertyBinding buildNavigationBinding(ForeignKey fk, Table pkTable, String fqn) {
        CsdlNavigationPropertyBinding navigationBinding = new CsdlNavigationPropertyBinding();
        navigationBinding.setPath(fk.getName());
        if (!((Schema)((Table)fk.getParent()).getParent()).equals((Object)pkTable.getParent())) {
            navigationBinding.setTarget(fqn);
        } else {
            navigationBinding.setTarget(pkTable.getName());
        }
        return navigationBinding;
    }

    private static CsdlNavigationPropertyBinding buildReverseNavigationBinding(Table table, Table pkTable, ForeignKey fk, String fqn) {
        CsdlNavigationPropertyBinding navigationBinding = new CsdlNavigationPropertyBinding();
        navigationBinding.setPath(table.getName() + "_" + fk.getName());
        if (!((Schema)table.getParent()).equals((Object)pkTable.getParent())) {
            navigationBinding.setTarget(fqn);
        } else {
            navigationBinding.setTarget(table.getName());
        }
        return navigationBinding;
    }

    private static CsdlNavigationProperty buildNavigation(ForeignKey fk, String fqn) {
        CsdlNavigationProperty navigaton = new CsdlNavigationProperty();
        navigaton.setName(fk.getName()).setType(new FullQualifiedName(fqn));
        ArrayList constrainsts = new ArrayList();
        for (int i = 0; i < fk.getColumns().size(); ++i) {
            Column c = (Column)fk.getColumns().get(i);
            String refColumn = (String)fk.getReferenceColumns().get(i);
            CsdlReferentialConstraint constraint = new CsdlReferentialConstraint();
            constraint.setProperty(c.getName());
            constraint.setReferencedProperty(refColumn);
        }
        navigaton.setReferentialConstraints(constrainsts);
        return navigaton;
    }

    private static CsdlNavigationProperty buildReverseNavigation(Table table, ForeignKey fk, String fqn) {
        CsdlNavigationProperty navigaton = new CsdlNavigationProperty();
        navigaton.setName(table.getName() + "_" + fk.getName()).setType(new FullQualifiedName(fqn));
        ArrayList constrainsts = new ArrayList();
        for (int i = 0; i < fk.getColumns().size(); ++i) {
            Column c = (Column)fk.getColumns().get(i);
            String refColumn = (String)fk.getReferenceColumns().get(i);
            CsdlReferentialConstraint constraint = new CsdlReferentialConstraint();
            constraint.setProperty(refColumn);
            constraint.setReferencedProperty(c.getName());
        }
        navigaton.setReferentialConstraints(constrainsts);
        return navigaton;
    }

    static void buildProcedures(Schema schema, CsdlSchema csdlSchema) {
        ArrayList<CsdlComplexType> complexTypes = new ArrayList<CsdlComplexType>();
        ArrayList<CsdlFunction> functions = new ArrayList<CsdlFunction>();
        ArrayList<CsdlFunctionImport> functionImports = new ArrayList<CsdlFunctionImport>();
        ArrayList<CsdlAction> actions = new ArrayList<CsdlAction>();
        ArrayList<CsdlActionImport> actionImports = new ArrayList<CsdlActionImport>();
        for (Procedure proc : schema.getProcedures().values()) {
            if (!ODataSchemaBuilder.allowedProcedure(proc)) {
                LogManager.logDetail((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16032, new Object[]{proc.getFullName()}));
                continue;
            }
            if (!ODataSchemaBuilder.isObjectVisible((AbstractMetadataRecord)proc)) continue;
            if (ODataSchemaBuilder.isFuntion(proc)) {
                ODataSchemaBuilder.buildFunction(proc, complexTypes, functions, functionImports, csdlSchema);
                continue;
            }
            ODataSchemaBuilder.buildAction(proc, complexTypes, actions, actionImports, csdlSchema);
        }
        csdlSchema.setComplexTypes(complexTypes);
        csdlSchema.setFunctions(functions);
        csdlSchema.setActions(actions);
        csdlSchema.getEntityContainer().setFunctionImports(functionImports);
        csdlSchema.getEntityContainer().setActionImports(actionImports);
    }

    private static boolean doesProcedureReturn(Procedure proc) {
        for (ProcedureParameter pp : proc.getParameters()) {
            if (!pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) continue;
            return true;
        }
        return proc.getResultSet() != null;
    }

    private static boolean allowedProcedure(Procedure proc) {
        int inouts = 0;
        int lobs = 0;
        int outs = 0;
        for (ProcedureParameter pp : proc.getParameters()) {
            if (pp.getType().equals((Object)ProcedureParameter.Type.Out)) continue;
            if (pp.getType().equals((Object)ProcedureParameter.Type.In) || pp.getType().equals((Object)ProcedureParameter.Type.InOut)) {
                ++inouts;
                if (!DataTypeManager.isLOB((String)pp.getRuntimeType())) continue;
                ++lobs;
                continue;
            }
            if (!pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) continue;
            ++outs;
        }
        if (proc.getResultSet() != null) {
            for (Column c : proc.getResultSet().getColumns()) {
                if (!DataTypeManager.isLOB((String)c.getRuntimeType())) continue;
                return false;
            }
            ++outs;
        }
        if (outs > 1) {
            return false;
        }
        return inouts <= true || lobs < true;
    }

    private static boolean isInputParameterLob(Procedure proc) {
        for (ProcedureParameter pp : proc.getParameters()) {
            if (pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue) || pp.getType().equals((Object)ProcedureParameter.Type.Out) || !DataTypeManager.isLOB((String)pp.getRuntimeType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isFuntion(Procedure proc) {
        if (ODataSchemaBuilder.doesProcedureReturn(proc) && proc.getUpdateCount() < 1 && !ODataSchemaBuilder.isInputParameterLob(proc)) {
            return proc.getUpdateCount() != -1;
        }
        return false;
    }

    static void buildFunction(Procedure proc, ArrayList<CsdlComplexType> complexTypes, ArrayList<CsdlFunction> functions, ArrayList<CsdlFunctionImport> functionImports, CsdlSchema csdlSchema) {
        EdmPrimitiveTypeKind odataType;
        CsdlFunction edmFunction = new CsdlFunction();
        String procName = proc.getName();
        edmFunction.setName(procName);
        edmFunction.setBound(false);
        ArrayList<CsdlParameter> params = new ArrayList<CsdlParameter>();
        for (ProcedureParameter pp : proc.getParameters()) {
            odataType = ODataTypeManager.odataType((BaseColumn)pp);
            if (pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) {
                edmFunction.setReturnType(new CsdlReturnType().setType(odataType.getFullQualifiedName()).setCollection(DataTypeManager.isArrayType((String)pp.getRuntimeType())));
                continue;
            }
            if (!pp.getType().equals((Object)ProcedureParameter.Type.In) && !pp.getType().equals((Object)ProcedureParameter.Type.InOut)) continue;
            CsdlParameter parameter = ODataSchemaBuilder.buildParameter(pp, odataType);
            ODataSchemaBuilder.addOperationParameterAnnotations(pp, parameter, csdlSchema);
            params.add(parameter);
        }
        edmFunction.setParameters(params);
        ColumnSet returnColumns = proc.getResultSet();
        if (returnColumns != null) {
            CsdlComplexType complexType = ODataSchemaBuilder.buildComplexType(proc, (ColumnSet<Procedure>)returnColumns, csdlSchema);
            complexTypes.add(complexType);
            odataType = new FullQualifiedName(csdlSchema.getAlias(), complexType.getName());
            edmFunction.setReturnType(new CsdlReturnType().setType((FullQualifiedName)odataType).setCollection(true));
        }
        CsdlFunctionImport functionImport = new CsdlFunctionImport();
        functionImport.setName(procName).setFunction(new FullQualifiedName(csdlSchema.getAlias(), procName));
        ODataSchemaBuilder.addOperationAnnotations(proc, (CsdlOperation)edmFunction, csdlSchema);
        functions.add(edmFunction);
        functionImports.add(functionImport);
    }

    private static CsdlParameter buildParameter(ProcedureParameter pp, EdmPrimitiveTypeKind odatatype) {
        String srid;
        CsdlParameter param = new CsdlParameter();
        param.setName(pp.getName());
        param.setType(odatatype.getFullQualifiedName());
        if (DataTypeManager.isArrayType((String)pp.getRuntimeType())) {
            param.setCollection(true);
        }
        param.setNullable(pp.getNullType() == BaseColumn.NullType.Nullable);
        String runtimeType = pp.getRuntimeType();
        if (runtimeType.equals("string") || runtimeType.equals("varbinary")) {
            param.setMaxLength(Integer.valueOf(pp.getLength()));
        } else if (runtimeType.equals("bigdecimal") || runtimeType.equals("biginteger")) {
            if (pp.getScale() < 0) {
                param.setPrecision(Integer.valueOf((int)Math.min(Integer.MAX_VALUE, (long)pp.getPrecision() - (long)pp.getScale())));
            } else {
                param.setPrecision(Integer.valueOf(pp.getPrecision()));
            }
            param.setScale(Integer.valueOf(Math.max(0, pp.getScale())));
        } else if (runtimeType.equals("timestamp") || runtimeType.equals("time")) {
            param.setPrecision(Integer.valueOf(pp.getPrecision() == 0 ? new Integer(4).intValue() : pp.getPrecision()));
        }
        if (pp.getDefaultValue() != null) {
            // empty if block
        }
        if ((srid = pp.getProperty("teiid_spatial:srid", false)) != null) {
            param.setSrid(SRID.valueOf((String)srid));
        }
        return param;
    }

    static void buildAction(Procedure proc, ArrayList<CsdlComplexType> complexTypes, ArrayList<CsdlAction> actions, ArrayList<CsdlActionImport> actionImports, CsdlSchema csdlSchema) {
        CsdlAction edmAction = new CsdlAction();
        String procName = proc.getName();
        edmAction.setName(procName);
        edmAction.setBound(false);
        ArrayList<CsdlParameter> params = new ArrayList<CsdlParameter>();
        for (ProcedureParameter pp : proc.getParameters()) {
            EdmPrimitiveTypeKind odatatype = ODataTypeManager.odataType((BaseColumn)pp);
            if (pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) {
                edmAction.setReturnType(new CsdlReturnType().setType(odatatype.getFullQualifiedName()).setCollection(DataTypeManager.isArrayType((String)pp.getRuntimeType())));
                continue;
            }
            if (!pp.getType().equals((Object)ProcedureParameter.Type.In) && !pp.getType().equals((Object)ProcedureParameter.Type.InOut)) continue;
            CsdlParameter parameter = ODataSchemaBuilder.buildParameter(pp, odatatype);
            ODataSchemaBuilder.addOperationParameterAnnotations(pp, parameter, csdlSchema);
            params.add(parameter);
        }
        edmAction.setParameters(params);
        ColumnSet returnColumns = proc.getResultSet();
        if (returnColumns != null) {
            CsdlComplexType complexType = ODataSchemaBuilder.buildComplexType(proc, (ColumnSet<Procedure>)returnColumns, csdlSchema);
            complexTypes.add(complexType);
            edmAction.setReturnType(new CsdlReturnType().setType(new FullQualifiedName(csdlSchema.getAlias(), complexType.getName())).setCollection(true));
        }
        CsdlActionImport actionImport = new CsdlActionImport();
        actionImport.setName(procName).setAction(new FullQualifiedName(csdlSchema.getAlias(), procName));
        ODataSchemaBuilder.addOperationAnnotations(proc, (CsdlOperation)edmAction, csdlSchema);
        actions.add(edmAction);
        actionImports.add(actionImport);
    }

    private static CsdlComplexType buildComplexType(Procedure proc, ColumnSet<Procedure> returnColumns, CsdlSchema csdlSchema) {
        CsdlComplexType complexType = new CsdlComplexType();
        String entityTypeName = proc.getName() + "_" + returnColumns.getName();
        complexType.setName(entityTypeName);
        ArrayList<CsdlProperty> props = new ArrayList<CsdlProperty>();
        Iterator iterator = returnColumns.getColumns().iterator();
        while (iterator.hasNext()) {
            Column c;
            CsdlProperty property = ODataSchemaBuilder.buildProperty(c, (c = (Column)iterator.next()).getNullType() == BaseColumn.NullType.Nullable);
            props.add(property);
            ODataSchemaBuilder.addColumnAnnotations(c, property, csdlSchema);
        }
        complexType.setProperties(props);
        return complexType;
    }

    private static void addTableAnnotations(Table table, CsdlEntityType entityType, CsdlSchema csdlSchema) {
        ODataSchemaBuilder.addCommonAnnotations((AbstractMetadataRecord)table, (CsdlAnnotatable)entityType);
        if (table.getCardinality() != -1) {
            ODataSchemaBuilder.addIntAnnotation((CsdlAnnotatable)entityType, "teiid.CARDINALITY", table.getCardinality());
        }
        if (table.isMaterialized()) {
            if (table.getMaterializedTable() != null) {
                ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)entityType, "teiid.MATERIALIZED_TABLE", table.getMaterializedTable().getFullName());
            }
            if (table.getMaterializedStageTable() != null) {
                ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)entityType, "teiid.MATERIALIZED_STAGE_TABLE", table.getMaterializedStageTable().getFullName());
            }
        }
        if (table.getAccessPatterns() != null && !table.getAccessPatterns().isEmpty()) {
            ArrayList<String> values = new ArrayList<String>();
            for (KeyRecord record : table.getAccessPatterns()) {
                StringBuilder sb = new StringBuilder();
                for (Column c : record.getColumns()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(c.getName());
                }
                values.add(sb.toString());
            }
            ODataSchemaBuilder.addStringCollectionAnnotation((CsdlAnnotatable)entityType, "teiid.ACCESS_PATTERNS", values);
        }
        if (table.supportsUpdate()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)entityType, "teiid.UPDATABLE", table.supportsUpdate());
        }
        for (String property : table.getProperties().keySet()) {
            ODataSchemaBuilder.addTerm(ODataSchemaBuilder.normalizeTermName(property), new String[]{"EntityType"}, csdlSchema);
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)entityType, csdlSchema.getAlias() + "." + ODataSchemaBuilder.normalizeTermName(property), (String)table.getProperties().get(property));
        }
    }

    private static void addColumnAnnotations(Column column, CsdlProperty property, CsdlSchema csdlSchema) {
        ODataSchemaBuilder.addCommonAnnotations((AbstractMetadataRecord)column, (CsdlAnnotatable)property);
        if (!column.isSelectable()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.SELECTABLE", column.isSelectable());
        }
        if (column.isUpdatable()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.UPDATABLE", column.isUpdatable());
        }
        if (column.isCurrency()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.CURRENCY", column.isCurrency());
        }
        if (column.isCaseSensitive()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.CASE_SENSITIVE", column.isCaseSensitive());
        }
        if (column.isFixedLength()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.FIXED_LENGTH", column.isFixedLength());
        }
        if (!column.isSigned()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.SIGNED", column.isSigned());
        }
        if (column.getDistinctValues() != -1) {
            ODataSchemaBuilder.addIntAnnotation((CsdlAnnotatable)property, "teiid.DISTINCT_VALUES", column.getDistinctValues());
        }
        if (column.getNullValues() != -1) {
            ODataSchemaBuilder.addIntAnnotation((CsdlAnnotatable)property, "teiid.NULL_VALUE_COUNT", column.getNullValues());
        }
        for (String str : column.getProperties().keySet()) {
            ODataSchemaBuilder.addTerm(ODataSchemaBuilder.normalizeTermName(str), new String[]{"Property"}, csdlSchema);
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)property, csdlSchema.getAlias() + "." + ODataSchemaBuilder.normalizeTermName(str), (String)column.getProperties().get(str));
        }
    }

    private static void addOperationAnnotations(Procedure proc, CsdlOperation operation, CsdlSchema csdlSchema) {
        ODataSchemaBuilder.addCommonAnnotations((AbstractMetadataRecord)proc, (CsdlAnnotatable)operation);
        if (proc.getUpdateCount() != -1) {
            ODataSchemaBuilder.addIntAnnotation((CsdlAnnotatable)operation, "teiid.UPDATECOUNT", proc.getUpdateCount());
        }
        for (String str : proc.getProperties().keySet()) {
            ODataSchemaBuilder.addTerm(ODataSchemaBuilder.normalizeTermName(str), new String[]{"Action", "Function"}, csdlSchema);
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)operation, csdlSchema.getAlias() + "." + ODataSchemaBuilder.normalizeTermName(str), (String)proc.getProperties().get(str));
        }
    }

    private static void addOperationParameterAnnotations(ProcedureParameter procedure, CsdlParameter parameter, CsdlSchema csdlSchema) {
        ODataSchemaBuilder.addCommonAnnotations((AbstractMetadataRecord)procedure, (CsdlAnnotatable)parameter);
        for (String str : procedure.getProperties().keySet()) {
            ODataSchemaBuilder.addTerm(ODataSchemaBuilder.normalizeTermName(str), new String[]{"Parameter"}, csdlSchema);
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)parameter, csdlSchema.getAlias() + "." + ODataSchemaBuilder.normalizeTermName(str), (String)procedure.getProperties().get(str));
        }
    }

    private static void addCommonAnnotations(AbstractMetadataRecord rec, CsdlAnnotatable recipent) {
        if (rec.getAnnotation() != null) {
            ODataSchemaBuilder.addStringAnnotation(recipent, "Core.Description", rec.getAnnotation());
        }
        if (rec.getNameInSource() != null) {
            ODataSchemaBuilder.addStringAnnotation(recipent, "teiid.NAMEINSOURCE", rec.getNameInSource());
        }
        if (!NAME_PATTERN.matcher(rec.getName()).matches()) {
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16063, new Object[]{rec.getFullName()}));
        }
    }

    private static void addStringAnnotation(CsdlAnnotatable recipent, String term, String value) {
        CsdlAnnotation annotation = new CsdlAnnotation();
        annotation.setTerm(term);
        annotation.setExpression((CsdlExpression)new CsdlConstantExpression(CsdlConstantExpression.ConstantExpressionType.String, value));
        recipent.getAnnotations().add(annotation);
    }

    private static void addIntAnnotation(CsdlAnnotatable recipent, String term, int value) {
        CsdlAnnotation annotation = new CsdlAnnotation();
        annotation.setTerm(term);
        annotation.setExpression((CsdlExpression)new CsdlConstantExpression(CsdlConstantExpression.ConstantExpressionType.Int, String.valueOf(value)));
        recipent.getAnnotations().add(annotation);
    }

    private static void addBooleanAnnotation(CsdlAnnotatable recipent, String term, boolean value) {
        CsdlAnnotation annotation = new CsdlAnnotation();
        annotation.setTerm(term);
        annotation.setExpression((CsdlExpression)new CsdlConstantExpression(CsdlConstantExpression.ConstantExpressionType.Bool, String.valueOf(value)));
        recipent.getAnnotations().add(annotation);
    }

    private static void addStringCollectionAnnotation(CsdlAnnotatable recipent, String term, List<String> values) {
        CsdlAnnotation annotation = new CsdlAnnotation();
        annotation.setTerm(term);
        CsdlCollection collection = new CsdlCollection();
        for (String value : values) {
            collection.getItems().add(new CsdlConstantExpression(CsdlConstantExpression.ConstantExpressionType.String, value));
        }
        annotation.setExpression((CsdlExpression)collection);
        recipent.getAnnotations().add(annotation);
    }

    private static void addTerm(String property, String[] appliesTo, CsdlSchema schema) {
        CsdlTerm term = schema.getTerm(property);
        if (term == null) {
            term = new CsdlTerm();
            term.setName(property);
            term.setType("Edm.String");
            schema.getTerms().add(term);
        }
        for (int i = 0; i < appliesTo.length; ++i) {
            if (term.getAppliesTo().contains(appliesTo[i])) continue;
            term.getAppliesTo().add(appliesTo[i]);
        }
    }

    private static String normalizeTermName(String name) {
        return name;
    }

    public static final class ODataSchemaInfo {
        public CsdlSchema schema = new CsdlSchema();
        public Map<String, CsdlEntitySet> entitySets = new LinkedHashMap<String, CsdlEntitySet>();
        public Map<String, CsdlEntityType> entityTypes = new LinkedHashMap<String, CsdlEntityType>();
        public TeiidEdmProvider edmProvider;
    }

    public static interface SchemaResolver {
        public ODataSchemaInfo getSchemaInfo(String var1);
    }
}

