/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.geo;

import java.sql.Clob;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.teiid.core.types.ClobType;
import org.teiid.geo.GeometryTransformUtils;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.resolver.TestFunctionResolving;
import org.teiid.query.sql.symbol.Expression;

public class TestOptionalGeospatial {
    @Test
    public void testTransform() throws Exception {
        Geometry g0 = new WKTReader().read("POINT(426418.89 4957737.37)");
        Geometry g1 = GeometryTransformUtils.transform((Geometry)g0, (String)"+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs", (String)"+proj=longlat +datum=WGS84 +no_defs");
        Assert.assertEquals((Object)"POINT (8.07013599546795 44.76924401481436)", (Object)g1.toText());
    }

    @Test
    public void testGeoJsonCollection() throws Exception {
        Expression ex = TestFunctionResolving.getExpression((String)"ST_AsGeoJson(ST_GeomFromText('GEOMETRYCOLLECTION(POINT(4 6),LINESTRING(4 6,7 10))'))");
        ClobType c = (ClobType)Evaluator.evaluate((Expression)ex);
        Assert.assertEquals((Object)"{\"type\":\"GeometryCollection\",\"geometries\":[{\"type\":\"Point\",\"coordinates\":[4.0,6.0]},{\"type\":\"LineString\",\"coordinates\":[[4.0,6.0],[7.0,10.0]]}]}", (Object)ClobType.getString((Clob)c));
    }

    @Test
    public void testFromGeoJson() throws Exception {
        TestFunctionResolving.assertEval((String)"ST_AsText(ST_GeomFromGeoJSON('{\"coordinates\":[-48.23456,20.12345],\"type\":\"Point\"}'))", (String)"POINT (-48.23456 20.12345)");
        TestFunctionResolving.assertEval((String)"ST_AsText(ST_GeomFromGeoJSON('{\"coordinates\":[[[40.0,0.0],[50.0,50.0],[0.0,50.0],[0.0,0.0],[40.0,0.0]]],\"type\":\"Polygon\"}'))", (String)"POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))");
    }

    @Test
    public void testGeoJson() throws Exception {
        Expression ex = TestFunctionResolving.getExpression((String)"ST_AsText(ST_GeomFromGeoJson(ST_AsGeoJSON(ST_GeomFromText('MULTIPOINT ((10 40), (40 30), (20 20), (30 10))'))))");
        Assert.assertEquals((Object)"MULTIPOINT ((10 40), (40 30), (20 20), (30 10))", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
        ex = TestFunctionResolving.getExpression((String)"ST_AsText(ST_GeomFromGeoJson(ST_AsGeoJSON(ST_GeomFromText('MULTILINESTRING ((10 10, 20 20, 10 40),(40 40, 30 30, 40 20, 30 10))'))))");
        Assert.assertEquals((Object)"MULTILINESTRING ((10 10, 20 20, 10 40), (40 40, 30 30, 40 20, 30 10))", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
        ex = TestFunctionResolving.getExpression((String)"ST_AsText(ST_GeomFromGeoJson(ST_AsGeoJSON(ST_GeomFromText('LINESTRING (30 10, 10 30, 40 40)'))))");
        Assert.assertEquals((Object)"LINESTRING (30 10, 10 30, 40 40)", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
    }

    @Test
    public void testAsGeoJson() throws Exception {
        TestFunctionResolving.assertEval((String)"ST_AsGeoJson(ST_GeomFromText('POINT (-48.23456 20.12345)'))", (String)"{\"type\":\"Point\",\"coordinates\":[-48.23456,20.12345]}");
        TestFunctionResolving.assertEval((String)"ST_AsGeoJson(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))", (String)"{\"type\":\"Polygon\",\"coordinates\":[[[40.0,0.0],[50.0,50.0],[0.0,50.0],[0.0,0.0],[40.0,0.0]]]}");
    }
}

