/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.json;

import com.jayway.jsonpath.PathNotFoundException;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.JsonType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.json.JsonPathFunctionMethods;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.rewriter.TestQueryRewriter;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestJsonPath {
    private static String EXAMPLE;

    @Test
    public void testJsonPathValueNonascii() throws Exception {
        String result = JsonPathFunctionMethods.jsonPathValue((Clob)new ClobImpl(EXAMPLE), (String)"$.owner", (boolean)false);
        Assert.assertEquals((Object)"G\u00fcnter Grass", (Object)result);
    }

    @Test
    public void testJsonPathValueDefiniteArray() throws Exception {
        String result = JsonPathFunctionMethods.jsonPathValue((Clob)new ClobImpl(EXAMPLE), (String)"$.store.book", (boolean)false);
        Assert.assertEquals((Object)"[{\"category\":\"reference\",\"author\":\"Nigel Rees\",\"title\":\"Sayings of the Century\",\"price\":8.95},{\"category\":\"fiction\",\"author\":\"Evelyn Waugh\",\"title\":\"Sword of Honour\",\"price\":12.99},{\"category\":\"fiction\",\"author\":\"Herman Melville\",\"title\":\"Moby Dick\",\"isbn\":\"0-553-21311-3\",\"price\":8.99},{\"category\":\"fiction\",\"author\":\"J. R. R. Tolkien\",\"title\":\"The Lord of the Rings\",\"isbn\":\"0-395-19395-8\",\"price\":22.99}]", (Object)result);
    }

    @Test
    public void testJsonPathValueIndefiniteArray() throws Exception {
        String result = JsonPathFunctionMethods.jsonPathValue((Clob)new ClobImpl(EXAMPLE), (String)"$..author", (boolean)false);
        Assert.assertEquals((Object)"Nigel Rees", (Object)result);
    }

    @Test
    public void testJsonPathValueIndefiniteNonExistent() throws Exception {
        String result = JsonPathFunctionMethods.jsonPathValue((Clob)new ClobImpl(EXAMPLE), (String)"$..mountains", (boolean)false);
        Assert.assertNull((Object)result);
    }

    @Test(expected=PathNotFoundException.class)
    public void testJsonPathValueDefiniteNonExistent() throws Exception {
        JsonPathFunctionMethods.jsonPathValue((Clob)new ClobImpl(EXAMPLE), (String)"$.mountains", (boolean)false);
    }

    @Test
    public void testJsonPathValueDefiniteNonExistent1() throws Exception {
        String result = JsonPathFunctionMethods.jsonPathValue((Clob)new ClobImpl(EXAMPLE), (String)"$.mountains", (boolean)true);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testJsonQuery() throws Exception {
        JsonType result = JsonPathFunctionMethods.jsonQuery((Clob)new ClobImpl(EXAMPLE), (String)"$..author", (boolean)false);
        Assert.assertEquals((Object)"[\"Nigel Rees\",\"Evelyn Waugh\",\"Herman Melville\",\"J. R. R. Tolkien\"]", (Object)ClobType.getString((Clob)result));
    }

    @Test
    public void testJsonQueryNullLeaf() throws Exception {
        JsonType result = JsonPathFunctionMethods.jsonQuery((Clob)new ClobImpl(EXAMPLE), (String)"$..author", (boolean)true);
        Assert.assertEquals((Object)"[null,null,\"Nigel Rees\",\"Evelyn Waugh\",\"Herman Melville\",\"J. R. R. Tolkien\",null]", (Object)ClobType.getString((Clob)result));
    }

    @Test
    public void testJsonToArray() throws Exception {
        Object[] result = JsonPathFunctionMethods.jsonToArray((Clob)new ClobImpl(EXAMPLE), (String)"$.store.book", (boolean)true, (String[])new String[]{"@.author", "@.type"});
        Assert.assertEquals((Object)"[[Nigel Rees, null], [Evelyn Waugh, null], [Herman Melville, null], [J. R. R. Tolkien, null]]", (Object)Arrays.deepToString(result));
    }

    @Test(expected=FunctionExecutionException.class)
    public void testJsonToArrayInvalidPath() throws Exception {
        JsonPathFunctionMethods.jsonToArray((Clob)new ClobImpl(EXAMPLE), (String)"$.store.book", (boolean)true, (String[])new String[]{".author", "@.type"});
    }

    @Test
    public void testFullSelect() {
        ProcessorPlan plan = TestProcessor.helpGetPlan((String)("select * from arraytable(rows jsontoarray('" + EXAMPLE + "', '$..book[0:2]', false, '@.author', '@.title', '@.price') columns author string, title string, price decimal) as x"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList("Nigel Rees", "Sayings of the Century", BigDecimal.valueOf(8.95)), Arrays.asList("Evelyn Waugh", "Sword of Honour", BigDecimal.valueOf(12.99))};
        TestProcessor.helpProcess((ProcessorPlan)plan, (ProcessorDataManager)new HardcodedDataManager(), (List[])expected);
    }

    @Test
    public void testJsonTableRewrite() throws Exception {
        TestQueryRewriter.helpTestRewriteCommand((String)"SELECT * from jsontable('{\"1\":{\"2\":3}}', '$[''1'']', true columns \"2\" integer) as x", (String)"SELECT x.\"2\" FROM ARRAYTABLE(ROWS jsontoarray('{\"1\":{\"2\":3}}', '$[''1'']', TRUE, '@[''2'']') COLUMNS \"2\" integer) AS x", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testJsonTableRewrite1() throws Exception {
        TestQueryRewriter.helpTestRewriteCommand((String)"SELECT * from jsontable('{\"1\":{\"2\":3}}', '$..*' columns a integer path '@.x', b string) as x", (String)"SELECT x.a, x.b FROM ARRAYTABLE(ROWS jsontoarray('{\"1\":{\"2\":3}}', '$..*', FALSE, '@.x', '@[''b'']') COLUMNS a integer, b string) AS x", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testJsonTableProcessing() throws Exception {
        ProcessorPlan plan = TestProcessor.helpGetPlan((String)("select * from jsontable('" + EXAMPLE + "', '$..book.*' columns author string, title string, price decimal) as x"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList("Nigel Rees", "Sayings of the Century", BigDecimal.valueOf(8.95)), Arrays.asList("Evelyn Waugh", "Sword of Honour", BigDecimal.valueOf(12.99)), Arrays.asList("Herman Melville", "Moby Dick", BigDecimal.valueOf(8.99)), Arrays.asList("J. R. R. Tolkien", "The Lord of the Rings", BigDecimal.valueOf(22.99))};
        TestProcessor.helpProcess((ProcessorPlan)plan, (ProcessorDataManager)new HardcodedDataManager(), (List[])expected);
    }

    @Test
    public void testJsonTableProcessingMissing() throws Exception {
        ProcessorPlan plan = TestProcessor.helpGetPlan((String)("select * from jsontable('" + EXAMPLE + "', '$..book[1:3]', true columns id for ordinality, isbn string, title string, price decimal) as x"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(1, null, "Sword of Honour", BigDecimal.valueOf(12.99)), Arrays.asList(2, "0-553-21311-3", "Moby Dick", BigDecimal.valueOf(8.99))};
        TestProcessor.helpProcess((ProcessorPlan)plan, (ProcessorDataManager)new HardcodedDataManager(), (List[])expected);
    }

    @Test
    public void testJsonTableProcessingCorrelated() throws Exception {
        ProcessorPlan plan = TestProcessor.helpGetPlan((String)"select x.* from pm1.g1, jsontable(e1, '$..book[1:3]', true columns id for ordinality, isbn string, title string, price decimal) as x", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(1, null, "Sword of Honour", BigDecimal.valueOf(12.99)), Arrays.asList(2, "0-553-21311-3", "Moby Dick", BigDecimal.valueOf(8.99))};
        HardcodedDataManager hdm = new HardcodedDataManager();
        hdm.addData("SELECT g_0.e1 FROM pm1.g1 AS g_0", new List[]{Arrays.asList(EXAMPLE), Collections.singletonList(null)});
        TestProcessor.helpProcess((ProcessorPlan)plan, (ProcessorDataManager)hdm, (List[])expected);
    }

    @Test
    public void testRootObject() throws Exception {
        String sql = "SELECT j.id, j.name, j.status FROM JSONTABLE(cast('{\n  \"id\": 5,\n  \"name\": \"carly\",\n  \"status\": \"sold\"\n}' as json), '$', false COLUMNS id integer, name string, status string) as j";
        ProcessorPlan plan = TestProcessor.helpGetPlan((String)sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(5, "carly", "sold")};
        HardcodedDataManager hdm = new HardcodedDataManager();
        TestProcessor.helpProcess((ProcessorPlan)plan, (ProcessorDataManager)hdm, (List[])expected);
    }

    static {
        try {
            EXAMPLE = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"example.json"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

