/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAwareEx;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.JsonType;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.function.TeiidFunctions;

@TeiidFunctions(category="JSON")
public class JsonPathFunctionMethods {
    private static String ORDINAL = "ordinal";
    private static BundleUtil UTIL = BundleUtil.getBundleUtil(JsonPathFunctionMethods.class);

    @TeiidFunction(name="jsonpathvalue", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static String jsonPathValue(Clob clob, String jsonPath, boolean nullLeaf) throws IOException, SQLException {
        JsonPath path = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
        Object result = JsonPathFunctionMethods.jsonPathRead(clob.getCharacterStream(), path, nullLeaf);
        if (path.isDefinite()) {
            return JsonPathFunctionMethods.toString(result);
        }
        if (result instanceof JSONArray) {
            JSONArray list = (JSONArray)result;
            if (!list.isEmpty()) {
                return JsonPathFunctionMethods.toString(list.get(0));
            }
            return null;
        }
        return (String)result;
    }

    private static String toString(Object result) {
        if (result == null) {
            return null;
        }
        if (result instanceof JSONAwareEx) {
            return ((JSONAwareEx)result).toJSONString();
        }
        return result.toString();
    }

    @TeiidFunction(name="jsonpathvalue", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static String jsonPathValue(Clob clob, String jsonPath) throws IOException, SQLException {
        return JsonPathFunctionMethods.jsonPathValue(clob, jsonPath, false);
    }

    @TeiidFunction(name="jsonquery", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static JsonType jsonQuery(Clob clob, String jsonPath, boolean nullLeaf) throws IOException, SQLException {
        JsonPath path = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
        Object result = JsonPathFunctionMethods.jsonPathRead(clob.getCharacterStream(), path, nullLeaf);
        if (result == null) {
            return null;
        }
        return new JsonType((Clob)new ClobImpl(JsonPathFunctionMethods.toString(result)));
    }

    @TeiidFunction(name="jsonquery", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static JsonType jsonQuery(Clob clob, String jsonPath) throws IOException, SQLException {
        return JsonPathFunctionMethods.jsonQuery(clob, jsonPath, false);
    }

    @TeiidFunction(name="jsontoarray", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static Object[] jsonToArray(Clob clob, String jsonPath, boolean nullLeaf, String ... colpaths) throws IOException, SQLException, FunctionExecutionException {
        JsonPath[] paths = new JsonPath[colpaths.length];
        for (int i = 0; i < colpaths.length; ++i) {
            String path = colpaths[i];
            if (path == null || !path.trim().startsWith("@") && !path.equalsIgnoreCase(ORDINAL)) {
                throw new FunctionExecutionException(UTIL.gs("invalid_path", new Object[0]));
            }
            if (path.equalsIgnoreCase(ORDINAL)) continue;
            paths[i] = JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
        }
        JsonPath path = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
        Object result = JsonPathFunctionMethods.jsonPathRead(clob.getCharacterStream(), path, nullLeaf);
        if (result == null) {
            return null;
        }
        Configuration conf = Configuration.defaultConfiguration();
        if (nullLeaf) {
            conf = conf.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        if (result instanceof JSONArray) {
            JSONArray list = (JSONArray)result;
            int row = 1;
            for (int i = 0; i < list.size(); ++i) {
                Object value = list.get(i);
                if (value == null) continue;
                rows.add(JsonPathFunctionMethods.buildRow(value, conf, paths, row++));
            }
        } else {
            rows.add(JsonPathFunctionMethods.buildRow(result, conf, paths, 1));
        }
        return rows.toArray(new Object[rows.size()]);
    }

    private static Object[] buildRow(Object value, Configuration conf, JsonPath[] paths, int row) {
        DocumentContext dc = JsonPath.parse((Object)value, (Configuration)conf);
        Object[] values = new Object[paths.length == 0 ? 1 : paths.length];
        for (int j = 0; j < paths.length; ++j) {
            if (paths[j] == null) {
                values[j] = row;
                continue;
            }
            Object colValue = dc.read(paths[j]);
            values[j] = JsonPathFunctionMethods.getTeiidValue(colValue);
        }
        if (paths.length == 0) {
            values[0] = JsonPathFunctionMethods.getTeiidValue(value);
        }
        return values;
    }

    private static Object getTeiidValue(Object colValue) {
        if (colValue instanceof JSONAwareEx) {
            return new JsonType((Clob)new ClobImpl(JsonPathFunctionMethods.toString(colValue)));
        }
        return colValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object jsonPathRead(Reader jsonReader, JsonPath jsonPath, boolean nullLeaf) throws IOException {
        Configuration conf = Configuration.defaultConfiguration();
        if (nullLeaf) {
            conf = conf.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        }
        try {
            Object object = jsonPath.read((InputStream)new ReaderInputStream(jsonReader, Charset.forName("UTF-8")), conf);
            return object;
        }
        finally {
            jsonReader.close();
        }
    }
}

