/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.xquery.saxon;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.option.xom.XOMDocumentWrapper;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nux.xom.xquery.StreamingPathFilter;
import nux.xom.xquery.StreamingTransform;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.symbol.XMLCast;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.util.CommandContext;
import org.teiid.xquery.saxon.PathMapFilter;
import org.teiid.xquery.saxon.SaxonReader;
import org.teiid.xquery.saxon.SaxonXMLTableNode;
import org.teiid.xquery.saxon.SaxonXQueryExpression;
import org.teiid.xquery.saxon.XMLEventStreamReader;
import org.xml.sax.XMLReader;

public class XQueryEvaluator {
    private static Nodes NONE = new Nodes();
    private static InputStream FAKE_IS = new InputStream(){

        @Override
        public int read() throws IOException {
            return 0;
        }
    };

    /*
     * Unable to fully structure code
     */
    public static SaxonXQueryExpression.Result evaluateXQuery(final SaxonXQueryExpression xquery, Object context, Map<String, Object> parameterValues, final SaxonXQueryExpression.RowProcessor processor, CommandContext commandContext) throws TeiidProcessingException, TeiidComponentException {
        block29: {
            dynamicContext = new DynamicQueryContext(xquery.config);
            result = new SaxonXQueryExpression.Result();
            for (Map.Entry<String, Object> entry : parameterValues.entrySet()) {
                try {
                    value = entry.getValue();
                    s = null;
                    if (value instanceof SQLXML) {
                        value = XMLSystemFunctions.convertToSource((Object)value);
                        result.sources.add((Source)value);
                        source = XQueryEvaluator.wrapStax((Source)value);
                        s = xquery.config.buildDocumentTree(source).getRootNode();
                    } else if (value instanceof java.util.Date) {
                        s = XQueryEvaluator.convertToAtomicValue(value);
                    } else if (value instanceof BinaryType) {
                        s = new HexBinaryValue(((BinaryType)value).getBytesDirect());
                    }
                    dynamicContext.setParameter(StructuredQName.fromClarkName((String)entry.getKey()), (Sequence)s);
                }
                catch (TransformerException e) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30148, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30148, new Object[]{entry.getKey()}));
                }
            }
            if (context == null) break block29;
            source = XMLSystemFunctions.convertToSource((Object)context);
            result.sources.add((Source)source);
            source = XQueryEvaluator.wrapStax((Source)source);
            if (xquery.contextRoot != null) {
                sourceInput = AugmentedSource.makeAugmentedSource((Source)source);
                sourceInput.addFilter(new FilterFactory(){

                    public ProxyReceiver makeFilter(Receiver arg0) {
                        return new PathMapFilter(xquery.contextRoot, arg0);
                    }
                });
                source = sourceInput;
                if (xquery.streamingPath != null && processor != null) {
                    if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Using stream processing for evaluation of", (Object)xquery.xQueryString);
                    }
                    isNonBlocking = commandContext.isNonBlocking();
                    commandContext.setNonBlocking(true);
                    myTransform = new StreamingTransform(){

                        public Nodes transform(Element elem) {
                            processor.processRow(XQueryEvaluator.wrap((Node)elem, xquery.config));
                            return NONE;
                        }
                    };
                    builder = new Builder((XMLReader)new SaxonReader(xquery.config, sourceInput), false, new StreamingPathFilter(xquery.streamingPath, xquery.namespaceMap).createNodeFactory(null, myTransform));
                    try {
                        builder.build(XQueryEvaluator.FAKE_IS);
                        var12_16 = result;
                        return var12_16;
                    }
                    catch (ParsingException e) {
                        if (e.getCause() instanceof TeiidRuntimeException) {
                            RelationalNode.unwrapException((TeiidRuntimeException)((TeiidRuntimeException)e.getCause()));
                        }
                        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30151, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30151, new Object[0]));
                    }
                    catch (IOException e) {
                        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30151, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30151, new Object[0]));
                    }
                    finally {
                        if (!isNonBlocking) {
                            commandContext.setNonBlocking(false);
                        }
                    }
                }
            }
            ** try [egrp 5[TRYBLOCK] [5 : 530->544)] { 
lbl-1000:
            // 1 sources

            {
                doc = xquery.config.buildDocumentTree((Source)source);
            }
lbl58:
            // 1 sources

            catch (XPathException e) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30151, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30151, new Object[0]));
            }
            dynamicContext.setContextItem((Item)doc.getRootNode());
        }
        try {
            result.iter = xquery.xQuery.iterator(dynamicContext);
            source = result;
            return source;
        }
        catch (TransformerException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30152, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30152, new Object[0]));
        }
        finally {
            if (result.iter == null) {
                result.close();
            }
        }
    }

    private static Source wrapStax(Source value) throws TeiidProcessingException {
        if (value instanceof StAXSource) {
            StAXSource staxSource = (StAXSource)value;
            if (staxSource.getXMLStreamReader() != null) {
                return staxSource;
            }
            try {
                return new StAXSource(new XMLEventStreamReader(staxSource.getXMLEventReader()));
            }
            catch (XMLStreamException e) {
                throw new TeiidProcessingException((Throwable)e);
            }
        }
        return value;
    }

    static NodeInfo wrap(Node node, Configuration config) {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (node instanceof DocType) {
            throw new IllegalArgumentException("DocType can't be queried by XQuery/XPath");
        }
        Node root = node;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        XOMDocumentWrapper docWrapper = new XOMDocumentWrapper(root, config);
        return docWrapper.wrap(node);
    }

    public static Object evaluateXMLQuery(List<?> tuple, XMLQuery xmlQuery, boolean exists, Map<String, Object> parameters, CommandContext context) throws BlockedException, TeiidComponentException, FunctionExecutionException {
        boolean emptyOnEmpty = xmlQuery.getEmptyOnEmpty() == null || xmlQuery.getEmptyOnEmpty() != false;
        try (SaxonXQueryExpression.Result result = null;){
            Object contextItem;
            SaxonXQueryExpression sxqe;
            XMLQueryRowProcessor rp;
            block25: {
                rp = null;
                sxqe = (SaxonXQueryExpression)xmlQuery.getXQueryExpression();
                if (sxqe.isStreaming()) {
                    rp = new XMLQueryRowProcessor(exists, context);
                }
                try {
                    contextItem = null;
                    if (!parameters.containsKey(null) || (contextItem = parameters.remove(null)) != null) break block25;
                    Object var10_13 = null;
                    return var10_13;
                }
                catch (TeiidRuntimeException e) {
                    if (e.getCause() instanceof XPathException) {
                        throw (XPathException)e.getCause();
                    }
                    throw e;
                }
            }
            result = XQueryEvaluator.evaluateXQuery(sxqe, contextItem, parameters, rp, context);
            if (result == null) {
                Object var10_14 = null;
                return var10_14;
            }
            if (exists) {
                if (result.iter.next() == null) {
                    Boolean bl = false;
                    return bl;
                }
                Boolean bl = true;
                return bl;
            }
            if (rp != null) {
                if (exists) {
                    Boolean e = rp.hasItem;
                    return e;
                }
                XMLType.Type type = rp.type;
                if (type == null) {
                    if (!emptyOnEmpty) {
                        Object var10_17 = null;
                        return var10_17;
                    }
                    type = XMLType.Type.CONTENT;
                }
                XMLType val = rp.concat.close(context);
                val.setType(rp.type);
                XMLType xMLType = val;
                return xMLType;
            }
            XMLType xMLType = sxqe.createXMLType(result.iter, context.getBufferManager(), emptyOnEmpty, context);
            return xMLType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluate(XMLType value, XMLCast expression, CommandContext context) throws ExpressionEvaluationException {
        Configuration config = new Configuration();
        XMLType.Type t = value.getType();
        try {
            StringValue i = null;
            switch (t) {
                case CONTENT: 
                case COMMENT: 
                case PI: {
                    throw new FunctionExecutionException();
                }
                case TEXT: {
                    i = new StringValue((CharSequence)value.getString());
                    break;
                }
                case UNKNOWN: 
                case DOCUMENT: 
                case ELEMENT: {
                    StreamSource ss = (StreamSource)value.getSource(StreamSource.class);
                    try {
                        i = config.buildDocument((Source)ss);
                        break;
                    }
                    finally {
                        if (ss.getInputStream() != null) {
                            ss.getInputStream().close();
                        }
                        if (ss.getReader() != null) {
                            ss.getReader().close();
                        }
                    }
                }
                default: {
                    throw new AssertionError((Object)("Unknown xml value type " + t));
                }
            }
            return SaxonXMLTableNode.getValue(expression.getType(), (Item)i, config, context);
        }
        catch (IOException e) {
            throw new FunctionExecutionException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new FunctionExecutionException((Throwable)e);
        }
        catch (TransformationException e) {
            throw new FunctionExecutionException((Throwable)e);
        }
        catch (XPathException e) {
            throw new FunctionExecutionException((Throwable)e);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException((Throwable)e);
        }
    }

    public static AtomicValue convertToAtomicValue(Object value) throws TransformerException {
        if (value instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)value;
            DateTimeValue tdv = DateTimeValue.fromJavaDate((java.util.Date)d);
            if (value instanceof Date) {
                value = new DateValue(tdv.getYear(), tdv.getMonth(), tdv.getDay(), tdv.getTimezoneInMinutes(), true);
            } else if (value instanceof Time) {
                value = new TimeValue(tdv.getHour(), tdv.getMinute(), tdv.getSecond(), tdv.getMicrosecond(), tdv.getTimezoneInMinutes());
            } else if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                value = tdv.add((DurationValue)DayTimeDurationValue.fromMicroseconds((long)(ts.getNanos() / 1000)));
            }
            return (AtomicValue)value;
        }
        JPConverter converter = JPConverter.allocate(value.getClass(), null, null);
        return (AtomicValue)converter.convert(value, null);
    }

    static final class XMLQueryRowProcessor
    implements SaxonXQueryExpression.RowProcessor {
        XMLSystemFunctions.XmlConcat concat;
        XMLType.Type type;
        private Result result;
        boolean hasItem;

        XMLQueryRowProcessor(boolean exists, CommandContext context) throws TeiidProcessingException {
            if (!exists) {
                this.concat = new XMLSystemFunctions.XmlConcat(context.getBufferManager());
                this.result = new StreamResult(this.concat.getWriter());
            }
        }

        @Override
        public void processRow(NodeInfo row) {
            if (this.concat == null) {
                this.hasItem = true;
                return;
            }
            this.type = this.type == null ? SaxonXQueryExpression.getType(row) : XMLType.Type.CONTENT;
            try {
                QueryResult.serialize((NodeInfo)row, (Result)this.result, (Properties)SaxonXQueryExpression.DEFAULT_OUTPUT_PROPERTIES);
            }
            catch (XPathException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
    }
}

