/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.xquery.saxon;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stax.StAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.client.plan.Annotation;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLTranslator;
import org.teiid.core.types.XMLType;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.util.CommandContext;
import org.teiid.query.xquery.XQueryExpression;
import org.teiid.util.WSUtil;
import org.teiid.xquery.saxon.PushBackSequenceIterator;
import org.teiid.xquery.saxon.StreamingUtils;

public class SaxonXQueryExpression
implements XQueryExpression {
    private static final String XQUERY_PLANNING = "XQuery Planning";
    private static final String EMPTY_STRING = "";
    public static final Properties DEFAULT_OUTPUT_PROPERTIES = new Properties();
    private static final Expression DUMMY_EXPRESSION = new Expression(){

        protected int computeCardinality() {
            return 0;
        }

        public PathMap.PathMapNodeSet addToPathMap(PathMap arg0, PathMap.PathMapNodeSet arg1) {
            return arg1;
        }

        public int getImplementationMethod() {
            return 0;
        }

        public ItemType getItemType() {
            return null;
        }

        public void export(ExpressionPresenter out) throws XPathException {
        }

        public Expression copy(RebindingMap rebindings) {
            return null;
        }
    };
    private static final ErrorListener ERROR_LISTENER = new ErrorListener(){

        @Override
        public void warning(TransformerException arg0) throws TransformerException {
        }

        @Override
        public void error(TransformerException arg0) throws TransformerException {
        }

        @Override
        public void fatalError(TransformerException arg0) throws TransformerException {
        }
    };
    net.sf.saxon.query.XQueryExpression xQuery;
    String xQueryString;
    Map<String, String> namespaceMap;
    Configuration config;
    PathMap.PathMapRoot contextRoot;
    String streamingPath;
    Map<String, XPathExpression> columnMap;
    boolean relativePaths;
    public static final boolean[] isValidAncestorAxis = new boolean[]{false, false, true, false, false, false, false, false, true, true, false, false, true, false};

    public static SaxonXQueryExpression compile(String xQueryString, XMLNamespaces namespaces, List<DerivedColumn> passing, List<XMLTable.XMLColumn> columns) throws QueryResolverException {
        SaxonXQueryExpression saxonXQueryExpression = new SaxonXQueryExpression();
        CommandContext cc = CommandContext.getThreadLocalContext();
        if (cc != null) {
            saxonXQueryExpression.relativePaths = cc.getOptions().isRelativeXPath();
        }
        saxonXQueryExpression.config.setErrorListener(ERROR_LISTENER);
        saxonXQueryExpression.xQueryString = xQueryString;
        StaticQueryContext context = saxonXQueryExpression.config.newStaticQueryContext();
        IndependentContext ic = new IndependentContext(saxonXQueryExpression.config);
        saxonXQueryExpression.namespaceMap.put(EMPTY_STRING, EMPTY_STRING);
        if (namespaces != null) {
            for (XMLNamespaces.NamespaceItem item : namespaces.getNamespaceItems()) {
                if (item.getPrefix() == null) {
                    if (item.getUri() == null) {
                        context.setDefaultElementNamespace(EMPTY_STRING);
                        ic.setDefaultElementNamespace(EMPTY_STRING);
                        continue;
                    }
                    context.setDefaultElementNamespace(item.getUri());
                    ic.setDefaultElementNamespace(item.getUri());
                    saxonXQueryExpression.namespaceMap.put(EMPTY_STRING, item.getUri());
                    continue;
                }
                context.declareNamespace(item.getPrefix(), item.getUri());
                ic.declareNamespace(item.getPrefix(), item.getUri());
                saxonXQueryExpression.namespaceMap.put(item.getPrefix(), item.getUri());
            }
        }
        for (DerivedColumn derivedColumn : passing) {
            if (derivedColumn.getAlias() == null) continue;
            try {
                context.declareGlobalVariable(StructuredQName.fromClarkName((String)derivedColumn.getAlias()), SequenceType.ANY_SEQUENCE, (Sequence)EmptySequence.getInstance(), true);
            }
            catch (XPathException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30153, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30153, new Object[0]));
            }
        }
        saxonXQueryExpression.processColumns(columns, ic);
        try {
            saxonXQueryExpression.xQuery = context.compileQuery(xQueryString);
        }
        catch (XPathException e) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30154, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30154, new Object[]{xQueryString}));
        }
        return saxonXQueryExpression;
    }

    private SaxonXQueryExpression() {
        DEFAULT_OUTPUT_PROPERTIES.setProperty("method", "xml");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "yes");
        this.namespaceMap = new HashMap<String, String>();
        this.config = new Configuration();
        this.relativePaths = true;
    }

    public SaxonXQueryExpression clone() {
        try {
            return (SaxonXQueryExpression)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public boolean usesContextItem() {
        return this.xQuery.usesContextItem();
    }

    public void useDocumentProjection(List<XMLTable.XMLColumn> columns, AnalysisRecord record) {
        PathMap.PathMapRoot parentRoot;
        block18: {
            try {
                this.streamingPath = StreamingUtils.getStreamingPath(this.xQueryString, this.namespaceMap);
            }
            catch (IllegalArgumentException e) {
                if (!record.recordAnnotations()) break block18;
                record.addAnnotation(XQUERY_PLANNING, "Invalid streaming path " + this.xQueryString + " " + e.getMessage(), "Document streaming will not be used", Annotation.Priority.MEDIUM);
            }
        }
        this.contextRoot = null;
        PathMap map = new PathMap(this.xQuery.getExpression());
        try {
            parentRoot = map.getContextDocumentRoot();
        }
        catch (IllegalStateException e) {
            if (record.recordAnnotations()) {
                record.addAnnotation(XQUERY_PLANNING, "Multiple context items exist " + this.xQueryString, "Document projection will not be used", Annotation.Priority.MEDIUM);
            }
            return;
        }
        if (parentRoot == null) {
            if (record.recordAnnotations()) {
                record.addAnnotation(XQUERY_PLANNING, "No context item reference was found in the XQuery " + this.xQueryString, "Document projection will not be used", Annotation.Priority.MEDIUM);
            }
            return;
        }
        HashSet<PathMap.PathMapNode> finalNodes = new HashSet<PathMap.PathMapNode>();
        this.getReturnableNodes((PathMap.PathMapNode)parentRoot, finalNodes);
        if (!finalNodes.isEmpty()) {
            if (columns != null && !columns.isEmpty()) {
                if (finalNodes.size() != 1) {
                    if (record.recordAnnotations()) {
                        record.addAnnotation(XQUERY_PLANNING, "multiple return items exist " + this.xQueryString, "Document projection will not be used", Annotation.Priority.MEDIUM);
                    }
                    return;
                }
                if ((parentRoot = this.projectColumns(parentRoot, columns, finalNodes.iterator().next(), record)) == null) {
                    return;
                }
            } else {
                for (PathMap.PathMapNode subNode : finalNodes) {
                    subNode.createArc((byte)5, (NodeTest)AnyNodeTest.getInstance());
                }
            }
        }
        if (parentRoot.hasUnknownDependencies()) {
            if (record.recordAnnotations()) {
                record.addAnnotation(XQUERY_PLANNING, "There are unknown dependencies (most likely a user defined function) in " + this.xQueryString, "Document projection will not be used", Annotation.Priority.MEDIUM);
            }
            return;
        }
        if (record.recordAnnotations()) {
            StringBuilder sb = null;
            if (record.recordDebug()) {
                sb = new StringBuilder();
                SaxonXQueryExpression.showArcs(sb, (PathMap.PathMapNode)parentRoot, 0);
            }
            record.addAnnotation(XQUERY_PLANNING, "Projection conditions met for " + this.xQueryString, "Document projection will be used" + (sb != null ? "\n" + sb.toString() : EMPTY_STRING), Annotation.Priority.MEDIUM);
        }
        this.contextRoot = parentRoot;
    }

    private PathMap.PathMapRoot projectColumns(PathMap.PathMapRoot parentRoot, List<XMLTable.XMLColumn> columns, PathMap.PathMapNode finalNode, AnalysisRecord record) {
        for (XMLTable.XMLColumn xmlColumn : columns) {
            if (xmlColumn.isOrdinal()) continue;
            Expression internalExpression = this.getXPathExpression(xmlColumn.getName()).getInternalExpression();
            if (this.containsRootFunction(internalExpression)) {
                if (record.recordAnnotations()) {
                    record.addAnnotation(XQUERY_PLANNING, "Root function used in column path " + xmlColumn.getPath(), "Document projection will not be used", Annotation.Priority.MEDIUM);
                }
                return null;
            }
            PathMap subMap = new PathMap(internalExpression);
            PathMap.PathMapRoot subContextRoot = null;
            for (PathMap.PathMapRoot pathMapRoot : subMap.getPathMapRoots()) {
                if (!(pathMapRoot.getRootExpression() instanceof ContextItemExpression) && !(pathMapRoot.getRootExpression() instanceof RootExpression)) continue;
                if (subContextRoot != null) {
                    if (record.recordAnnotations()) {
                        record.addAnnotation(XQUERY_PLANNING, "Multiple context items exist in column path " + xmlColumn.getPath(), "Document projection will not be used", Annotation.Priority.MEDIUM);
                    }
                    return null;
                }
                subContextRoot = pathMapRoot;
            }
            if (internalExpression instanceof ContextItemExpression) {
                this.addReturnedArcs(finalNode);
            }
            if (subContextRoot == null) continue;
            for (PathMap.PathMapRoot pathMapRoot : subContextRoot.getArcs()) {
                if (this.streamingPath != null && !this.validateColumnForStreaming(record, xmlColumn, (PathMap.PathMapArc)pathMapRoot)) {
                    this.streamingPath = null;
                }
                finalNode.createArc(pathMapRoot.getAxis(), pathMapRoot.getNodeTest(), pathMapRoot.getTarget());
            }
            HashSet<PathMap.PathMapNode> subFinalNodes = new HashSet<PathMap.PathMapNode>();
            this.getReturnableNodes((PathMap.PathMapNode)subContextRoot, subFinalNodes);
            for (PathMap.PathMapNode subNode : subFinalNodes) {
                this.addReturnedArcs(subNode);
            }
        }
        PathMap newMap = new PathMap(DUMMY_EXPRESSION);
        PathMap.PathMapRoot newRoot = newMap.makeNewRoot(parentRoot.getRootExpression());
        if (parentRoot.isAtomized()) {
            newRoot.setAtomized();
        }
        if (parentRoot.isReturnable()) {
            newRoot.setReturnable(true);
        }
        if (parentRoot.hasUnknownDependencies()) {
            newRoot.setHasUnknownDependencies();
        }
        for (PathMap.PathMapArc arc : parentRoot.getArcs()) {
            newRoot.createArc(arc.getAxis(), arc.getNodeTest(), arc.getTarget());
        }
        return newMap.reduceToDownwardsAxes(newRoot);
    }

    private boolean containsRootFunction(Expression internalExpression) {
        SystemFunctionCall sfc;
        if (internalExpression instanceof SystemFunctionCall && (sfc = (SystemFunctionCall)internalExpression).getDisplayName().equals("fn:root")) {
            return true;
        }
        for (Operand ex : internalExpression.operands()) {
            if (!this.containsRootFunction(ex.getChildExpression())) continue;
            return true;
        }
        return false;
    }

    private boolean validateColumnForStreaming(AnalysisRecord record, XMLTable.XMLColumn xmlColumn, PathMap.PathMapArc arc) {
        boolean ancestor = false;
        LinkedList<PathMap.PathMapArc> arcStack = new LinkedList<PathMap.PathMapArc>();
        arcStack.add(arc);
        while (!arcStack.isEmpty()) {
            PathMap.PathMapArc current = (PathMap.PathMapArc)arcStack.removeFirst();
            byte axis = current.getAxis();
            if (ancestor) {
                if (current.getTarget().isReturnable() && axis != 8 && axis != 2) {
                    if (record.recordAnnotations()) {
                        record.addAnnotation(XQUERY_PLANNING, "The column path contains an invalid reverse axis " + xmlColumn.getPath(), "Document streaming will not be used", Annotation.Priority.MEDIUM);
                    }
                    return false;
                }
                if (!isValidAncestorAxis[axis]) {
                    if (record.recordAnnotations()) {
                        record.addAnnotation(XQUERY_PLANNING, "The column path contains an invalid reverse axis " + xmlColumn.getPath(), "Document streaming will not be used", Annotation.Priority.MEDIUM);
                    }
                    return false;
                }
            } else if (!AxisInfo.isSubtreeAxis[axis]) {
                if (axis == 9 || axis == 0 || axis == 1) {
                    if (current.getTarget().isReturnable()) {
                        if (record.recordAnnotations()) {
                            record.addAnnotation(XQUERY_PLANNING, "The column path contains an invalid reverse axis " + xmlColumn.getPath(), "Document streaming will not be used", Annotation.Priority.MEDIUM);
                        }
                        return false;
                    }
                    ancestor = true;
                } else {
                    if (record.recordAnnotations()) {
                        record.addAnnotation(XQUERY_PLANNING, "The column path may not reference an ancestor or subtree " + xmlColumn.getPath(), "Document streaming will not be used", Annotation.Priority.MEDIUM);
                    }
                    return false;
                }
            }
            for (PathMap.PathMapArc pathMapArc : current.getTarget().getArcs()) {
                arcStack.add(pathMapArc);
            }
        }
        return true;
    }

    private void addReturnedArcs(PathMap.PathMapNode subNode) {
        subNode.createArc((byte)5, (NodeTest)AnyNodeTest.getInstance());
    }

    private void getReturnableNodes(PathMap.PathMapNode node, HashSet<PathMap.PathMapNode> finalNodes) {
        if (node.isReturnable()) {
            finalNodes.add(node);
        }
        for (PathMap.PathMapArc arc : node.getArcs()) {
            this.getReturnableNodes(arc.getTarget(), finalNodes);
        }
    }

    private void processColumns(List<XMLTable.XMLColumn> columns, IndependentContext ic) throws QueryResolverException {
        if (columns == null) {
            return;
        }
        this.columnMap = new HashMap<String, XPathExpression>();
        XPathEvaluator eval = new XPathEvaluator(this.config);
        eval.setStaticContext((XPathStaticContext)ic);
        for (XMLTable.XMLColumn xmlColumn : columns) {
            XPathExpression exp;
            if (xmlColumn.isOrdinal()) continue;
            String path = xmlColumn.getPath();
            if (path == null) {
                path = xmlColumn.getName();
            }
            path = path.trim();
            if (this.relativePaths && path.startsWith("/")) {
                path = path.startsWith("//") ? '.' + path : path.substring(1);
            }
            try {
                exp = eval.createExpression(path);
            }
            catch (XPathException e) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30155, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30155, new Object[]{xmlColumn.getName(), xmlColumn.getPath()}));
            }
            this.columnMap.put(xmlColumn.getName(), exp);
        }
    }

    public XMLType createXMLType(final SequenceIterator iter, BufferManager bufferManager, boolean emptyOnEmpty, CommandContext context) throws XPathException, TeiidComponentException, TeiidProcessingException {
        Item next;
        final Item item = iter.next();
        if (item == null && !emptyOnEmpty) {
            return null;
        }
        XMLType.Type type = XMLType.Type.CONTENT;
        if (item instanceof NodeInfo) {
            NodeInfo info = (NodeInfo)item;
            type = SaxonXQueryExpression.getType(info);
        }
        if ((next = iter.next()) != null) {
            type = XMLType.Type.CONTENT;
        }
        SQLXMLImpl xml = XMLSystemFunctions.saveToBufferManager((BufferManager)bufferManager, (XMLTranslator)new XMLTranslator(){

            public void translate(Writer writer) throws TransformerException, IOException {
                QueryResult.serializeSequence((SequenceIterator)new PushBackSequenceIterator(iter, item, next), (Configuration)SaxonXQueryExpression.this.config, (Writer)writer, (Properties)DEFAULT_OUTPUT_PROPERTIES);
            }
        }, (CommandContext)context);
        XMLType value = new XMLType((SQLXML)xml);
        value.setType(type);
        return value;
    }

    public static XMLType.Type getType(NodeInfo info) {
        switch (info.getNodeKind()) {
            case 9: {
                return XMLType.Type.DOCUMENT;
            }
            case 1: {
                return XMLType.Type.ELEMENT;
            }
            case 3: {
                return XMLType.Type.TEXT;
            }
            case 8: {
                return XMLType.Type.COMMENT;
            }
            case 7: {
                return XMLType.Type.PI;
            }
        }
        return XMLType.Type.CONTENT;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static void showArcs(StringBuilder sb, PathMap.PathMapNode node, int level) {
        for (PathMap.PathMapArc pathMapArc : node.getArcs()) {
            char[] pad = new char[level * 2];
            Arrays.fill(pad, ' ');
            sb.append(new String(pad));
            sb.append(AxisInfo.axisName[pathMapArc.getAxis()]);
            sb.append(' ');
            sb.append(pathMapArc.getNodeTest());
            sb.append('\n');
            node = pathMapArc.getTarget();
            SaxonXQueryExpression.showArcs(sb, node, level + 1);
        }
    }

    public boolean isStreaming() {
        return this.streamingPath != null && this.contextRoot != null;
    }

    public XPathExpression getXPathExpression(String name) {
        if (this.columnMap == null) {
            return null;
        }
        return this.columnMap.get(name);
    }

    public static class Result {
        public SequenceIterator iter;
        public List<Source> sources = new LinkedList<Source>();

        public void close() {
            for (Source source : this.sources) {
                WSUtil.closeSource((Source)source);
                if (!(source instanceof StAXSource)) continue;
                StAXSource ss = (StAXSource)source;
                if (ss.getXMLEventReader() != null) {
                    try {
                        ss.getXMLEventReader().close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                    continue;
                }
                try {
                    ss.getXMLStreamReader().close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            if (this.iter != null) {
                this.iter.close();
            }
            this.sources.clear();
            this.iter = null;
        }
    }

    public static interface RowProcessor {
        public void processRow(NodeInfo var1);
    }
}

