/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestAggregatePushdown;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.rewriter.TestQueryRewriter;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestXMLOptimization {
    @Test
    public void testRewriteXmlElement() throws Exception {
        String original = "xmlserialize(document xmlelement(name a, xmlattributes('b' as c)) as string)";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        TestQueryRewriter.helpTestRewriteExpression((String)original, (String)"'<a c=\"b\"></a>'", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteXmlElement1() throws Exception {
        String original = "xmlelement(name a, xmlattributes(1+1 as c), BQT1.SmallA.timevalue)";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        TestQueryRewriter.helpTestRewriteExpression((String)original, (String)"XMLELEMENT(NAME a, XMLATTRIBUTES(2 AS c), BQT1.SmallA.timevalue)", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteXmlSerialize() throws Exception {
        String original = "xmlserialize(document xmlelement(name a, xmlattributes('b' as c)) as string)";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        TestQueryRewriter.helpTestRewriteExpression((String)original, (String)"'<a c=\"b\"></a>'", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteXmlTable() throws Exception {
        String original = "select * from xmltable('/' passing 1 + 1 as a columns x string default curdate()) as x";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        TestQueryRewriter.helpTestRewriteCommand((String)original, (String)"SELECT x.x FROM XMLTABLE('/' PASSING 2 AS a COLUMNS x string DEFAULT convert(curdate(), string)) AS x", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCountXMLAgg() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan((String)"select count(X.e1), xmlagg(xmlelement(name e1, x.e1) order by x.e2) FROM pm1.g1 as X, pm2.g2 as Y group by X.e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, (String[])new String[]{"SELECT 1 FROM pm2.g2 AS g_0", "SELECT g_0.e2, g_0.e1 FROM pm1.g1 AS g_0"}, (boolean)true);
        TestOptimizer.checkNodeTypes((ProcessorPlan)plan, (int[])new int[]{2, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0});
    }
}

