/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.xquery.saxon;

import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.StringValue;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.util.CommandContext;
import org.teiid.xquery.saxon.PushBackSequenceIterator;
import org.teiid.xquery.saxon.SaxonXQueryExpression;
import org.teiid.xquery.saxon.XMLFunctions;
import org.teiid.xquery.saxon.XQueryEvaluator;

public class SaxonXMLTableNode
extends SubqueryAwareRelationalNode {
    private static Map<Class<?>, BuiltInAtomicType> typeMapping = new HashMap();
    private static TeiidRuntimeException EARLY_TERMINATION;
    private XMLTable table;
    private SaxonXQueryExpression saxonXQueryExpression;
    private List<XMLTable.XMLColumn> projectedColumns;
    private SaxonXQueryExpression.Result result;
    private long rowCount = 0L;
    private Item item;
    private TupleBuffer buffer;
    private State state = State.BUILDING;
    private volatile TeiidRuntimeException asynchException;
    private long outputRow = 1L;
    private boolean usingOutput;
    private int rowLimit = -1;
    private boolean streaming;

    public SaxonXMLTableNode(int nodeID) {
        super(nodeID);
    }

    public synchronized void closeDirect() {
        super.closeDirect();
        if (this.buffer != null) {
            if (!this.usingOutput) {
                this.buffer.remove();
            }
            this.buffer = null;
        }
        this.reset();
    }

    public synchronized void reset() {
        super.reset();
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
        this.item = null;
        this.rowCount = 0L;
        this.outputRow = 1L;
        this.usingOutput = false;
        this.buffer = null;
        this.state = State.BUILDING;
        this.asynchException = null;
        this.rowLimit = -1;
    }

    public void setTable(XMLTable table) {
        this.table = table;
        this.saxonXQueryExpression = (SaxonXQueryExpression)this.table.getXQueryExpression();
    }

    public void setProjectedColumns(List<XMLTable.XMLColumn> projectedColumns) {
        this.projectedColumns = projectedColumns;
    }

    public SaxonXMLTableNode clone() {
        SaxonXMLTableNode clone = new SaxonXMLTableNode(this.getID());
        this.copyTo((RelationalNode)clone);
        clone.setTable(this.table);
        clone.setProjectedColumns(this.projectedColumns);
        return clone;
    }

    public void open() throws TeiidComponentException, TeiidProcessingException {
        LimitNode parent;
        super.open();
        if (this.getParent() instanceof LimitNode && (parent = (LimitNode)this.getParent()).getLimit() > 0) {
            this.rowLimit = parent.getLimit() + parent.getOffset();
        }
        this.streaming = this.saxonXQueryExpression.isStreaming();
    }

    protected synchronized TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        this.evaluate(false);
        if (this.streaming) {
            while (this.state == State.BUILDING) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30169, (Throwable)e);
                }
            }
            SaxonXMLTableNode.unwrapException((TeiidRuntimeException)this.asynchException);
            TupleBatch batch = this.buffer.getBatch(this.outputRow);
            this.outputRow = batch.getEndRow() + 1L;
            if (this.state != State.DONE && !batch.getTerminationFlag()) {
                this.state = this.hasNextBatch() ? State.AVAILABLE : State.BUILDING;
            }
            return batch;
        }
        while (!this.isBatchFull() && !this.isLastBatch()) {
            if (this.item == null) {
                try {
                    this.item = this.result.iter.next();
                }
                catch (XPathException e) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30170, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30170, new Object[]{e.getMessage()}));
                }
                ++this.rowCount;
                if (this.item == null) {
                    this.terminateBatches();
                    break;
                }
            }
            this.addBatchRow(this.processRow());
            if (this.rowCount != (long)this.rowLimit) continue;
            this.terminateBatches();
            break;
        }
        return this.pullBatch();
    }

    private void evaluate(boolean useFinalBuffer) throws TeiidComponentException, ExpressionEvaluationException, BlockedException, TeiidProcessingException {
        Object contextItem;
        if (this.result != null || this.buffer != null) {
            return;
        }
        this.setReferenceValues((TableFunctionReference)this.table);
        final HashMap<String, Object> parameters = new HashMap<String, Object>();
        Evaluator eval = this.getEvaluator(Collections.emptyMap());
        eval.evaluateParameters(this.table.getPassing(), null, parameters);
        if (parameters.containsKey(null)) {
            contextItem = parameters.remove(null);
            if (contextItem == null) {
                this.result = new SaxonXQueryExpression.Result();
                this.result.iter = EmptyIterator.emptyIterator();
                this.streaming = false;
                return;
            }
        } else {
            contextItem = null;
        }
        if (this.saxonXQueryExpression.isStreaming()) {
            if (this.buffer == null) {
                this.buffer = this.getBufferManager().createTupleBuffer(this.getOutputElements(), this.getConnectionID(), BufferManager.TupleSourceType.PROCESSOR);
                if (!useFinalBuffer) {
                    this.buffer.setForwardOnly(true);
                }
            }
            Runnable r = new Runnable(){
                TupleBuffer b;
                {
                    this.b = SaxonXMLTableNode.this.buffer;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        XQueryEvaluator.evaluateXQuery(SaxonXMLTableNode.this.saxonXQueryExpression, contextItem, parameters, new SaxonXQueryExpression.RowProcessor(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void processRow(NodeInfo row) {
                                SaxonXMLTableNode saxonXMLTableNode = SaxonXMLTableNode.this;
                                synchronized (saxonXMLTableNode) {
                                    if (b != SaxonXMLTableNode.this.buffer) {
                                        throw EARLY_TERMINATION;
                                    }
                                    SaxonXMLTableNode.this.processRow(row);
                                }
                            }
                        }, SaxonXMLTableNode.this.getContext());
                    }
                    catch (TeiidRuntimeException e) {
                        if (e != EARLY_TERMINATION) {
                            SaxonXMLTableNode.this.asynchException = e;
                        }
                    }
                    catch (Throwable e) {
                        SaxonXMLTableNode.this.asynchException = new TeiidRuntimeException(e);
                    }
                    finally {
                        SaxonXMLTableNode e = SaxonXMLTableNode.this;
                        synchronized (e) {
                            if (SaxonXMLTableNode.this.buffer != null && SaxonXMLTableNode.this.asynchException == null) {
                                try {
                                    SaxonXMLTableNode.this.buffer.close();
                                }
                                catch (TeiidComponentException e2) {
                                    SaxonXMLTableNode.this.asynchException = new TeiidRuntimeException((Throwable)e2);
                                }
                            }
                            SaxonXMLTableNode.this.state = State.DONE;
                            ((Object)((Object)SaxonXMLTableNode.this)).notifyAll();
                        }
                    }
                }
            };
            this.getContext().getExecutor().execute(r);
            return;
        }
        try {
            this.result = XQueryEvaluator.evaluateXQuery(this.saxonXQueryExpression, contextItem, parameters, null, this.getContext());
        }
        catch (TeiidRuntimeException e) {
            SaxonXMLTableNode.unwrapException((TeiidRuntimeException)e);
        }
    }

    private List<?> processRow() throws ExpressionEvaluationException, BlockedException, TeiidComponentException, TeiidProcessingException {
        ArrayList<Object> tuple = new ArrayList<Object>(this.projectedColumns.size());
        for (XMLTable.XMLColumn proColumn : this.projectedColumns) {
            if (proColumn.isOrdinal()) {
                if (this.rowCount > Integer.MAX_VALUE) {
                    throw new TeiidRuntimeException((Throwable)new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31174, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31174, new Object[0])));
                }
                tuple.add((int)this.rowCount);
                continue;
            }
            try {
                XPathExpression path = this.saxonXQueryExpression.getXPathExpression(proColumn.getName());
                XPathDynamicContext dynamicContext = path.createDynamicContext(this.item);
                SequenceIterator pathIter = path.iterate(dynamicContext);
                Item colItem = pathIter.next();
                if (colItem == null) {
                    if (proColumn.getDefaultExpression() != null) {
                        tuple.add(this.getEvaluator(Collections.emptyMap()).evaluate(proColumn.getDefaultExpression(), null));
                        continue;
                    }
                    tuple.add(null);
                    continue;
                }
                if (proColumn.getSymbol().getType() == DataTypeManager.DefaultDataClasses.XML) {
                    tuple.add(this.asXml(pathIter, colItem));
                    continue;
                }
                if (proColumn.getSymbol().getType().isArray()) {
                    ArrayList<Object> vals = new ArrayList<Object>();
                    Class<?> componentType = proColumn.getSymbol().getType().getComponentType();
                    vals.add(this.getValueOrXml(colItem, componentType));
                    Item next = null;
                    while ((next = pathIter.next()) != null) {
                        vals.add(this.getValueOrXml(next, componentType));
                    }
                    ArrayImpl value = new ArrayImpl(vals.toArray((Object[])Array.newInstance(componentType, vals.size())));
                    tuple.add(value);
                    continue;
                }
                if (pathIter.next() != null) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30171, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30171, new Object[]{proColumn.getName()}));
                }
                Object value = SaxonXMLTableNode.getValue(proColumn.getSymbol().getType(), colItem, this.saxonXQueryExpression.getConfig(), this.getContext());
                tuple.add(value);
            }
            catch (XPathException e) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30172, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30172, new Object[]{proColumn.getName()}));
            }
        }
        this.item = null;
        return tuple;
    }

    private Object getValueOrXml(Item colItem, Class<?> componentType) throws XPathException, ValidationException, TeiidComponentException, TeiidProcessingException {
        if (componentType == DataTypeManager.DefaultDataClasses.XML) {
            SequenceIterator iter = colItem.iterate();
            return this.asXml(iter, iter.next());
        }
        return SaxonXMLTableNode.getValue(componentType, colItem, this.saxonXQueryExpression.getConfig(), this.getContext());
    }

    private XMLType asXml(SequenceIterator pathIter, Item colItem) throws XPathException, TeiidComponentException, TeiidProcessingException {
        PushBackSequenceIterator pushBack = new PushBackSequenceIterator(pathIter, colItem);
        return this.saxonXQueryExpression.createXMLType(pushBack, this.getBufferManager(), false, this.getContext());
    }

    public static Object getValue(Class<?> type, Item colItem, Configuration config, CommandContext context) throws XPathException, ValidationException, TransformationException {
        Object value = colItem;
        if (value instanceof AtomicValue) {
            value = SaxonXMLTableNode.getValue((AtomicValue)colItem, context);
        } else if (value instanceof Item) {
            Item i = value;
            if (XMLFunctions.isNull(i)) {
                return null;
            }
            BuiltInAtomicType bat = typeMapping.get(type);
            if (bat != null) {
                StringValue av = new StringValue(i.getStringValueCS());
                AtomicValue cr = Converter.convert((AtomicValue)av, (AtomicType)bat, (ConversionRules)config.getConversionRules());
                value = cr.asAtomic();
                if ((value = SaxonXMLTableNode.getValue((AtomicValue)value, context)) instanceof Item) {
                    value = value.getStringValue();
                }
            } else {
                value = i.getStringValue();
            }
        }
        return FunctionDescriptor.importValue((Object)value, type, (CommandContext)context);
    }

    private static Object getValue(AtomicValue value, CommandContext context) throws XPathException {
        CalendarValue cv;
        if (value instanceof CalendarValue && !(cv = (CalendarValue)value).hasTimezone()) {
            TimeZone tz = context.getServerTimeZone();
            int tzMin = tz.getRawOffset() / 60000;
            if (tz.getDSTSavings() > 0) {
                tzMin = tz.getOffset(cv.getCalendar().getTimeInMillis()) / 60000;
            }
            cv.setTimezoneInMinutes(tzMin);
            GregorianCalendar cal = cv.getCalendar();
            return new Timestamp(cal.getTime().getTime());
        }
        return SequenceTool.convertToJava((Item)value);
    }

    public void processRow(NodeInfo row) {
        if (this.isClosed()) {
            throw EARLY_TERMINATION;
        }
        assert (this.state != State.DONE);
        this.item = row;
        ++this.rowCount;
        try {
            this.buffer.addTuple(this.processRow());
            if (this.buffer.getRowCount() == (long)this.rowLimit) {
                throw EARLY_TERMINATION;
            }
            if (this.state == State.BUILDING && this.hasNextBatch()) {
                this.state = State.AVAILABLE;
                ((Object)((Object)this)).notifyAll();
            }
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private boolean hasNextBatch() {
        return this.outputRow + (long)this.buffer.getBatchSize() <= this.rowCount + 1L;
    }

    public Collection<? extends LanguageObject> getObjects() {
        return this.table.getPassing();
    }

    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        AnalysisRecord.addLanaguageObjects((PlanNode)props, (String)"Table Function", Arrays.asList(this.table));
        props.addProperty("Streaming", String.valueOf(this.saxonXQueryExpression.isStreaming()));
        return props;
    }

    static {
        typeMapping.put(DataTypeManager.DefaultDataClasses.TIMESTAMP, BuiltInAtomicType.DATE_TIME);
        typeMapping.put(DataTypeManager.DefaultDataClasses.TIME, BuiltInAtomicType.TIME);
        typeMapping.put(DataTypeManager.DefaultDataClasses.DATE, BuiltInAtomicType.DATE);
        typeMapping.put(DataTypeManager.DefaultDataClasses.FLOAT, BuiltInAtomicType.FLOAT);
        typeMapping.put(DataTypeManager.DefaultDataClasses.DOUBLE, BuiltInAtomicType.DOUBLE);
        typeMapping.put(DataTypeManager.DefaultDataClasses.BLOB, BuiltInAtomicType.HEX_BINARY);
        typeMapping.put(DataTypeManager.DefaultDataClasses.VARBINARY, BuiltInAtomicType.HEX_BINARY);
        EARLY_TERMINATION = new TeiidRuntimeException();
    }

    private static enum State {
        BUILDING,
        AVAILABLE,
        DONE;

    }
}

