/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.Reader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.query.function.TestFunctionLibrary;
import org.teiid.query.util.CommandContext;

public class TestXMLFunctionLibrary {
    private TestFunctionLibrary tester = new TestFunctionLibrary();

    @Before
    public void before() {
        this.tester.setUp();
    }

    @After
    public void after() {
        this.tester.tearDown();
    }

    @Test
    public void testInvokeXpath1() {
        this.tester.helpInvokeMethod("xpathValue", new Object[]{"<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>", "a/b/c"}, (Object)"test");
    }

    @Test
    public void testInvokeXpathWithNill() {
        this.tester.helpInvokeMethod("xpathValue", new Object[]{"<?xml version=\"1.0\" encoding=\"utf-8\" ?><a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><b xsi:nil=\"true\"/></a>", "//*[local-name()='b' and not(@*[local-name()='nil' and string()='true'])]"}, null);
    }

    @Test
    public void testInvokeXpathWithNill1() {
        this.tester.helpInvokeMethod("xpathValue", new Object[]{"<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b>value</b></a>", "//*[local-name()='b' and not(@*[local-name()='nil' and string()='true'])]"}, (Object)"value");
    }

    @Test
    public void testInvokeXslTransform() throws Exception {
        CommandContext c = new CommandContext();
        c.setBufferManager((BufferManager)BufferManagerFactory.getStandaloneBufferManager());
        ClobType result = (ClobType)this.tester.helpInvokeMethod("xsltransform", new Class[]{DataTypeManager.DefaultDataClasses.XML, DataTypeManager.DefaultDataClasses.XML}, new Object[]{DataTypeManager.transformValue((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Catalog><Items><Item ItemID=\"001\"><Name>Lamp</Name><Quantity>5</Quantity></Item></Items></Catalog></Catalogs>", (Class)DataTypeManager.DefaultDataClasses.XML), DataTypeManager.transformValue((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template><xsl:template match=\"Quantity\"/></xsl:stylesheet>", (Class)DataTypeManager.DefaultDataClasses.XML)}, c);
        String xml = ObjectConverterUtil.convertToString((Reader)result.getCharacterStream());
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Catalog><Items><Item ItemID=\"001\"><Name>Lamp</Name></Item></Items></Catalog></Catalogs>", (Object)xml);
    }

    @Test
    public void testInvokeXmlConcat() throws Exception {
        CommandContext c = new CommandContext();
        c.setBufferManager((BufferManager)BufferManagerFactory.getStandaloneBufferManager());
        XMLType result = (XMLType)this.tester.helpInvokeMethod("xmlconcat", new Class[]{DataTypeManager.DefaultDataClasses.XML, DataTypeManager.DefaultDataClasses.XML}, new Object[]{DataTypeManager.transformValue((Object)"<bar/>", (Class)DataTypeManager.DefaultDataClasses.XML), DataTypeManager.transformValue((Object)"<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Catalog><Items><Item ItemID=\"001\"><Name>Lamp</Name><Quantity>5</Quantity></Item></Items></Catalog></Catalogs>", (Class)DataTypeManager.DefaultDataClasses.XML)}, c);
        String xml = ObjectConverterUtil.convertToString((Reader)result.getCharacterStream());
        Assert.assertEquals((Object)"<bar/><Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Catalog><Items><Item ItemID=\"001\"><Name>Lamp</Name><Quantity>5</Quantity></Item></Items></Catalog></Catalogs>", (Object)xml);
    }

    @Test
    public void testInvokeXmlComment() throws Exception {
        CommandContext c = new CommandContext();
        c.setBufferManager((BufferManager)BufferManagerFactory.getStandaloneBufferManager());
        XMLType result = (XMLType)this.tester.helpInvokeMethod("xmlcomment", new Class[]{DataTypeManager.DefaultDataClasses.STRING}, new Object[]{"comment"}, c);
        String xml = ObjectConverterUtil.convertToString((Reader)result.getCharacterStream());
        Assert.assertEquals((Object)"<!--comment-->", (Object)xml);
    }
}

