/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.TestValidator;

public class TestXMLValidation {
    @Test
    public void testXMLQueryPassingContextType() {
        TestValidator.helpValidate((String)"select xmlquery('/' passing 2)", (String[])new String[]{"XMLQUERY('/' PASSING 2)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXpathValueValid_defect15088() {
        String userSql = "SELECT xpathValue('<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>', 'a/b/c')";
        TestValidator.helpValidate((String)userSql, (String[])new String[0], (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testXpathValueInvalid_defect15088() throws Exception {
        String userSql = "SELECT xpathValue('<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>', '//*[local-name()=''bookName\"]')";
        TestValidator.helpValidate((String)userSql, (String[])new String[]{"xpathValue('<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>', '//*[local-name()=''bookName\"]')"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testXMLTablePassingMultipleContext() {
        TestValidator.helpValidate((String)"select * from pm1.g1, xmltable('/' passing xmlparse(DOCUMENT '<a/>'), xmlparse(DOCUMENT '<b/>')) as x", (String[])new String[]{"XMLTABLE('/' PASSING XMLPARSE(DOCUMENT '<a/>'), XMLPARSE(DOCUMENT '<b/>')) AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateNoExpressionName() {
        TestValidator.helpValidate((String)"SELECT xmlelement(name a, xmlattributes('1'))", (String[])new String[]{"XMLATTRIBUTES('1')"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testInvalidCorrelation() {
        TestValidator.helpValidate((String)"SELECT XMLELEMENT(NAME metadata, XMLFOREST(e1 AS objectName), (SELECT XMLAGG(XMLELEMENT(NAME subTypes, XMLFOREST(e1))) FROM pm1.g2 AS b WHERE b.e2 = a.e2)) FROM pm1.g1 AS a GROUP BY e1", (String[])new String[]{"a.e2"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLNamespacesReserved() {
        TestValidator.helpValidate((String)"select xmlforest(xmlnamespaces('http://foo' as xmlns), e1 as \"table\") from pm1.g1", (String[])new String[]{"XMLNAMESPACES('http://foo' AS xmlns)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXmlNameValidation() throws Exception {
        TestValidator.helpValidate((String)"select xmlelement(\":\")", (String[])new String[]{"XMLELEMENT(NAME \":\")"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testWindowFunctionWithNestedOrdering() {
        TestValidator.helpValidate((String)"SELECT xmlagg(xmlelement(name x, e1) order by e2) over () from pm1.g1", (String[])new String[]{"XMLAGG(XMLELEMENT(NAME x, e1) ORDER BY e2) OVER ()"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLTableContextRequired() {
        TestValidator.helpValidate((String)"select * from xmltable('/a/b' passing convert('<a/>', xml) as a columns x for ordinality, c integer path '.') as x", (String[])new String[]{"XMLTABLE('/a/b' PASSING convert('<a/>', xml) AS a COLUMNS x FOR ORDINALITY, c integer PATH '.') AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidDefault() {
        TestValidator.helpValidate((String)"select * from pm1.g1, xmltable('/' passing xmlparse(DOCUMENT '<a/>') columns y string default 'a', x string default (select e1 from pm1.g1)) as x", (String[])new String[]{"XMLTABLE('/' PASSING XMLPARSE(DOCUMENT '<a/>') COLUMNS y string DEFAULT 'a', x string DEFAULT (SELECT e1 FROM pm1.g1)) AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLTableMultipleOrdinals() {
        TestValidator.helpValidate((String)"select * from pm1.g1, xmltable('/' passing XMLPARSE(DOCUMENT '<a/>') columns x for ordinality, y for ordinality) as x", (String[])new String[]{"XMLTABLE('/' PASSING XMLPARSE(DOCUMENT '<a/>') COLUMNS x FOR ORDINALITY, y FOR ORDINALITY) AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLTablePassingContextType() {
        TestValidator.helpValidate((String)"select * from pm1.g1, xmltable('/' passing 2) as x", (String[])new String[]{"XMLTABLE('/' PASSING 2) AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLNamespaces() {
        TestValidator.helpValidate((String)"select xmlforest(xmlnamespaces(no default, default 'http://foo'), e1 as \"table\") from pm1.g1", (String[])new String[]{"XMLNAMESPACES(NO DEFAULT, DEFAULT 'http://foo')"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLNamespacesInvalid() {
        TestValidator.helpValidate((String)"select xmlforest(xmlnamespaces('http://foo' as \"1\"), e1 as \"table\") from pm1.g1", (String[])new String[]{"XMLNAMESPACES('http://foo' AS \"1\")"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateAlterViewDeep() {
        TestValidator.helpValidate((String)"alter view Defect15355 as select xpathvalue('a', ':'), cast(1 as biginteger)", (String[])new String[]{"xpathvalue('a', ':')"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }
}

