/*
 * Copyright Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags and
 * the COPYRIGHT.txt file distributed with this work.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.teiid.query.sql.navigator;

import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;


/** 
 * @since 4.2
 */
public class DeepPostOrderNavigator extends PreOrPostOrderNavigator {

    public DeepPostOrderNavigator(LanguageVisitor visitor) {
        super(visitor, PreOrPostOrderNavigator.POST_ORDER, true);
    }

    public static void doVisit(LanguageObject object, LanguageVisitor visitor) {
        DeepPostOrderNavigator nav = new DeepPostOrderNavigator(visitor);
        object.acceptVisitor(nav);
    }

}
