/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.teiid.PolicyDecider;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.infinispan.InfinispanCacheFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DataRolePolicyDecider;
import org.teiid.dqp.internal.process.DefaultAuthorizationValidator;
import org.teiid.dqp.internal.process.TeiidExecutor;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.query.ObjectReplicator;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.runtime.WorkManagerTeiidExecutor;
import org.teiid.security.SecurityHelper;
import org.teiid.transport.SocketConfiguration;

public class EmbeddedConfiguration
extends DQPConfiguration {
    static final int DEFAULT_MAX_ASYNC_WORKERS = 10;
    private SecurityHelper securityHelper;
    private String securityDomain;
    private TransactionManager transactionManager;
    private ObjectReplicator objectReplicator;
    private WorkManager workManager;
    private boolean useDisk = true;
    private String bufferDirectory;
    private CacheFactory cacheFactory;
    private int maxResultSetCacheStaleness = 0;
    private String infinispanConfigFile = "infinispan-config.xml";
    private String jgroupsConfigFile;
    private List<SocketConfiguration> transports;
    private int maxODBCLobSizeAllowed = 0x500000;
    private int maxAsyncThreads = 10;
    private int processorBatchSize = -1;
    private int maxReserveKb = -1;
    private int maxProcessingKb = -1;
    private boolean inlineLobs = true;
    private int maxOpenFiles = -1;
    private long maxBufferSpace = -1L;
    private long maxFileSize = -1L;
    private boolean encryptFiles = false;
    private int maxStorageObjectSize = -1;
    private boolean memoryBufferOffHeap = false;
    private int memoryBufferSpace = -1;
    private String nodeName;
    private DefaultCacheManager cacheManager;
    private AuthenticationType authenticationType;

    public EmbeddedConfiguration() {
        DefaultAuthorizationValidator authorizationValidator = new DefaultAuthorizationValidator();
        authorizationValidator.setPolicyDecider((PolicyDecider)new DataRolePolicyDecider());
        this.setAuthorizationValidator((AuthorizationValidator)authorizationValidator);
    }

    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public ObjectReplicator getObjectReplicator() {
        return this.objectReplicator;
    }

    public void setObjectReplicator(ObjectReplicator objectReplicator) {
        this.objectReplicator = objectReplicator;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public TeiidExecutor getTeiidExecutor() {
        if (this.workManager == null) {
            return super.getTeiidExecutor();
        }
        return new WorkManagerTeiidExecutor(this.workManager);
    }

    public boolean isUseDisk() {
        return this.useDisk;
    }

    public void setUseDisk(boolean useDisk) {
        this.useDisk = useDisk;
    }

    public void setBufferDirectory(String dir) {
        this.bufferDirectory = dir;
    }

    public String getBufferDirectory() {
        return this.bufferDirectory;
    }

    public String getInfinispanConfigFile() {
        return this.infinispanConfigFile;
    }

    public void setInfinispanConfigFile(String infinispanConfigFile) {
        this.infinispanConfigFile = infinispanConfigFile;
    }

    public CacheFactory getCacheFactory() {
        if (this.cacheFactory == null) {
            try {
                this.cacheManager = new DefaultCacheManager(this.infinispanConfigFile, true);
                for (String cacheName : this.cacheManager.getCacheNames()) {
                    if (this.getTransactionManager() != null) {
                        this.setCacheTransactionManger(cacheName);
                    }
                    this.cacheManager.startCache(cacheName);
                }
                this.cacheFactory = new InfinispanCacheFactory((EmbeddedCacheManager)this.cacheManager, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (IOException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40100, (Throwable)e);
            }
        }
        return this.cacheFactory;
    }

    private void setCacheTransactionManger(String cacheName) {
        this.cacheManager.getCacheConfiguration(cacheName).transaction().transactionManagerLookup(new TransactionManagerLookup(){

            public TransactionManager getTransactionManager() throws Exception {
                return EmbeddedConfiguration.this.getTransactionManager();
            }
        });
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public int getMaxResultSetCacheStaleness() {
        return this.maxResultSetCacheStaleness;
    }

    public void setMaxResultSetCacheStaleness(int maxResultSetCacheStaleness) {
        this.maxResultSetCacheStaleness = maxResultSetCacheStaleness;
    }

    public String getJgroupsConfigFile() {
        return this.jgroupsConfigFile;
    }

    public void setJgroupsConfigFile(String jgroupsConfigFile) {
        this.jgroupsConfigFile = jgroupsConfigFile;
    }

    protected void stop() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }

    public void addTransport(SocketConfiguration configuration) {
        if (this.transports == null) {
            this.transports = new ArrayList<SocketConfiguration>();
        }
        this.transports.add(configuration);
    }

    public List<SocketConfiguration> getTransports() {
        return this.transports;
    }

    public int getMaxODBCLobSizeAllowed() {
        return this.maxODBCLobSizeAllowed;
    }

    public void setMaxODBCLobSizeAllowed(int lobSize) {
        this.maxODBCLobSizeAllowed = lobSize;
    }

    public int getMaxAsyncThreads() {
        return this.maxAsyncThreads;
    }

    public void setMaxAsyncThreads(int maxAsyncThreads) {
        this.maxAsyncThreads = maxAsyncThreads;
    }

    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    public void setProcessorBatchSize(int processorBatchSize) {
        this.processorBatchSize = processorBatchSize;
    }

    public int getMaxReserveKb() {
        return this.maxReserveKb;
    }

    public void setMaxReserveKb(int maxReserveKb) {
        this.maxReserveKb = maxReserveKb;
    }

    public int getMaxProcessingKb() {
        return this.maxProcessingKb;
    }

    public void setMaxProcessingKb(int maxProcessingKb) {
        this.maxProcessingKb = maxProcessingKb;
    }

    public boolean isInlineLobs() {
        return this.inlineLobs;
    }

    public void setInlineLobs(boolean inlineLobs) {
        this.inlineLobs = inlineLobs;
    }

    public int getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public long getMaxBufferSpace() {
        return this.maxBufferSpace;
    }

    public void setMaxBufferSpace(long maxBufferSpace) {
        this.maxBufferSpace = maxBufferSpace;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public boolean isEncryptFiles() {
        return this.encryptFiles;
    }

    public void setEncryptFiles(boolean encryptFiles) {
        this.encryptFiles = encryptFiles;
    }

    public int getMaxStorageObjectSize() {
        return this.maxStorageObjectSize;
    }

    public void setMaxStorageObjectSize(int maxStorageObjectSize) {
        this.maxStorageObjectSize = maxStorageObjectSize;
    }

    public boolean isMemoryBufferOffHeap() {
        return this.memoryBufferOffHeap;
    }

    public void setMemoryBufferOffHeap(boolean memoryBufferOffHeap) {
        this.memoryBufferOffHeap = memoryBufferOffHeap;
    }

    public int getMemoryBufferSpace() {
        return this.memoryBufferSpace;
    }

    public void setMemoryBufferSpace(int memoryBufferSpace) {
        this.memoryBufferSpace = memoryBufferSpace;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }
}

