/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.ArrayList;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.runtime.RuntimePlugin;

public class ExtendedPropertyMetadata {
    String displayName;
    String description;
    boolean advanced;
    boolean masked;
    boolean editable = true;
    boolean required;
    ArrayList<String> allowed;
    String name;
    String dataType;
    String defaultValue;
    String category;
    String owner;

    public ExtendedPropertyMetadata() {
    }

    public ExtendedPropertyMetadata(String name, String type, String encodedData, String defaultValue) {
        this.name = name;
        this.dataType = type;
        this.defaultValue = defaultValue;
        encodedData = encodedData.trim();
        if (!encodedData.startsWith("{")) {
            this.displayName = encodedData;
            return;
        }
        if (!encodedData.endsWith("}")) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40034, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40034, new Object[]{encodedData}));
        }
        encodedData = encodedData.substring(1, encodedData.length() - 1);
        int index = 0;
        int start = -1;
        boolean inQuotes = false;
        int inQuotesStart = -1;
        boolean inArray = false;
        String propertyName = null;
        ArrayList<String> values = new ArrayList<String>();
        for (char c : encodedData.toCharArray()) {
            if (c == '$' && start == -1) {
                start = index;
            } else if (c == '\"') {
                boolean bl = inQuotes = !inQuotes;
                if (inQuotes && inQuotesStart == -1) {
                    inQuotesStart = index;
                } else if (!inQuotes && inQuotesStart != -1) {
                    if (inQuotesStart + 1 != index) {
                        values.add(encodedData.substring(inQuotesStart + 1, index));
                    } else {
                        values.add("");
                    }
                    inQuotesStart = -1;
                }
            } else if (c == '[') {
                inArray = true;
            } else if (c == ']') {
                inArray = false;
            } else if (c == ':' && !inQuotes && !inArray && start != -1) {
                propertyName = encodedData.substring(start, index);
            } else if (c == ',' && !inQuotes && !inArray && start != -1) {
                this.addProperty(propertyName, values);
                propertyName = null;
                values = new ArrayList();
                start = -1;
            }
            ++index;
        }
        if (propertyName != null) {
            this.addProperty(propertyName, values);
        }
    }

    private void addProperty(String name, ArrayList<String> values) {
        if (name.equals("$display")) {
            this.displayName = values.get(0);
        } else if (name.equals("$description")) {
            this.description = values.get(0);
        } else if (name.equals("$advanced")) {
            this.advanced = Boolean.parseBoolean(values.get(0));
        } else if (name.equals("$masked")) {
            this.masked = Boolean.parseBoolean(values.get(0));
        } else if (name.equals("$editable")) {
            this.editable = Boolean.parseBoolean(values.get(0));
        } else if (name.equals("$allowed")) {
            this.allowed = new ArrayList<String>(values);
        } else if (name.equals("$required")) {
            this.required = Boolean.parseBoolean(values.get(0));
        }
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String display() {
        return this.displayName;
    }

    public boolean advanced() {
        return this.advanced;
    }

    public boolean masked() {
        return this.masked;
    }

    public boolean readOnly() {
        return !this.editable;
    }

    public boolean required() {
        return this.required;
    }

    public String[] allowed() {
        if (this.allowed != null) {
            return this.allowed.toArray(new String[this.allowed.size()]);
        }
        return new String[0];
    }

    public String datatype() {
        return this.dataType;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String category() {
        return this.category;
    }

    public String owner() {
        return this.owner;
    }
}

