/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.vdb.runtime.VDBKey;

public abstract class VDBStatusChecker {
    private static final String JAVA_CONTEXT = "java:/";

    public void translatorAdded(String translatorName) {
    }

    public void translatorRemoved(String translatorName) {
    }

    public void dataSourceAdded(String dataSourceName, VDBKey vdbKey) {
        dataSourceName = VDBStatusChecker.stripContext(dataSourceName);
        if (vdbKey == null) {
            this.resourceAdded(dataSourceName);
        } else {
            CompositeVDB cvdb = this.getVDBRepository().getCompositeVDB(vdbKey);
            if (cvdb == null) {
                return;
            }
            VDBMetaData vdb = cvdb.getVDB();
            this.resourceAdded(dataSourceName, new LinkedList<Runnable>(), vdb);
        }
    }

    public static String stripContext(String dataSourceName) {
        if (dataSourceName == null) {
            return null;
        }
        if (dataSourceName.startsWith(JAVA_CONTEXT)) {
            dataSourceName = dataSourceName.substring(5);
        }
        return dataSourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSourceRemoved(String dataSourceName, VDBKey vdbKey) {
        dataSourceName = VDBStatusChecker.stripContext(dataSourceName);
        CompositeVDB cvdb = this.getVDBRepository().getCompositeVDB(vdbKey);
        if (cvdb == null) {
            return;
        }
        VDBMetaData vdb = cvdb.getVDB();
        if (vdb.getStatus() == VDB.Status.FAILED) {
            return;
        }
        VDBMetaData vDBMetaData = vdb;
        synchronized (vDBMetaData) {
            ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
            for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                String sourceName = this.getSourceName(dataSourceName, model);
                if (sourceName == null) continue;
                ModelMetaData.Message.Severity severity = ModelMetaData.Message.Severity.WARNING;
                ConnectorManager cm = cmr.getConnectorManager(sourceName);
                if (cm.getExecutionFactory().isSourceRequired() && vdb.getStatus() == VDB.Status.ACTIVE) {
                    severity = ModelMetaData.Message.Severity.ERROR;
                }
                String msg = RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40012, new Object[]{vdb.getName(), vdb.getVersion(), dataSourceName});
                model.addRuntimeMessage(severity, msg);
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)msg);
            }
        }
    }

    public boolean dataSourceReplaced(String vdbName, String vdbVersion, String modelName, String sourceName, String translatorName, String dsName) throws AdminProcessingException {
        return this.updateSource(vdbName, vdbVersion, new SourceMappingMetadata(sourceName, translatorName, dsName), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSource(String vdbName, String vdbVersion, SourceMappingMetadata mapping, boolean replace) throws AdminProcessingException {
        String dsName = VDBStatusChecker.stripContext(mapping.getConnectionJndiName());
        VDBMetaData vdb = this.getVDBRepository().getLiveVDB(vdbName, vdbVersion);
        if (vdb == null || vdb.getStatus() == VDB.Status.FAILED) {
            return false;
        }
        VDBMetaData vDBMetaData = vdb;
        synchronized (vDBMetaData) {
            ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
            ConnectorManager existing = cmr.getConnectorManager(mapping.getName());
            try {
                cmr.createConnectorManager(vdb, cmr.getProvider(), mapping, replace);
            }
            catch (TeiidException e) {
                throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40033, (Throwable)e);
            }
            if (!(mapping.getConnectionJndiName() == null || existing != null && dsName.equals(existing.getConnectionName()))) {
                ArrayList<Runnable> runnables = new ArrayList<Runnable>();
                this.resourceAdded(dsName, runnables, vdb);
                return true;
            }
            return false;
        }
    }

    void resourceAdded(String resourceName) {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        for (CompositeVDB cvdb : this.getVDBRepository().getCompositeVDBs()) {
            VDBMetaData vdb = cvdb.getVDB();
            if (vdb.getStatus() == VDB.Status.FAILED) continue;
            this.resourceAdded(resourceName, runnables, vdb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resourceAdded(String resourceName, List<Runnable> runnables, VDBMetaData vdb) {
        VDBMetaData vDBMetaData = vdb;
        synchronized (vDBMetaData) {
            ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
            boolean usesResourse = false;
            for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                String sourceName;
                if (!model.hasRuntimeMessages() || (sourceName = this.getSourceName(resourceName, model)) == null) continue;
                usesResourse = true;
                ConnectorManager cm = cmr.getConnectorManager(sourceName);
                this.checkStatus(runnables, vdb, model, cm);
            }
            if (usesResourse) {
                this.updateVDB(runnables, vdb);
            }
        }
    }

    private void updateVDB(List<Runnable> runnables, VDBMetaData vdb) {
        if (!runnables.isEmpty()) {
            for (Runnable runnable : runnables) {
                this.getExecutor().execute(runnable);
            }
            runnables.clear();
        } else if (vdb.hasErrors()) {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40003, new Object[]{vdb.getName(), vdb.getVersion(), vdb.getStatus()}));
        }
    }

    private void checkStatus(List<Runnable> runnables, VDBMetaData vdb, ModelMetaData model, ConnectorManager cm) {
        model.removeAttachment(VDBStatusChecker.class);
        Runnable r = (Runnable)model.removeAttachment(Runnable.class);
        if (r != null) {
            runnables.add(r);
        } else {
            String status = cm.getStausMessage();
            if (status != null && status.length() > 0) {
                ModelMetaData.Message.Severity severity = vdb.getStatus() == VDB.Status.LOADING ? ModelMetaData.Message.Severity.WARNING : ModelMetaData.Message.Severity.ERROR;
                model.addRuntimeMessage(severity, status);
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)status);
            } else if (vdb.getStatus() != VDB.Status.LOADING) {
                model.clearRuntimeMessages();
            } else {
                model.addAttchment(VDBStatusChecker.class, (Object)this);
            }
        }
    }

    private String getSourceName(String factoryName, ModelMetaData model) {
        for (SourceMappingMetadata source : model.getSources().values()) {
            String jndiName = source.getConnectionJndiName();
            if (jndiName == null || !factoryName.equals(jndiName = VDBStatusChecker.stripContext(jndiName))) continue;
            return source.getName();
        }
        return null;
    }

    public abstract Executor getExecutor();

    public abstract VDBRepository getVDBRepository();
}

