/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odbc;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.odbc.ScriptReader;

public class TestScriptReader {
    @Test
    public void testRewrite() throws Exception {
        ScriptReader sr = new ScriptReader("select 'a'::b from foo");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select cast('a' AS b) from foo", (Object)result);
    }

    @Test
    public void testRewriteComplexLiteral() throws Exception {
        ScriptReader sr = new ScriptReader("select 'a''c'::b");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select cast('a''c' AS b)", (Object)result);
    }

    @Test
    public void testRewrite1() throws Exception {
        ScriptReader sr = new ScriptReader("select a~b, a!~~c from foo");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select a LIKE_REGEX b, a NOT LIKE c from foo", (Object)result);
    }

    @Test
    public void testRewrite2() throws Exception {
        ScriptReader sr = new ScriptReader("select a~");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select a LIKE_REGEX ", (Object)result);
    }

    @Test
    public void testRewrite3() throws Exception {
        ScriptReader sr = new ScriptReader("select a::b");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select a", (Object)result);
    }

    @Test
    public void testDelimited() throws Exception {
        ScriptReader sr = new ScriptReader("set foo 'bar'; set foo1 'bar1'");
        String result = sr.readStatement();
        Assert.assertEquals((Object)"set foo 'bar'", (Object)result);
        result = sr.readStatement();
        Assert.assertEquals((Object)" set foo1 'bar1'", (Object)result);
    }

    @Test
    public void testRegClassCast() throws Exception {
        ScriptReader sr = new ScriptReader("where oid='\"a\"'::regclass");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"where oid=regclass('\"a\"')", (Object)result);
    }

    @Test
    public void testExtraDelim() throws Exception {
        ScriptReader sr = new ScriptReader("BEGIN;declare \"SQL_CUR0x1e4ba50\" cursor with hold for select * from pg_proc;;fetch 1 in \"SQL_CUR0x1e4ba50\"");
        String result = sr.readStatement();
        Assert.assertEquals((Object)"BEGIN", (Object)result);
        result = sr.readStatement();
        Assert.assertEquals((Object)"declare \"SQL_CUR0x1e4ba50\" cursor with hold for select * from pg_proc", (Object)result);
        result = sr.readStatement();
        Assert.assertEquals((Object)"fetch 1 in \"SQL_CUR0x1e4ba50\"", (Object)result);
        Assert.assertNull((Object)sr.readStatement());
    }

    @Test
    public void testFunctionRewrite() throws Exception {
        ScriptReader sr = new ScriptReader("select textcat('a', 'b'), textcat+('a', 'b')");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select concat('a', 'b'), textcat+('a', 'b')", (Object)result);
    }

    @Test
    public void testFunctionRewrite2() throws Exception {
        ScriptReader sr = new ScriptReader("select \"ltrunc('a')\", ltrunc('a')");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select \"ltrunc('a')\", left('a')", (Object)result);
    }
}

