/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.deployers.CompositeGlobalTableStore;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.PgCatalogMetadataStore;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataStore;
import org.teiid.net.ConnectionException;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.metadata.DatabaseStore;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.VDBResources;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.report.ReportItem;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.runtime.MaterializationManager;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.vdb.runtime.VDBKey;

public class VDBRepository
implements Serializable {
    private static final String LIFECYCLE_CONTEXT = "org.teiid.RUNTIME.VDBLifeCycleListener";
    private static final long serialVersionUID = 312177538191772674L;
    private static final int DEFAULT_TIMEOUT_MILLIS = PropertiesUtils.getIntProperty((Properties)System.getProperties(), (String)"org.teiid.clientVdbLoadTimeoutMillis", (int)300000);
    private static final boolean ADD_PG_METADATA = PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.addPGMetadata", (boolean)true);
    private NavigableMap<VDBKey, CompositeVDB> vdbRepo = new ConcurrentSkipListMap<VDBKey, CompositeVDB>();
    private NavigableMap<VDBKey, VDBMetaData> pendingDeployments = new ConcurrentSkipListMap<VDBKey, VDBMetaData>();
    private MetadataStore systemStore = SystemMetadata.getInstance().getSystemStore();
    private MetadataStore odbcStore;
    private Set<VDBLifeCycleListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private SystemFunctionManager systemFunctionManager;
    private Map<String, Datatype> datatypeMap = SystemMetadata.getInstance().getRuntimeTypeMap();
    private ReentrantLock lock = new ReentrantLock();
    private Condition vdbAdded = this.lock.newCondition();
    private boolean dataRolesRequired;
    private MetadataException odbcException;
    private BufferManager bufferManager;
    private ObjectReplicator objectReplictor;
    private DatabaseStore databaseStore;
    private boolean allowEnv = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVDB(VDBMetaData vdb, MetadataStore metadataStore, LinkedHashMap<String, VDBResources.Resource> visibilityMap, UDFMetaData udf, ConnectorManagerRepository cmr) throws VirtualDatabaseException {
        if (this.systemStore == null) {
            throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40022, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40022, new Object[0]));
        }
        if (this.dataRolesRequired && vdb.getDataPolicyMap().isEmpty()) {
            throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40143, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40143, new Object[]{vdb}));
        }
        boolean pgMetadataEnabled = ADD_PG_METADATA;
        String includePgMetadata = vdb.getPropertyValue("include-pg-metadata");
        if (includePgMetadata != null) {
            pgMetadataEnabled = Boolean.parseBoolean(includePgMetadata);
        }
        if (pgMetadataEnabled && this.odbcException != null) {
            throw this.odbcException;
        }
        MetadataStore[] stores = null;
        stores = pgMetadataEnabled ? new MetadataStore[]{this.systemStore, this.odbcStore} : new MetadataStore[]{this.systemStore};
        CompositeVDB cvdb = new CompositeVDB(vdb, metadataStore, visibilityMap, udf, this.systemFunctionManager.getSystemFunctions(), cmr, this, stores);
        this.lock.lock();
        try {
            VDBKey vdbKey = cvdb.getVDBKey();
            if (vdbKey.isAtMost()) {
                throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40145, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40145, new Object[]{vdbKey}));
            }
            if (this.vdbRepo.containsKey(vdbKey)) {
                throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40035, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40035, new Object[]{vdb.getName(), vdb.getVersion()}));
            }
            vdb.setVersion(vdbKey.getVersion());
            vdb.addAttchment(VDBKey.class, (Object)vdbKey);
            vdb.setStatus(VDB.Status.LOADING);
            this.vdbRepo.put(vdbKey, cvdb);
            this.pendingDeployments.remove(vdbKey);
            this.vdbAdded.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.notifyAdd(vdb.getName(), vdb.getVersion(), cvdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinished(VDBKey key, int timeOutMillis) throws ConnectionException {
        CompositeVDB cvdb = null;
        if (timeOutMillis < 0) {
            timeOutMillis = DEFAULT_TIMEOUT_MILLIS;
        }
        long timeOutNanos = TimeUnit.MILLISECONDS.toNanos(timeOutMillis);
        this.lock.lock();
        try {
            while ((cvdb = (CompositeVDB)this.vdbRepo.get(key)) == null) {
                if (timeOutNanos <= 0L) {
                    throw new ConnectionException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40096, new Object[]{timeOutMillis, key.getName(), key.getVersion()}));
                }
                timeOutNanos = this.vdbAdded.awaitNanos(timeOutNanos);
            }
        }
        catch (InterruptedException e) {
            return;
        }
        finally {
            this.lock.unlock();
        }
        VDBMetaData vdb = cvdb.getVDB();
        long finishNanos = System.nanoTime() + timeOutNanos;
        VDBMetaData vDBMetaData = vdb;
        synchronized (vDBMetaData) {
            while (vdb.getStatus() != VDB.Status.ACTIVE) {
                long millis = timeOutNanos / 1000000L;
                if (millis <= 0L) {
                    throw new ConnectionException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40097, new Object[]{timeOutMillis, key.getName(), key.getVersion(), vdb.getValidityErrors()}));
                }
                try {
                    vdb.wait(millis);
                }
                catch (InterruptedException e) {
                    return;
                }
                timeOutNanos = finishNanos - System.nanoTime();
            }
        }
    }

    public CompositeVDB getCompositeVDB(VDBKey key) {
        return (CompositeVDB)this.vdbRepo.get(key);
    }

    public VDBMetaData getLiveVDB(String name, Object version) {
        CompositeVDB v = (CompositeVDB)this.vdbRepo.get(new VDBKey(name, version));
        if (v != null) {
            return v.getVDB();
        }
        return null;
    }

    public List<VDBMetaData> getVDBs() {
        ArrayList<VDBMetaData> vdbs = new ArrayList<VDBMetaData>();
        for (CompositeVDB cVDB : this.vdbRepo.values()) {
            vdbs.add(cVDB.getVDB());
        }
        vdbs.addAll(this.pendingDeployments.values());
        return vdbs;
    }

    Collection<CompositeVDB> getCompositeVDBs() {
        return this.vdbRepo.values();
    }

    public VDBMetaData getLiveVDB(String vdbName) {
        VDBMetaData result = null;
        VDBKey key = new VDBKey(vdbName, null);
        if (!key.isAtMost()) {
            CompositeVDB v = (CompositeVDB)this.vdbRepo.get(key);
            if (v != null) {
                return v.getVDB();
            }
            return null;
        }
        for (Map.Entry<VDBKey, CompositeVDB> entry : this.vdbRepo.tailMap(key).entrySet()) {
            if (!key.acceptsVerion(entry.getKey())) break;
            VDBMetaData vdb = entry.getValue().getVDB();
            switch (vdb.getConnectionType()) {
                case ANY: {
                    result = vdb;
                    break;
                }
                case BY_VERSION: 
                case NONE: {
                    if (result != null && result.getConnectionType() != VDB.ConnectionType.NONE) break;
                    result = vdb;
                }
            }
        }
        return result;
    }

    public MetadataStore getSystemStore() {
        return this.systemStore;
    }

    public MetadataStore getODBCStore() {
        return this.odbcStore;
    }

    public void setSystemStore(MetadataStore store) {
        this.systemStore = store;
    }

    private MetadataStore getODBCMetadataStore() {
        try {
            PgCatalogMetadataStore pg = new PgCatalogMetadataStore("pg_catalog", this.getRuntimeTypeMap());
            ValidatorReport report = new ValidatorReport("Function Validation");
            FunctionMetadataValidator.validateFunctionMethods(pg.getSchema().getFunctions().values(), (ValidatorReport)report);
            if (report.hasItems()) {
                throw new MetadataException(report.getFailureMessage());
            }
            return pg.asMetadataStore();
        }
        catch (MetadataException e) {
            this.odbcException = e;
            LogManager.logError((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40002, new Object[0]));
            return null;
        }
    }

    public VDBMetaData removeVDB(String vdbName, Object vdbVersion) {
        VDBKey key = new VDBKey(vdbName, vdbVersion);
        return this.removeVDB(key);
    }

    private VDBMetaData removeVDB(VDBKey key) {
        this.notifyBeforeRemove(key.getName(), key.getVersion(), (CompositeVDB)this.vdbRepo.get(key));
        this.pendingDeployments.remove(key);
        CompositeVDB removed = (CompositeVDB)this.vdbRepo.remove(key);
        if (removed == null) {
            return null;
        }
        removed.getVDB().setStatus(VDB.Status.REMOVED);
        if (this.objectReplictor != null) {
            GlobalTableStore gts = (GlobalTableStore)removed.getVDB().getAttachment(GlobalTableStore.class);
            this.objectReplictor.stop((Object)gts);
        }
        this.notifyRemove(key.getName(), key.getVersion(), removed);
        return removed.getVDB();
    }

    public Map<String, Datatype> getRuntimeTypeMap() {
        return this.datatypeMap;
    }

    public void start() {
        this.odbcStore = this.getODBCMetadataStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDeployment(String name, String version) {
        VDBKey key = new VDBKey(name, (Object)version);
        CompositeVDB v = (CompositeVDB)this.vdbRepo.get(key);
        if (v == null) {
            return;
        }
        VDBMetaData metadataAwareVDB = v.getVDB();
        if (v.getOriginalVDB().getStatus() == VDB.Status.FAILED) {
            if (v.getOriginalVDB() != metadataAwareVDB && metadataAwareVDB.getStatus() == VDB.Status.LOADING) {
                metadataAwareVDB.setStatus(VDB.Status.FAILED);
            }
            return;
        }
        VDBMetaData vDBMetaData = metadataAwareVDB;
        synchronized (vDBMetaData) {
            try {
                ValidatorReport report;
                block18: {
                    try {
                        v.metadataLoadFinished(this.allowEnv);
                    }
                    catch (MetadataException e) {
                        LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40073, new Object[]{name, version, e.getMessage()}));
                        if (metadataAwareVDB.isPreview()) break block18;
                        report = new ValidatorReport();
                        report.addItem((ReportItem)new ValidatorFailure(e.getMessage()));
                        if (this.processMetadataValidatorReport(key, report)) break block18;
                        metadataAwareVDB.setStatus(VDB.Status.FAILED);
                        this.notifyFinished(name, version, v);
                        if (metadataAwareVDB.getStatus() != VDB.Status.ACTIVE && metadataAwareVDB.getStatus() != VDB.Status.FAILED) {
                            metadataAwareVDB.setStatus(VDB.Status.FAILED);
                            this.notifyFinished(name, version, v);
                        }
                        return;
                    }
                }
                MetadataStore store = (MetadataStore)metadataAwareVDB.removeAttachment(MetadataStore.class);
                report = new MetadataValidator((Map)store.getDatatypes(), QueryParser.getQueryParser()).validate(metadataAwareVDB, store);
                if (report.hasItems()) {
                    LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40073, new Object[]{name, version, report.getItems().iterator().next()}));
                    if (!metadataAwareVDB.isPreview() && !this.processMetadataValidatorReport(key, report)) {
                        metadataAwareVDB.setStatus(VDB.Status.FAILED);
                        this.notifyFinished(name, version, v);
                        return;
                    }
                }
                this.validateDataSources(metadataAwareVDB);
                metadataAwareVDB.setStatus(VDB.Status.ACTIVE);
                GlobalTableStore gts = CompositeGlobalTableStore.createInstance(v, this.bufferManager, this.objectReplictor);
                metadataAwareVDB.addAttchment(GlobalTableStore.class, (Object)gts);
                if (this.databaseStore != null) {
                    metadataAwareVDB.addAttchment(DatabaseStore.class, (Object)this.databaseStore);
                }
                this.notifyFinished(name, version, v);
            }
            finally {
                if (metadataAwareVDB.getStatus() != VDB.Status.ACTIVE && metadataAwareVDB.getStatus() != VDB.Status.FAILED) {
                    metadataAwareVDB.setStatus(VDB.Status.FAILED);
                    this.notifyFinished(name, version, v);
                }
            }
        }
    }

    protected boolean processMetadataValidatorReport(VDBKey key, ValidatorReport report) {
        return false;
    }

    void validateDataSources(VDBMetaData vdb) {
        ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            if (!model.isSource()) continue;
            Collection mappings = model.getSourceMappings();
            for (SourceMappingMetadata mapping : mappings) {
                String msg;
                ConnectorManager cm = cmr.getConnectorManager(mapping.getName());
                if (cm == null || (msg = cm.getStausMessage()) == null || msg.length() <= 0) continue;
                model.addRuntimeError(msg);
                model.setMetadataStatus(Model.MetadataStatus.FAILED);
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)msg);
            }
        }
    }

    private void notifyFinished(String name, String version, CompositeVDB v) {
        LogManager.logInfo((String)LIFECYCLE_CONTEXT, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40003, new Object[]{name, version, v.getVDB().getStatus()}));
        VDBLifeCycleListener mm = null;
        for (VDBLifeCycleListener l : this.listeners) {
            if (l instanceof MaterializationManager) {
                mm = l;
                continue;
            }
            l.finishedDeployment(name, v);
        }
        if (mm != null) {
            mm.finishedDeployment(name, v);
        }
    }

    public Collection<CompositeVDB> addListener(VDBLifeCycleListener listener) {
        this.lock.lock();
        try {
            this.listeners.add(listener);
            ArrayList<CompositeVDB> arrayList = new ArrayList<CompositeVDB>(this.vdbRepo.values());
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeListener(VDBLifeCycleListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAdd(String name, String version, CompositeVDB vdb) {
        LogManager.logInfo((String)LIFECYCLE_CONTEXT, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40118, new Object[]{name, version}));
        for (VDBLifeCycleListener l : this.listeners) {
            l.added(name, vdb);
        }
    }

    private void notifyRemove(String name, String version, CompositeVDB vdb) {
        LogManager.logInfo((String)LIFECYCLE_CONTEXT, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40119, new Object[]{name, version}));
        for (VDBLifeCycleListener l : this.listeners) {
            l.removed(name, vdb);
        }
    }

    private void notifyBeforeRemove(String name, String version, CompositeVDB vdb) {
        LogManager.logInfo((String)LIFECYCLE_CONTEXT, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40120, new Object[]{name, version}));
        for (VDBLifeCycleListener l : this.listeners) {
            l.beforeRemove(name, vdb);
        }
    }

    public SystemFunctionManager getSystemFunctionManager() {
        return this.systemFunctionManager;
    }

    public void setSystemFunctionManager(SystemFunctionManager mgr) {
        this.systemFunctionManager = mgr;
    }

    public void addPendingDeployment(VDBMetaData deployment) {
        deployment.setStatus(VDB.Status.LOADING);
        VDBKey key = new VDBKey(deployment.getName(), (Object)deployment.getVersion());
        this.pendingDeployments.put(key, deployment);
    }

    public VDBMetaData getVDB(String vdbName, Object vdbVersion) {
        VDBKey key = new VDBKey(vdbName, vdbVersion);
        CompositeVDB cvdb = (CompositeVDB)this.vdbRepo.get(key);
        if (cvdb != null) {
            return cvdb.getVDB();
        }
        return (VDBMetaData)this.pendingDeployments.get(key);
    }

    public boolean isDataRolesRequired() {
        return this.dataRolesRequired;
    }

    public void setDataRolesRequired(boolean requireDataRoles) {
        this.dataRolesRequired = requireDataRoles;
    }

    public void setBufferManager(BufferManager value) {
        this.bufferManager = value;
    }

    public void setObjectReplicator(ObjectReplicator value) {
        this.objectReplictor = value;
    }

    NavigableMap<VDBKey, CompositeVDB> getVdbRepo() {
        return this.vdbRepo;
    }

    public void setAllowEnvFunction(boolean allowEnv) {
        this.allowEnv = allowEnv;
    }
}

