/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.StringUtil;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.ContainerLifeCycleListener;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.tempdata.TempTableDataManager;
import org.teiid.runtime.NodeTracker;
import org.teiid.vdb.runtime.VDBKey;

public abstract class MaterializationManager
implements VDBLifeCycleListener,
NodeTracker.NodeListener {
    private static final int WAITTIME = 60000;
    private ContainerLifeCycleListener shutdownListener;

    public abstract ScheduledExecutorService getScheduledExecutorService();

    public abstract DQPCore getDQP();

    public abstract VDBRepository getVDBRepository();

    public MaterializationManager(ContainerLifeCycleListener shutdownListener) {
        this.shutdownListener = shutdownListener;
    }

    @Override
    public void added(String name, CompositeVDB cvdb) {
    }

    @Override
    public void beforeRemove(String name, CompositeVDB cvdb) {
        if (cvdb == null) {
            return;
        }
        final VDBMetaData vdb = cvdb.getVDB();
        Collection<Future<?>> tasks = cvdb.clearTasks();
        if (tasks != null && !tasks.isEmpty()) {
            for (Future<?> f : tasks) {
                f.cancel(true);
            }
        }
        if (!this.shutdownListener.isShutdownInProgress()) {
            this.doMaterializationActions(vdb, new MaterializationAction(){

                @Override
                public void process(Table table) {
                    if (table.getMaterializedTable() == null) {
                        return;
                    }
                    String remove = table.getProperty("{http://www.teiid.org/ext/relational/2012}ON_VDB_DROP_SCRIPT", false);
                    if (remove != null) {
                        try {
                            MaterializationManager.this.executeQuery(vdb, remove);
                        }
                        catch (SQLException e) {
                            LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
                        }
                    }
                }
            });
        }
    }

    @Override
    public void removed(String name, CompositeVDB cvdb) {
    }

    @Override
    public void finishedDeployment(String name, final CompositeVDB cvdb) {
        final VDBMetaData vdb = cvdb.getVDB();
        if (vdb.getStatus() != VDB.Status.ACTIVE) {
            return;
        }
        this.doMaterializationActions(vdb, new MaterializationAction(){

            @Override
            public void process(final Table table) {
                String stalenessString;
                if (table.getMaterializedTable() == null) {
                    long ttl;
                    String ttlStr = table.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL", false);
                    if (ttlStr != null && (ttl = Long.parseLong(ttlStr)) > 0L) {
                        ScheduledFuture<?> f = MaterializationManager.this.getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

                            @Override
                            public void run() {
                                boolean invalidate = TempTableDataManager.shouldInvalidate((VDBMetaData)vdb);
                                try {
                                    MaterializationManager.this.executeAsynchQuery(vdb, "call SYSADMIN.refreshMatView('" + table.getFullName().replaceAll("'", "''") + "', " + invalidate + ")");
                                }
                                catch (SQLException e) {
                                    LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
                                }
                            }
                        }, 0L, ttl, TimeUnit.MILLISECONDS);
                        cvdb.addTask(f);
                        return;
                    }
                    try {
                        MaterializationManager.this.executeAsynchQuery(vdb, "select count(*) from " + table.getSQLString());
                    }
                    catch (SQLException e) {
                        LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
                    }
                    return;
                }
                String nodeName = System.getProperty("jboss.node.name");
                MaterializationManager.this.resetPendingJob(vdb, table, nodeName);
                String start = table.getProperty("{http://www.teiid.org/ext/relational/2012}ON_VDB_START_SCRIPT", false);
                if (start != null) {
                    try {
                        MaterializationManager.this.executeQuery(vdb, start);
                    }
                    catch (SQLException e) {
                        LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
                    }
                }
                long ttl = 0L;
                String ttlStr = table.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL", false);
                if (ttlStr == null) {
                    ttlStr = String.valueOf(Long.MAX_VALUE);
                }
                if (ttlStr != null && (ttl = Long.parseLong(ttlStr)) > 0L) {
                    MaterializationManager.this.scheduleSnapshotJob(cvdb, table, ttl, 0L, false);
                }
                if ((stalenessString = table.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_MAX_STALENESS_PCT", false)) != null) {
                    if (ttl <= 0L) {
                        MaterializationManager.this.scheduleSnapshotJob(cvdb, table, 0L, 0L, true);
                    }
                    MaterializationManager.this.scheduleSnapshotJob(cvdb, table, 60000L, 60000L, true);
                }
            }
        });
    }

    public int resetPendingJob(VDBMetaData vdb, Table table, String nodeName) {
        try {
            String statusTable = table.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_STATUS_TABLE", false);
            String updateStatusTable = "UPDATE " + statusTable + " SET LOADSTATE='needs_loading' WHERE LOADSTATE = 'LOADING' AND NODENAME = '" + nodeName + "' AND NAME = '" + table.getName() + "'";
            List<Map<String, String>> results = this.executeQuery(vdb, updateStatusTable);
            String count = results.get(0).get("update-count");
            return Integer.parseInt(count);
        }
        catch (SQLException e) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
            return 0;
        }
    }

    private void doMaterializationActions(VDBMetaData vdb, MaterializationAction action) {
        TransformationMetadata metadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (metadata == null) {
            return;
        }
        Set imports = vdb.getImportedModels();
        CompositeMetadataStore store = metadata.getMetadataStore();
        for (Schema schema : store.getSchemaList()) {
            if (imports.contains(schema.getName())) continue;
            for (Table table : schema.getTables().values()) {
                if (!table.isVirtual() || !table.isMaterialized() || !Boolean.valueOf(table.getProperty("{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT", false)).booleanValue()) continue;
                action.process(table);
            }
        }
    }

    public void scheduleSnapshotJob(CompositeVDB vdb, Table table, long ttl, long delay, boolean oneTimeJob) {
        SnapshotJobScheduler task = new SnapshotJobScheduler(vdb, table, ttl, delay, oneTimeJob);
        this.queueTask(vdb, task, delay);
    }

    private void runJob(final CompositeVDB vdb, final Table table, final long ttl, final boolean onetimeJob) {
        String command = "execute SYSADMIN.loadMatView('" + StringUtil.replaceAll((String)((Schema)table.getParent()).getName(), (String)"'", (String)"''") + "','" + StringUtil.replaceAll((String)table.getName(), (String)"'", (String)"''") + "')";
        try {
            final AtomicInteger procReturn = new AtomicInteger();
            this.executeAsynchQuery(vdb.getVDB(), command, new DQPCore.ResultsListener(){

                public void onResults(List<String> columns, List<? extends List<?>> results) throws Exception {
                    procReturn.set((Integer)results.get(0).get(0));
                }
            }).addCompletionListener(new ResultsFuture.CompletionListener(){

                public void onCompletion(ResultsFuture future) {
                    try {
                        future.get();
                        if (!onetimeJob) {
                            if (procReturn.get() >= 0) {
                                MaterializationManager.this.scheduleSnapshotJob(vdb, table, ttl, ttl, onetimeJob);
                            } else {
                                MaterializationManager.this.scheduleSnapshotJob(vdb, table, ttl, Math.min(ttl / 4L, 60000L), onetimeJob);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException e) {
                        LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
                        MaterializationManager.this.scheduleSnapshotJob(vdb, table, ttl, Math.min(ttl / 4L, 60000L), onetimeJob);
                    }
                }
            });
        }
        catch (SQLException e) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
            this.scheduleSnapshotJob(vdb, table, ttl, Math.min(ttl / 4L, 60000L), onetimeJob);
        }
    }

    private void queueTask(CompositeVDB vdb, SnapshotJobScheduler task, long delay) {
        ScheduledFuture<?> sf = this.getScheduledExecutorService().schedule(task, delay < 0L ? 0L : delay, TimeUnit.MILLISECONDS);
        task.attachScheduledFuture(sf);
    }

    public ResultsFuture<?> executeAsynchQuery(VDBMetaData vdb, String command) throws SQLException {
        try {
            return DQPCore.executeQuery((Object)command, (VDBMetaData)vdb, (String)"embedded-async", (String)"internal", (long)-1L, (DQPCore)this.getDQP(), (DQPCore.ResultsListener)new DQPCore.ResultsListener(){

                public void onResults(List<String> columns, List<? extends List<?>> results) throws Exception {
                }
            });
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    public ResultsFuture<?> executeAsynchQuery(VDBMetaData vdb, String command, DQPCore.ResultsListener listener) throws SQLException {
        try {
            return DQPCore.executeQuery((Object)command, (VDBMetaData)vdb, (String)"embedded-async", (String)"internal", (long)-1L, (DQPCore)this.getDQP(), (DQPCore.ResultsListener)listener);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    public List<Map<String, String>> executeQuery(VDBMetaData vdb, String command) throws SQLException {
        final ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        try {
            ResultsFuture f = DQPCore.executeQuery((Object)command, (VDBMetaData)vdb, (String)"embedded-async", (String)"internal", (long)-1L, (DQPCore)this.getDQP(), (DQPCore.ResultsListener)new DQPCore.ResultsListener(){

                public void onResults(List<String> columns, List<? extends List<?>> results) throws Exception {
                    for (List<?> row : results) {
                        TreeMap<String, String> rowResult = new TreeMap<String, String>();
                        for (int colNum = 0; colNum < columns.size(); ++colNum) {
                            Object value = row.get(colNum);
                            if (value != null && value instanceof Timestamp) {
                                value = ((Timestamp)value).getTime();
                            }
                            rowResult.put(columns.get(colNum), value == null ? null : value.toString());
                        }
                        rows.add(rowResult);
                    }
                }
            });
            f.get();
        }
        catch (InterruptedException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                throw new SQLException(e.getCause());
            }
            throw new SQLException(e);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
        return rows;
    }

    @Override
    public void nodeJoined(String nodeName) {
    }

    @Override
    public void nodeDropped(String nodeName) {
        for (VDBMetaData vdb : this.getVDBRepository().getVDBs()) {
            TransformationMetadata metadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
            if (metadata == null) continue;
            for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                if (vdb.getImportedModels().contains(model.getName())) continue;
                CompositeMetadataStore store = metadata.getMetadataStore();
                Schema schema = store.getSchema(model.getName());
                for (Table t : schema.getTables().values()) {
                    long ttl;
                    int update;
                    String allow;
                    if (!t.isVirtual() || !t.isMaterialized() || t.getMaterializedTable() == null || (allow = t.getProperty("{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT", false)) == null || !Boolean.valueOf(allow).booleanValue() || (update = this.resetPendingJob(vdb, t, nodeName)) <= 0) continue;
                    String ttlStr = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL", false);
                    if (ttlStr == null) {
                        ttlStr = String.valueOf(Long.MAX_VALUE);
                    }
                    if (ttlStr == null || (ttl = Long.parseLong(ttlStr)) <= 0L) continue;
                    CompositeVDB cvdb = this.getVDBRepository().getCompositeVDB(new VDBKey(vdb.getName(), (Object)vdb.getVersion()));
                    this.scheduleSnapshotJob(cvdb, t, ttl, 0L, true);
                }
            }
        }
    }

    class SnapshotJobScheduler
    implements MaterializationTask {
        protected Table table;
        protected long ttl;
        protected long delay;
        protected CompositeVDB vdb;
        protected ScheduledFuture<?> future;
        protected boolean oneTimeJob;

        public SnapshotJobScheduler(CompositeVDB vdb, Table table, long ttl, long delay, boolean oneTimeJob) {
            this.vdb = vdb;
            this.table = table;
            this.ttl = ttl;
            this.delay = delay;
            this.oneTimeJob = oneTimeJob;
        }

        @Override
        public void attachScheduledFuture(ScheduledFuture<?> sf) {
            this.vdb.addTask(sf);
            this.future = sf;
        }

        @Override
        public void removeScheduledFuture() {
            this.vdb.removeTask(this.future);
            this.future = null;
        }

        @Override
        public void run() {
            Map<String, String> row;
            this.removeScheduledFuture();
            String query = "execute SYSADMIN.matViewStatus('" + StringUtil.replaceAll((String)((Schema)this.table.getParent()).getName(), (String)"'", (String)"''") + "', '" + StringUtil.replaceAll((String)this.table.getName(), (String)"'", (String)"''") + "')";
            if (this.vdb.getVDB().getStatus() != VDB.Status.ACTIVE) {
                return;
            }
            if (!this.vdb.getVDB().isValid()) {
                MaterializationManager.this.scheduleSnapshotJob(this.vdb, this.table, this.ttl, Math.min(this.ttl / 4L, 60000L), this.oneTimeJob);
                return;
            }
            List<Map<String, String>> result = null;
            try {
                result = MaterializationManager.this.executeQuery(this.vdb.getVDB(), query);
            }
            catch (SQLException e) {
                LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
                MaterializationManager.this.scheduleSnapshotJob(this.vdb, this.table, this.ttl, Math.min(this.ttl / 4L, 60000L), this.oneTimeJob);
                return;
            }
            long updated = 0L;
            this.delay = this.ttl;
            String loadstate = null;
            boolean valid = false;
            if (result != null && !result.isEmpty() && (row = result.get(0)) != null) {
                loadstate = row.get("LoadState");
                updated = Long.parseLong(row.get("Updated"));
                valid = Boolean.parseBoolean(row.get("Valid"));
            }
            long elapsed = System.currentTimeMillis() - updated;
            long next = this.ttl;
            if (loadstate == null || loadstate.equalsIgnoreCase("needs_loading") || !valid) {
                MaterializationManager.this.runJob(this.vdb, this.table, this.ttl, this.oneTimeJob);
                return;
            }
            if (loadstate.equalsIgnoreCase("loading")) {
                next = this.ttl - elapsed;
                if (elapsed >= this.ttl) {
                    next = Math.min(this.ttl / 4L, 60000L);
                }
            } else if (loadstate.equalsIgnoreCase("loaded")) {
                if (elapsed >= this.ttl) {
                    MaterializationManager.this.runJob(this.vdb, this.table, this.ttl, this.oneTimeJob);
                    return;
                }
                next = this.ttl - elapsed;
            } else if (loadstate.equalsIgnoreCase("failed_load")) {
                if (elapsed > this.ttl / 4L || elapsed > 60000L) {
                    MaterializationManager.this.runJob(this.vdb, this.table, this.ttl, this.oneTimeJob);
                    return;
                }
                next = Math.min(this.ttl / 4L - elapsed, 60000L - elapsed);
            }
            MaterializationManager.this.scheduleSnapshotJob(this.vdb, this.table, this.ttl, next, this.oneTimeJob);
        }
    }

    static interface MaterializationTask
    extends Runnable {
        public void attachScheduledFuture(ScheduledFuture<?> var1);

        public void removeScheduledFuture();
    }

    private static interface MaterializationAction {
        public void process(Table var1);
    }
}

