/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.HardCodedExecutionFactory;
import org.teiid.translator.BaseDelegatingExecutionFactory;
import org.teiid.translator.ExecutionFactory;

public class TestEmbeddedServerCaching {
    EmbeddedServer es;

    @Before
    public void setup() {
        this.es = new EmbeddedServer();
    }

    @After
    public void teardown() {
        if (this.es != null) {
            this.es.stop();
        }
    }

    @Test
    public void testDelegatingCaching() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        HardCodedExecutionFactory hcef = new HardCodedExecutionFactory();
        hcef.addData("SELECT pm1.g1.e1 FROM pm1.g1", Arrays.asList(Arrays.asList("a")));
        this.es.addTranslator("hc1", (ExecutionFactory)hcef);
        this.es.addTranslator(BaseDelegatingExecutionFactory.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("delegateName", "hc1");
        properties.put("cachePattern", ".*");
        properties.put("cacheTtl", "5000");
        this.es.addTranslator("x", "delegator", properties);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("my-schema");
        mmd.addSourceMapping("x", "x", null);
        mmd.addSourceMetadata("ddl", "create foreign table \"pm1.g1\" (e1 string)");
        this.es.deployVDB("test", new ModelMetaData[]{mmd});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        Statement s = c.createStatement();
        s.executeQuery("select * from pm1.g1");
        s.executeQuery("select * from pm1.g1");
        Assert.assertEquals((long)1L, (long)hcef.getCommands().size());
    }
}

