/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import org.teiid.adminapi.Admin;
import org.teiid.adminapi.impl.EngineStatisticsMetadata;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.runtime.EmbeddedAdminImpl;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.services.BufferServiceImpl;

public class EmbeddedAdminFactory {
    private static EmbeddedAdminFactory INSTANCE = new EmbeddedAdminFactory();

    public static EmbeddedAdminFactory getInstance() {
        return INSTANCE;
    }

    public static EngineStatisticsMetadata createEngineStats(int activeSessionsCount, BufferServiceImpl bufferService, DQPCore dqp) {
        EngineStatisticsMetadata stats = new EngineStatisticsMetadata();
        stats.setSessionCount(activeSessionsCount);
        stats.setTotalMemoryUsedInKB(bufferService.getHeapCacheMemoryInUseKB());
        stats.setMemoryUsedByActivePlansInKB(bufferService.getHeapMemoryInUseByActivePlansKB());
        stats.setDiskWriteCount(bufferService.getDiskWriteCount());
        stats.setDiskReadCount(bufferService.getDiskReadCount());
        stats.setCacheReadCount(bufferService.getCacheReadCount());
        stats.setCacheWriteCount(bufferService.getCacheWriteCount());
        stats.setDiskSpaceUsedInMB(bufferService.getUsedDiskBufferSpaceMB());
        stats.setActivePlanCount(dqp.getActivePlanCount());
        stats.setWaitPlanCount(dqp.getWaitingPlanCount());
        stats.setMaxWaitPlanWaterMark(dqp.getMaxWaitingPlanWatermark());
        return stats;
    }

    public Admin createAdmin(EmbeddedServer embeddedServer) {
        return new EmbeddedAdminImpl(embeddedServer);
    }
}

