/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odbc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ietf.jgss.GSSCredential;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.RequestMessage;
import org.teiid.client.security.LogonException;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.dqp.service.SessionService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.odbc.ODBCClientRemote;
import org.teiid.odbc.ODBCServerRemote;
import org.teiid.odbc.PGUtil;
import org.teiid.odbc.ScriptReader;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.security.GSSResult;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.ODBCClientInstance;
import org.teiid.transport.PgBackendProtocol;
import org.teiid.transport.PgFrontendProtocol;
import org.teiid.transport.pg.TimestampUtils;

public class ODBCServerRemoteImpl
implements ODBCServerRemote {
    private static final boolean HONOR_DECLARE_FETCH_TXN = (Boolean)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.honorDeclareFetchTxn", (Object)false, Boolean.class);
    public static final String CONNECTION_PROPERTY_PREFIX = "connection.";
    private static final String UNNAMED = "";
    private static Pattern setPattern = Pattern.compile("set\\s+(\\w+)\\s+to\\s+((?:'[^']*')+)", 34);
    private static Pattern columnMetadataPattern = Pattern.compile("select n.nspname, c.relname, a.attname, a.atttypid, t.typname, a.attnum, a.attlen, a.atttypmod, a.attnotnull, c.relhasrules, c.relkind, c.oid, pg_get_expr\\(d.adbin, d.adrelid\\), case t.typtype when 'd' then t.typbasetype else 0 end, t.typtypmod, c.relhasoids from \\(\\(\\(pg_catalog.pg_class c inner join pg_catalog.pg_namespace n on n.oid = c.relnamespace and c.oid = (\\d+)\\) inner join pg_catalog.pg_attribute a on \\(not a.attisdropped\\) and a.attnum > 0 and a.attrelid = c.oid\\) inner join pg_catalog.pg_type t on t.oid = a.atttypid\\) left outer join pg_attrdef d on a.atthasdef and d.adrelid = a.attrelid and d.adnum = a.attnum order by n.nspname, c.relname, attnum");
    private static Pattern pkPattern = Pattern.compile("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.relname = (E?(?:'[^']*')+) AND n.nspname = (E?(?:'[^']*')+).*", 34);
    private static Pattern pkKeyPattern = Pattern.compile("select ta.attname, ia.attnum, ic.relname, n.nspname, NULL from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class ic, pg_catalog.pg_index i, pg_catalog.pg_namespace n where ic.relname = (E?(?:'[^']*')+) AND n.nspname = (E?(?:'[^']*')+) .*", 34);
    private Pattern fkPattern = Pattern.compile("select\\s+((?:'[^']*')+)::name as PKTABLE_CAT,\\s+n2.nspname as PKTABLE_SCHEM,\\s+c2.relname as PKTABLE_NAME,\\s+a2.attname as PKCOLUMN_NAME,\\s+((?:'[^']*')+)::name as FKTABLE_CAT,\\s+n1.nspname as FKTABLE_SCHEM,\\s+c1.relname as FKTABLE_NAME,\\s+a1.attname as FKCOLUMN_NAME,\\s+i::int2 as KEY_SEQ,\\s+case ref.confupdtype\\s+when 'c' then (\\d)::int2\\s+when 'n' then (\\d)::int2\\s+when 'd' then (\\d)::int2\\s+when 'r' then (\\d)::int2\\s+else 3::int2\\s+end as UPDATE_RULE,\\s+case ref.confdeltype\\s+when 'c' then (\\d)::int2\\s+when 'n' then (\\d)::int2\\s+when 'd' then (\\d)::int2\\s+when 'r' then (\\d)::int2\\s+else 3::int2\\s+end as DELETE_RULE,\\s+ref.conname as FK_NAME,\\s+cn.conname as PK_NAME,\\s+case\\s+when ref.condeferrable then\\s+case\\s+when ref.condeferred then (\\d)::int2\\s+else (\\d)::int2\\s+end\\s+else (\\d)::int2\\s+end as DEFERRABLITY\\s+from\\s+\\(\\(\\(\\(\\(\\(\\( \\(select cn.oid, conrelid, conkey, confrelid, confkey,\\s+generate_series\\(array_lower\\(conkey, 1\\), array_upper\\(conkey, 1\\)\\) as i,\\s+confupdtype, confdeltype, conname,\\s+condeferrable, condeferred\\s+from pg_catalog.pg_constraint cn,\\s+pg_catalog.pg_class c,\\s+pg_catalog.pg_namespace n\\s+where contype = 'f'\\s+and\\s+con(f?)relid = c.oid\\s+and\\s+relname = (E?(?:'[^']*')+)\\s+and\\s+n.oid = c.relnamespace\\s+and\\s+n.nspname = (E?(?:'[^']*')+)\\s+\\) ref\\s+inner join pg_catalog.pg_class c1\\s+on c1.oid = ref.conrelid\\)\\s+inner join pg_catalog.pg_namespace n1\\s+on\\s+n1.oid = c1.relnamespace\\)\\s+inner join pg_catalog.pg_attribute a1\\s+on\\s+a1.attrelid = c1.oid\\s+and\\s+a1.attnum = conkey\\[i\\]\\)\\s+inner join pg_catalog.pg_class c2\\s+on\\s+c2.oid = ref.confrelid\\)\\s+inner join pg_catalog.pg_namespace n2\\s+on\\s+n2.oid = c2.relnamespace\\)\\s+inner join pg_catalog.pg_attribute a2\\s+on\\s+a2.attrelid = c2.oid\\s+and\\s+a2.attnum = confkey\\[i\\]\\)\\s+left outer join pg_catalog.pg_constraint cn\\s+on cn.conrelid = ref.confrelid\\s+and cn.contype = 'p'\\)\\s+order by ref.oid, ref.i", 34);
    public static final String TYPE_QUERY = "SELECT typinput='array_in'::regproc, typtype   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = $1  ORDER BY sp.r, pg_type.oid DESC LIMIT 1";
    private static final String PK_QUERY = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM,   ct.relname AS TABLE_NAME, a.attname AS COLUMN_NAME,   (i.keys).n AS KEY_SEQ, ci.relname AS PK_NAME FROM pg_catalog.pg_class ct   JOIN pg_catalog.pg_attribute a ON (ct.oid = a.attrelid)   JOIN pg_catalog.pg_namespace n ON (ct.relnamespace = n.oid)   JOIN (SELECT i.indexrelid, i.indrelid, i.indisprimary,              information_schema._pg_expandarray(i.indkey) AS keys         FROM pg_catalog.pg_index i) i     ON (a.attnum = (i.keys).x AND a.attrelid = i.indrelid)   JOIN pg_catalog.pg_class ci ON (ci.oid = i.indexrelid) WHERE true";
    private static final String PK_REPLACEMENT_QUERY = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ct.relname AS TABLE_NAME, a.attname AS COLUMN_NAME, a.attnum AS KEY_SEQ, ci.relname AS PK_NAME\nFROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i \nWHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid AND a.attrelid=ci.oid AND ct.relnamespace = n.oid ";
    private static Pattern cursorSelectPattern = Pattern.compile("DECLARE\\s+(\\S+)(\\s+BINARY)?(?:\\s+INSENSITIVE)?(\\s+(NO\\s+)?SCROLL)?\\s+CURSOR\\s+(?:WITH(?:OUT)? HOLD\\s+)?FOR\\s+(.*)", 34);
    private static Pattern fetchPattern = Pattern.compile("FETCH(?:(?:\\s+(FORWARD|ABSOLUTE|RELATIVE))?\\s+(\\d+)\\s+(?:IN|FROM))?\\s+(\\S+)\\s*", 34);
    private static Pattern fetchFirstLastPattern = Pattern.compile("FETCH\\s+(FIRST|LAST)\\s+(?:IN|FROM)\\s+(\\S+)\\s*", 34);
    private static Pattern movePattern = Pattern.compile("MOVE(?:\\s+(FORWARD|BACKWARD))?\\s+(\\d+)\\s+(?:IN|FROM)\\s+(\\S+)\\s*", 34);
    private static Pattern closePattern = Pattern.compile("CLOSE (\\S+)", 34);
    private static Pattern deallocatePattern = Pattern.compile("DEALLOCATE(?:\\s+PREPARE)?\\s+(.*)", 34);
    private static Pattern releasePattern = Pattern.compile("RELEASE\\s+(\\w+\\d?_*)", 34);
    private static Pattern savepointPattern = Pattern.compile("SAVEPOINT\\s+(\\w+\\d?_*)", 34);
    private static Pattern rollbackPattern = Pattern.compile("ROLLBACK(\\s+to)?\\s+(\\w+\\d+_*)", 34);
    private static Pattern txnPattern = Pattern.compile("(BEGIN(?:\\s+READ\\s+ONLY)?|COMMIT|ROLLBACK)(\\s+(WORK|TRANSACTION))?", 34);
    private TeiidDriver driver;
    private ODBCClientRemote client;
    private Properties props;
    private ConnectionImpl connection;
    private volatile boolean executing;
    private boolean errorOccurred;
    private volatile ResultsFuture<Boolean> executionFuture;
    private Map<String, Prepared> preparedMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Portal> portalMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Cursor> cursorMap = Collections.synchronizedMap(new HashMap());
    private LogonImpl logon;
    private static final long BIT_MASK = 0xFFFFFFFFL;
    private static ConcurrentHashMap<Long, ODBCServerRemoteImpl> remotes = new ConcurrentHashMap();
    private long secretKey = (long)(Math.random() * 9.223372036854776E18);
    private volatile String executingStatement;

    public ODBCServerRemoteImpl(ODBCClientInstance client, TeiidDriver driver, LogonImpl logon) {
        this.driver = driver;
        this.client = client.getClient();
        this.logon = logon;
    }

    @Override
    public void initialize(Properties props) {
        this.props = props;
        this.client.initialized(this.props);
        String user = props.getProperty("user");
        String database = props.getProperty("database");
        AuthenticationType authType = null;
        try {
            authType = this.getAuthenticationType(user, database);
        }
        catch (LogonException e) {
            this.errorOccurred(e);
            this.terminate();
            return;
        }
        if (authType.equals((Object)AuthenticationType.USERPASSWORD)) {
            this.client.useClearTextAuthentication();
        } else if (authType.equals((Object)AuthenticationType.GSS)) {
            this.client.useAuthenticationGSS();
        } else {
            throw new AssertionError((Object)"Unsupported Authentication Type");
        }
    }

    private AuthenticationType getAuthenticationType(String user, String database) throws LogonException {
        SessionService ss = this.logon.getSessionService();
        if (ss == null) {
            return AuthenticationType.USERPASSWORD;
        }
        return ss.getAuthenticationType(database, null, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void logon(String databaseName, String user, PgFrontendProtocol.NullTerminatedStringDataInputStream data, SocketAddress remoteAddress) {
        try {
            String applicationName;
            Properties info = new Properties();
            info.put("user", user);
            AuthenticationType authType = this.getAuthenticationType(user, databaseName);
            String password = null;
            if (authType.equals((Object)AuthenticationType.USERPASSWORD)) {
                password = data.readString();
            } else {
                if (!authType.equals((Object)AuthenticationType.GSS)) throw new AssertionError((Object)"Unsupported Authentication Type");
                byte[] serviceToken = data.readServiceToken();
                GSSResult result = this.logon.neogitiateGssLogin(serviceToken, databaseName, null, user);
                serviceToken = result.getServiceToken();
                if (result.isAuthenticated()) {
                    info.put("KRB5TOKEN", serviceToken);
                    if (!result.isNullContinuationToken()) {
                        this.client.authenticationGSSContinue(serviceToken);
                    }
                    if (result.getDelegationCredential() != null) {
                        info.put(GSSCredential.class.getName(), result.getDelegationCredential());
                    }
                } else {
                    this.client.authenticationGSSContinue(serviceToken);
                    return;
                }
            }
            String url = "jdbc:teiid:" + databaseName;
            if (password != null) {
                info.put("password", password);
            }
            if ((applicationName = this.props.getProperty("application_name")) == null) {
                applicationName = "ODBC";
                this.props.put("application_name", applicationName);
            }
            info.put("ApplicationName", applicationName);
            if (remoteAddress instanceof InetSocketAddress) {
                SocketServerConnection.updateConnectionProperties((Properties)info, (InetAddress)((InetSocketAddress)remoteAddress).getAddress(), (boolean)false);
            }
            this.connection = this.driver.connect(url, info);
            SessionMetadata sm = ((LocalServerConnection)this.connection.getServerConnection()).getWorkContext().getSession();
            sm.addAttchment(ODBCServerRemoteImpl.class, (Object)this);
            ODBCServerRemoteImpl.setConnectionProperties(this.connection);
            Enumeration<?> keys = this.props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.connection.setExecutionProperty(key, this.props.getProperty(key));
            }
            try (StatementImpl s = this.connection.createStatement();){
                s.execute("select teiid_session_set('resolve_groupby_positional', true)");
            }
            this.client.authenticationSucess((int)(this.secretKey >> 32 & 0xFFFFFFFFL), (int)(this.secretKey & 0xFFFFFFFFL));
            this.ready();
            remotes.put(this.secretKey, this);
            return;
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            this.terminate();
            return;
        }
        catch (LogonException e) {
            this.errorOccurred(e);
            this.terminate();
            return;
        }
        catch (IOException e) {
            this.errorOccurred(e);
            this.terminate();
        }
    }

    @Override
    public void cancel(int pid, int key) {
        String current;
        long keyToCancel = pid;
        keyToCancel <<= 32;
        ODBCServerRemoteImpl remote = remotes.get(keyToCancel |= (long)key & 0xFFFFFFFFL);
        if (remote != null && (current = remote.executingStatement) != null) {
            try {
                remote.connection.cancelRequest(current);
            }
            catch (TeiidComponentException | TeiidProcessingException e) {
                LogManager.logDetail((String)"org.teiid.ODBC", (Object)e, (Object)"Error cancelling statement");
            }
        }
    }

    public static void setConnectionProperties(ConnectionImpl conn) throws SQLException {
        SessionMetadata sm = ((LocalServerConnection)conn.getServerConnection()).getWorkContext().getSession();
        VDBMetaData vdb = sm.getVdb();
        Properties p = vdb.getProperties();
        ODBCServerRemoteImpl.setConnectionProperties(conn, p);
    }

    public static void setConnectionProperties(ConnectionImpl conn, Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(CONNECTION_PROPERTY_PREFIX)) continue;
            conn.setExecutionProperty(key.substring(CONNECTION_PROPERTY_PREFIX.length()), (String)entry.getValue());
        }
    }

    private void cursorExecute(String cursorName, String sql, ResultsFuture<Integer> completion, boolean scroll, boolean binary) {
        try {
            short[] sArray;
            this.preparedMap.remove(UNNAMED);
            Portal p = this.portalMap.remove(UNNAMED);
            if (p != null) {
                this.closePortal(p);
            }
            if (cursorName == null || cursorName.length() == 0) {
                cursorName = UNNAMED;
            }
            PreparedStatementImpl stmt = this.connection.prepareStatement(sql, scroll ? 1004 : 1003, 1007);
            if (binary) {
                short[] sArray2 = new short[1];
                sArray = sArray2;
                sArray2[0] = 1;
            } else {
                sArray = null;
            }
            this.internalCursorExecute(completion, cursorName, null, stmt, sql, sArray, null);
        }
        catch (SQLException e) {
            completion.getResultsReceiver().exceptionOccurred((Throwable)e);
        }
    }

    private void internalCursorExecute(final ResultsFuture<Integer> completion, final String cursorName, final String portalName, final PreparedStatementImpl stmt, final String sql, final short[] resultColumnFormat, final List<PGUtil.PgColInfo> cols) throws SQLException {
        Cursor cursor = this.cursorMap.get(cursorName);
        if (cursor != null) {
            this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40111, new Object[]{cursorName}));
            return;
        }
        this.executionFuture = stmt.submitExecute(RequestMessage.ResultsMode.RESULTSET, null);
        this.executingStatement = stmt.getRequestIdentifier();
        this.executionFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

            public void onCompletion(ResultsFuture<Boolean> future) {
                ODBCServerRemoteImpl.this.executionFuture = null;
                try {
                    if (((Boolean)future.get()).booleanValue()) {
                        ODBCServerRemoteImpl.this.cursorMap.put(cursorName, new Cursor(cursorName, sql, stmt, stmt.getResultSet(), cols == null ? ODBCServerRemoteImpl.this.getPgColInfo(stmt.getResultSet().getMetaData()) : cols, resultColumnFormat));
                        if (portalName != null) {
                            ODBCServerRemoteImpl.this.portalMap.remove(portalName);
                        }
                        ODBCServerRemoteImpl.this.client.sendCommandComplete("DECLARE CURSOR", null);
                        completion.getResultsReceiver().receiveResults((Object)0);
                    }
                }
                catch (Throwable e) {
                    completion.getResultsReceiver().exceptionOccurred(e);
                }
            }
        });
    }

    private void cursorFetch(String cursorName, ODBCClientRemote.CursorDirection direction, int rows, ResultsFuture<Integer> completion) throws SQLException {
        Cursor cursor = this.cursorMap.get(cursorName);
        if (cursor == null) {
            throw new SQLException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40078, new Object[]{cursorName}));
        }
        if (rows < 1) {
            throw new SQLException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40112, new Object[]{cursorName, rows}));
        }
        this.client.sendResults("FETCH", cursor.rs, cursor.prepared.columnMetadata, completion, direction, rows, true, cursor.resultColumnFormat);
    }

    private void cursorMove(String prepareName, String direction, final int rows, final ResultsFuture<Integer> completion) throws SQLException {
        if (rows == 0) {
            this.client.sendCommandComplete("MOVE", 0);
            completion.getResultsReceiver().receiveResults((Object)0);
            return;
        }
        final Cursor cursor = this.cursorMap.get(prepareName);
        if (cursor == null) {
            throw new SQLException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40078, new Object[]{prepareName}));
        }
        final boolean forward = direction == null || direction.equalsIgnoreCase("forward");
        Runnable r = new Runnable(){

            @Override
            public void run() {
                this.run(null, 0);
            }

            public void run(ResultsFuture<Boolean> next, int i) {
                while (i < rows) {
                    try {
                        if (next == null) {
                            next = forward ? cursor.rs.submitNext() : StatementImpl.booleanFuture((boolean)cursor.rs.previous());
                        }
                        if (!next.isDone()) {
                            final int current = i;
                            next.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

                                public void onCompletion(ResultsFuture<Boolean> future) {
                                    this.run(future, current);
                                }
                            });
                            return;
                        }
                        if (!((Boolean)next.get()).booleanValue()) break;
                        next = null;
                    }
                    catch (Throwable e) {
                        completion.getResultsReceiver().exceptionOccurred(e);
                        return;
                    }
                    ++i;
                }
                if (!completion.isDone()) {
                    ODBCServerRemoteImpl.this.client.sendCommandComplete("MOVE", i);
                    completion.getResultsReceiver().receiveResults((Object)i);
                }
            }
        };
        r.run();
    }

    private void cursorClose(String prepareName) throws SQLException {
        Cursor cursor = this.cursorMap.remove(prepareName);
        if (cursor != null) {
            this.closePortal(cursor);
            this.client.sendCommandComplete("CLOSE CURSOR", null);
        }
    }

    private void sqlExecute(final String sql, final ResultsFuture<Integer> completion) throws SQLException {
        String modfiedSQL = this.fixSQL(sql);
        final boolean autoCommit = this.connection.getAutoCommit();
        final StatementImpl stmt = this.connection.createStatement();
        this.executionFuture = stmt.submitExecute(modfiedSQL, null);
        this.executingStatement = stmt.getRequestIdentifier();
        completion.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

            public void onCompletion(ResultsFuture<Integer> future) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LogManager.logDetail((String)"org.teiid.ODBC", (Object)e, (Object)"Error closing statement");
                }
            }
        });
        this.executionFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

            public void onCompletion(ResultsFuture<Boolean> future) {
                block5: {
                    ODBCServerRemoteImpl.this.executionFuture = null;
                    try {
                        if (((Boolean)future.get()).booleanValue()) {
                            List cols = ODBCServerRemoteImpl.this.getPgColInfo(stmt.getResultSet().getMetaData());
                            String tag = PgBackendProtocol.getCompletionTag(sql, null);
                            ODBCServerRemoteImpl.this.client.sendResults(sql, stmt.getResultSet(), cols, (ResultsFuture<Integer>)completion, ODBCClientRemote.CursorDirection.FORWARD, -1, tag.equals("SELECT") || tag.equals("SHOW"), null);
                        } else {
                            if (autoCommit ^ ODBCServerRemoteImpl.this.connection.getAutoCommit()) {
                                ODBCServerRemoteImpl.this.closePortals();
                            }
                            ODBCServerRemoteImpl.this.client.sendUpdateCount(sql, stmt.getUpdateCount());
                            ODBCServerRemoteImpl.this.updateSessionProperties();
                            completion.getResultsReceiver().receiveResults((Object)1);
                        }
                    }
                    catch (Throwable e) {
                        if (completion.isDone()) break block5;
                        completion.getResultsReceiver().exceptionOccurred(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String prepareName, String sql, int[] paramType) {
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if (sql != null) {
            PreparedStatementImpl stmt = null;
            try {
                if (prepareName.equals(UNNAMED)) {
                    this.preparedMap.remove(prepareName);
                } else {
                    Prepared previous = this.preparedMap.get(prepareName);
                    if (previous != null) {
                        this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40110, new Object[]{prepareName}));
                        return;
                    }
                }
                String modfiedSQL = this.fixSQL(sql);
                Matcher m = null;
                String cursorName = null;
                boolean scroll = false;
                m = cursorSelectPattern.matcher(modfiedSQL);
                if (m.matches()) {
                    modfiedSQL = this.fixSQL(m.group(5));
                    cursorName = ODBCServerRemoteImpl.normalizeName(m.group(1));
                    scroll = m.group(3) != null && m.group(4) == null;
                }
                stmt = this.connection.prepareStatement(modfiedSQL, scroll ? 1004 : 1003, 1007);
                Prepared prepared = new Prepared(prepareName, sql, modfiedSQL, paramType, this.getPgColInfo(stmt.getMetaData()), cursorName);
                this.preparedMap.put(prepareName, prepared);
                this.client.prepareCompleted(prepareName);
            }
            catch (SQLException e) {
                if (e.getCause() instanceof TeiidProcessingException) {
                    LogManager.logWarning((String)"org.teiid.ODBC", (Throwable)e.getCause(), (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40020, new Object[0]));
                }
                this.errorOccurred(e);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private long readLong(byte[] bytes, int length) {
        long val = 0L;
        for (int k = 0; k < length; ++k) {
            val += (long)((bytes[k] & 0xFF) << (length - k - 1) * 8);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindParameters(String bindName, String prepareName, Object[] params, int resultCodeCount, short[] resultColumnFormat, Charset encoding) {
        Prepared prepared;
        if (bindName == null || bindName.length() == 0) {
            Portal p = this.portalMap.remove(UNNAMED);
            if (p != null) {
                this.closePortal(p);
            }
            bindName = UNNAMED;
        } else if (this.portalMap.get(bindName) != null || this.cursorMap.get(bindName) != null) {
            this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40111, new Object[]{bindName}));
            return;
        }
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if ((prepared = this.preparedMap.get(prepareName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40077, new Object[]{prepareName}));
            return;
        }
        PreparedStatementImpl stmt = null;
        try {
            stmt = this.connection.prepareStatement(prepared.modifiedSql);
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                if (param instanceof byte[] && prepared.paramType.length > i) {
                    int oid = prepared.paramType[i];
                    switch (oid) {
                        case 0: {
                            break;
                        }
                        case 17: {
                            break;
                        }
                        case 21: {
                            param = (short)this.readLong((byte[])param, 2);
                            break;
                        }
                        case 23: {
                            param = (int)this.readLong((byte[])param, 4);
                            break;
                        }
                        case 20: {
                            param = this.readLong((byte[])param, 8);
                            break;
                        }
                        case 700: {
                            param = Float.valueOf(Float.intBitsToFloat((int)this.readLong((byte[])param, 4)));
                            break;
                        }
                        case 701: {
                            param = Double.longBitsToDouble(this.readLong((byte[])param, 8));
                            break;
                        }
                        case 1082: {
                            param = TimestampUtils.toDate(TimestampWithTimezone.getCalendar().getTimeZone(), (int)this.readLong((byte[])param, 4));
                            break;
                        }
                        default: {
                            param = new String((byte[])param, encoding);
                        }
                    }
                }
                stmt.setObject(i + 1, param);
            }
            this.portalMap.put(bindName, new Portal(bindName, prepared, resultColumnFormat, stmt));
            this.client.bindComplete();
            stmt = null;
        }
        catch (SQLException e) {
            this.errorOccurred(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void unsupportedOperation(String msg) {
        this.errorOccurred(msg);
    }

    @Override
    public void execute(String bindName, int maxRows) {
        Cursor cursor;
        if (this.beginExecution()) {
            this.errorOccurred("Awaiting asynch result");
            return;
        }
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if (maxRows == 0) {
            maxRows = -1;
        }
        if ((cursor = this.cursorMap.get(bindName)) != null) {
            this.sendCursorResults(cursor, maxRows);
            return;
        }
        Portal query = this.portalMap.get(bindName);
        if (query == null) {
            this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40078, new Object[]{bindName}));
            return;
        }
        if (query.prepared.sql.trim().isEmpty()) {
            this.client.emptyQueryReceived();
            return;
        }
        this.sendPortalResults(maxRows, query);
    }

    private void sendPortalResults(final int maxRows, final Portal query) {
        if (query.rs != null) {
            this.sendCursorResults(query, maxRows);
            return;
        }
        final PreparedStatementImpl stmt = query.stmt;
        try {
            if (query.prepared.cursorName != null) {
                ResultsFuture results = new ResultsFuture();
                results.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

                    public void onCompletion(ResultsFuture<Integer> future) {
                        try {
                            future.get();
                            ODBCServerRemoteImpl.this.doneExecuting();
                        }
                        catch (ExecutionException e) {
                            Throwable cause;
                            for (cause = e; cause instanceof ExecutionException && cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
                            }
                            ODBCServerRemoteImpl.this.errorOccurred(cause);
                        }
                        catch (Throwable e) {
                            ODBCServerRemoteImpl.this.errorOccurred(e);
                        }
                    }
                });
                this.internalCursorExecute((ResultsFuture<Integer>)results, query.prepared.cursorName, query.name, stmt, query.prepared.sql, query.resultColumnFormat, query.prepared.columnMetadata);
                return;
            }
            this.executionFuture = stmt.submitExecute(RequestMessage.ResultsMode.EITHER, null);
            this.executingStatement = stmt.getRequestIdentifier();
            this.executionFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

                public void onCompletion(ResultsFuture<Boolean> future) {
                    ODBCServerRemoteImpl.this.executionFuture = null;
                    try {
                        if (((Boolean)future.get()).booleanValue()) {
                            query.rs = stmt.getResultSet();
                            ODBCServerRemoteImpl.this.sendCursorResults(query, maxRows);
                        } else {
                            ODBCServerRemoteImpl.this.client.sendUpdateCount(query.prepared.sql, stmt.getUpdateCount());
                            ODBCServerRemoteImpl.this.updateSessionProperties();
                            ODBCServerRemoteImpl.this.doneExecuting();
                        }
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() != null) {
                            ODBCServerRemoteImpl.this.errorOccurred(e.getCause());
                        } else {
                            ODBCServerRemoteImpl.this.errorOccurred(e);
                        }
                    }
                    catch (Throwable e) {
                        ODBCServerRemoteImpl.this.errorOccurred(e);
                    }
                }
            });
        }
        catch (SQLException e) {
            this.errorOccurred(e);
        }
    }

    private void sendCursorResults(final Portal cursor, final int fetchSize) {
        ResultsFuture result = new ResultsFuture();
        this.client.sendResults(null, cursor.rs, cursor.prepared.columnMetadata, (ResultsFuture<Integer>)result, ODBCClientRemote.CursorDirection.FORWARD, fetchSize, false, cursor.resultColumnFormat);
        result.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

            public void onCompletion(ResultsFuture<Integer> future) {
                try {
                    int rowsSent = (Integer)future.get();
                    if (rowsSent < fetchSize || fetchSize <= 0) {
                        ODBCServerRemoteImpl.this.client.sendCommandComplete(cursor.prepared.sql, rowsSent);
                    } else {
                        ODBCServerRemoteImpl.this.client.sendPortalSuspended();
                    }
                    ODBCServerRemoteImpl.this.doneExecuting();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                catch (ExecutionException e) {
                    ODBCServerRemoteImpl.this.errorOccurred(e.getCause());
                }
            }
        });
    }

    private String fixSQL(String sql) {
        String modified = this.modifySQL(sql);
        if (modified != null && !modified.equals(sql)) {
            LogManager.logDetail((String)"org.teiid.ODBC", (Object)"Modified Query:", (Object)modified);
        }
        return modified;
    }

    private String modifySQL(String sql) {
        String modified = sql;
        if (sql == null) {
            return null;
        }
        Matcher m = null;
        if (StringUtil.startsWithIgnoreCase((String)sql, (String)"select")) {
            m = pkPattern.matcher(modified);
            if (m.matches()) {
                return new StringBuffer("SELECT k.Name AS attname, convert(Position, short) AS attnum, TableName AS relname, SchemaName AS nspname, TableName AS relname").append(" FROM SYS.KeyColumns k").append(" WHERE ").append(" UCASE(SchemaName)").append(" LIKE UCASE(").append(m.group(2)).append(")").append(" AND UCASE(TableName)").append(" LIKE UCASE(").append(m.group(1)).append(")").append(" AND KeyType LIKE 'Primary'").append(" ORDER BY attnum").toString();
            }
            m = pkKeyPattern.matcher(modified);
            if (m.matches()) {
                String tableName = m.group(1);
                if (tableName.endsWith("_pkey'")) {
                    tableName = tableName.substring(0, tableName.length() - 6) + '\'';
                    return "select ia.attname, ia.attnum, ic.relname, n.nspname, NULL from pg_catalog.pg_attribute ia, pg_catalog.pg_class ic, pg_catalog.pg_namespace n, Sys.KeyColumns kc where ic.relname = " + tableName + " AND n.nspname = " + m.group(2) + " AND n.oid = ic.relnamespace AND ia.attrelid = ic.oid AND kc.SchemaName = n.nspname AND kc.TableName = ic.relname AND kc.KeyType = 'Primary' AND kc.Name = ia.attname order by ia.attnum";
                }
                return "SELECT NULL, NULL, NULL, NULL, NULL FROM (SELECT 1) as X WHERE 0=1";
            }
            m = this.fkPattern.matcher(modified);
            if (m.matches()) {
                String baseQuery = "SELECT PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYS.ReferenceKeyColumns WHERE  ";
                if ("f".equals(m.group(14))) {
                    return baseQuery + "PKTABLE_NAME = " + m.group(15) + " and PKTABLE_SCHEM = " + m.group(16);
                }
                return baseQuery + "FKTABLE_NAME = " + m.group(15) + " and FKTABLE_SCHEM = " + m.group(16);
            }
            if (modified.startsWith("SELECT name FROM master..sysdatabases")) {
                return "SELECT 'Teiid'";
            }
            if (modified.equalsIgnoreCase("select db_name() dbname")) {
                return "SELECT current_database()";
            }
            if (sql.equalsIgnoreCase("select current_schema()")) {
                return "SELECT ''";
            }
            if (sql.equals("SELECT typinput='array_in'::regproc, typtype FROM pg_catalog.pg_type WHERE typname = $1")) {
                return "SELECT substring(typname,1,1) = '_', typtype FROM pg_catalog.pg_type WHERE typname = ?";
            }
            m = columnMetadataPattern.matcher(modified);
            if (m.matches()) {
                return "select t1.schemaname as nspname, c.relname, t1.name as attname, t.oid as attypid, t.typname, convert(t1.Position, short) as attnum, t.typlen as attlen,(CASE WHEN (t1.DataType = 'bigdecimal' OR t1.DataType = 'biginteger') THEN 4+(65536*(case when (t1.Precision>32767) then 32767 else t1.Precision end)+(case when (t1.Scale>32767) then 32767 else t1.Scale end)) WHEN (t1.DataType = 'string' OR t1.DataType = 'char') THEN (CASE WHEN (t1.Length <= 2147483643) THEN 4+ t1.Length ELSE 2147483647 END) ELSE -1 END) as atttypmod, CASE WHEN (t1.NullType = 'No Nulls') THEN true ELSE false END as attnotnull, c.relhasrules, c.relkind, c.oid, pg_get_expr(case when t1.IsAutoIncremented then 'nextval(' else t1.DefaultValue end, c.oid),  case t.typtype when 'd' then t.typbasetype else 0 end, t.typtypmod, c.relhasoids from sys.columns as t1, pg_catalog.matpg_datatype as t, pg_catalog.pg_class c where c.relnspname=t1.schemaname and c.relname=t1.tablename and t1.DataType = t.Name and c.oid = " + m.group(1) + " order by nspname, relname, attnum";
            }
            if (modified.equals(TYPE_QUERY)) {
                return "select typname like '\\_%' escape '\\', typname from pg_catalog.pg_type where typname = $1";
            }
            if (modified.startsWith(PK_QUERY)) {
                return PK_REPLACEMENT_QUERY + modified.substring(PK_QUERY.length());
            }
        } else {
            if (sql.equalsIgnoreCase("show max_identifier_length")) {
                return "select 63";
            }
            m = setPattern.matcher(sql);
            if (m.matches()) {
                return "SET " + m.group(1) + " " + m.group(2);
            }
            m = txnPattern.matcher(sql);
            if (m.matches()) {
                if (StringUtil.startsWithIgnoreCase((String)m.group(1), (String)"BEGIN")) {
                    return "START TRANSACTION";
                }
                return m.group(1);
            }
            m = rollbackPattern.matcher(modified);
            if (m.matches()) {
                return "set \"dummy-update-pg-odbc\" 0";
            }
            m = savepointPattern.matcher(sql);
            if (m.matches()) {
                return "set \"dummy-update-pg-odbc\" 0";
            }
            m = releasePattern.matcher(sql);
            if (m.matches()) {
                return "set \"dummy-update-pg-odbc\" 0";
            }
        }
        for (int i = 0; i < modified.length(); ++i) {
            switch (modified.charAt(i)) {
                case '$': 
                case '(': 
                case ':': 
                case '~': {
                    ScriptReader reader = new ScriptReader(modified);
                    reader.setRewrite(true);
                    try {
                        return reader.readStatement();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return modified;
    }

    @Override
    public void executeQuery(String query) {
        if (this.beginExecution()) {
            this.errorOccurred("Awaiting asynch result");
            this.ready();
            return;
        }
        Portal p = this.portalMap.remove(UNNAMED);
        if (p != null) {
            this.closePortal(p);
        }
        this.preparedMap.remove(UNNAMED);
        query = query.trim();
        if (query.length() == 0) {
            this.client.emptyQueryReceived();
            this.ready();
        }
        QueryWorkItem r = new QueryWorkItem(query);
        r.run();
    }

    private boolean beginExecution() {
        if (this.executionFuture != null) {
            return true;
        }
        this.executing = true;
        return false;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    @Override
    public void getParameterDescription(String prepareName) {
        Prepared query;
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if ((query = this.preparedMap.get(prepareName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40079, new Object[]{prepareName}));
            return;
        }
        this.client.sendParameterDescription(query.paramType);
        this.client.sendResultSetDescription(query.columnMetadata, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorOccurred(String error) {
        this.client.errorOccurred(error);
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = true;
            this.doneExecuting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorOccurred(Throwable error) {
        this.client.errorOccurred(error);
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = true;
            this.doneExecuting();
        }
    }

    @Override
    public void getResultSetMetaDataDescription(String bindName) {
        Portal query;
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.get(bindName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40078, new Object[]{bindName}));
        } else if (query.prepared.cursorName != null) {
            this.client.sendResultSetDescription(null, query.resultColumnFormat);
        } else {
            this.client.sendResultSetDescription(query.prepared.columnMetadata, query.resultColumnFormat);
        }
    }

    @Override
    public void sync() {
        this.ready();
    }

    protected void doneExecuting() {
        this.executing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ready() {
        boolean inTxn = false;
        boolean failedTxn = false;
        try {
            if (!this.connection.getAutoCommit()) {
                inTxn = true;
            }
        }
        catch (SQLException e) {
            failedTxn = true;
        }
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = false;
        }
        this.executingStatement = null;
        this.client.ready(inTxn, failedTxn);
    }

    @Override
    public void closeBoundStatement(String bindName) {
        Portal query;
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.remove(bindName)) != null) {
            this.closePortal(query);
        }
        this.client.statementClosed();
    }

    private void closePortal(Portal query) {
        ResultSetImpl rs = query.rs;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LogManager.logDetail((String)"org.teiid.ODBC", (Object)e, (Object)"Did not successfully close portal", (Object)query.name);
            }
            query.rs = null;
        }
        try {
            query.stmt.close();
        }
        catch (SQLException e) {
            LogManager.logDetail((String)"org.teiid.ODBC", (Object)e, (Object)"Did not successfully close portal", (Object)query.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePreparedStatement(String preparedName) {
        Prepared query;
        if (preparedName == null || preparedName.length() == 0) {
            preparedName = UNNAMED;
        }
        if ((query = this.preparedMap.remove(preparedName)) != null) {
            Map<String, Portal> map = this.portalMap;
            synchronized (map) {
                Iterator<Portal> iter = this.portalMap.values().iterator();
                while (iter.hasNext()) {
                    Portal p = iter.next();
                    if (p.prepared.name.equals(preparedName)) {
                        iter.remove();
                    }
                    this.closePortal(p);
                }
            }
        }
        this.client.statementClosed();
    }

    @Override
    public void terminate() {
        remotes.remove(this.secretKey);
        this.closePortals();
        this.preparedMap.clear();
        try {
            if (this.connection != null) {
                if (!this.connection.getAutoCommit()) {
                    this.connection.rollback(false);
                }
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.client.terminated();
    }

    private void closePortals() {
        for (Portal portal : this.portalMap.values()) {
            this.closePortal(portal);
        }
        for (Cursor cursor : this.cursorMap.values()) {
            this.closePortal(cursor);
        }
        this.portalMap.clear();
        this.cursorMap.clear();
    }

    @Override
    public void flush() {
        this.client.flush();
    }

    @Override
    public void functionCall(int oid) {
        this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40081, new Object[0]));
    }

    @Override
    public void sslRequest() {
        this.client.sendSslResponse();
    }

    private void updateSessionProperties() {
        String existing;
        String appName;
        String encoding = this.getEncoding();
        if (encoding != null) {
            this.client.setEncoding(encoding, false);
        }
        if ((appName = this.connection.getExecutionProperty("application_name")) != null && !EquivalenceUtil.areEqual((Object)appName, (Object)(existing = this.props.getProperty("application_name")))) {
            try {
                SessionMetadata sm = ((LocalServerConnection)this.connection.getServerConnection()).getWorkContext().getSession();
                sm.setApplicationName(appName);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.client.sendParameterStatus("application_name", appName);
            this.props.put("application_name", appName);
        }
    }

    public String getEncoding() {
        return this.connection.getExecutionProperty("client_encoding");
    }

    static String normalizeName(String name) {
        if (name.length() > 1 && name.startsWith("\"") && name.endsWith("\"")) {
            return StringUtil.replaceAll((String)name.substring(1, name.length() - 1), (String)"\"", (String)"\"\"");
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PGUtil.PgColInfo> getPgColInfo(ResultSetMetaData meta) throws SQLException {
        if (meta == null) {
            return null;
        }
        int columns = meta.getColumnCount();
        ArrayList<PGUtil.PgColInfo> result = new ArrayList<PGUtil.PgColInfo>(columns);
        for (int i = 1; i <= columns; ++i) {
            PGUtil.PgColInfo info = new PGUtil.PgColInfo();
            info.name = meta.getColumnLabel(i);
            info.type = meta.getColumnType(i);
            String typeName = meta.getColumnTypeName(i);
            info.type = PGUtil.convertType(info.type, typeName);
            info.precision = meta.getColumnDisplaySize(i);
            info.mod = info.type == 1700 ? 4 + 65536 * Math.min(Short.MAX_VALUE, meta.getPrecision(i)) + Math.min(Short.MAX_VALUE, meta.getScale(i)) : (info.type == 1042 || info.type == 1043 ? (int)Math.min(Integer.MAX_VALUE, 4L + (long)meta.getColumnDisplaySize(i)) : -1);
            String name = meta.getColumnName(i);
            String table = meta.getTableName(i);
            String schema = meta.getSchemaName(i);
            if (schema != null) {
                try (PreparedStatementImpl ps = this.connection.prepareStatement("select pg_catalog.getOid(SYS.Columns.TableUID), cast(SYS.Columns.Position as short), cast((select p.value from SYS.Properties p where p.name = 'pg_type:oid' and p.uid = SYS.Columns.uid) as integer) from SYS.Columns where Name = ? and TableName = ? and SchemaName = ?");){
                    ps.setString(1, name);
                    ps.setString(2, table);
                    ps.setString(3, schema);
                    ResultSetImpl rs = ps.executeQuery();
                    if (rs.next()) {
                        info.reloid = rs.getInt(1);
                        info.attnum = rs.getShort(2);
                        int specificType = rs.getInt(3);
                        if (!rs.wasNull()) {
                            info.type = specificType;
                        }
                    }
                }
            }
            result.add(info);
        }
        return result;
    }

    static class Cursor
    extends Portal {
        public Cursor(String name, String sql, PreparedStatementImpl stmt, ResultSetImpl rs, List<PGUtil.PgColInfo> colMetadata, short[] resultColumnFormat) {
            super(name, new Prepared(ODBCServerRemoteImpl.UNNAMED, sql, sql, null, colMetadata, null), resultColumnFormat, stmt);
            this.rs = rs;
        }
    }

    static class Portal {
        final String name;
        final short[] resultColumnFormat;
        final Prepared prepared;
        volatile ResultSetImpl rs;
        final PreparedStatementImpl stmt;

        public Portal(String name, Prepared prepared, short[] resultColumnformat, PreparedStatementImpl stmt) {
            this.name = name;
            this.prepared = prepared;
            this.resultColumnFormat = resultColumnformat;
            this.stmt = stmt;
        }
    }

    static class Prepared {
        final String name;
        final String sql;
        final String modifiedSql;
        final int[] paramType;
        final List<PGUtil.PgColInfo> columnMetadata;
        final String cursorName;

        public Prepared(String name, String sql, String modifiedSql, int[] paramType, List<PGUtil.PgColInfo> columnMetadata, String cursorName) {
            this.name = name;
            this.sql = sql;
            this.modifiedSql = modifiedSql;
            this.paramType = paramType;
            this.columnMetadata = columnMetadata;
            this.cursorName = cursorName;
        }
    }

    private final class QueryWorkItem
    implements Runnable {
        private final ScriptReader reader;
        String sql;
        private String next;

        private QueryWorkItem(String query) {
            this.reader = new ScriptReader(query);
        }

        private void done(Throwable error) {
            if (error != null) {
                ODBCServerRemoteImpl.this.errorOccurred(error);
            } else {
                ODBCServerRemoteImpl.this.doneExecuting();
            }
            ODBCServerRemoteImpl.this.ready();
        }

        @Override
        public void run() {
            block25: {
                try {
                    if (this.sql == null) {
                        this.sql = this.reader.readStatement();
                    }
                    if (this.sql == null) break block25;
                    try {
                        ResultsFuture results = new ResultsFuture();
                        results.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

                            public void onCompletion(ResultsFuture<Integer> future) {
                                try {
                                    future.get();
                                    if (QueryWorkItem.this.next != null) {
                                        QueryWorkItem.this.sql = QueryWorkItem.this.next;
                                        QueryWorkItem.this.next = null;
                                    } else {
                                        QueryWorkItem.this.sql = QueryWorkItem.this.reader.readStatement();
                                    }
                                }
                                catch (InterruptedException e) {
                                    throw new AssertionError((Object)e);
                                }
                                catch (IOException e) {
                                    QueryWorkItem.this.done(e);
                                    return;
                                }
                                catch (ExecutionException e) {
                                    Throwable cause;
                                    for (cause = e; cause instanceof ExecutionException && cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
                                    }
                                    QueryWorkItem.this.done(cause);
                                    return;
                                }
                                QueryWorkItem.this.run();
                            }
                        });
                        if (ODBCServerRemoteImpl.this.isErrorOccurred()) {
                            if (!ODBCServerRemoteImpl.this.connection.getAutoCommit()) {
                                ODBCServerRemoteImpl.this.connection.rollback(false);
                            }
                            break block25;
                        }
                        if (!HONOR_DECLARE_FETCH_TXN && this.sql.equalsIgnoreCase("BEGIN") && ODBCServerRemoteImpl.this.connection.getAutoCommit()) {
                            this.next = this.reader.readStatement();
                            if (this.next != null && cursorSelectPattern.matcher(this.next).matches()) {
                                this.sql = this.next;
                                this.next = null;
                                LogManager.logDetail((String)"org.teiid.ODBC", (Object)"not honoring the transaction for declare/fetch");
                            }
                        }
                        Matcher m = null;
                        m = cursorSelectPattern.matcher(this.sql);
                        if (m.matches()) {
                            boolean scroll = false;
                            if (m.group(3) != null && m.group(4) == null) {
                                scroll = true;
                            }
                            ODBCServerRemoteImpl.this.cursorExecute(ODBCServerRemoteImpl.normalizeName(m.group(1)), ODBCServerRemoteImpl.this.fixSQL(m.group(5)), (ResultsFuture<Integer>)results, scroll, m.group(2) != null);
                        } else {
                            m = fetchPattern.matcher(this.sql);
                            if (m.matches()) {
                                String rows;
                                int rowCount = 1;
                                String direction = m.group(1);
                                ODBCClientRemote.CursorDirection cursorDirection = ODBCClientRemote.CursorDirection.FORWARD;
                                if (direction != null) {
                                    cursorDirection = ODBCClientRemote.CursorDirection.valueOf(direction.toUpperCase());
                                }
                                if ((rows = m.group(2)) != null) {
                                    rowCount = Integer.parseInt(rows);
                                }
                                ODBCServerRemoteImpl.this.cursorFetch(ODBCServerRemoteImpl.normalizeName(m.group(3)), cursorDirection, rowCount, (ResultsFuture<Integer>)results);
                            } else {
                                m = fetchFirstLastPattern.matcher(this.sql);
                                if (m.matches()) {
                                    int rowCount = 1;
                                    String direction = m.group(1);
                                    ODBCClientRemote.CursorDirection cursorDirection = ODBCClientRemote.CursorDirection.valueOf(direction.toUpperCase());
                                    ODBCServerRemoteImpl.this.cursorFetch(ODBCServerRemoteImpl.normalizeName(m.group(2)), cursorDirection, rowCount, (ResultsFuture<Integer>)results);
                                } else {
                                    m = movePattern.matcher(this.sql);
                                    if (m.matches()) {
                                        ODBCServerRemoteImpl.this.cursorMove(ODBCServerRemoteImpl.normalizeName(m.group(3)), m.group(1), Integer.parseInt(m.group(2)), (ResultsFuture<Integer>)results);
                                    } else {
                                        m = closePattern.matcher(this.sql);
                                        if (m.matches()) {
                                            ODBCServerRemoteImpl.this.cursorClose(ODBCServerRemoteImpl.normalizeName(m.group(1)));
                                            results.getResultsReceiver().receiveResults((Object)1);
                                        } else {
                                            m = deallocatePattern.matcher(this.sql);
                                            if (m.matches()) {
                                                String plan_name = m.group(1);
                                                plan_name = ODBCServerRemoteImpl.normalizeName(plan_name);
                                                ODBCServerRemoteImpl.this.closePreparedStatement(plan_name);
                                                ODBCServerRemoteImpl.this.client.sendCommandComplete("DEALLOCATE", null);
                                                results.getResultsReceiver().receiveResults((Object)1);
                                            } else {
                                                ODBCServerRemoteImpl.this.sqlExecute(this.sql, (ResultsFuture<Integer>)results);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        return;
                    }
                    catch (SQLException e) {
                        this.done(e);
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    this.done((Throwable)TeiidSQLException.create((Throwable)e, (String)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40147, new Object[]{e.getMessage()})));
                    return;
                }
                catch (Exception e) {
                    this.done(e);
                    return;
                }
            }
            this.done(null);
        }
    }
}

