/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.jmx;

import java.util.ArrayList;
import java.util.List;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.EngineStatisticsBean;
import org.teiid.adminapi.RequestBean;
import org.teiid.adminapi.SessionBean;
import org.teiid.adminapi.WorkerPoolStatisticsBean;
import org.teiid.client.plan.PlanNode;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.runtime.EmbeddedAdminFactory;
import org.teiid.runtime.jmx.TeiidBean;
import org.teiid.services.BufferServiceImpl;

class Teiid
implements TeiidBean {
    private final DQPCore dqp;
    private final SessionService sessionService;
    private final BufferServiceImpl bufferService;

    public Teiid(DQPCore dqp, SessionService sessionService, BufferServiceImpl bufferService) {
        this.dqp = dqp;
        this.sessionService = sessionService;
        this.bufferService = bufferService;
    }

    @Override
    public String getQueryPlan(String sessionId, long executionId) {
        PlanNode plan = this.dqp.getPlan(sessionId, executionId);
        if (plan == null) {
            return null;
        }
        return plan.toXml();
    }

    @Override
    public List<RequestBean> getRequests() throws AdminException {
        return new ArrayList<RequestBean>(this.dqp.getRequests());
    }

    @Override
    public List<SessionBean> getSessions() throws AdminException {
        return new ArrayList<SessionBean>(this.sessionService.getActiveSessions());
    }

    @Override
    public void terminateSession(String sessionId) throws AdminException {
        this.dqp.terminateSession(sessionId);
    }

    @Override
    public void cancelRequest(String sessionId, long executionId) throws AdminException {
        try {
            this.dqp.cancelRequest(sessionId, executionId);
        }
        catch (TeiidComponentException e) {
            throw new AdminProcessingException((Throwable)e);
        }
    }

    @Override
    public void terminateTransaction(String transactionId) throws AdminException {
        this.dqp.terminateTransaction(transactionId);
    }

    @Override
    public WorkerPoolStatisticsBean getWorkerPoolStatisticsBean() {
        return this.dqp.getWorkerPoolStatistics();
    }

    @Override
    public EngineStatisticsBean getEngineStatisticsBean() {
        try {
            return EmbeddedAdminFactory.createEngineStats(this.sessionService.getActiveSessionsCount(), this.bufferService, this.dqp);
        }
        catch (SessionServiceException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }
}

