/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.common.buffer.impl.BufferFrontedFileStoreCache;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.EncryptedStorageManager;
import org.teiid.common.buffer.impl.FileStorageManager;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.common.buffer.impl.SplittableStorageManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.FileUtils;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.SessionService;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.services.SessionServiceImpl;

public class BufferServiceImpl
implements BufferService,
Serializable {
    private static final long serialVersionUID = -6217808623863643531L;
    private static final long MB = 0x100000L;
    private BufferManagerImpl bufferMgr;
    private int processorBatchSize = 256;
    private boolean inlineLobs = true;
    private boolean useDisk = true;
    private int maxStorageObjectSize = 0x800000;
    private BufferFrontedFileStoreCache fsc;
    private FileStorageManager fsm;
    private int maxProcessingKb = -1;
    private int maxReservedHeapKb = -1;
    private long fixedMemoryBufferSpaceMb = -1L;
    private boolean fixedMemoryBufferOffHeap;
    private File bufferDir;
    private boolean encryptFiles = false;
    private int maxOpenFiles = 64;
    private long maxFileSize = 2048L;
    private long maxDiskBufferSpace = 5120L;
    private long vmMaxMemory = Runtime.getRuntime().maxMemory();
    private SessionServiceImpl sessionService;

    void cleanDirectory(File file) {
        FileUtils.removeChildrenRecursively((File)file);
    }

    public void start() {
        try {
            this.bufferMgr = new BufferManagerImpl(false);
            this.bufferMgr.setProcessorBatchSize(this.processorBatchSize);
            this.bufferMgr.setMaxReserveKB(this.maxReservedHeapKb);
            this.bufferMgr.setMaxProcessingKB(this.maxProcessingKb);
            this.bufferMgr.setInlineLobs(this.inlineLobs);
            this.bufferMgr.setSessionService((SessionService)this.sessionService);
            this.bufferMgr.initialize();
            if (this.useDisk) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Starting BufferManager using", (Object)this.bufferDir);
                if (!this.bufferDir.exists()) {
                    this.bufferDir.mkdirs();
                }
                this.cleanDirectory(this.bufferDir);
                this.fsm = new FileStorageManager();
                this.fsm.setStorageDirectory(this.bufferDir.getCanonicalPath());
                this.fsm.setMaxOpenFiles(this.maxOpenFiles);
                this.fsm.setMaxBufferSpace(this.maxDiskBufferSpace * 0x100000L);
                SplittableStorageManager ssm = new SplittableStorageManager((StorageManager)this.fsm);
                ssm.setMaxFileSize(this.maxFileSize);
                SplittableStorageManager sm = ssm;
                if (this.encryptFiles) {
                    sm = new EncryptedStorageManager((StorageManager)ssm);
                }
                this.fsc = new BufferFrontedFileStoreCache();
                this.fsc.setBufferManager(this.bufferMgr);
                this.fsc.setMaxStorageObjectSize(this.maxStorageObjectSize);
                this.fsc.setDirect(this.fixedMemoryBufferOffHeap);
                if (this.fixedMemoryBufferSpaceMb < 0L) {
                    long autoMaxBufferSpace = 4L * ((long)this.bufferMgr.getMaxReserveKB() << 10) / 10L;
                    if (this.maxReservedHeapKb >= 0) {
                        autoMaxBufferSpace = Math.min(autoMaxBufferSpace, (this.vmMaxMemory - ((long)this.bufferMgr.getMaxReserveKB() << 10)) / 4L);
                    }
                    this.fsc.setMemoryBufferSpace(autoMaxBufferSpace);
                } else {
                    this.fsc.setMemoryBufferSpace(this.fixedMemoryBufferSpaceMb << 20);
                }
                long batchAndInodeOverheadKB = this.fsc.getMemoryBufferSpace() >> (this.fixedMemoryBufferOffHeap ? 19 : 17);
                this.bufferMgr.setMaxReserveKB((int)Math.max(0L, (long)this.bufferMgr.getMaxReserveKB() - batchAndInodeOverheadKB));
                if (this.maxReservedHeapKb < 0) {
                    if (this.fixedMemoryBufferOffHeap) {
                        this.bufferMgr.setMaxReserveKB(8 * this.bufferMgr.getMaxReserveKB() / 10);
                    } else {
                        this.bufferMgr.setMaxReserveKB((int)Math.max(0L, (long)this.bufferMgr.getMaxReserveKB() - (this.fsc.getMemoryBufferSpace() >> 10)));
                    }
                }
                this.fsc.setStorageManager((StorageManager)sm);
                this.fsc.initialize();
                this.bufferMgr.setCache((Cache)this.fsc);
            } else {
                MemoryStorageManager msm = new MemoryStorageManager();
                SplittableStorageManager ssm = new SplittableStorageManager((StorageManager)msm);
                ssm.setMaxFileSizeDirect(131072L);
                this.bufferMgr.setCache((Cache)msm);
                this.bufferMgr.setStorageManager((StorageManager)ssm);
            }
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40039, (Throwable)e, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40039, new Object[0]));
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40039, (Throwable)e, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40039, new Object[0]));
        }
    }

    public void stop() {
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Stopping BufferManager using", (Object)this.bufferDir);
        if (this.bufferMgr != null) {
            this.bufferMgr.shutdown();
            this.bufferMgr = null;
        }
        if (this.bufferDir != null) {
            this.cleanDirectory(this.bufferDir);
            this.bufferDir.delete();
        }
    }

    public BufferManagerImpl getBufferManager() {
        return this.bufferMgr;
    }

    public TupleBufferCache getTupleBufferCache() {
        return this.bufferMgr;
    }

    public void setUseDisk(boolean flag) {
        this.useDisk = flag;
    }

    public void setDiskDirectory(String dir) {
        this.bufferDir = new File(dir, "buffer");
    }

    public void setProcessorBatchSize(int size) {
        this.processorBatchSize = size;
    }

    public void setInlineLobs(boolean inlineLobs) {
        this.inlineLobs = inlineLobs;
    }

    public File getBufferDirectory() {
        return this.bufferDir;
    }

    public boolean isUseDisk() {
        return this.useDisk;
    }

    public boolean isInlineLobs() {
        return this.inlineLobs;
    }

    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public int getMaxProcessingKb() {
        return this.maxProcessingKb;
    }

    public void setMaxReservedHeapMb(int maxReservedHeap) {
        this.maxReservedHeapKb = (int)Math.min(Integer.MAX_VALUE, (long)maxReservedHeap << 10);
    }

    public int getMaxReservedHeapMb() {
        return this.maxReservedHeapKb >> 10;
    }

    public void setMaxProcessingKb(int maxProcessingKb) {
        this.maxProcessingKb = maxProcessingKb;
    }

    @Deprecated
    public void setMaxReserveKb(int maxReserveKb) {
        this.maxReservedHeapKb = maxReserveKb;
    }

    public long getMaxDiskBufferSpaceMb() {
        return this.maxDiskBufferSpace;
    }

    public void setMaxDiskBufferSpaceMb(long maxBufferSpace) {
        this.maxDiskBufferSpace = maxBufferSpace;
    }

    public void setFixedMemoryBufferOffHeap(boolean memoryBufferOffHeap) {
        this.fixedMemoryBufferOffHeap = memoryBufferOffHeap;
    }

    public void setFixedMemoryBufferSpaceMb(int memoryBufferSpace) {
        this.fixedMemoryBufferSpaceMb = memoryBufferSpace;
    }

    @Deprecated
    public void setMaxStorageObjectSize(int maxStorageObjectSize) {
        this.maxStorageObjectSize = maxStorageObjectSize;
    }

    public void setMaxStorageObjectSizeKb(int maxStorageObjectSize) {
        this.maxStorageObjectSize = (int)Math.min(Integer.MAX_VALUE, (long)maxStorageObjectSize << 10);
    }

    public long getUsedDiskBufferSpaceMb() {
        if (this.fsm != null) {
            return this.fsm.getUsedBufferSpace() / 0x100000L;
        }
        return 0L;
    }

    public long getHeapBufferInUseKb() {
        return this.bufferMgr.getActiveBatchBytes() / 1024L;
    }

    public long getMemoryReservedByActivePlansKb() {
        return (long)this.bufferMgr.getMaxReserveKB() - this.bufferMgr.getReserveBatchBytes() / 1024L;
    }

    public long getDiskReadCount() {
        if (this.fsc != null) {
            return this.fsc.getStorageReads();
        }
        return 0L;
    }

    public long getDiskWriteCount() {
        if (this.fsc != null) {
            return this.fsc.getStorageWrites();
        }
        return 0L;
    }

    public long getMemoryBufferUsedKb() {
        if (this.fsc != null) {
            return this.fsc.getMemoryInUseBytes() >> 10;
        }
        return 0L;
    }

    public long getStorageReadCount() {
        return this.bufferMgr.getReadCount();
    }

    public long getStorageWriteCount() {
        return this.bufferMgr.getWriteCount();
    }

    public long getReadAttempts() {
        return this.bufferMgr.getReadAttempts();
    }

    public int getFixedMemoryBufferSpaceMb() {
        return (int)this.fixedMemoryBufferSpaceMb;
    }

    public int getMaxStorageObjectSizeKb() {
        return this.maxStorageObjectSize >> 10;
    }

    public boolean isFixedMemoryBufferOffHeap() {
        return this.fixedMemoryBufferOffHeap;
    }

    public boolean isEncryptFiles() {
        return this.encryptFiles;
    }

    public void setEncryptFiles(boolean encryptFiles) {
        this.encryptFiles = encryptFiles;
    }

    public void setBufferManager(BufferManagerImpl bufferManager) {
        this.bufferMgr = bufferManager;
    }

    public void setVmMaxMemory(long vmMaxMemory) {
        this.vmMaxMemory = vmMaxMemory;
    }

    public void setSessionService(SessionServiceImpl sessionService) {
        this.sessionService = sessionService;
    }
}

