/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.ServiceInvocationStruct;
import org.teiid.odbc.ODBCServerRemote;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.PgBackendProtocol;

public class PgFrontendProtocol
extends ByteToMessageDecoder {
    private static final int LO_CREAT = 957;
    private static final int LO_OPEN = 952;
    private static final int LO_CLOSE = 953;
    private static final int LO_READ = 954;
    private static final int LO_WRITE = 955;
    private static final int LO_LSEEK = 956;
    private static final int LO_TELL = 958;
    private static final int LO_UNLINK = 964;
    private int maxObjectSize;
    private Byte messageType;
    private Integer dataLength;
    private boolean initialized = false;
    private ODBCServerRemote odbcProxy;
    private PGRequest message;
    private String user;
    private String databaseName;
    private PgBackendProtocol pgBackendProtocol;

    public PgFrontendProtocol(PgBackendProtocol pgBackendProtocol, int maxObjectSize) {
        if (maxObjectSize <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + maxObjectSize);
        }
        this.maxObjectSize = maxObjectSize;
        this.pgBackendProtocol = pgBackendProtocol;
        this.odbcProxy = (ODBCServerRemote)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{ODBCServerRemote.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.ODBC", (int)6)) {
                    LogManager.logTrace((String)"org.teiid.ODBC", (Object)"invoking server method:", (Object)method.getName(), (Object)Arrays.deepToString(args));
                }
                PgFrontendProtocol.this.message = new PGRequest();
                ((PgFrontendProtocol)PgFrontendProtocol.this).message.struct = new ServiceInvocationStruct(args, method.getName(), ODBCServerRemote.class);
                return null;
            }
        });
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (this.initialized && this.messageType == null) {
            if (buffer.readableBytes() < 1) {
                return;
            }
            this.messageType = buffer.readByte();
            if (this.messageType < 0) {
                this.odbcProxy.terminate();
                out.add(this.message);
            }
        }
        if (!this.initialized) {
            this.messageType = 73;
        }
        if (this.dataLength == null) {
            if (buffer.readableBytes() < 4) {
                return;
            }
            this.dataLength = buffer.readInt();
            if (this.dataLength <= 0) {
                throw new StreamCorruptedException("invalid data length: " + this.dataLength);
            }
            if (this.dataLength > this.maxObjectSize) {
                throw new StreamCorruptedException("data length too big: " + this.dataLength + " (max: " + this.maxObjectSize + ')');
            }
        }
        if (buffer.readableBytes() < this.dataLength - 4) {
            return;
        }
        byte[] data = PgFrontendProtocol.createByteArray(this.dataLength - 4);
        buffer.readBytes(data);
        this.createRequestMessage(this.messageType, new NullTerminatedStringDataInputStream(data, new DataInputStream(new ByteArrayInputStream(data, 0, this.dataLength - 4)), this.pgBackendProtocol.getEncoding()), ctx.channel());
        this.dataLength = null;
        this.messageType = null;
        out.add(this.message);
    }

    private Object createRequestMessage(byte messageType, NullTerminatedStringDataInputStream data, Channel channel) throws IOException {
        switch (messageType) {
            case 73: {
                this.initialized = true;
                return this.buildInitialize(data, channel);
            }
            case 112: {
                return this.buildLogin(data, channel);
            }
            case 80: {
                return this.buildParse(data);
            }
            case 66: {
                return this.buildBind(data);
            }
            case 69: {
                return this.buildExecute(data);
            }
            case 81: {
                return this.buildExecuteQuery(data);
            }
            case 68: {
                return this.buildDescribe(data);
            }
            case 88: {
                return this.buildTeminate();
            }
            case 83: {
                return this.buildSync();
            }
            case 67: {
                return this.buildClose(data);
            }
            case 72: {
                return this.buildFlush();
            }
            case 70: {
                return this.buildFunctionCall(data);
            }
        }
        return this.buildError();
    }

    private Object buildError() {
        this.odbcProxy.unsupportedOperation("option not suported");
        return this.message;
    }

    private Object buildFlush() {
        this.odbcProxy.flush();
        return this.message;
    }

    private Object buildTeminate() {
        this.odbcProxy.terminate();
        return this.message;
    }

    private Object buildInitialize(NullTerminatedStringDataInputStream data, Channel channel) throws IOException {
        String param;
        Properties props = new Properties();
        int version = data.readInt();
        props.setProperty("version", Integer.toString(version));
        if (version == 80877103) {
            this.initialized = false;
            this.odbcProxy.sslRequest();
            return this.message;
        }
        if (version == 80877102) {
            int pid = data.readInt();
            int key = data.readInt();
            this.odbcProxy.cancel(pid, key);
            return this.message;
        }
        if (this.pgBackendProtocol.secureData() && channel.pipeline().get("sslHandler") == null) {
            this.odbcProxy.unsupportedOperation(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40123, new Object[0]));
            return this.message;
        }
        PgFrontendProtocol.trace("StartupMessage version", version, "(", version >> 16, ".", version & 0xFF, ")");
        while ((param = data.readString()).length() != 0) {
            String value = data.readString();
            props.setProperty(param, value);
        }
        this.user = props.getProperty("user");
        this.databaseName = props.getProperty("database");
        String clientEncoding = props.getProperty("client_encoding", "UTF8");
        props.setProperty("client_encoding", clientEncoding);
        props.setProperty("default_transaction_isolation", "read committed");
        props.setProperty("integer_datetimes", "on");
        props.setProperty("DateStyle", "ISO");
        props.setProperty("TimeZone", Calendar.getInstance().getTimeZone().getDisplayName());
        this.odbcProxy.initialize(props);
        return this.message;
    }

    private Object buildLogin(NullTerminatedStringDataInputStream data, Channel channel) {
        this.odbcProxy.logon(this.databaseName, this.user, data, channel.remoteAddress());
        return this.message;
    }

    private Object buildParse(NullTerminatedStringDataInputStream data) throws IOException {
        String name = data.readString();
        String sql = data.readString();
        int count = data.readShort();
        int[] paramType = new int[count];
        for (int i = 0; i < count; ++i) {
            int type;
            paramType[i] = type = data.readInt();
        }
        this.odbcProxy.prepare(name, sql, paramType);
        return this.message;
    }

    private Object buildBind(NullTerminatedStringDataInputStream data) throws IOException {
        String bindName = data.readString();
        String prepName = data.readString();
        int formatCodeCount = data.readShort();
        int[] formatCodes = new int[formatCodeCount];
        for (int i = 0; i < formatCodeCount; ++i) {
            formatCodes[i] = data.readShort();
        }
        int paramCount = data.readShort();
        Object[] params = new Object[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            int paramLen = data.readInt();
            byte[] paramdata = PgFrontendProtocol.createByteArray(paramLen);
            data.readFully(paramdata);
            params[i] = formatCodeCount == 0 || formatCodeCount == 1 && formatCodes[0] == 0 || formatCodes[i] == 0 ? new String(paramdata, this.pgBackendProtocol.getEncoding()) : (Object)paramdata;
        }
        int resultCodeCount = data.readShort();
        short[] resultColumnFormat = null;
        if (resultCodeCount != 0) {
            resultColumnFormat = new short[resultCodeCount];
            for (int i = 0; i < resultCodeCount; ++i) {
                resultColumnFormat[i] = data.readShort();
            }
        }
        this.odbcProxy.bindParameters(bindName, prepName, params, resultCodeCount, resultColumnFormat, this.pgBackendProtocol.getEncoding());
        return this.message;
    }

    private Object buildExecute(NullTerminatedStringDataInputStream data) throws IOException {
        String portalName = data.readString();
        int maxRows = data.readInt();
        this.odbcProxy.execute(portalName, maxRows);
        return this.message;
    }

    private Object buildDescribe(NullTerminatedStringDataInputStream data) throws IOException {
        char type = (char)data.readByte();
        String name = data.readString();
        if (type == 'S') {
            this.odbcProxy.getParameterDescription(name);
            return this.message;
        }
        if (type == 'P') {
            this.odbcProxy.getResultSetMetaDataDescription(name);
            return this.message;
        }
        PgFrontendProtocol.trace("expected S or P, got ", Character.valueOf(type));
        this.odbcProxy.unsupportedOperation("expected S or P");
        return this.message;
    }

    private Object buildSync() {
        this.odbcProxy.sync();
        return this.message;
    }

    private Object buildExecuteQuery(NullTerminatedStringDataInputStream data) throws IOException {
        String query = data.readString();
        this.odbcProxy.executeQuery(query);
        return this.message;
    }

    static byte[] createByteArray(int length) throws StreamCorruptedException {
        try {
            return new byte[length];
        }
        catch (OutOfMemoryError e) {
            throw new StreamCorruptedException("data too big: " + e.getMessage());
        }
    }

    private Object buildClose(NullTerminatedStringDataInputStream data) throws IOException {
        char type = (char)data.read();
        String name = data.readString();
        if (type == 'S') {
            this.odbcProxy.closePreparedStatement(name);
        } else if (type == 'P') {
            this.odbcProxy.closeBoundStatement(name);
        } else {
            this.odbcProxy.unsupportedOperation("unknown close type specified");
        }
        return this.message;
    }

    private Object buildFunctionCall(NullTerminatedStringDataInputStream data) throws IOException {
        int funcID = data.readInt();
        int formatCount = data.readShort();
        int[] formatTypes = new int[formatCount];
        for (int i = 0; i < formatCount; ++i) {
            formatTypes[i] = data.readShort();
        }
        data.readShort();
        int oid = this.readInt(data);
        switch (funcID) {
            case 957: {
                break;
            }
            case 952: {
                int mode = this.readInt(data);
                break;
            }
            case 953: {
                break;
            }
            case 954: {
                int length = this.readInt(data);
                break;
            }
            case 955: {
                byte[] contents = this.readByteArray(data);
                break;
            }
            case 956: {
                int offset = this.readInt(data);
                int where = this.readInt(data);
                break;
            }
            case 958: {
                break;
            }
        }
        this.odbcProxy.functionCall(oid);
        return this.message;
    }

    private int readInt(NullTerminatedStringDataInputStream data) throws IOException {
        data.readInt();
        return data.readInt();
    }

    private byte[] readByteArray(NullTerminatedStringDataInputStream data) throws IOException {
        int length = data.readInt();
        if (length == -1 || length == 0) {
            return null;
        }
        byte[] content = PgFrontendProtocol.createByteArray(length);
        data.read(content, 0, length);
        return content;
    }

    private static void trace(Object ... msg) {
        LogManager.logTrace((String)"org.teiid.ODBC", (Object[])msg);
    }

    public static class NullTerminatedStringDataInputStream
    extends DataInputStream {
        private Charset encoding;
        private byte[] rawData;

        public NullTerminatedStringDataInputStream(byte[] rawData, DataInputStream in, Charset encoding) {
            super(in);
            this.encoding = encoding;
            this.rawData = rawData;
        }

        public String readString() throws IOException {
            int x;
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            while ((x = this.read()) > 0) {
                buff.write(x);
            }
            return new String(buff.toByteArray(), this.encoding);
        }

        public byte[] readServiceToken() {
            return this.rawData;
        }
    }

    public static class PGRequest {
        ServiceInvocationStruct struct;
    }
}

