/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;

@Translator(name="hardcoded")
public class HardCodedExecutionFactory
extends ExecutionFactory<Object, Object> {
    Map<String, List<? extends List<?>>> dataMap = new ConcurrentHashMap();
    Map<String, Object> updateMap = new ConcurrentHashMap<String, Object>();
    private List<Command> commands = new CopyOnWriteArrayList<Command>();

    public HardCodedExecutionFactory() {
        this.setSourceRequired(false);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
        this.commands.add((Command)command);
        List<List<?>> list = this.getData((Command)command);
        if (list == null) {
            throw new RuntimeException(command.toString());
        }
        final Iterator<? extends List<?>> result = list.iterator();
        return new ProcedureExecution(){

            public void execute() throws TranslatorException {
            }

            public void close() {
            }

            public void cancel() throws TranslatorException {
            }

            public List<?> next() throws TranslatorException, DataNotAvailableException {
                if (result.hasNext()) {
                    return (List)result.next();
                }
                return null;
            }

            public List<?> getOutputParameterValues() throws TranslatorException {
                return null;
            }
        };
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
        this.commands.add((Command)command);
        List<List<?>> list = this.getData(command);
        if (list == null) {
            throw new RuntimeException(command.toString());
        }
        final Iterator<? extends List<?>> result = list.iterator();
        return new ResultSetExecution(){

            public void execute() throws TranslatorException {
            }

            public void close() {
            }

            public void cancel() throws TranslatorException {
            }

            public List<?> next() throws TranslatorException, DataNotAvailableException {
                if (result.hasNext()) {
                    return (List)result.next();
                }
                return null;
            }
        };
    }

    protected List<? extends List<?>> getData(QueryExpression command) {
        return this.getData((Command)command);
    }

    protected List<? extends List<?>> getData(Command command) {
        return this.dataMap.get(command.toString());
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
        this.commands.add(command);
        Object response = this.updateMap.get(command.toString());
        if (response == null) {
            throw new RuntimeException(command.toString());
        }
        if (response instanceof int[]) {
            final int[] result = (int[])response;
            return new UpdateExecution(){

                public void execute() throws TranslatorException {
                }

                public void close() {
                }

                public void cancel() throws TranslatorException {
                }

                public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
                    return result;
                }
            };
        }
        throw (TranslatorException)response;
    }

    public void addData(String key, List<? extends List<?>> list) {
        this.dataMap.put(key, list);
    }

    public void addUpdate(String key, int[] counts) {
        this.updateMap.put(key, counts);
    }

    public void addUpdate(String key, TranslatorException exception) {
        this.updateMap.put(key, exception);
    }

    public List<Command> getCommands() {
        return this.commands;
    }
}

