/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Parser;
import org.teiid.metadata.Schema;
import org.teiid.metadata.VDBResource;
import org.teiid.metadatastore.DeploymentBasedDatabaseStore;
import org.teiid.query.metadata.ChainingMetadataRepository;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.DDLFileMetadataRepository;
import org.teiid.query.metadata.DDLMetadataRepository;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.DatabaseStore;
import org.teiid.query.metadata.DatabaseUtil;
import org.teiid.query.metadata.DirectQueryMetadataRepository;
import org.teiid.query.metadata.MaterializationMetadataRepository;
import org.teiid.query.metadata.NativeMetadataRepository;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.metadata.UDFMetadataRepository;
import org.teiid.query.metadata.VDBResources;
import org.teiid.query.parser.QueryParser;
import org.teiid.runtime.MultiSourceMetadataRepository;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public abstract class AbstractVDBDeployer {
    public static final boolean ALLOW_INFORMATION_SCHEMA = Boolean.valueOf(PropertiesUtils.getHierarchicalProperty((String)"org.teiid.allow_information_schema", (String)Boolean.FALSE.toString()));
    protected ConcurrentSkipListMap<String, MetadataRepository<?, ?>> repositories = new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER);

    public AbstractVDBDeployer() {
        this.repositories.put("ddl", (MetadataRepository<?, ?>)new DDLMetadataRepository());
        this.repositories.put("native", (MetadataRepository<?, ?>)new NativeMetadataRepository());
        this.repositories.put("ddl-file", (MetadataRepository<?, ?>)new DDLFileMetadataRepository());
        this.repositories.put("udf", (MetadataRepository<?, ?>)new UDFMetadataRepository());
    }

    public void addMetadataRepository(String name, MetadataRepository<?, ?> metadataRepository) {
        this.repositories.put(name, metadataRepository);
    }

    protected void assignMetadataRepositories(VDBMetaData deployment, MetadataRepository<?, ?> defaultRepo) throws VirtualDatabaseException {
        for (ModelMetaData model : deployment.getModelMetaDatas().values()) {
            if (model.getModelType() != Model.Type.OTHER && (model.getName() == null || model.getName().indexOf(46) >= 0) || model.getName().equalsIgnoreCase("SYS") || model.getName().equalsIgnoreCase("SYSADMIN") || model.getName().equalsIgnoreCase("pg_catalog") || !ALLOW_INFORMATION_SCHEMA && model.getName().equalsIgnoreCase("information_schema")) {
                throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40121, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40121, new Object[]{model.getName(), deployment.getName(), deployment.getVersion()}));
            }
            if (model.isSource() && model.getSourceNames().isEmpty()) {
                throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40093, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40093, new Object[]{model.getName(), deployment.getName(), deployment.getVersion()}));
            }
            if (model.getModelType() == Model.Type.FUNCTION || model.getModelType() == Model.Type.OTHER) continue;
            ChainingMetadataRepository repo = this.getMetadataRepository(deployment, model, defaultRepo);
            if (model.isSupportsMultiSourceBindings() && Boolean.valueOf(model.getPropertyValue("multisource.addColumn")).booleanValue()) {
                ArrayList<Object> repos = new ArrayList<Object>(2);
                repos.add(repo);
                String columnName = model.getPropertyValue("multisource.columnName");
                repos.add(new MultiSourceMetadataRepository(columnName == null ? "SOURCE_NAME" : columnName));
                repo = new ChainingMetadataRepository(repos);
            }
            model.addAttchment(MetadataRepository.class, repo);
        }
    }

    private MetadataRepository<?, ?> getMetadataRepository(VDBMetaData vdb, ModelMetaData model, MetadataRepository<?, ?> defaultRepo) throws VirtualDatabaseException {
        if (model.getSourceMetadataType().isEmpty()) {
            if (defaultRepo != null) {
                return defaultRepo;
            }
            if (model.isSource()) {
                return new ChainingMetadataRepository(Arrays.asList(new NativeMetadataRepository(), new DirectQueryMetadataRepository()));
            }
            throw new VirtualDatabaseException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40094, new Object[]{model.getName(), vdb.getName(), vdb.getVersion(), null}));
        }
        ArrayList<Object> repos = new ArrayList<Object>(2);
        for (int i = 0; i < model.getSourceMetadataType().size(); ++i) {
            String schemaTypes = (String)model.getSourceMetadataType().get(i);
            StringTokenizer st = new StringTokenizer(schemaTypes, ",");
            while (st.hasMoreTokens()) {
                String repoType = st.nextToken().trim();
                MetadataRepository<?, ?> current = this.getMetadataRepository(repoType);
                if (current == null) {
                    throw new VirtualDatabaseException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40094, new Object[]{model.getName(), vdb.getName(), vdb.getVersion(), repoType}));
                }
                if (model.getSourceMetadataText().size() > i) {
                    current = new MetadataRepositoryWrapper(current, (String)model.getSourceMetadataText().get(i));
                }
                repos.add(current);
            }
        }
        if (model.getModelType() == Model.Type.PHYSICAL) {
            repos.add(new DirectQueryMetadataRepository());
        }
        if (model.getModelType() == Model.Type.VIRTUAL) {
            repos.add(new MaterializationMetadataRepository());
        }
        if (repos.size() == 1) {
            return (MetadataRepository)repos.get(0);
        }
        return new ChainingMetadataRepository(repos);
    }

    protected List<ConnectorManager> getConnectorManagers(ModelMetaData model, ConnectorManagerRepository cmr) {
        if (model.isSource()) {
            Collection mappings = model.getSources().values();
            ArrayList<ConnectorManager> result = new ArrayList<ConnectorManager>(mappings.size());
            for (SourceMappingMetadata mapping : mappings) {
                result.add(cmr.getConnectorManager(mapping.getName()));
            }
            return result;
        }
        return Collections.singletonList(null);
    }

    protected void loadMetadata(VDBMetaData vdb, ConnectorManagerRepository cmr, MetadataStore store, VDBResources vdbResources) throws TranslatorException {
        store.addDataTypes(SystemMetadata.getInstance().getRuntimeTypeMap());
        String value = vdb.getPropertyValue("domain-ddl");
        if (value != null) {
            DatabaseStore dbStore = new DatabaseStore(){

                public Map<String, Datatype> getRuntimeTypes() {
                    return AbstractVDBDeployer.this.getVDBRepository().getRuntimeTypeMap();
                }
            };
            dbStore.startEditing(true);
            dbStore.databaseCreated(new Database("x", "1"));
            dbStore.databaseSwitched("x", "1");
            dbStore.setMode(DatabaseStore.Mode.DOMAIN);
            QueryParser.getQueryParser().parseDDL(dbStore, (Reader)new StringReader(value));
            dbStore.stopEditing();
            store.addDataTypes((Map)dbStore.getDatabase("x", "1").getMetadataStore().getDatatypes());
        }
        AtomicInteger loadCount = new AtomicInteger();
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            if (model.getModelType() != Model.Type.PHYSICAL && model.getModelType() != Model.Type.VIRTUAL) continue;
            loadCount.incrementAndGet();
        }
        if (loadCount.get() == 0) {
            this.processVDBDDL(vdb, store, cmr, vdbResources);
            this.getVDBRepository().finishDeployment(vdb.getName(), vdb.getVersion());
            return;
        }
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            MetadataRepository metadataRepository = (MetadataRepository)model.getAttachment(MetadataRepository.class);
            if (model.getModelType() == Model.Type.PHYSICAL || model.getModelType() == Model.Type.VIRTUAL) {
                this.loadMetadata(vdb, model, cmr, metadataRepository, store, loadCount, vdbResources);
                LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Model ", model.getName(), "in VDB ", vdb.getName(), " was being loaded from its repository"});
                continue;
            }
            LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Model ", model.getName(), "in VDB ", vdb.getName(), " skipped being loaded because of its type ", model.getModelType()});
        }
    }

    protected abstract VDBRepository getVDBRepository();

    protected abstract void loadMetadata(VDBMetaData var1, ModelMetaData var2, ConnectorManagerRepository var3, MetadataRepository var4, MetadataStore var5, AtomicInteger var6, VDBResources var7) throws TranslatorException;

    protected void metadataLoaded(VDBMetaData vdb, ModelMetaData model, MetadataStore vdbMetadataStore, AtomicInteger loadCount, MetadataFactory factory, boolean success, ConnectorManagerRepository cmr, VDBResources vdbResources) {
        if (success) {
            factory.mergeInto(vdbMetadataStore);
            model.clearRuntimeMessages();
            model.setMetadataStatus(Model.MetadataStatus.LOADED);
        } else {
            model.setMetadataStatus(Model.MetadataStatus.FAILED);
            vdb.setStatus(VDB.Status.FAILED);
        }
        if (loadCount.decrementAndGet() == 0 || vdb.getStatus() == VDB.Status.FAILED) {
            if (vdb.getStatus() != VDB.Status.FAILED) {
                this.processVDBDDL(vdb, vdbMetadataStore, cmr, vdbResources);
            }
            this.getVDBRepository().finishDeployment(vdb.getName(), vdb.getVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processVDBDDL(final VDBMetaData vdb, MetadataStore vdbMetadataStore, final ConnectorManagerRepository cmr, final VDBResources vdbResources) {
        if (vdb.getStatus() == VDB.Status.FAILED) {
            return;
        }
        String ddl = vdb.getPropertyValue("full-ddl");
        if (ddl != null) {
            Database database = DatabaseUtil.convert((VDBMetaData)vdb, (MetadataStore)vdbMetadataStore);
            CompositeMetadataStore compositeStore = new CompositeMetadataStore(vdbMetadataStore);
            final TransformationMetadata metadata = new TransformationMetadata(vdb, compositeStore, null, this.getVDBRepository().getSystemFunctionManager().getSystemFunctions(), null).getDesignTimeMetadata();
            DeploymentBasedDatabaseStore deploymentStore = new DeploymentBasedDatabaseStore(this.getVDBRepository()){

                protected TransformationMetadata getTransformationMetadata() {
                    return metadata;
                }

                @Override
                public void importSchema(String schemaName, String serverType, String serverName, String foreignSchemaName, List<String> includeTables, List<String> excludeTables, Map<String, String> properties) {
                    ChainingMetadataRepository metadataRepository;
                    ModelMetaData model = vdb.getModel(schemaName);
                    Properties modelProperties = new Properties();
                    modelProperties.putAll((Map<?, ?>)model.getPropertiesMap());
                    modelProperties.putAll(properties);
                    if (!includeTables.isEmpty()) {
                        modelProperties.put("importer.includeTables", StringUtil.join(includeTables, (String)","));
                    }
                    if (!excludeTables.isEmpty()) {
                        modelProperties.put("importer.excludeTables", StringUtil.join(excludeTables, (String)","));
                    }
                    modelProperties.put("importer.schemaName", foreignSchemaName);
                    MetadataFactory factory = DatabaseStore.createMF((DatabaseStore)this, (Schema)this.getSchema(schemaName), (boolean)true, (Properties)modelProperties);
                    factory.setParser((Parser)new QueryParser());
                    if (vdbResources != null) {
                        factory.setVdbResources((Map)vdbResources.getEntriesPlusVisibilities());
                    }
                    factory.setVDBClassLoader((ClassLoader)vdb.getAttachment(ClassLoader.class));
                    MetadataRepository baseRepo = (MetadataRepository)model.getAttachment(MetadataRepository.class);
                    try {
                        metadataRepository = AbstractVDBDeployer.this.getMetadataRepository(serverType);
                        if (metadataRepository == null) {
                            throw new VirtualDatabaseException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40094, new Object[]{model.getName(), vdb.getName(), vdb.getVersion(), serverType}));
                        }
                    }
                    catch (VirtualDatabaseException e1) {
                        throw new MetadataException((Throwable)((Object)e1));
                    }
                    metadataRepository = new ChainingMetadataRepository(Arrays.asList(new MetadataRepositoryWrapper((MetadataRepository<?, ?>)metadataRepository, null), baseRepo));
                    ExecutionFactory ef = null;
                    Object cf = null;
                    Exception te = null;
                    for (ConnectorManager cm : AbstractVDBDeployer.this.getConnectorManagers(model, cmr)) {
                        if (te != null) {
                            LogManager.logDetail((String)"org.teiid.RUNTIME", te, (Object)"Failed to get metadata, trying next source.");
                            te = null;
                        }
                        try {
                            if (cm != null) {
                                ef = cm.getExecutionFactory();
                                cf = cm.getConnectionFactory();
                            }
                        }
                        catch (TranslatorException e) {
                            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)((Object)e), (Object)"Failed to get a connection factory for metadata load.");
                        }
                        if (LogManager.isMessageToBeRecorded((String)"org.teiid.RUNTIME", (int)6)) {
                            LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"CREATE SCHEMA", factory.getSchema().getName(), ";\n", DDLStringVisitor.getDDLString((Schema)factory.getSchema(), null, null)});
                        }
                        try {
                            metadataRepository.loadMetadata(factory, ef, cf);
                            break;
                        }
                        catch (Exception e) {
                            te = e;
                            factory = DatabaseStore.createMF((DatabaseStore)this, (Schema)this.getSchema(schemaName), (boolean)true, (Properties)modelProperties);
                            factory.setParser((Parser)new QueryParser());
                            if (vdbResources == null) continue;
                            factory.setVdbResources((Map)vdbResources.getEntriesPlusVisibilities());
                        }
                    }
                    if (te != null) {
                        if (te instanceof RuntimeException) {
                            throw (RuntimeException)te;
                        }
                        throw new MetadataException(te);
                    }
                }
            };
            deploymentStore.startEditing(false);
            deploymentStore.databaseCreated(database);
            deploymentStore.databaseSwitched(database.getName(), database.getVersion());
            deploymentStore.setMode(DatabaseStore.Mode.SCHEMA);
            try {
                QueryParser.getQueryParser().parseDDL((DatabaseStore)deploymentStore, (Reader)new StringReader(ddl));
            }
            finally {
                deploymentStore.stopEditing();
            }
            DatabaseUtil.copyDatabaseGrantsAndRoles((Database)database, (VDBMetaData)vdb);
        }
    }

    protected MetadataFactory createMetadataFactory(VDBMetaData vdb, MetadataStore store, ModelMetaData model, Map<String, ? extends VDBResource> vdbResources) {
        NavigableMap datatypes = store.getDatatypes();
        MetadataFactory factory = new MetadataFactory(vdb.getName(), (Object)vdb.getVersion(), (Map)datatypes, model);
        factory.getSchema().setPhysical(model.isSource());
        factory.setParser((Parser)new QueryParser());
        factory.setVdbResources(vdbResources);
        factory.setVDBClassLoader((ClassLoader)vdb.getAttachment(ClassLoader.class));
        return factory;
    }

    protected MetadataRepository<?, ?> getMetadataRepository(String repoType) throws VirtualDatabaseException {
        return this.repositories.get(repoType);
    }

    private static class MetadataRepositoryWrapper<F, C>
    implements MetadataRepository<F, C> {
        private MetadataRepository<F, C> repo;
        private String text;

        public MetadataRepositoryWrapper(MetadataRepository<F, C> repo, String text) {
            this.repo = repo;
            this.text = text;
        }

        public void loadMetadata(MetadataFactory factory, ExecutionFactory<F, C> executionFactory, F connectionFactory) throws TranslatorException {
            this.repo.loadMetadata(factory, executionFactory, connectionFactory, this.text);
        }
    }
}

