/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.service.buffer;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.impl.BufferFrontedFileStoreCache;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.FileStorageManager;
import org.teiid.common.buffer.impl.SplittableStorageManager;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.services.BufferServiceImpl;

public class TestLocalBufferService {
    @Test
    public void testCheckMemPropertyGotSet() throws Exception {
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/1");
        svc.setUseDisk(true);
        svc.setInlineLobs(false);
        svc.start();
        Assert.assertTrue((String)"Not Directory", (boolean)svc.getBufferDirectory().isDirectory());
        Assert.assertTrue((String)"does not exist", (boolean)svc.getBufferDirectory().exists());
        Assert.assertTrue((String)"does not end with one", (boolean)svc.getBufferDirectory().getParent().endsWith("1"));
        Assert.assertTrue((boolean)svc.isUseDisk());
        Assert.assertFalse((boolean)svc.isInlineLobs());
        BufferManagerImpl mgr = svc.getBufferManager();
        SplittableStorageManager ssm = (SplittableStorageManager)((BufferFrontedFileStoreCache)mgr.getCache()).getStorageManager();
        Assert.assertTrue((boolean)((FileStorageManager)ssm.getStorageManager()).getDirectory().endsWith(svc.getBufferDirectory().getName()));
    }

    @Test
    public void testCheckMemPropertyGotSet2() throws Exception {
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/1");
        svc.setUseDisk(false);
        svc.start();
        Assert.assertFalse((boolean)svc.isUseDisk());
    }

    @Test
    public void testSchemaSize() throws Exception {
        int i;
        ArrayList<Constant> schema = new ArrayList<Constant>();
        for (i = 0; i < 82; ++i) {
            schema.add(new Constant(null, DataTypeManager.DefaultDataClasses.STRING));
        }
        for (i = 0; i < 11; ++i) {
            schema.add(new Constant(null, DataTypeManager.DefaultDataClasses.DATE));
        }
        schema.add(new Constant(null, DataTypeManager.DefaultDataClasses.LONG));
        schema.add(new Constant(null, DataTypeManager.DefaultDataClasses.SHORT));
        for (i = 0; i < 20; ++i) {
            schema.add(new Constant(null, DataTypeManager.DefaultDataClasses.BIG_DECIMAL));
        }
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/1");
        svc.setUseDisk(false);
        svc.start();
        BufferManagerImpl mgr = svc.getBufferManager();
        Assert.assertEquals((long)0x335500L, (long)mgr.getSchemaSize(schema));
        Assert.assertEquals((long)128L, (long)mgr.getProcessorBatchSize(schema));
    }

    @Test
    public void testStateTransfer() throws Exception {
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/1");
        svc.setUseDisk(true);
        svc.start();
        BufferManagerImpl mgr = svc.getBufferManager();
        ArrayList<ElementSymbol> schema = new ArrayList<ElementSymbol>(2);
        ElementSymbol es = new ElementSymbol("x");
        es.setType(DataTypeManager.getDataTypeClass((String)"string"));
        schema.add(es);
        ElementSymbol es2 = new ElementSymbol("y");
        es2.setType(DataTypeManager.getDataTypeClass((String)"integer"));
        schema.add(es2);
        TupleBuffer buffer = mgr.createTupleBuffer(schema, "cached", BufferManager.TupleSourceType.FINAL);
        buffer.setBatchSize(50);
        buffer.setId("state_id");
        for (int batch = 0; batch < 3; ++batch) {
            for (int row = 0; row < 50; ++row) {
                int val = batch * 50 + row;
                buffer.addTuple(Arrays.asList("String" + val, new Integer(val)));
            }
        }
        buffer.close();
        mgr.distributeTupleBuffer(buffer.getId(), buffer);
        FileOutputStream fo = new FileOutputStream(UnitTestUtil.getTestScratchPath() + "/teiid/statetest");
        mgr.getState(buffer.getId(), (OutputStream)fo);
        fo.close();
        svc.stop();
        BufferServiceImpl svc2 = new BufferServiceImpl();
        svc2.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/2");
        svc2.setUseDisk(true);
        svc2.start();
        BufferManagerImpl mgr2 = svc2.getBufferManager();
        FileInputStream fis = new FileInputStream(UnitTestUtil.getTestScratchPath() + "/teiid/statetest");
        mgr2.setState(buffer.getId(), (InputStream)fis);
        fis.close();
        String id = "state_id";
        buffer = mgr2.getTupleBuffer(id);
        for (int batch = 0; batch < 3; ++batch) {
            TupleBatch tb = buffer.getBatch((long)(batch * 50 + 1));
            List[] rows = tb.getAllTuples();
            for (int row = 0; row < 50; ++row) {
                int val = batch * 50 + row;
                Assert.assertEquals((Object)("String" + val), rows[row].get(0));
                Assert.assertEquals((Object)val, rows[row].get(1));
            }
        }
        svc2.stop();
    }

    @Test
    public void testUseDiskFalse() throws Exception {
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/1");
        svc.setUseDisk(false);
        svc.start();
        BufferManagerImpl mgr = svc.getBufferManager();
        FileStore f = mgr.getCache().createFileStore("x");
        f.write(new byte[1234], 0, 1234);
    }

    @Test
    public void testFixedSizing() throws Exception {
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/1");
        svc.setVmMaxMemory(0x380000000L);
        svc.setMaxReservedHeapMb(10240);
        svc.start();
        BufferManagerImpl impl = svc.getBufferManager();
        BufferFrontedFileStoreCache cache = (BufferFrontedFileStoreCache)impl.getCache();
        Assert.assertEquals((long)0x40000000L, (long)cache.getMemoryBufferSpace());
    }
}

