/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.UDFSource;

public class UDFMetaData {
    protected TreeMap<String, UDFSource> methods = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private ClassLoader classLoader;

    public Map<String, UDFSource> getFunctions() {
        return this.methods;
    }

    public void addFunctions(String name, Collection<FunctionMethod> funcs) {
        if (funcs.isEmpty()) {
            return;
        }
        UDFSource udfSource = this.methods.get(name);
        if (udfSource != null) {
            ArrayList<FunctionMethod> allMethods = new ArrayList<FunctionMethod>(udfSource.getFunctionMethods());
            allMethods.addAll(funcs);
            ClassLoader cl = udfSource.getClassLoader();
            udfSource = new UDFSource(allMethods);
            udfSource.setClassLoader(cl);
        } else {
            udfSource = new UDFSource(funcs);
            udfSource.setClassLoader(this.classLoader);
        }
        this.methods.put(name, udfSource);
    }

    public void addFunctions(UDFMetaData funcs) {
        this.methods.putAll(funcs.methods);
        this.classLoader = funcs.classLoader;
    }

    public void setFunctionClassLoader(ClassLoader functionClassLoader) {
        for (UDFSource udf : this.methods.values()) {
            udf.setClassLoader(functionClassLoader);
        }
        this.classLoader = functionClassLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

