/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.TestEmbeddedServer;

public class TestOverrideTranslators {
    EmbeddedServer es;

    @Before
    public void setup() {
        this.es = new EmbeddedServer(){

            protected boolean allowOverrideTranslators() {
                return true;
            }
        };
    }

    @After
    public void teardown() {
        if (this.es != null) {
            this.es.stop();
        }
    }

    @Ignore(value="the handling for this is in teiid spring boot")
    @Test
    public void testOverrideTranslator() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        this.es.addTranslator(TestEmbeddedServer.DummyExecutionFactory.class);
        String ddl = "CREATE DATABASE db;\nUSE DATABASE db;\nCREATE FOREIGN DATA WRAPPER myloopback handler dummy OPTIONS (supportsOrderBy true);\nCREATE SERVER salesforce FOREIGN DATA WRAPPER myloopback;\nCREATE SCHEMA sf SERVER salesforce;\nIMPORT FROM SERVER salesforce INTO sf OPTIONS(\"importer.useFullSchemaName\" 'false');";
        this.es.getAdmin().deploy("x-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl.getBytes("UTF-8")));
    }

    @Test
    public void testImplicitTranslatorReference() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        this.es.addTranslator(TestEmbeddedServer.DummyExecutionFactory.class);
        String ddl = "CREATE DATABASE db;\nUSE DATABASE db;\nCREATE SERVER salesforce FOREIGN DATA WRAPPER dummy;\nCREATE SCHEMA sf SERVER salesforce;\nIMPORT FROM SERVER salesforce INTO sf OPTIONS(\"importer.useFullSchemaName\" 'false');";
        this.es.getAdmin().deploy("x-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl.getBytes("UTF-8")));
    }
}

