/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.service.SessionService;
import org.teiid.logging.LogManager;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.jmx.Cache;
import org.teiid.runtime.jmx.Teiid;
import org.teiid.services.BufferServiceImpl;

public class JMXService {
    public static String TEIID = "org.teiid:type=Runtime";
    public static String CACHE_PREFIX = "org.teiid:type=Cache,name=";
    private DQPCore dqp;
    private BufferServiceImpl bufferService;
    private SessionService sessionService;
    private MBeanServer server;
    private Set<String> registerdBeans = new HashSet<String>();

    public JMXService(DQPCore dqpCore, BufferServiceImpl bufferServiceImpl, SessionService sessionService) {
        this.dqp = dqpCore;
        this.bufferService = bufferServiceImpl;
        this.sessionService = sessionService;
        this.server = ManagementFactory.getPlatformMBeanServer();
    }

    void setServer(MBeanServer server) {
        this.server = server;
    }

    public synchronized void registerBeans() {
        try {
            this.register(new Teiid(this.dqp, this.sessionService, this.bufferService), TEIID);
            this.register(new Cache(this.dqp.getPrepPlanCache()), CACHE_PREFIX + "PreparedPlan");
            this.register(new Cache(this.dqp.getResltSetCache()), CACHE_PREFIX + "ResultSet");
        }
        catch (MBeanRegistrationException | OperationsException e) {
            LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)"JMX Registration Exception - it's likely another Teiid instance is running in this VM");
        }
    }

    public synchronized void unregisterBeans() {
        this.registerdBeans.forEach(name -> {
            try {
                this.server.unregisterMBean(new ObjectName((String)name));
            }
            catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException jMException) {
                // empty catch block
            }
        });
        this.registerdBeans.clear();
    }

    void register(Object mbean, String name) throws OperationsException, MBeanRegistrationException {
        this.server.registerMBean(mbean, new ObjectName(name));
        this.registerdBeans.add(name);
    }

    public static void main(String[] args) throws Exception {
        EmbeddedServer es = new EmbeddedServer();
        es.start(new EmbeddedConfiguration());
        Thread.sleep(1000000L);
    }
}

