/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.runtime.DoNothingSecurityHelper;
import org.teiid.security.Credentials;
import org.teiid.security.SecurityHelper;
import org.teiid.services.SessionServiceImpl;
import org.teiid.vdb.runtime.VDBKey;

public class TestSessionServiceImpl {
    SessionServiceImpl ssi;

    @Before
    public void setup() {
        this.ssi = new SessionServiceImpl();
        this.ssi.setSecurityHelper((SecurityHelper)new DoNothingSecurityHelper());
    }

    @Test
    public void testActiveVDBWithNoVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getLiveVDB("name")).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        this.ssi.getActiveVDB("name", null);
        ((VDBRepository)Mockito.verify((Object)repo, (VerificationMode)Mockito.times((int)1))).getLiveVDB("name");
    }

    @Test
    public void testActiveVDBWithSemanticVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name.1.2.3");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getLiveVDB("name.1.2.3")).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        this.ssi.getActiveVDB("name.1.2.3", null);
        ((VDBRepository)Mockito.verify((Object)repo, (VerificationMode)Mockito.times((int)1))).getLiveVDB("name.1.2.3");
    }

    @Test
    public void testActiveVDBWithVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getLiveVDB("name", (Object)"1")).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        this.ssi.getActiveVDB("name", "1");
        ((VDBRepository)Mockito.verify((Object)repo, (VerificationMode)Mockito.times((int)1))).getLiveVDB("name", (Object)"1");
    }

    @Test
    public void testActiveVDBNameWithVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getLiveVDB("name", (Object)"1")).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        this.ssi.getActiveVDB("name", "1");
        ((VDBRepository)Mockito.verify((Object)repo, (VerificationMode)Mockito.times((int)1))).getLiveVDB("name", (Object)"1");
    }

    @Test
    public void testActiveVDBNameWithVersionNonInteger() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getLiveVDB("name", (Object)1)).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        Assert.assertNull((Object)this.ssi.getActiveVDB("name.x", null));
    }

    @Test
    public void testActiveVDBNameWithVersionAndVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getLiveVDB("name", (Object)1)).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        Assert.assertNull((Object)this.ssi.getActiveVDB("name.1", "1"));
        Assert.assertNull((Object)this.ssi.getActiveVDB("name..1", null));
    }

    @Test
    public void testSecurityDomain() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        vdb.addProperty("security-domain", "domain");
        Mockito.stub((Object)repo.getLiveVDB("name", (Object)"1")).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        Properties properties = new Properties();
        properties.setProperty("VirtualDatabaseName", "name.1");
        SessionMetadata s = this.ssi.createSession("name", "1", AuthenticationType.USERPASSWORD, "x", new Credentials(new char[]{'y'}), "z", properties);
        Assert.assertEquals((Object)"domain", (Object)s.getSecurityDomain());
    }

    @Test
    public void testLegacySecurityDomain() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getLiveVDB("name", (Object)"1")).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        this.ssi.setSecurityDomain("sd");
        Properties properties = new Properties();
        properties.setProperty("VirtualDatabaseName", "name.1");
        SessionMetadata s = this.ssi.createSession("name", "1", AuthenticationType.USERPASSWORD, "x@sd", new Credentials(new char[]{'y'}), "z", properties);
        Assert.assertEquals((Object)"sd", (Object)s.getSecurityDomain());
        s = this.ssi.createSession("name", "1", AuthenticationType.USERPASSWORD, "x", new Credentials(new char[]{'y'}), "z", properties);
        Assert.assertEquals((Object)"sd", (Object)s.getSecurityDomain());
        s = this.ssi.createSession("name", "1", AuthenticationType.USERPASSWORD, "x@sd", new Credentials(new char[]{'y'}), "z", properties);
        Assert.assertEquals((Object)"sd", (Object)s.getSecurityDomain());
        Assert.assertEquals((Object)"x@sd", (Object)s.getUserName());
    }

    @Test
    public void testAuthenticationType() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        vdb.addProperty("security-domain", "domain");
        vdb.addProperty("gss-pattern", "x");
        Mockito.stub((Object)repo.getLiveVDB("name", (Object)"1")).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        this.ssi.setAuthenticationType(AuthenticationType.USERPASSWORD);
        Assert.assertEquals((Object)AuthenticationType.GSS, (Object)this.ssi.getAuthenticationType("name", "1", "x"));
        Assert.assertEquals((Object)AuthenticationType.USERPASSWORD, (Object)this.ssi.getAuthenticationType("name", "1", "y"));
        Assert.assertEquals((Object)AuthenticationType.USERPASSWORD, (Object)this.ssi.getAuthenticationType("name", "1", "z"));
        vdb = new VDBMetaData();
        vdb.setName("name1");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        vdb.addProperty("security-domain", "domain");
        vdb.addProperty("authentication-type", "GSS");
        Mockito.stub((Object)repo.getLiveVDB("name1", (Object)"1")).toReturn((Object)vdb);
        Assert.assertEquals((Object)AuthenticationType.GSS, (Object)this.ssi.getAuthenticationType("name1", "1", "x"));
        Assert.assertEquals((Object)AuthenticationType.GSS, (Object)this.ssi.getAuthenticationType("name1", "1", "y"));
        vdb = new VDBMetaData();
        vdb.setName("name2");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getLiveVDB("name2", (Object)"1")).toReturn((Object)vdb);
        Assert.assertEquals((Object)AuthenticationType.USERPASSWORD, (Object)this.ssi.getAuthenticationType("name2", "1", "x"));
        Assert.assertEquals((Object)AuthenticationType.USERPASSWORD, (Object)this.ssi.getAuthenticationType("name2", "1", "y"));
        this.ssi.setAuthenticationType(AuthenticationType.GSS);
        Assert.assertEquals((Object)AuthenticationType.GSS, (Object)this.ssi.getAuthenticationType("name2", "1", "x"));
        Assert.assertEquals((Object)AuthenticationType.GSS, (Object)this.ssi.getAuthenticationType("name2", "1", "y"));
    }

    @Test
    public void testMaxSessionsPerUser() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        vdb.addProperty("max-sessions-per-user", "1");
        vdb.addAttachment(VDBKey.class, (Object)new VDBKey("x", (Object)1));
        Mockito.stub((Object)repo.getLiveVDB("name", (Object)"1")).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        Properties properties = new Properties();
        properties.setProperty("VirtualDatabaseName", "name.1");
        this.ssi.createSession("name", "1", AuthenticationType.USERPASSWORD, "x", new Credentials(new char[]{'y'}), "z", properties);
        try {
            this.ssi.createSession("name", "1", AuthenticationType.USERPASSWORD, "x", new Credentials(new char[]{'y'}), "z", properties);
            Assert.fail();
        }
        catch (SessionServiceException sessionServiceException) {
            // empty catch block
        }
    }
}

