/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadatastore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Identity;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.FileUtils;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.VDBRepository;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.metadata.MetadataRepository;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.runtime.EmbeddedAdminImpl;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.runtime.TestEmbeddedServer;
import org.teiid.runtime.util.ConvertVDB;
import org.teiid.security.Credentials;
import org.teiid.security.GSSResult;
import org.teiid.security.SecurityHelper;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.file.FileExecutionFactory;
import org.teiid.vdb.runtime.VDBKey;

public class TestDDLMetadataStore {
    static ExtendedEmbeddedServer es;

    @Before
    public void setup() {
        FileUtils.removeDirectoryAndChildren((File)new File(UnitTestUtil.getTestScratchPath()));
        es = new ExtendedEmbeddedServer();
    }

    @After
    public void teardown() {
        if (es != null) {
            es.stop();
        }
    }

    @Test
    public void testVDBExport() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        ec.setSecurityHelper((SecurityHelper)new ThreadLocalSecurityHelper());
        es.addTranslator("y", new TestEmbeddedServer.FakeTranslator(false));
        es.start(ec);
        AtomicInteger counter = new AtomicInteger();
        EmbeddedServer.SimpleConnectionFactoryProvider cfp = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)counter);
        es.addConnectionFactoryProvider("z", (EmbeddedServer.ConnectionFactoryProvider)cfp);
        es.addMetadataRepository("myrepo", (MetadataRepository)Mockito.mock(MetadataRepository.class));
        es.deployVDB(new FileInputStream(UnitTestUtil.getTestDataPath() + "/first-db.ddl"), true);
        Admin admin = es.getAdmin();
        VDBMetaData vdb = (VDBMetaData)admin.getVDB("empty", "2");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        VDBMetadataParser.marshall((VDBMetaData)vdb, (OutputStream)out);
        String expected = ObjectConverterUtil.convertFileToString((File)new File(UnitTestUtil.getTestDataPath() + "/first-vdb.xml"));
        Assert.assertEquals((Object)expected, (Object)new String(out.toByteArray()));
        String exportedDdl = admin.getSchema("empty", "2", null, null, null);
        Assert.assertEquals((Object)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"first-vdb.ddl")), (Object)exportedDdl);
    }

    @Test
    public void testRoles() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        ec.setSecurityHelper((SecurityHelper)new ThreadLocalSecurityHelper());
        es.addTranslator("y", new TestEmbeddedServer.FakeTranslator(false));
        es.addTranslator("y2", new TestEmbeddedServer.FakeTranslator(false));
        AtomicInteger counter = new AtomicInteger();
        EmbeddedServer.SimpleConnectionFactoryProvider cfp = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)counter);
        es.addConnectionFactoryProvider("z", (EmbeddedServer.ConnectionFactoryProvider)cfp);
        es.start(ec);
        es.addMetadataRepository("myrepo", (MetadataRepository)Mockito.mock(MetadataRepository.class));
        es.deployVDB(new FileInputStream(UnitTestUtil.getTestDataPath() + "/first-db.ddl"), true);
        TeiidDriver td = es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:empty", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from mytable");
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"my-column", (Object)rs.getMetaData().getColumnLabel(1));
        s.execute("update mytable set \"my-column\" = 'a'");
        Assert.assertEquals((long)2L, (long)s.getUpdateCount());
        try {
            s.execute("delete from mytable where \"my-column\" = 'a'");
            Assert.fail((String)"should have stopped by roles");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testConvertVDBXML() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        es.addTranslator("file", (ExecutionFactory)new FileExecutionFactory());
        es.addTranslator("h2", new ExecutionFactory());
        es.start(ec);
        FileInputStream vdb = new FileInputStream(UnitTestUtil.getTestDataPath() + "/portfolio-vdb.xml");
        es.deployVDB(vdb);
        String content = ConvertVDB.convert((File)new File(UnitTestUtil.getTestDataPath() + "/portfolio-vdb.xml"));
        es.undeployVDB("Portfolio");
        String expected = ObjectConverterUtil.convertFileToString((File)new File(UnitTestUtil.getTestDataPath() + "/portfolio-vdb.ddl"));
        Assert.assertEquals((Object)expected, (Object)content);
        try {
            es.getAdmin().deploy("portfolio-vdb.ddl", (InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")));
            Assert.fail();
        }
        catch (AdminProcessingException adminProcessingException) {
            // empty catch block
        }
    }

    @Test
    public void testMigrateVDBXML() throws Exception {
        File vdb = new File(UnitTestUtil.getTestDataPath() + "/portfolio-vdb.xml");
        String content = ConvertVDB.convert((File)vdb);
        String expected = ObjectConverterUtil.convertFileToString((File)new File(UnitTestUtil.getTestDataPath() + "/portfolio-converted-vdb.ddl"));
        Assert.assertEquals((Object)expected, (Object)content);
    }

    @Test
    public void testOverideTranslator() throws Exception {
        File vdb = new File(UnitTestUtil.getTestDataPath() + "/override-vdb.xml");
        String content = ConvertVDB.convert((File)vdb);
        String expected = ObjectConverterUtil.convertFileToString((File)new File(UnitTestUtil.getTestDataPath() + "/override-vdb.ddl"));
        Assert.assertEquals((Object)expected, (Object)content);
    }

    @Test
    public void testMultiSource() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        es.start(ec);
        es.addTranslator(FileExecutionFactory.class);
        es.deployVDB(new FileInputStream(UnitTestUtil.getTestDataPath() + "/multisource-vdb.ddl"), true);
        es.getAdmin().addSource("multisource", "1", "MarketData", "x", "file", "z");
        ConnectionImpl c = es.getDriver().connect("jdbc:teiid:multisource", null);
        DatabaseMetaData dmd = c.getMetaData();
        ResultSet rs = dmd.getProcedureColumns(null, null, "deleteFile", null);
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testPolicies() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        es.addTranslator("file", (ExecutionFactory)new FileExecutionFactory());
        es.addTranslator("h2", new ExecutionFactory());
        es.start(ec);
        FileInputStream vdb = new FileInputStream(UnitTestUtil.getTestDataPath() + "/portfolio-vdb.xml");
        es.deployVDB(vdb);
        CompositeVDB cvdb = es.getVDBRepository().getCompositeVDB(new VDBKey("portfolio", (Object)1));
        TransformationMetadata metadata = (TransformationMetadata)cvdb.getVDB().getAttachment(TransformationMetadata.class);
        Assert.assertEquals((Object)"[Accounts[R], Accounts.Account.SSN[ mask null], Accounts.Customer[ condition state <> 'New York'], Accounts.Customer.SSN[ mask null], MarketData[R], Stocks[R], Stocks.StockPrices.Price[ mask CASE WHEN hasRole('Prices') = true THEN Price END order 1]]", (Object)((DataPolicyMetadata)metadata.getPolicies().get("ReadOnly")).getPermissions().toString());
    }

    public static class ThreadLocalSecurityHelper
    implements SecurityHelper {
        private static ThreadLocal<Subject> threadLocalContext = new ThreadLocal();

        public Object associateSecurityContext(Object context) {
            Subject previous = threadLocalContext.get();
            threadLocalContext.set((Subject)context);
            return previous;
        }

        public Object getSecurityContext(String securityDomain) {
            return threadLocalContext.get();
        }

        public void clearSecurityContext() {
            threadLocalContext.remove();
        }

        public Object authenticate(String securityDomain, String baseUserName, Credentials credentials, String applicationName) throws LoginException {
            Subject subject = new Subject();
            subject.getPrincipals().add(new SimplePrincipal("superuser"));
            SimpleGroup rolesGroup = new SimpleGroup("Roles");
            rolesGroup.addMember(new SimplePrincipal("superuser"));
            rolesGroup.addMember(new SimplePrincipal("admin"));
            subject.getPrincipals().add(rolesGroup);
            return subject;
        }

        public Subject getSubjectInContext(Object context) {
            return (Subject)context;
        }

        public GSSResult negotiateGssLogin(String securityDomain, byte[] serviceTicket) throws LoginException {
            return null;
        }
    }

    private static class SimpleGroup
    extends SimplePrincipal
    implements Group {
        private HashSet<Principal> members = new HashSet();

        private SimpleGroup(String name) {
            super(name);
        }

        public boolean addMember(Principal user) {
            return this.members.add(user);
        }

        public boolean isMember(Principal member) {
            return this.members.contains(member);
        }

        public Enumeration<? extends Principal> members() {
            return Collections.enumeration(this.members);
        }

        public boolean removeMember(Principal user) {
            return this.members.remove(user);
        }
    }

    private static class SimplePrincipal
    extends Identity {
        private SimplePrincipal(String name) {
            super(name);
        }
    }

    private static class DatasourceAwareEmbeddedAdmin
    extends EmbeddedAdminImpl {
        HashSet<String> datasourceNames = new HashSet();

        public DatasourceAwareEmbeddedAdmin(EmbeddedServer embeddedServer) {
            super(embeddedServer);
        }

        public void createDataSource(String deploymentName, String templateName, Properties properties) throws AdminException {
            if (deploymentName.equals("z") && templateName.equals("custom")) {
                AtomicInteger counter = new AtomicInteger();
                EmbeddedServer.SimpleConnectionFactoryProvider cfp = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)counter);
                es.addConnectionFactoryProvider(deploymentName, (EmbeddedServer.ConnectionFactoryProvider)cfp);
                this.datasourceNames.add(deploymentName);
            }
        }

        public Collection<? extends PropertyDefinition> getTemplatePropertyDefinitions(String templateName) throws AdminException {
            return Collections.emptyList();
        }

        public Properties getDataSource(String deployedName) throws AdminException {
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40137, new Object[]{"getDataSource"}));
        }

        public void deleteDataSource(String deployedName) throws AdminException {
            if (deployedName.equals("z")) {
                this.datasourceNames.remove(deployedName);
            }
        }

        public Collection<String> getDataSourceNames() throws AdminException {
            return this.datasourceNames;
        }

        public Set<String> getDataSourceTemplateNames() throws AdminException {
            HashSet<String> names = new HashSet<String>();
            names.add("custom");
            return names;
        }
    }

    static final class ExtendedEmbeddedServer
    extends EmbeddedServer {
        ExtendedEmbeddedServer() {
        }

        public Admin getAdmin() {
            return new DatasourceAwareEmbeddedAdmin(this);
        }

        public VDBRepository getVDBRepository() {
            return super.getVDBRepository();
        }
    }
}

