/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.client.DQP;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.client.util.ResultsReceiver;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.crypto.Cryptor;
import org.teiid.core.crypto.NullCryptor;
import org.teiid.core.util.ApplicationInfo;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.HostInfo;
import org.teiid.net.TeiidURL;
import org.teiid.net.socket.Message;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.net.socket.SocketServerInstance;
import org.teiid.net.socket.SocketServerInstanceFactory;
import org.teiid.net.socket.SocketServerInstanceImpl;
import org.teiid.net.socket.UrlServerDiscovery;
import org.teiid.transport.ClientInstance;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.ServerWorkItem;

public class TestSocketRemoting {
    @Test
    public void testUnckedException() throws Exception {
        FakeClientServerInstance serverInstance = new FakeClientServerInstance(null);
        try {
            this.createFakeConnection(serverInstance);
            Assert.fail((String)"expected exception");
        }
        catch (CommunicationException e) {
            Assert.assertEquals((Object)"TEIID20018 Unable to find a component used authenticate on to Teiid", (Object)e.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testMethodInvocation() throws Exception {
        ClientServiceRegistryImpl csr = new ClientServiceRegistryImpl(){

            public ClassLoader getCallerClassloader() {
                return ((Object)((Object)this)).getClass().getClassLoader();
            }
        };
        csr.registerClientService(ILogon.class, (Object)new ILogon(){

            public ResultsFuture<?> logoff() throws InvalidSessionException {
                ResultsFuture result = new ResultsFuture();
                result.getResultsReceiver().exceptionOccurred((Throwable)new TeiidComponentException("some exception"));
                return result;
            }

            public LogonResult logon(Properties connectionProperties) throws LogonException, TeiidComponentException {
                return new LogonResult();
            }

            public ResultsFuture<?> ping() throws InvalidSessionException, TeiidComponentException {
                return null;
            }

            public ResultsFuture<?> ping(Collection<String> sessions) throws TeiidComponentException, CommunicationException {
                return null;
            }

            public void assertIdentity(SessionToken sessionId) throws InvalidSessionException, TeiidComponentException {
            }

            public LogonResult neogitiateGssLogin(Properties connectionProperties, byte[] serviceToken, boolean createSession) throws LogonException {
                return null;
            }
        }, "foo");
        csr.registerClientService(FakeService.class, (Object)new FakeServiceImpl(), "foo");
        FakeClientServerInstance serverInstance = new FakeClientServerInstance(csr);
        SocketServerConnection connection = this.createFakeConnection(serverInstance);
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        ResultsFuture result = logon.ping();
        Assert.assertNull(result.get(0L, TimeUnit.MILLISECONDS));
        result = logon.logoff();
        try {
            result.get(0L, TimeUnit.MICROSECONDS);
            Assert.fail((String)"exception expected");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TeiidComponentException));
        }
        FakeService service = (FakeService)connection.getService(FakeService.class);
        ResultsFuture<Integer> asynchInteger = service.asynchResult();
        Assert.assertEquals((Object)new Integer(5), asynchInteger.get(0L, TimeUnit.MILLISECONDS));
        try {
            service.exceptionMethod();
            Assert.fail((String)"exception expected");
        }
        catch (TeiidProcessingException teiidProcessingException) {
            // empty catch block
        }
        DQP dqp = (DQP)connection.getService(DQP.class);
        try {
            ResultsFuture future = dqp.begin();
            future.get();
            Assert.fail((String)"exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((e.getMessage().indexOf("Component not found:") != -1 ? 1 : 0) != 0);
        }
    }

    private SocketServerConnection createFakeConnection(final FakeClientServerInstance serverInstance) throws CommunicationException, ConnectionException {
        SocketServerConnection connection = new SocketServerConnection(new SocketServerInstanceFactory(){

            public SocketServerInstance getServerInstance(HostInfo info) throws CommunicationException, IOException {
                return serverInstance;
            }

            public String resolveHostname(InetAddress addr) {
                return null;
            }
        }, false, new UrlServerDiscovery(new TeiidURL("0.0.0.0", 1, false)), new Properties());
        return connection;
    }

    private static class FakeClientServerInstance
    extends SocketServerInstanceImpl
    implements ClientInstance {
        ClientServiceRegistryImpl server;
        private ResultsReceiver<Object> listener;

        public FakeClientServerInstance(ClientServiceRegistryImpl server) throws UnknownHostException {
            super(new HostInfo("foo", new InetSocketAddress(InetAddress.getLocalHost(), 1)), 1000L, 1000);
            this.server = server;
        }

        public boolean isOpen() {
            return true;
        }

        public void send(Message message, ResultsReceiver<Object> l, Serializable messageKey) throws CommunicationException, InterruptedException {
            ServerWorkItem workItem = new ServerWorkItem((ClientInstance)this, messageKey, message, this.server);
            this.listener = l;
            workItem.run();
        }

        public void shutdown() {
        }

        public Cryptor getCryptor() {
            return new NullCryptor();
        }

        public DQPWorkContext getWorkContext() {
            return new DQPWorkContext();
        }

        public void send(Message message, Serializable messageKey) {
            this.listener.receiveResults(message.getContents());
        }

        public String getServerVersion() {
            return ApplicationInfo.getInstance().getReleaseNumber();
        }
    }

    static class FakeServiceImpl
    implements FakeService {
        FakeServiceImpl() {
        }

        @Override
        public ResultsFuture<Integer> asynchResult() {
            ResultsFuture result = new ResultsFuture();
            result.getResultsReceiver().receiveResults((Object)new Integer(5));
            return result;
        }

        @Override
        public String exceptionMethod() throws TeiidProcessingException {
            throw new TeiidProcessingException();
        }

        @Override
        public int lobMethod(InputStream is, Reader r) throws IOException {
            return ObjectConverterUtil.convertToByteArray((InputStream)is).length + ObjectConverterUtil.convertToString((Reader)r).length();
        }

        @Override
        public Reader getReader() throws IOException {
            return new StringReader("hello world");
        }

        @Override
        public ResultsFuture<Integer> delayedAsynchResult() {
            ResultsFuture result = new ResultsFuture();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            result.getResultsReceiver().receiveResults((Object)new Integer(5));
            return result;
        }
    }

    public static interface FakeService {
        public ResultsFuture<Integer> asynchResult();

        public ResultsFuture<Integer> delayedAsynchResult();

        public String exceptionMethod() throws TeiidProcessingException;

        public int lobMethod(InputStream var1, Reader var2) throws IOException;

        public Reader getReader() throws IOException;
    }
}

