/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.logging.Logger;
import org.teiid.metadata.Database;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.DatabaseUtil;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.JBossLogger;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class ConvertVDB {
    public static void main(String[] args) throws Exception {
        File f;
        if (args.length < 1) {
            System.out.println("usage: CovertVDB /path/to/file-vdb.xml [/path/to/writefile-vdb.ddl]");
            System.exit(0);
        }
        if (!(f = new File(args[0])).exists()) {
            System.out.println("vdb file " + f.getAbsolutePath() + " does not exist");
            return;
        }
        if (f.getName().toLowerCase().endsWith(".xml")) {
            if (args.length > 1 && args[1] != null) {
                System.out.println("Writing to file " + args[1]);
                ObjectConverterUtil.write((byte[])ConvertVDB.convert(f).getBytes("UTF-8"), (String)new File(args[1]).getAbsolutePath());
            } else {
                System.out.println(ConvertVDB.convert(f));
            }
        } else {
            System.out.println("Unknown file type supplied, only .XML based VDBs are supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convert(File f) throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, IOException, URISyntaxException, MalformedURLException, AdminException, Exception, FileNotFoundException {
        LogManager.setLogListener((Logger)new JBossLogger(){

            @Override
            public boolean isEnabled(String context, int level) {
                return false;
            }
        });
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        MyServer es = new MyServer();
        LogManager.setLogListener((Logger)new JBossLogger(){

            @Override
            public boolean isEnabled(String context, int level) {
                return false;
            }
        });
        es.start(ec);
        try {
            String string = es.convertVDB(new FileInputStream(f));
            return string;
        }
        finally {
            es.stop();
        }
    }

    private static class MyServer
    extends EmbeddedServer {
        private MyServer() {
        }

        @Override
        public ExecutionFactory<Object, Object> getExecutionFactory(String name) throws ConnectorManagerRepository.ConnectorManagerException {
            return new ExecutionFactory<Object, Object>(){

                public boolean isSourceRequired() {
                    return false;
                }

                public boolean isSourceRequiredForMetadata() {
                    return false;
                }
            };
        }

        String convertVDB(InputStream is) throws Exception {
            byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)is);
            VDBMetaData metadata = null;
            try {
                metadata = VDBMetadataParser.unmarshall((InputStream)new ByteArrayInputStream(bytes));
            }
            catch (XMLStreamException e) {
                throw new VirtualDatabaseException(e);
            }
            metadata.setXmlDeployment(true);
            MetadataStore metadataStore = new MetadataStore();
            final LinkedHashMap modelMetaDatas = metadata.getModelMetaDatas();
            for (ModelMetaData m : modelMetaDatas.values()) {
                Schema schema = new Schema();
                schema.setName(m.getName());
                schema.setAnnotation(m.getDescription());
                schema.setVisible(m.isVisible());
                schema.setPhysical(m.isSource());
                schema.setProperties(m.getPropertiesMap());
                metadataStore.addSchema(schema);
            }
            Database db = DatabaseUtil.convert((VDBMetaData)metadata, (MetadataStore)metadataStore);
            DDLStringVisitor visitor = new DDLStringVisitor(null, null){

                protected void createdSchmea(Schema schema) {
                }

                protected void visit(Schema schema) {
                    ModelMetaData m = (ModelMetaData)modelMetaDatas.get(schema.getName());
                    String replace = "";
                    String sourceName = m.getSourceNames().isEmpty() ? "" : (String)m.getSourceNames().get(0);
                    String schemaName = (String)m.getPropertiesMap().get("importer.schemaPattern");
                    if (m.getSourceMetadataType().isEmpty()) {
                        if (m.isSource()) {
                            replace = this.replaceMetadataTag(m, sourceName, schemaName, true);
                        }
                    } else {
                        for (int i = 0; i < m.getSourceMetadataType().size(); ++i) {
                            String type = (String)m.getSourceMetadataType().get(i);
                            StringTokenizer st = new StringTokenizer(type, ",");
                            while (st.hasMoreTokens()) {
                                type = st.nextToken().trim();
                                if (type.equalsIgnoreCase("NATIVE")) {
                                    replace = replace + this.replaceMetadataTag(m, sourceName, schemaName, true);
                                    continue;
                                }
                                if (!type.equalsIgnoreCase("DDL")) {
                                    replace = replace + this.replaceMetadataTag(m, type, schemaName, false);
                                    continue;
                                }
                                replace = replace + (String)m.getSourceMetadataText().get(i) + "\n";
                            }
                        }
                    }
                    this.buffer.append(replace);
                }
            };
            visitor.visit(db);
            return visitor.toString();
        }

        private String replaceMetadataTag(ModelMetaData m, String sourceName, String schemaName, boolean server) {
            String replace = "IMPORT";
            if (schemaName != null) {
                replace = replace + " FOREIGN SCHEMA " + SQLStringVisitor.escapeSinglePart((String)schemaName);
            }
            replace = replace + " FROM " + (server ? "SERVER " : "REPOSITORY ") + SQLStringVisitor.escapeSinglePart((String)sourceName) + " INTO " + SQLStringVisitor.escapeSinglePart((String)m.getName());
            if (!m.getPropertiesMap().isEmpty()) {
                replace = replace + " OPTIONS (\n";
                Iterator it = m.getPropertiesMap().keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    replace = replace + "\t" + SQLStringVisitor.escapeSinglePart((String)key) + " '" + StringUtil.replaceAll((String)((String)m.getPropertiesMap().get(key)), (String)"'", (String)"''") + "'";
                    if (!it.hasNext()) continue;
                    replace = replace + ",\n";
                }
                replace = replace + ")";
            }
            replace = replace + ";\n\n";
            return replace;
        }

        @Override
        protected boolean allowOverrideTranslators() {
            return true;
        }
    }
}

