/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.teiid.net.socket.SocketUtil;

public class SSLConfiguration {
    public static final String ONEWAY = "1-way";
    public static final String TWOWAY = "2-way";
    @Deprecated
    public static final String ANONYMOUS = "anonymous";
    public static final String LOGIN = "login";
    public static final String DISABLED = "disabled";
    public static final String ENABLED = "enabled";
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private String mode = "login";
    private String sslProtocol = "TLSv1.2";
    private String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String keyStoreType = "JKS";
    private String keyStoreFileName;
    private String keyStorePassword = "";
    private String trustStoreFileName;
    private String trustStorePassword = "";
    private ClientAuth authenticationMode = ClientAuth.NONE;
    private String[] enabledCipherSuites;
    private String keyAlias;
    private String keyPassword;
    private boolean truststoreCheckExpired;
    private boolean disableTrustManager;

    public SSLEngine getServerSSLEngine() throws IOException, GeneralSecurityException {
        if (!this.isSslEnabled()) {
            return null;
        }
        SSLContext context = null;
        context = SocketUtil.getSSLContext((KeyManager[])this.getKeyManagers(), (TrustManager[])(this.disableTrustManager ? SSLConfiguration.getTrustAllManagers() : this.getTrustManagers()), (String)this.sslProtocol);
        SSLEngine result = context.createSSLEngine();
        result.setUseClientMode(false);
        if (this.enabledCipherSuites != null) {
            result.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        switch (this.authenticationMode) {
            case NEED: {
                result.setNeedClientAuth(true);
                break;
            }
            case WANT: {
                result.setWantClientAuth(true);
                break;
            }
        }
        return result;
    }

    public boolean isClientEncryptionEnabled() {
        return LOGIN.equalsIgnoreCase(this.mode);
    }

    public boolean isSslEnabled() {
        return ENABLED.equalsIgnoreCase(this.mode);
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setKeystoreFilename(String value) {
        this.keyStoreFileName = value;
    }

    public void setKeystorePassword(String value) {
        this.keyStorePassword = value;
    }

    public void setKeystoreType(String value) {
        this.keyStoreType = value;
    }

    public void setSslProtocol(String value) {
        this.sslProtocol = value;
    }

    public void setKeymanagementAlgorithm(String value) {
        this.keyManagerFactoryAlgorithm = value;
    }

    public void setTruststoreFilename(String value) {
        this.trustStoreFileName = value;
    }

    public void setTruststorePassword(String value) {
        this.trustStorePassword = value;
    }

    public void setAuthenticationMode(ClientAuth value) {
        this.authenticationMode = value;
    }

    public void setAuthenticationMode(String value) {
        for (ClientAuth auth : ClientAuth.values()) {
            if (!auth.name().equals(value) && !auth.oldValue.equals(value)) continue;
            this.authenticationMode = auth;
            return;
        }
        if (value.equals(ANONYMOUS)) {
            this.authenticationMode = ClientAuth.NONE;
            this.enabledCipherSuites = new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"};
            return;
        }
        throw new IllegalArgumentException("Unknown authentication mode");
    }

    public ClientAuth getAuthenticationMode() {
        return this.authenticationMode;
    }

    public void setEnabledCipherSuites(String enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites.split(",");
        for (int i = 0; i < this.enabledCipherSuites.length; ++i) {
            this.enabledCipherSuites[i] = this.enabledCipherSuites[i].trim();
        }
    }

    public String[] getEnabledCipherSuitesAsArray() {
        return this.enabledCipherSuites;
    }

    public void setKeystoreKeyAlias(String alias) {
        this.keyAlias = alias;
    }

    public void setKeystoreKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public boolean isTruststoreCheckExpired() {
        return this.truststoreCheckExpired;
    }

    public void setTruststoreCheckExpired(boolean checkExpired) {
        this.truststoreCheckExpired = checkExpired;
    }

    public KeyManager[] getKeyManagers() throws IOException, GeneralSecurityException {
        return SocketUtil.getKeyManagers((String)this.keyStoreFileName, (String)this.keyStorePassword, (String)this.keyManagerFactoryAlgorithm, (String)this.keyStoreType, (String)this.keyAlias, (String)this.keyPassword);
    }

    public TrustManager[] getTrustManagers() throws IOException, GeneralSecurityException {
        return SocketUtil.getTrustManagers((String)this.trustStoreFileName, (String)this.trustStorePassword, (String)this.keyManagerFactoryAlgorithm, (String)this.keyStoreType, (boolean)this.truststoreCheckExpired);
    }

    public static TrustManager[] getTrustAllManagers() {
        return SocketUtil.getTrustAllManagers();
    }

    public boolean isDisableTrustManager() {
        return this.disableTrustManager;
    }

    public void setDisableTrustManager(boolean disableTrustManager) {
        this.disableTrustManager = disableTrustManager;
    }

    public static enum ClientAuth {
        NONE("1-way"),
        WANT("want_client"),
        NEED("2-way");

        private String oldValue;

        private ClientAuth(String oldValue) {
            this.oldValue = oldValue;
        }

        public String getOldValue() {
            return this.oldValue;
        }
    }
}

