/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;

public class TestExplain {
    private static EmbeddedServer es = new EmbeddedServer();
    private Connection conn;

    @BeforeClass
    public static void beforeClass() throws Exception {
        es.start(new EmbeddedConfiguration());
        es.deployVDB((InputStream)new ByteArrayInputStream("CREATE DATABASE test VERSION '1';USE DATABASE test VERSION '1';CREATE VIRTUAL SCHEMA test; SET SCHEMA test;CREATE VIEW test as select 1".getBytes()), true);
    }

    @Before
    public void before() throws Exception {
        this.conn = es.getDriver().connect("jdbc:teiid:test", null);
    }

    @AfterClass
    public static void afterClass() {
        es.stop();
    }

    @After
    public void after() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Test
    public void testExplainXml() throws SQLException {
        try (Statement statement = this.conn.createStatement();){
            ResultSet rs = statement.executeQuery("explain (format xml) select * from test");
            rs.next();
            String plan = rs.getString(1);
            Assert.assertFalse((boolean)plan.contains("Statistics"));
        }
    }

    @Test
    public void testExplainAnalyzeYaml() throws SQLException {
        try (Statement statement = this.conn.createStatement();){
            ResultSet rs = statement.executeQuery("explain (analyze true, format yaml) select * from test");
            rs.next();
            String plan = rs.getString(1);
            Assert.assertTrue((boolean)plan.contains("- Node Output Rows: 1"));
        }
    }

    @Test
    public void testExplainAnalyzeText() throws SQLException {
        try (Statement statement = this.conn.createStatement();){
            ResultSet rs = statement.executeQuery("explain (analyze) select * from test");
            rs.next();
            String plan = rs.getString(1);
            Assert.assertTrue((boolean)plan.contains("0: Node Output Rows: 1"));
        }
    }

    @Test
    public void testExplainAnalyzeWithGeneratedKey() throws SQLException {
        try (Statement statement = this.conn.createStatement();){
            statement.execute("create local temporary table t (id serial, val string, primary key (id))");
            int result = statement.executeUpdate("explain (analyze) insert into t (val) values ('a')", 1);
            Assert.assertEquals((long)0L, (long)result);
            ResultSet keys = statement.getGeneratedKeys();
            Assert.assertFalse((boolean)keys.next());
            result = statement.executeUpdate("insert into t (val) values ('a')", 1);
            keys = statement.getGeneratedKeys();
            Assert.assertTrue((boolean)keys.next());
        }
    }

    @Test
    public void testPgSubquery() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("explain SELECT pg_get_constraintdef((select oid from pg_constraint where contype = 'f' and conrelid = (select oid from pg_class where relname = 'Functions')), true)");
        ResultSet rs = s.getResultSet();
        rs.next();
        Assert.assertTrue((boolean)rs.getString(1).contains("ProjectNode"));
    }
}

