/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;

public class TestGrantRevokeTargets {
    EmbeddedServer es;

    @Before
    public void setup() {
        this.es = new EmbeddedServer();
    }

    @After
    public void teardown() {
        if (this.es != null) {
            this.es.stop();
        }
    }

    @Test
    public void testGrantTargetTable() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        String ddl1 = "CREATE DATABASE x VERSION '1';USE DATABASE x VERSION '1';CREATE VIRTUAL SCHEMA test2;CREATE ROLE r with any authenticated;\nSET SCHEMA test2;CREATE VIEW x as select 1 as col;GRANT select on table test2.x to r;";
        this.es.getAdmin().deploy("x-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl1.getBytes("UTF-8")));
        String ddl2 = "CREATE DATABASE x2 VERSION '1';USE DATABASE x2 VERSION '1';CREATE VIRTUAL SCHEMA test2;CREATE ROLE r with any authenticated;\nSET SCHEMA test2;CREATE VIEW x as select 1 as col;GRANT select on table test2.y to r;";
        try {
            this.es.getAdmin().deploy("x2-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl2.getBytes("UTF-8")));
            Assert.fail();
        }
        catch (AdminProcessingException adminProcessingException) {
            // empty catch block
        }
    }

    @Test
    public void testGrantTargetSchema() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        String ddl1 = "CREATE DATABASE x VERSION '1';USE DATABASE x VERSION '1';CREATE VIRTUAL SCHEMA test2;CREATE ROLE r with any authenticated;\nSET SCHEMA test2;CREATE VIEW x as select 1 as col;GRANT select on schema test2 to r;";
        this.es.getAdmin().deploy("x-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl1.getBytes("UTF-8")));
        String ddl2 = "CREATE DATABASE x2 VERSION '1';USE DATABASE x2 VERSION '1';CREATE VIRTUAL SCHEMA test2;CREATE ROLE r with any authenticated;\nSET SCHEMA test2;CREATE VIEW x as select 1 as col;GRANT select on schema test3 to r;";
        try {
            this.es.getAdmin().deploy("x2-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl2.getBytes("UTF-8")));
            Assert.fail();
        }
        catch (AdminProcessingException adminProcessingException) {
            // empty catch block
        }
    }

    @Test
    public void testGrantTargetColumn() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        String ddl1 = "CREATE DATABASE x VERSION '1';USE DATABASE x VERSION '1';CREATE VIRTUAL SCHEMA test2;CREATE ROLE r with any authenticated;\nSET SCHEMA test2;CREATE VIEW x as select 1 as col;GRANT select on column test2.x.col to r;";
        this.es.getAdmin().deploy("x-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl1.getBytes("UTF-8")));
        String ddl2 = "CREATE DATABASE x2 VERSION '1';USE DATABASE x2 VERSION '1';CREATE VIRTUAL SCHEMA test2;CREATE ROLE r with any authenticated;\nSET SCHEMA test2;CREATE VIEW x as select 1 as col;GRANT select on column test2.x.col2 to r;";
        try {
            this.es.getAdmin().deploy("x2-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl2.getBytes("UTF-8")));
            Assert.fail();
        }
        catch (AdminProcessingException adminProcessingException) {
            // empty catch block
        }
    }

    @Test
    public void testGrantTargetProcedure() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        String ddl1 = "CREATE DATABASE x VERSION '1';USE DATABASE x VERSION '1';CREATE VIRTUAL SCHEMA test2;CREATE ROLE r with any authenticated;\nSET SCHEMA test2;CREATE VIRTUAL PROCEDURE x () as select 1;GRANT select on procedure test2.x to r;";
        this.es.getAdmin().deploy("x-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl1.getBytes("UTF-8")));
        String ddl2 = "CREATE DATABASE x2 VERSION '1';USE DATABASE x2 VERSION '1';CREATE VIRTUAL SCHEMA test2;CREATE ROLE r with any authenticated;\nSET SCHEMA test2;CREATE VIRTUAL PROCEDURE x () as select 1;GRANT select on procedure test2.y to r;";
        try {
            this.es.getAdmin().deploy("x2-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl2.getBytes("UTF-8")));
            Assert.fail();
        }
        catch (AdminProcessingException adminProcessingException) {
            // empty catch block
        }
    }

    @Test
    public void testGrantTargetFunction() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        String ddl1 = "CREATE DATABASE x VERSION '1';USE DATABASE x VERSION '1';CREATE VIRTUAL SCHEMA test2;CREATE ROLE r with any authenticated;\nSET SCHEMA test2;CREATE VIRTUAL function x () returns integer as return 1;GRANT select on function test2.x to r;";
        this.es.getAdmin().deploy("x-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl1.getBytes("UTF-8")));
        String ddl2 = "CREATE DATABASE x2 VERSION '1';USE DATABASE x2 VERSION '1';CREATE VIRTUAL SCHEMA test2;CREATE ROLE r with any authenticated;\nSET SCHEMA test2;CREATE VIRTUAL function x () returns integer as return 1;GRANT select on function test2.y to r;";
        try {
            this.es.getAdmin().deploy("x2-vdb.ddl", (InputStream)new ByteArrayInputStream(ddl2.getBytes("UTF-8")));
            Assert.fail();
        }
        catch (AdminProcessingException adminProcessingException) {
            // empty catch block
        }
    }
}

