/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.HardCodedExecutionFactory;
import org.teiid.translator.ExecutionFactory;

public class TestVirtualFunctionPushdown {
    private static EmbeddedServer es = new EmbeddedServer();
    private Connection conn;
    private static HardCodedExecutionFactory ef;

    @BeforeClass
    public static void beforeClass() throws Exception {
        es.start(new EmbeddedConfiguration());
        ef = new HardCodedExecutionFactory(){

            public boolean supportsSelectExpression() {
                return true;
            }
        };
        es.addTranslator("hardcoded", (ExecutionFactory)ef);
        es.deployVDB((InputStream)new ByteArrayInputStream("CREATE DATABASE test VERSION '1';USE DATABASE test VERSION '1';CREATE SERVER s FOREIGN DATA WRAPPER hardcoded;CREATE VIRTUAL SCHEMA v; CREATE SCHEMA p SERVER s; SET SCHEMA v;CREATE VIRTUAL FUNCTION VFUNC(msg varchar) RETURNS varchar AS return msg || 'a';CREATE VIRTUAL FUNCTION VFUNC1(msg varchar) RETURNS varchar AS return msg || 'a';SET SCHEMA p;CREATE FOREIGN FUNCTION SFUNC(msg varchar)  RETURNS varchar OPTIONS (\"teiid_rel:virtual-function\" 'v.vfunc');CREATE FOREIGN FUNCTION IFUNC(msg integer) RETURNS varchar OPTIONS (\"teiid_rel:virtual-function\" 'v.vfunc1');CREATE FOREIGN FUNCTION SYSFUNC(msg string) RETURNS integer OPTIONS (\"teiid_rel:virtual-function\" 'ascii');CREATE FOREIGN TABLE TBL (COL STRING);".getBytes()), true);
    }

    @Before
    public void before() throws Exception {
        this.conn = es.getDriver().connect("jdbc:teiid:test", null);
        ef.clearData();
    }

    @AfterClass
    public static void afterClass() {
        es.stop();
    }

    @After
    public void after() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Test
    public void testPushdown() throws SQLException {
        ef.addData("SELECT SFUNC(TBL.COL) FROM TBL", Arrays.asList(Arrays.asList("a")));
        try (Statement statement = this.conn.createStatement();){
            ResultSet rs = statement.executeQuery("select vfunc(col) from tbl");
            Assert.assertTrue((boolean)rs.next());
        }
    }

    @Test
    public void testNoPushdown() throws SQLException {
        ef.addData("SELECT TBL.COL FROM TBL", Arrays.asList(Arrays.asList("a")));
        try (Statement statement = this.conn.createStatement();){
            ResultSet rs = statement.executeQuery("select vfunc1(col) from tbl");
            Assert.assertTrue((boolean)rs.next());
        }
    }

    @Test
    public void testSysPushdown() throws SQLException {
        ef.addData("SELECT SYSFUNC(TBL.COL) FROM TBL", Arrays.asList(Arrays.asList(1)));
        try (Statement statement = this.conn.createStatement();){
            ResultSet rs = statement.executeQuery("select ascii(col) from tbl");
            Assert.assertTrue((boolean)rs.next());
        }
    }
}

