/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.events.EventDistributor;
import org.teiid.events.EventListener;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnStats;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.TableStats;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.SourceTriggerActionPlanner;
import org.teiid.query.processor.DdlPlan;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.runtime.RuntimePlugin;

public abstract class EventDistributorImpl
implements EventDistributor {
    private Set<EventListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public abstract VDBRepository getVdbRepository();

    public abstract DQPCore getDQPCore();

    public EventDistributorImpl() {
        this.getVdbRepository().addListener(new VDBLifeCycleListener(){

            @Override
            public void removed(String name, CompositeVDB vdb) {
                for (EventListener el : EventDistributorImpl.this.listeners) {
                    try {
                        el.vdbUndeployed(name, vdb.getVDB().getVersion());
                    }
                    catch (Exception e) {
                        LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40148, new Object[]{"undeployed", vdb.getVDBKey()}));
                    }
                }
            }

            @Override
            public void finishedDeployment(String name, CompositeVDB vdb) {
                for (EventListener el : EventDistributorImpl.this.listeners) {
                    try {
                        if (vdb.getVDB().getStatus().equals((Object)VDB.Status.ACTIVE)) {
                            el.vdbLoaded((VDB)vdb.getVDB());
                            continue;
                        }
                        el.vdbLoadFailed((VDB)vdb.getVDB());
                    }
                    catch (Exception e) {
                        LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40148, new Object[]{"finished deployment", vdb.getVDBKey()}));
                    }
                }
            }

            @Override
            public void added(String name, CompositeVDB vdb) {
                for (EventListener el : EventDistributorImpl.this.listeners) {
                    try {
                        el.vdbDeployed(name, vdb.getVDB().getVersion());
                    }
                    catch (Exception e) {
                        LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40148, new Object[]{"deployed", vdb.getVDBKey()}));
                    }
                }
            }

            @Override
            public void beforeRemove(String name, CompositeVDB vdb) {
            }
        });
    }

    public void updateMatViewRow(String vdbName, int vdbVersion, String schema, String viewName, List<?> tuple, boolean delete) {
        this.updateMatViewRow(vdbName, String.valueOf(vdbVersion), schema, viewName, tuple, delete);
    }

    public void updateMatViewRow(String vdbName, String vdbVersion, String schema, String viewName, List<?> tuple, boolean delete) {
        GlobalTableStore gts;
        VDBMetaData metadata = this.getVdbRepository().getLiveVDB(vdbName, vdbVersion);
        if (metadata != null && (gts = (GlobalTableStore)metadata.getAttachment(GlobalTableStore.class)) != null) {
            try {
                gts.updateMatViewRow(("#MAT_" + schema + '.' + viewName).toUpperCase(), tuple, delete);
            }
            catch (TeiidComponentException e) {
                LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40013, new Object[]{"updateMatViewRow"}));
            }
        }
    }

    public void dataModification(String vdbName, int vdbVersion, String schema, String ... tableNames) {
        this.dataModification(vdbName, String.valueOf(vdbVersion), schema, tableNames);
    }

    public void dataModification(String vdbName, String vdbVersion, String schema, String ... tableNames) {
        this.updateModified(true, vdbName, vdbVersion, schema, tableNames);
    }

    private void updateModified(boolean data, String vdbName, String vdbVersion, String schema, String ... objectNames) {
        Schema s = this.getSchema(vdbName, vdbVersion, schema);
        if (s == null) {
            return;
        }
        long ts = System.currentTimeMillis();
        for (String name : objectNames) {
            Table table = (Table)s.getTables().get(name);
            if (table == null) continue;
            if (data) {
                table.setLastDataModification(ts);
                continue;
            }
            table.setLastModified(ts);
        }
    }

    public void setColumnStats(String vdbName, int vdbVersion, String schemaName, String tableName, String columnName, ColumnStats stats) {
        this.setColumnStats(vdbName, String.valueOf(vdbVersion), schemaName, tableName, columnName, stats);
    }

    public void setColumnStats(String vdbName, String vdbVersion, String schemaName, String tableName, String columnName, ColumnStats stats) {
        VDBMetaData vdb = this.getVdbRepository().getLiveVDB(vdbName, vdbVersion);
        Table t = this.getTable(vdbName, vdbVersion, schemaName, tableName);
        if (t == null) {
            return;
        }
        Column c = t.getColumnByName(columnName);
        if (c != null) {
            DdlPlan.setColumnStats((VDBMetaData)vdb, (Column)c, (ColumnStats)stats);
        }
    }

    public void setTableStats(String vdbName, int vdbVersion, String schemaName, String tableName, TableStats stats) {
        this.setTableStats(vdbName, String.valueOf(vdbVersion), schemaName, tableName, stats);
    }

    public void setTableStats(String vdbName, String vdbVersion, String schemaName, String tableName, TableStats stats) {
        VDBMetaData vdb = this.getVdbRepository().getLiveVDB(vdbName, vdbVersion);
        Table t = this.getTable(vdbName, vdbVersion, schemaName, tableName);
        if (t == null) {
            return;
        }
        DdlPlan.setTableStats((VDBMetaData)vdb, (Table)t, (TableStats)stats);
    }

    private Table getTable(String vdbName, String vdbVersion, String schemaName, String tableName) {
        Schema s = this.getSchema(vdbName, vdbVersion, schemaName);
        if (s == null) {
            return null;
        }
        return (Table)s.getTables().get(tableName);
    }

    private Schema getSchema(String vdbName, String vdbVersion, String schemaName) {
        VDBMetaData vdb = this.getVdbRepository().getLiveVDB(vdbName, vdbVersion);
        if (vdb == null) {
            return null;
        }
        TransformationMetadata tm = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (tm == null) {
            return null;
        }
        return (Schema)tm.getMetadataStore().getSchemas().get(schemaName);
    }

    public void setInsteadOfTriggerDefinition(String vdbName, int vdbVersion, String schema, String viewName, Table.TriggerEvent triggerEvent, String triggerDefinition, Boolean enabled) {
        this.setInsteadOfTriggerDefinition(vdbName, String.valueOf(vdbVersion), schema, viewName, triggerEvent, triggerDefinition, enabled);
    }

    public void setInsteadOfTriggerDefinition(String vdbName, String vdbVersion, String schema, String viewName, Table.TriggerEvent triggerEvent, String triggerDefinition, Boolean enabled) {
        Table t = this.getTable(vdbName, vdbVersion, schema, viewName);
        if (t == null) {
            return;
        }
        DdlPlan.alterInsteadOfTrigger((VDBMetaData)this.getVdbRepository().getLiveVDB(vdbName, vdbVersion), (Table)t, (String)triggerDefinition, (Boolean)enabled, (Table.TriggerEvent)triggerEvent, (boolean)true);
    }

    public void setProcedureDefinition(String vdbName, int vdbVersion, String schema, String procName, String definition) {
        this.setProcedureDefinition(vdbName, String.valueOf(vdbVersion), schema, procName, definition);
    }

    public void setProcedureDefinition(String vdbName, String vdbVersion, String schema, String procName, String definition) {
        Schema s = this.getSchema(vdbName, vdbVersion, schema);
        if (s == null) {
            return;
        }
        Procedure p = (Procedure)s.getProcedures().get(procName);
        if (p == null) {
            return;
        }
        DdlPlan.alterProcedureDefinition((VDBMetaData)this.getVdbRepository().getLiveVDB(vdbName, vdbVersion), (Procedure)p, (String)definition, (boolean)true);
    }

    public void setViewDefinition(String vdbName, int vdbVersion, String schema, String viewName, String definition) {
        this.setViewDefinition(vdbName, String.valueOf(vdbVersion), schema, viewName, definition);
    }

    public void setViewDefinition(String vdbName, String vdbVersion, String schema, String viewName, String definition) {
        Table t = this.getTable(vdbName, vdbVersion, schema, viewName);
        if (t == null) {
            return;
        }
        DdlPlan.alterView((VDBMetaData)this.getVdbRepository().getLiveVDB(vdbName, vdbVersion), (Table)t, (String)definition, (boolean)true);
    }

    public void setProperty(String vdbName, int vdbVersion, String uuid, String name, String value) {
        this.setProperty(vdbName, String.valueOf(vdbVersion), uuid, name, value);
    }

    public void setProperty(String vdbName, String vdbVersion, String uuid, String name, String value) {
        VDBMetaData vdb = this.getVdbRepository().getLiveVDB(vdbName, vdbVersion);
        if (vdb == null) {
            return;
        }
        TransformationMetadata tm = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (tm == null) {
            return;
        }
        AbstractMetadataRecord record = DataTierManagerImpl.getByUuid((CompositeMetadataStore)tm.getMetadataStore(), (String)uuid);
        if (record != null) {
            DdlPlan.setProperty((VDBMetaData)vdb, (AbstractMetadataRecord)record, (String)name, (String)value);
        }
    }

    public ResultsFuture<?> dataModification(String vdbName, String vdbVersion, String schema, String tableName, Object[] oldValues, Object[] newValues, String[] columnNames) {
        VDBMetaData vdb = this.getVdbRepository().getLiveVDB(vdbName, vdbVersion);
        if (vdb == null) {
            return null;
        }
        TransformationMetadata tm = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (tm == null) {
            return null;
        }
        Table t = this.getTable(vdbName, vdbVersion, schema, tableName);
        if (t == null) {
            return null;
        }
        this.dataModification(vdbName, vdbVersion, schema, tableName);
        if (oldValues == null && newValues == null) {
            return null;
        }
        if (!t.getTriggers().isEmpty()) {
            if (columnNames != null) {
                if (oldValues != null && oldValues.length != columnNames.length || newValues != null && newValues.length != columnNames.length) {
                    throw new IllegalArgumentException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40162, new Object[0]));
                }
            } else if (oldValues != null && oldValues.length != t.getColumns().size() || newValues != null && newValues.length != t.getColumns().size()) {
                throw new IllegalArgumentException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40163, new Object[0]));
            }
            SourceTriggerActionPlanner.SourceEventCommand sec = new SourceTriggerActionPlanner.SourceEventCommand(t, oldValues, newValues, columnNames);
            try {
                return DQPCore.executeQuery((Object)sec, (VDBMetaData)vdb, (String)"admin", (String)"event-distributor", (long)-1L, (DQPCore)this.getDQPCore(), (DQPCore.ResultsListener)new DQPCore.ResultsListener(){

                    public void onResults(List<String> columns, List<? extends List<?>> results) throws Exception {
                    }
                });
            }
            catch (Throwable throwable) {
                throw new TeiidRuntimeException(throwable);
            }
        }
        return null;
    }

    public void register(EventListener listener) {
        this.listeners.add(listener);
    }

    public void unregister(EventListener listener) {
        this.listeners.remove(listener);
    }
}

