/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.net.InetSocketAddress;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.ODBCClientInstance;
import org.teiid.transport.PgBackendProtocol;
import org.teiid.transport.PgFrontendProtocol;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class ODBCSocketListener
extends SocketListener {
    private int maxBufferSize = (Integer)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.ODBCPacketSize", (Object)307200, Integer.class);
    private boolean requireSecure = (Boolean)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.ODBCRequireSecure", (Object)true, Boolean.class);
    private int maxLobSize;
    private TeiidDriver driver;
    private LogonImpl logonService;

    public ODBCSocketListener(InetSocketAddress address, SocketConfiguration config, ClientServiceRegistryImpl csr, StorageManager storageManager, int maxLobSize, LogonImpl logon, TeiidDriver driver) {
        super(address, config, csr, storageManager);
        this.maxLobSize = maxLobSize;
        this.driver = driver;
        this.logonService = logon;
    }

    public void setDriver(TeiidDriver driver) {
        this.driver = driver;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    protected void configureChannelPipeline(ChannelPipeline pipeline, SSLConfiguration config, StorageManager storageManager) throws Exception {
        PgBackendProtocol pgBackendProtocol = new PgBackendProtocol(this.maxLobSize, this.maxBufferSize, config, this.requireSecure);
        pipeline.addLast("odbcFrontendProtocol", (ChannelHandler)new PgFrontendProtocol(pgBackendProtocol, 0x100000));
        pipeline.addLast("odbcBackendProtocol", (ChannelHandler)pgBackendProtocol);
        pipeline.addLast("handler", (ChannelHandler)this.channelHandler);
    }

    @Override
    public ChannelListener createChannelListener(ObjectChannel channel) {
        return new ODBCClientInstance(channel, this.driver, this.logonService);
    }

    public void setRequireSecure(boolean requireSecure) {
        this.requireSecure = requireSecure;
    }
}

