/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport.pg;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;

public class TimestampUtils {
    private static final int ONEDAY = 86400000;
    public static final long DATE_POSITIVE_INFINITY = 9223372036825200000L;
    public static final long DATE_NEGATIVE_INFINITY = -9223372036832400000L;
    public static final long DATE_POSITIVE_SMALLER_INFINITY = 185543533774800000L;
    public static final long DATE_NEGATIVE_SMALLER_INFINITY = -185543533774800000L;

    public static Date toDate(TimeZone tz, int days) {
        long secs = TimestampUtils.toJavaSecs((long)days * 86400L);
        long millis = secs * 1000L;
        int offset = tz.getOffset(millis);
        if (millis <= -185543533774800000L) {
            millis = -9223372036832400000L;
            offset = 0;
        } else if (millis >= 185543533774800000L) {
            millis = 9223372036825200000L;
            offset = 0;
        }
        return new Date(millis - (long)offset);
    }

    private static long toJavaSecs(long secs) {
        if ((secs += 946684800L) < -12219292800L && (secs += 864000L) < -14825808000L) {
            int extraLeaps = (int)((secs + 14825808000L) / 3155760000L);
            --extraLeaps;
            extraLeaps -= extraLeaps / 4;
            secs += (long)extraLeaps * 86400L;
        }
        return secs;
    }

    public static long toPgSecs(long secs) {
        if ((secs -= 946684800L) < -13165977600L && (secs -= 864000L) < -15773356800L) {
            int years = (int)((secs + 15773356800L) / -3155823050L);
            ++years;
            years -= years / 4;
            secs += (long)(years * 86400);
        }
        return secs;
    }

    public static Timestamp toTimestamp(long time, TimeZone tz) {
        if (time == Long.MAX_VALUE) {
            return new Timestamp(9223372036825200000L);
        }
        if (time == Long.MIN_VALUE) {
            return new Timestamp(-9223372036832400000L);
        }
        long secs = time / 1000000L;
        int nanos = (int)(time - secs * 1000000L);
        if (nanos < 0) {
            --secs;
            nanos += 1000000;
        }
        secs = TimestampUtils.toJavaSecs(secs);
        long millis = secs * 1000L;
        Timestamp result = new Timestamp(millis -= (long)tz.getRawOffset());
        result.setNanos(nanos *= 1000);
        return result;
    }

    public static Time convertToTime(long millis, TimeZone tz) {
        int offset = tz.getRawOffset();
        millis += (long)offset;
        millis %= 86400000L;
        return new Time(millis -= (long)offset);
    }
}

