/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.teiid.spring.data.file.FileConnectionFactory;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;

public enum ExternalSource {
    ACTIAN("Actian", new String[]{"com.ingres.jdbc.IngresDriver"}, "actian-vector"),
    DB2("DB2", new String[]{"com.ibm.db2.jcc.DB2Driver"}, "db2"),
    DERBY("Derby", new String[]{"org.apache.derby.jdbc.ClientDriver"}, "derby"),
    H2("H2", new String[]{"org.h2.Driver"}, "h2"),
    HANA("Hana", new String[]{"com.sap.db.jdbc.Driver"}, "hana"),
    HIVE("Hive", new String[]{"org.apache.hive.jdbc.HiveDriver"}, "hive"),
    IMPALA("Impala", new String[]{"org.apache.hadoop.hive.jdbc.HiveDriver"}, "impala"),
    HSQL("HSQL", new String[]{"org.hsqldb.jdbc.JDBCDriver"}, "hsql"),
    INFORMIX("Informix", new String[]{"com.informix.jdbc.IfxDriver"}, "informix"),
    INGRES("Ingres", new String[]{"com.ingres.jdbc.IngresDriver"}, "ingres"),
    INTERSYSTEMSCACHE("Intersystems Cache", new String[]{"com.intersys.jdbc.CacheDriver"}, "intersystems-cache"),
    MYSQL("MySQL", new String[]{"com.mysql.jdbc.Driver"}, "mysql5"),
    OLAP("OLAP", new String[]{"org.olap4j.driver.xmla.XmlaOlap4jDriver"}, "olap"),
    MONDRIAN("Mondrian", new String[]{"mondrian.olap4j.MondrianOlap4jDriver"}, "olap"),
    ORACLE("Oracle", new String[]{"oracle.jdbc.OracleDriver"}, "oracle"),
    OSISOFTPI("OSISOFT PI", new String[]{"com.osisoft.jdbc.Driver"}, "osisoft-pi"),
    PHOENIX("Phoenix", new String[]{"org.apache.phoenix.jdbc.PhoenixDriver"}, "phoenix"),
    POSTGRESQL("PostgreSQL", new String[]{"org.postgresql.Driver"}, "postgresql"),
    PRESTODB("PrestoDB", new String[]{"com.facebook.presto.jdbc.PrestoDriver"}, "prestodb"),
    SQLSERVER("MS-SQL Server", new String[]{"com.microsoft.sqlserver.jdbc.SQLServerDriver"}, "sqlserver"),
    JTDS("MS-SQL Server", new String[]{"net.sourceforge.jtds.jdbc.Driver"}, "sqlserver"),
    SYBASE("Sybase", new String[]{"com.sybase.jdbc2.jdbc.SybDriver", "com.sybase.jdbc4.jdbc.SybDriver"}, "sybase"),
    TEIID("Teiid", new String[]{"org.teiid.jdbc.TeiidDriver"}, "teiid"),
    ACCESS("MS Access", new String[]{"net.ucanaccess.jdbc.UcanaccessDriver"}, "ucanaccess"),
    VERTICA("Vertica", new String[]{"com.vertica.jdbc.Driver"}, "vertica"),
    NETEZZA("Netezza", new String[]{"org.netezza.Driver "}, "netezza"),
    TERADATA("Teradata", new String[]{"com.teradata.jdbc.TeraDriver"}, "teradata"),
    FILE("file", new String[]{FileConnectionFactory.class.getName()}, "file"),
    REST("rest", new String[]{"org.teiid.spring.data.rest.RestConnectionFactory"}, "ws"),
    EXCEL("excel", new String[]{"org.teiid.spring.data.excel.ExcelConnectionFactory"}, "excel");

    private String name;
    private String[] driverNames;
    private String translatorName;

    private ExternalSource(String name, String[] driverNames, String translatorName) {
        this.name = name;
        this.driverNames = driverNames;
        this.translatorName = translatorName;
    }

    public String getName() {
        return this.name;
    }

    public String[] getDriverName() {
        return this.driverNames;
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public static String findTransaltorNameFromDriverName(String driverName) {
        for (ExternalSource source : ExternalSource.values()) {
            for (String driver : source.driverNames) {
                if (!driver.equals(driverName)) continue;
                return source.getTranslatorName();
            }
        }
        return "loopback";
    }

    public static Class<? extends ExecutionFactory<?, ?>> translatorClass(String translatorName) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Translator.class));
        Set components = provider.findCandidateComponents("org.teiid.translator");
        for (BeanDefinition c : components) {
            try {
                Class<?> clazz = Class.forName(c.getBeanClassName());
                String name = clazz.getAnnotation(Translator.class).name();
                if (!name.equals(translatorName)) continue;
                return clazz;
            }
            catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
                throw new IllegalStateException("Error loading translators", e);
            }
        }
        return null;
    }

    public static String findTransaltorNameFromAlias(String sourceName) {
        for (ExternalSource source : ExternalSource.values()) {
            if (!source.name.equalsIgnoreCase(sourceName)) continue;
            return source.getTranslatorName();
        }
        return null;
    }
}

