/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.type.AnnotationMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.spring.autoconfigure.MultiDataSourceInitializer;
import org.teiid.spring.autoconfigure.TeiidInitializer;
import org.teiid.spring.autoconfigure.TeiidServer;
import org.teiid.spring.data.BaseConnectionFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class TeiidPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationListener<ContextRefreshedEvent> {
    private static final Log logger = LogFactory.getLog(TeiidPostProcessor.class);
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private PhysicalNamingStrategy namingStrategy;

    TeiidPostProcessor() {
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource) {
            this.beanFactory.getBean("teiid", TeiidServer.class);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof TeiidServer) {
            this.beanFactory.getBean(TeiidInitializer.class);
        } else if (bean instanceof DataSource && !beanName.equals("dataSource")) {
            new MultiDataSourceInitializer((DataSource)bean, beanName, this.context).init();
            TeiidServer server = (TeiidServer)((Object)this.beanFactory.getBean(TeiidServer.class));
            VDBMetaData vdb = (VDBMetaData)this.beanFactory.getBean(VDBMetaData.class);
            server.addDataSource(vdb, beanName, (DataSource)bean, this.context);
            logger.info((Object)("Datasource added to Teiid = " + beanName));
        } else if (bean instanceof BaseConnectionFactory) {
            TeiidServer server = (TeiidServer)((Object)this.beanFactory.getBean(TeiidServer.class));
            VDBMetaData vdb = (VDBMetaData)this.beanFactory.getBean(VDBMetaData.class);
            server.addDataSource(vdb, beanName, (BaseConnectionFactory)bean, this.context);
            logger.info((Object)("Non JDBC Datasource added to Teiid = " + beanName));
        }
        return bean;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        boolean deploy = true;
        VDBMetaData vdb = (VDBMetaData)this.beanFactory.getBean(VDBMetaData.class);
        TeiidServer server = (TeiidServer)((Object)this.beanFactory.getBean(TeiidServer.class));
        if (vdb.getPropertyValue("implicit") != null && vdb.getPropertyValue("implicit").equals("true")) {
            deploy = server.findAndConfigureViews(vdb, event.getApplicationContext(), this.namingStrategy);
        }
        if (deploy) {
            try {
                server.undeployVDB("spring", "1.0.0");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                VDBMetadataParser.marshell((VDBMetaData)vdb, (OutputStream)out);
                logger.debug((Object)("XML Form of VDB:\n" + this.prettyFormat(new String(out.toByteArray()))));
                server.deployVDB(vdb);
            }
            catch (IOException | XMLStreamException exception) {
                // empty catch block
            }
        }
    }

    private String prettyFormat(String xml) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            DOMSource source = new DOMSource(db.parse(is));
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (IOException | IllegalArgumentException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | SAXException e) {
            return xml;
        }
    }

    static class Registrar
    implements ImportBeanDefinitionRegistrar {
        private static final String BEAN_NAME = "teiidInitializerPostProcessor";

        Registrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition(BEAN_NAME)) {
                GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                beanDefinition.setBeanClass(TeiidPostProcessor.class);
                beanDefinition.setRole(0);
                beanDefinition.setSynthetic(true);
                registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)beanDefinition);
            }
        }
    }
}

