/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dialect.TeiidDialect;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.spring.annotations.ExcelTable;
import org.teiid.spring.annotations.JsonTable;
import org.teiid.spring.annotations.SelectQuery;
import org.teiid.spring.annotations.TextTable;
import org.teiid.spring.annotations.UserDefinedFunctions;
import org.teiid.spring.autoconfigure.ExternalSource;
import org.teiid.spring.data.BaseConnectionFactory;
import org.teiid.spring.views.ExcelTableView;
import org.teiid.spring.views.JsonTableView;
import org.teiid.spring.views.SimpleView;
import org.teiid.spring.views.TextTableView;
import org.teiid.spring.views.UDFProcessor;
import org.teiid.translator.TranslatorException;

public class TeiidServer
extends EmbeddedServer {
    private static final Log logger = LogFactory.getLog(TeiidServer.class);

    public void addDataSource(VDBMetaData vdb, String sourceBeanName, Object source, ApplicationContext context) {
        if (vdb.getPropertyValue("implicit") != null && vdb.getPropertyValue("implicit").equals("true")) {
            this.addConnectionFactory(sourceBeanName, source);
            ModelMetaData model = null;
            if (source instanceof DataSource) {
                try {
                    model = this.buildModelFromDataSource(sourceBeanName, (DataSource)source, context);
                }
                catch (AdminException e) {
                    throw new IllegalStateException("Error adding the source, cause: " + e.getMessage());
                }
            } else if (source instanceof BaseConnectionFactory) {
                model = this.buildModelFromConnectionFactory(sourceBeanName, (BaseConnectionFactory)source, context);
            } else {
                throw new IllegalStateException("Auto detecting of sources currently only supports Tomcat Datasource");
            }
            if (model != null) {
                model.setVisible(false);
                vdb.addModel(model);
                logger.info((Object)("Added " + sourceBeanName + " to the Teiid Database"));
            }
            try {
                Admin admin = this.getAdmin();
                VDBMetaData previous = (VDBMetaData)admin.getVDB("spring", "1.0.0");
                for (Map.Entry entry : previous.getModelMetaDatas().entrySet()) {
                    String metadata = admin.getSchema("spring", "1.0.0", (String)entry.getKey(), null, null);
                    if (!vdb.getModel((String)entry.getKey()).getSourceMetadataType().isEmpty()) continue;
                    vdb.getModel((String)entry.getKey()).addSourceMetadata("DDL", metadata);
                }
            }
            catch (AdminException admin) {
                // empty catch block
            }
            this.undeployVDB("spring", "1.0.0");
            this.deployVDB(vdb);
        } else {
            for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                for (SourceMappingMetadata smm : model.getSourceMappings()) {
                    if (!smm.getConnectionJndiName().equalsIgnoreCase(sourceBeanName)) continue;
                    this.addConnectionFactory(smm.getName(), source);
                }
            }
        }
    }

    void deployVDB(VDBMetaData vdb) {
        try {
            if (vdb.getModel("teiid") == null) {
                for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                    model.setVisible(true);
                }
            } else {
                for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                    if (model.getName().equals("teiid")) continue;
                    model.setVisible(false);
                }
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            VDBMetadataParser.marshell((VDBMetaData)vdb, (OutputStream)out);
            this.deployVDB(new ByteArrayInputStream(out.toByteArray()));
        }
        catch (IOException | XMLStreamException | VirtualDatabaseException | ConnectorManagerRepository.ConnectorManagerException | TranslatorException e) {
            throw new IllegalStateException("Failed to deploy the VDB file", e);
        }
    }

    private ModelMetaData buildModelFromDataSource(String dsBeanName, DataSource ds, ApplicationContext context) throws AdminException {
        if (ds.getUrl().startsWith("jdbc:teiid:spring")) {
            return null;
        }
        ModelMetaData model = new ModelMetaData();
        model.setName(dsBeanName);
        model.setModelType(Model.Type.PHYSICAL);
        model.addProperty("importer.useQualifiedName", "false");
        model.addProperty("importer.tableTypes", "TABLE,VIEW");
        SourceMappingMetadata source = new SourceMappingMetadata();
        source.setName(dsBeanName);
        source.setConnectionJndiName(dsBeanName);
        String driverName = ds.getDriverClassName();
        String translatorName = ExternalSource.findTransaltorNameFromDriverName(driverName);
        source.setTranslatorName(translatorName);
        try {
            if (this.getExecutionFactory(translatorName) == null) {
                this.addTranslator(ExternalSource.translatorClass(translatorName));
            }
        }
        catch (ConnectorManagerRepository.ConnectorManagerException | TranslatorException e) {
            throw new IllegalStateException("Failed to load translator " + translatorName, e);
        }
        Collection importProperties = this.getAdmin().getTranslatorPropertyDefinitions(source.getTranslatorName(), Admin.TranlatorPropertyType.IMPORT);
        importProperties.forEach(prop -> {
            String key = prop.getName();
            String value = context.getEnvironment().getProperty("spring.datasource." + dsBeanName + "." + key);
            if (value != null) {
                model.addProperty(key, value);
            }
        });
        model.addSourceMapping(source);
        return model;
    }

    public ModelMetaData buildModelFromConnectionFactory(String sourceBeanName, BaseConnectionFactory factory, ApplicationContext context) {
        ModelMetaData model = new ModelMetaData();
        model.setName(sourceBeanName);
        model.setModelType(Model.Type.PHYSICAL);
        SourceMappingMetadata source = new SourceMappingMetadata();
        source.setName(sourceBeanName);
        source.setConnectionJndiName(sourceBeanName);
        String translatorName = ExternalSource.findTransaltorNameFromAlias(factory.getTranslatorName());
        source.setTranslatorName(translatorName);
        try {
            if (this.getExecutionFactory(translatorName) == null) {
                this.addTranslator(ExternalSource.translatorClass(translatorName));
            }
        }
        catch (ConnectorManagerRepository.ConnectorManagerException | TranslatorException e) {
            throw new IllegalStateException("Failed to load translator " + translatorName, e);
        }
        model.addSourceMapping(source);
        return model;
    }

    boolean findAndConfigureViews(VDBMetaData vdb, ApplicationContext context, PhysicalNamingStrategy namingStrategy) {
        Set components;
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Embeddable.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SelectQuery.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(UserDefinedFunctions.class));
        String basePackage = context.getEnvironment().getProperty("spring.teiid.model.package");
        if (basePackage == null) {
            logger.warn((Object)"***************************************************************");
            logger.warn((Object)"\"spring.teiid.model.package\" is NOT set, scanning entire classpath for @Entity classes.");
            logger.warn((Object)"consider setting this property to avoid time consuming scanning");
            logger.warn((Object)"***************************************************************");
            basePackage = "*";
        }
        if ((components = provider.findCandidateComponents(basePackage)).isEmpty()) {
            return false;
        }
        boolean load = false;
        for (BeanDefinition c : components) {
            try {
                Class<?> clazz = Class.forName(c.getBeanClassName());
                ExcelTable excelAnnotation = clazz.getAnnotation(ExcelTable.class);
                if (excelAnnotation == null) continue;
                this.addExcelModel(vdb, clazz, excelAnnotation);
                load = true;
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)"Error loading entity classes");
            }
        }
        ModelMetaData model = new ModelMetaData();
        model.setName("teiid");
        model.setModelType(Model.Type.VIRTUAL);
        MetadataFactory mf = new MetadataFactory("spring", (Object)"1.0.0", SystemMetadata.getInstance().getRuntimeTypeMap(), model);
        Metadata metadata = this.getMetadata(components, namingStrategy);
        UDFProcessor udfProcessor = new UDFProcessor(metadata, vdb);
        for (BeanDefinition c : components) {
            try {
                Class<?> clazz = Class.forName(c.getBeanClassName());
                Entity entityAnnotation = clazz.getAnnotation(Entity.class);
                SelectQuery selectAnnotation = clazz.getAnnotation(SelectQuery.class);
                TextTable textAnnotation = clazz.getAnnotation(TextTable.class);
                JsonTable jsonAnnotation = clazz.getAnnotation(JsonTable.class);
                ExcelTable excelAnnotation = clazz.getAnnotation(ExcelTable.class);
                UserDefinedFunctions udfAnnotation = clazz.getAnnotation(UserDefinedFunctions.class);
                if (textAnnotation != null) {
                    new TextTableView(metadata).buildView(clazz, mf, textAnnotation);
                } else if (jsonAnnotation != null) {
                    new JsonTableView(metadata).buildView(clazz, mf, jsonAnnotation);
                } else if (selectAnnotation != null) {
                    new SimpleView(metadata).buildView(clazz, mf, selectAnnotation);
                } else if (excelAnnotation != null) {
                    new ExcelTableView(metadata).buildView(clazz, mf, excelAnnotation);
                } else if (udfAnnotation != null) {
                    udfProcessor.buildFunctions(clazz, mf, udfAnnotation);
                }
                if (entityAnnotation == null) continue;
                udfProcessor.buildSequence(clazz, mf, entityAnnotation);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)"Error loading entity classes");
            }
        }
        udfProcessor.finishProcessing();
        if (!mf.getSchema().getTables().isEmpty()) {
            load = true;
            String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
            model.addSourceMetadata("DDL", ddl);
            vdb.addModel(model);
        }
        return load;
    }

    private Metadata getMetadata(Set<BeanDefinition> components, PhysicalNamingStrategy namingStrategy) {
        MetadataSources metadataSources = new MetadataSources();
        for (BeanDefinition c : components) {
            try {
                Class<?> clazz = Class.forName(c.getBeanClassName());
                metadataSources.addAnnotatedClass(clazz);
            }
            catch (ClassNotFoundException clazz) {}
        }
        ServiceRegistry registry = metadataSources.getServiceRegistry();
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder((BootstrapServiceRegistry)registry).applySetting("hibernate.dialect", TeiidDialect.class).build();
        Metadata metadata = metadataSources.getMetadataBuilder(serviceRegistry).applyPhysicalNamingStrategy(namingStrategy).build();
        return metadata;
    }

    private void addExcelModel(VDBMetaData vdb, Class<?> clazz, ExcelTable excelAnnotation) {
        ModelMetaData model = new ModelMetaData();
        model.setName(clazz.getSimpleName().toLowerCase());
        model.setModelType(Model.Type.PHYSICAL);
        model.addProperty("importer.DataRowNumber", String.valueOf(excelAnnotation.dataRowStartsAt()));
        model.addProperty("importer.ExcelFileName", excelAnnotation.file());
        model.addProperty("importer.IgnoreEmptyHeaderCells", String.valueOf(excelAnnotation.ignoreEmptyCells()));
        if (excelAnnotation.headerRow() != -1) {
            model.addProperty("importer.HeaderRowNumber", String.valueOf(excelAnnotation.headerRow()));
        }
        SourceMappingMetadata source = new SourceMappingMetadata();
        source.setName(clazz.getSimpleName().toLowerCase());
        source.setConnectionJndiName("file");
        source.setTranslatorName(ExternalSource.EXCEL.getTranslatorName());
        try {
            if (this.getExecutionFactory(ExternalSource.EXCEL.getTranslatorName()) == null) {
                this.addTranslator(ExternalSource.translatorClass(ExternalSource.EXCEL.getTranslatorName()));
            }
        }
        catch (ConnectorManagerRepository.ConnectorManagerException | TranslatorException e) {
            throw new IllegalStateException("Failed to load translator " + ExternalSource.EXCEL.getTranslatorName(), e);
        }
        model.addSourceMapping(source);
        vdb.addModel(model);
    }

    public Schema getSchema(String modelName) {
        VDBMetaData vdb = this.getVDBRepository().getVDB("spring", (Object)"1.0.0");
        if (vdb == null) {
            return null;
        }
        TransformationMetadata metadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (metadata == null) {
            return null;
        }
        Schema schema = metadata.getMetadataStore().getSchema(modelName);
        return schema;
    }
}

